/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IRtpHeaderExtension;
import fm.icelink.IntegerHolder;
import fm.icelink.MathAssistant;
import fm.icelink.RtpHeaderAbsSendTime;
import fm.icelink.RtpHeaderExtensionElement;
import fm.icelink.RtpHeaderExtensionForm;
import fm.icelink.RtpHeaderExtensionRegistry;
import fm.icelink.RtpHeaderExtensionType;
import java.util.ArrayList;
import java.util.HashMap;

class RtpHeaderExtension
implements IRtpHeaderExtension {
    private HashMap<String, RtpHeaderExtensionElement> __headerExtensionElements = new HashMap();
    private byte[] __id;
    private Object __lock = new Object();
    private int _appBits;
    private RtpHeaderExtensionForm _form;

    @Override
    public void fillBuffer(DataBuffer buffer, int offset) {
        RtpHeaderExtension.fillBytes(this, buffer, offset);
    }

    private static void fillBytes(RtpHeaderExtension extension, DataBuffer buffer, int offset) {
        int num = 4;
        buffer.writeBytes(extension.getId(), offset);
        for (RtpHeaderExtensionElement element : extension.getHeaderExtensionElements()) {
            int bytesWritten = 0;
            IntegerHolder _var0 = new IntegerHolder(bytesWritten);
            element.fillBytes(buffer, offset + num, _var0);
            bytesWritten = _var0.getValue();
            num += bytesWritten;
        }
        int num3 = (int)MathAssistant.ceil((num + 2) / 4 - 1);
        buffer.write16(num3, offset + 2);
        int num4 = 4 - num % 4;
        if (num4 == 4) {
            num4 = 0;
        }
        for (int i = 0; i < num4; ++i) {
            buffer.write8(0, offset + num);
            ++num;
        }
    }

    @Override
    public void free() {
    }

    public RtpHeaderAbsSendTime getAbsSendTime() {
        RtpHeaderExtensionElement element = null;
        String key = RtpHeaderExtensionType.AbsSendTime.toString();
        Holder<Object> _var0 = new Holder<Object>(element);
        boolean _var1 = HashMapExtensions.tryGetValue(this.__headerExtensionElements, key, _var0);
        element = _var0.getValue();
        return (RtpHeaderAbsSendTime)element;
    }

    public int getAppBits() {
        return this._appBits;
    }

    DataBuffer getData() {
        DataBuffer buffer = DataBufferPool.getInstance().take(8);
        RtpHeaderExtension.fillBytes(this, buffer, 0);
        return buffer;
    }

    public int getExtensionElementCount() {
        return HashMapExtensions.getCount(this.__headerExtensionElements);
    }

    public RtpHeaderExtensionForm getForm() {
        return this._form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpHeaderExtensionElement[] getHeaderExtensionElements() {
        ArrayList list = new ArrayList();
        Object object = this.__lock;
        synchronized (object) {
            ArrayListExtensions.addRange(list, HashMapExtensions.getValues(this.__headerExtensionElements));
        }
        return list.toArray(new RtpHeaderExtensionElement[0]);
    }

    @Override
    public byte[] getId() {
        if (this.__id == null) {
            this.__id = Global.equals((Object)this.getForm(), (Object)RtpHeaderExtensionForm.OneByte) ? Binary.toBytes16(48862, false) : new byte[]{16, (byte)this.getAppBits()};
        }
        return this.__id;
    }

    @Override
    public int getLength() {
        Object[] headerExtensionElements = this.getHeaderExtensionElements();
        if (headerExtensionElements == null || ArrayExtensions.getLength(headerExtensionElements) == 0) {
            return 4;
        }
        int num = 4;
        for (Object element : headerExtensionElements) {
            num += ((RtpHeaderExtensionElement)element).getLength();
        }
        int num2 = 4 - num % 4;
        if (num2 == 4) {
            num2 = 0;
        }
        return num + num2;
    }

    static RtpHeaderExtension parseBytes(DataBuffer bytes, RtpHeaderExtensionRegistry registry) {
        int num = bytes.read8(0);
        RtpHeaderExtensionForm oneByte = RtpHeaderExtensionForm.OneByte;
        int appBits = 0;
        if (num == 16) {
            oneByte = RtpHeaderExtensionForm.TwoByte;
            appBits = bytes.read8(1);
        }
        int num3 = bytes.read16(2);
        int num4 = 0;
        ArrayList<RtpHeaderExtensionElement> list = new ArrayList<RtpHeaderExtensionElement>();
        RtpHeaderExtensionElement item = null;
        while (num4 / 4 < num3) {
            int bytesRead = 0;
            IntegerHolder _var0 = new IntegerHolder(bytesRead);
            RtpHeaderExtensionElement _var1 = RtpHeaderExtensionElement.parseBytes(bytes, num4 + 4, oneByte, registry, _var0);
            bytesRead = _var0.getValue();
            item = _var1;
            list.add(item);
            num4 += bytesRead;
        }
        return new RtpHeaderExtension(oneByte, list.toArray(new RtpHeaderExtensionElement[0]), appBits);
    }

    public RtpHeaderExtension(RtpHeaderExtensionForm form, RtpHeaderExtensionElement[] elements) {
        this(form, elements, 0);
    }

    public RtpHeaderExtension(RtpHeaderExtensionForm form, RtpHeaderExtensionElement[] elements, int appBits) {
        this.setForm(form);
        for (RtpHeaderExtensionElement element : elements) {
            HashMapExtensions.set(HashMapExtensions.getItem(this.__headerExtensionElements), element.getType().toString(), element);
        }
        this.setAppBits(appBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbsSendTime(RtpHeaderAbsSendTime value) {
        Object object = this.__lock;
        synchronized (object) {
            if (value == null) {
                HashMapExtensions.remove(this.__headerExtensionElements, RtpHeaderExtensionType.AbsSendTime.toString());
            } else {
                HashMapExtensions.set(HashMapExtensions.getItem(this.__headerExtensionElements), RtpHeaderExtensionType.AbsSendTime.toString(), value);
            }
        }
    }

    private void setAppBits(int value) {
        this._appBits = value;
    }

    private void setForm(RtpHeaderExtensionForm value) {
        this._form = value;
    }
}

