/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.RtpHeaderExtensionElement;
import fm.icelink.RtpHeaderExtensionForm;
import fm.icelink.RtpHeaderExtensionType;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;

class RtpHeaderAbsSendTime
extends RtpHeaderExtensionElement {
    private int __absSendTime24 = -1;
    static String _formalName = "http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time";

    private int convertTimeToAbsSendtime24(long milliseconds) {
        long num = (long)((double)milliseconds / 0.00381469);
        return (int)(num & 0xFFFFFFL);
    }

    @Override
    void fillBytes(DataBuffer buffer, int offset, IntegerHolder bytesWritten) {
        buffer.write4(super.getId(), offset, 0);
        buffer.write4(2, offset, 4);
        buffer.write24(this.getAbsSendTime24(), offset + 1);
        bytesWritten.setValue(4);
    }

    public int getAbsSendTime24() {
        if (this.__absSendTime24 == -1) {
            this.__absSendTime24 = this.convertTimeToAbsSendtime24(Scheduler.getCurrentTime());
        }
        return this.__absSendTime24;
    }

    @Override
    public int getLength() {
        return 4;
    }

    public static RtpHeaderAbsSendTime parseBytes(DataBuffer buf, int offset, IntegerHolder bytesRead) {
        int id = buf.read4(offset, 0);
        int num2 = buf.read4(offset, 4);
        if (num2 != 2) {
            throw new RuntimeException(new Exception(StringExtensions.format("Could not parse Abs-send-time RTP header. Declared length {0} does not match expected length of 3.", IntegerExtensions.toString(num2))));
        }
        int num3 = buf.read24(offset + 1);
        bytesRead.setValue(4);
        return new RtpHeaderAbsSendTime(id, num3);
    }

    public RtpHeaderAbsSendTime(int id, int abs_send_time_24) {
        this();
        super.setId(id);
        this.setAbsSendTime24(abs_send_time_24);
    }

    public RtpHeaderAbsSendTime(long ntpTime) {
        this();
        this.setAbsSendTime24(this.convertTimeToAbsSendtime24(ntpTime));
    }

    private RtpHeaderAbsSendTime() {
        super.setId(-1);
        super.setType(RtpHeaderExtensionType.AbsSendTime);
        super.setForm(RtpHeaderExtensionForm.OneByte);
    }

    private void setAbsSendTime24(int value) {
        this.__absSendTime24 = value;
    }
}

