/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.DoubleExtensions;
import fm.icelink.FloatExtensions;
import fm.icelink.ILog;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;

class RtpBandwidthEstimator {
    private long __actualLatestDownstreamBitRate = -1L;
    private long __actualLatestUpstreamBitRate = -1L;
    private Object __bandwidthUpdateLock = new Object();
    private long __estimatedDownstreamBitrate = -1L;
    private long __estimatedUpstreamBitrate = -1L;
    private long __lastBWStatsCollectionStartTimestamp = -1L;
    private static ILog __log = Log.getLogger("FM.IceLink.Rtp.BandwidthEstimator");
    private double __smoothedDownlinkPacketLoss = -1.0;
    private long __smoothedUplinkBandwidthFromRemoteRemb = -1L;
    private double __smoothedUplinkPacketLoss = -1.0;
    private static float __smoothingFactor = 0.5f;
    private long _octetsReceivedSinceLastBWStatsCollectionStart;
    private long _octetsSentSinceLastBWStatsCollectionStart;

    public long getEstimatedDownstreamBitrate() {
        return this.__estimatedDownstreamBitrate;
    }

    public long getEstimatedUpstreamBitrate() {
        return this.__estimatedUpstreamBitrate;
    }

    public long getOctetsReceivedSinceLastBWStatsCollectionStart() {
        return this._octetsReceivedSinceLastBWStatsCollectionStart;
    }

    public long getOctetsSentSinceLastBWStatsCollectionStart() {
        return this._octetsSentSinceLastBWStatsCollectionStart;
    }

    private void logBitrateParameters(long currentTime, long duration, double currentUpstreamPacketLoss, double currentDownstreamPacketLoss, boolean logOutgoing, boolean logIncoming) {
        String str = LongExtensions.toString(currentTime);
        String str2 = LongExtensions.toString(duration);
        String str3 = LongExtensions.toString(this.getEstimatedUpstreamBitrate());
        String str4 = LongExtensions.toString(this.__actualLatestUpstreamBitRate);
        String str5 = LongExtensions.toString(this.getEstimatedDownstreamBitrate());
        String str6 = LongExtensions.toString(this.__actualLatestDownstreamBitRate);
        String str7 = DoubleExtensions.toString(currentUpstreamPacketLoss);
        String str8 = DoubleExtensions.toString(currentDownstreamPacketLoss);
        if (__log.getIsVerboseEnabled()) {
            if (logOutgoing) {
                __log.verbose(StringExtensions.format("RTP Bandwidth Estimator: Calculating upstream bitrate stats at {0}. Time interval: {1} ms, previous upstream bitrate estimate: {2} bps, actual upstream bitrate over the time interval: {3} bps, current packet loss ratio on upstream: {4}", new Object[]{str, str2, str3, str4, str7}));
            }
            if (logIncoming) {
                __log.verbose(StringExtensions.format("RTP Bandwidth Estimator: Calculating downstream bitrate stats at {0}. Time interval: {1} ms, previous downstream bitrate estimate: {2} bps, actual downstream bitrate over the time interval: {3} bps, current packet loss ratio on downstream: {4}", new Object[]{str, str2, str5, str6, str8}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBandwidthStats(AtomicLong octetsSentRtp, AtomicLong octetsReceivedRtp) {
        Object object = this.__bandwidthUpdateLock;
        synchronized (object) {
            long currentTime = Scheduler.getCurrentTime();
            long duration = currentTime - this.__lastBWStatsCollectionStartTimestamp;
            boolean logOutgoing = true;
            boolean logIncoming = true;
            if (duration < 0L) {
                throw new RuntimeException(new Exception(StringExtensions.format("RTP Bandwidth Estimator: unexpected duration for bandwidth estimation. Current time: {0}, last estimate time: {1}, duration: {2}", LongExtensions.toString(currentTime), LongExtensions.toString(this.__lastBWStatsCollectionStartTimestamp), LongExtensions.toString(duration))));
            }
            long num3 = (octetsSentRtp.getValue() - this.getOctetsSentSinceLastBWStatsCollectionStart()) * 8L;
            if (num3 > 0L) {
                this.__actualLatestUpstreamBitRate = 1000L * num3 / duration;
            } else {
                if (num3 < 0L) {
                    throw new RuntimeException(new Exception(StringExtensions.format("RTP Bandwidth Estimator: unexpected number of bytes sent. Octets sent: {0}, last octets sent: {1}, bytesSent: {2}", octetsSentRtp.toString(), LongExtensions.toString(this.getOctetsSentSinceLastBWStatsCollectionStart()), LongExtensions.toString(num3))));
                }
                logOutgoing = false;
            }
            long num4 = (octetsReceivedRtp.getValue() - this.getOctetsReceivedSinceLastBWStatsCollectionStart()) * 8L;
            if (num4 > 0L) {
                this.__actualLatestDownstreamBitRate = 1000L * num4 / duration;
            } else {
                if (num4 < 0L) {
                    throw new RuntimeException(new Exception(StringExtensions.format("RTP Bandwidth Estimator: unexpected number of bytes received. Octets received: {0}, last octets received: {1}, bytesRecv: {2}", octetsSentRtp.toString(), LongExtensions.toString(this.getOctetsSentSinceLastBWStatsCollectionStart()), LongExtensions.toString(num3))));
                }
                logIncoming = false;
            }
            double lossRatio = this.__smoothedUplinkPacketLoss < 0.0 ? 0.0 : this.__smoothedUplinkPacketLoss;
            double num6 = this.__smoothedDownlinkPacketLoss < 0.0 ? 0.0 : this.__smoothedDownlinkPacketLoss;
            long calculatedBR = this.__actualLatestDownstreamBitRate;
            long num8 = this.__actualLatestUpstreamBitRate;
            if (this.getEstimatedUpstreamBitrate() <= 0L && logOutgoing) {
                this.setEstimatedUpstreamBitrate(num8);
            }
            if (this.getEstimatedDownstreamBitrate() <= 0L && logIncoming) {
                this.setEstimatedDownstreamBitrate(calculatedBR);
            }
            if (logOutgoing) {
                num8 = this.updateBR(num8, this.getEstimatedUpstreamBitrate(), lossRatio);
            }
            if (logIncoming) {
                calculatedBR = this.updateBR(calculatedBR, this.getEstimatedDownstreamBitrate(), num6);
            }
            long num9 = num8;
            if (this.__smoothedUplinkBandwidthFromRemoteRemb > 0L) {
                if (num9 <= 0L || this.__smoothedUplinkBandwidthFromRemoteRemb < num9) {
                    num9 = this.__smoothedUplinkBandwidthFromRemoteRemb;
                }
                logOutgoing = true;
            }
            this.logBitrateParameters(currentTime, duration, lossRatio, num6, logOutgoing, logIncoming);
            if (logIncoming) {
                this.setEstimatedDownstreamBitrate(calculatedBR);
            }
            if (logOutgoing) {
                this.setEstimatedUpstreamBitrate(num9);
            }
            this.resetBWStats();
        }
    }

    public void processUplinkBandwidthFromRemoteRemb(long br) {
        this.__smoothedUplinkBandwidthFromRemoteRemb = this.__smoothedUplinkBandwidthFromRemoteRemb <= 0L ? br : (long)((float)br * __smoothingFactor) + this.__smoothedUplinkBandwidthFromRemoteRemb * (1L - br);
    }

    private void resetBWStats() {
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("RTP Bandwidth Estimator: Pausing bandwidth stats collection at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
        }
        this.__smoothedDownlinkPacketLoss = -1.0;
        this.__actualLatestDownstreamBitRate = -1L;
        this.__smoothedUplinkPacketLoss = -1.0;
        this.__actualLatestUpstreamBitRate = -1L;
        this.__smoothedUplinkBandwidthFromRemoteRemb = -1L;
    }

    public RtpBandwidthEstimator() {
        this.setOctetsSentSinceLastBWStatsCollectionStart(0L);
        this.setOctetsReceivedSinceLastBWStatsCollectionStart(0L);
    }

    private void setEstimatedDownstreamBitrate(long value) {
        this.__estimatedDownstreamBitrate = value;
        if (__log.getIsVerboseEnabled()) {
            float num = (float)this.__estimatedDownstreamBitrate / 1048576.0f;
            __log.verbose(StringExtensions.format("RTP Bandwidth Estimator: Setting estimated downstream bitrate to {0} mbps.", FloatExtensions.toString(Float.valueOf(num))));
        }
    }

    private void setEstimatedUpstreamBitrate(long value) {
        this.__estimatedUpstreamBitrate = value;
        if (__log.getIsVerboseEnabled()) {
            float num = (float)this.__estimatedUpstreamBitrate / 1048576.0f;
            __log.verbose(StringExtensions.format("RTP Bandwidth Estimator: Setting estimated upstream bitrate to {0} mbps.", FloatExtensions.toString(Float.valueOf(num))));
        }
    }

    public void setOctetsReceivedSinceLastBWStatsCollectionStart(long value) {
        this._octetsReceivedSinceLastBWStatsCollectionStart = value;
    }

    public void setOctetsSentSinceLastBWStatsCollectionStart(long value) {
        this._octetsSentSinceLastBWStatsCollectionStart = value;
    }

    public void startCollectingBWStats(AtomicLong octetsSentRtp, AtomicLong octetsReceivedRtp) {
        this.__lastBWStatsCollectionStartTimestamp = Scheduler.getCurrentTime();
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("RTP Bandwidth Estimator: Resuming bandwidth stats collection at {0}.", LongExtensions.toString(this.__lastBWStatsCollectionStartTimestamp)));
        }
        this.setOctetsSentSinceLastBWStatsCollectionStart(octetsSentRtp.getValue());
        this.setOctetsReceivedSinceLastBWStatsCollectionStart(octetsReceivedRtp.getValue());
    }

    private long updateBR(long calculatedBR, long previousBREstimate, double lossRatio) {
        double num = -1.0;
        if (lossRatio == 0.0) {
            lossRatio = 1.0E-6;
        }
        num = lossRatio < 0.01 ? 1.05 * (double)previousBREstimate : (lossRatio >= 0.01 && lossRatio <= 0.05 ? (double)previousBREstimate : (1.0 - 0.5 * lossRatio) * (double)calculatedBR);
        return (long)num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLossBasedEstimatedAvailableBandwidth(double lossRatio, boolean local) {
        Object object = this.__bandwidthUpdateLock;
        synchronized (object) {
            if (local) {
                this.__smoothedUplinkPacketLoss = this.__smoothedUplinkPacketLoss < 0.0 ? lossRatio : this.__smoothedUplinkPacketLoss * (double)(1.0f - __smoothingFactor) + lossRatio * (double)__smoothingFactor;
            } else {
                this.__smoothedDownlinkPacketLoss = this.__smoothedDownlinkPacketLoss < 0.0 ? lossRatio : this.__smoothedDownlinkPacketLoss * (double)(1.0f - __smoothingFactor) + lossRatio * (double)__smoothingFactor;
            }
        }
    }
}

