/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecContext;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioConfig;
import fm.icelink.AudioEncoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;
import fm.icelink.AudioSource;
import fm.icelink.AudioTrack;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.IViewSinkableMedia;
import fm.icelink.IViewableMedia;
import fm.icelink.LocalMedia;
import fm.icelink.Log;
import fm.icelink.MediaPipeState;
import fm.icelink.MediaSink;
import fm.icelink.MediaTrack;
import fm.icelink.SoundConverter;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoSource;
import fm.icelink.VideoTrack;
import fm.icelink.ViewSink;
import fm.icelink.pcmu.Encoder;
import fm.icelink.pcmu.Packetizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class RtcLocalMedia<TView>
extends LocalMedia
implements IViewSinkableMedia<TView, ViewSink<TView>>,
IViewableMedia<TView> {
    private ArrayList<AudioSink> __audioRecorders;
    private boolean __initialized = false;
    private Object __initializeLock;
    private List<IAction1<AudioPipe>> __onActiveAudioConverterChange = new ArrayList<IAction1<AudioPipe>>();
    private List<IAction1<AudioEncoder>> __onActiveAudioEncoderChange = new ArrayList<IAction1<AudioEncoder>>();
    private List<IAction1<AudioPipe>> __onActiveAudioPacketizerChange = new ArrayList<IAction1<AudioPipe>>();
    private List<IAction1<VideoPipe>> __onActiveVideoConverterChange = new ArrayList<IAction1<VideoPipe>>();
    private List<IAction1<VideoEncoder>> __onActiveVideoEncoderChange = new ArrayList<IAction1<VideoEncoder>>();
    private List<IAction1<VideoPipe>> __onActiveVideoPacketizerChange = new ArrayList<IAction1<VideoPipe>>();
    private AudioConfig __opusConfig = new AudioConfig(48000, 2);
    private AudioConfig __pcmaConfig;
    private AudioConfig __pcmuConfig = new AudioConfig(8000, 1);
    private ArrayList<VideoSink> __videoRecorders;
    private AudioPipe _activeAudioConverter;
    private AudioEncoder _activeAudioEncoder;
    private AudioPipe _activeAudioPacketizer;
    private VideoPipe _activeVideoConverter;
    private VideoEncoder _activeVideoEncoder;
    private VideoPipe _activeVideoPacketizer;
    private AecContext _aecContext;
    private boolean _audioDisabled;
    private Object _audioRecordingLock;
    private VideoPipe _h264Converter;
    private VideoEncoder _h264Encoder;
    private VideoPipe _h264Packetizer;
    private IAction1<AudioPipe> _onActiveAudioConverterChange = null;
    private IAction1<AudioEncoder> _onActiveAudioEncoderChange = null;
    private IAction1<AudioPipe> _onActiveAudioPacketizerChange = null;
    private IAction1<VideoPipe> _onActiveVideoConverterChange = null;
    private IAction1<VideoEncoder> _onActiveVideoEncoderChange = null;
    private IAction1<VideoPipe> _onActiveVideoPacketizerChange = null;
    private AudioPipe _opusConverter;
    private AudioEncoder _opusEncoder;
    private AudioPipe _opusPacketizer;
    private AudioPipe _pcmaConverter;
    private AudioEncoder _pcmaEncoder;
    private AudioPipe _pcmaPacketizer;
    private AudioPipe _pcmuConverter;
    private AudioEncoder _pcmuEncoder;
    private AudioPipe _pcmuPacketizer;
    private boolean _videoDisabled;
    private Object _videoRecordingLock;
    private ViewSink<TView> _viewSink;
    private VideoPipe _vp8Converter;
    private VideoEncoder _vp8Encoder;
    private VideoPipe _vp8Packetizer;
    private VideoPipe _vp9Converter;
    private VideoEncoder _vp9Encoder;
    private VideoPipe _vp9Packetizer;

    public void addOnActiveAudioConverterChange(IAction1<AudioPipe> value) {
        if (value != null) {
            if (this._onActiveAudioConverterChange == null) {
                this._onActiveAudioConverterChange = new IAction1<AudioPipe>(){

                    @Override
                    public void invoke(AudioPipe p0) {
                        for (IAction1 action : new ArrayList(RtcLocalMedia.this.__onActiveAudioConverterChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioConverterChange.add(value);
        }
    }

    public void addOnActiveAudioEncoderChange(IAction1<AudioEncoder> value) {
        if (value != null) {
            if (this._onActiveAudioEncoderChange == null) {
                this._onActiveAudioEncoderChange = new IAction1<AudioEncoder>(){

                    @Override
                    public void invoke(AudioEncoder p0) {
                        for (IAction1 action : new ArrayList(RtcLocalMedia.this.__onActiveAudioEncoderChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioEncoderChange.add(value);
        }
    }

    public void addOnActiveAudioPacketizerChange(IAction1<AudioPipe> value) {
        if (value != null) {
            if (this._onActiveAudioPacketizerChange == null) {
                this._onActiveAudioPacketizerChange = new IAction1<AudioPipe>(){

                    @Override
                    public void invoke(AudioPipe p0) {
                        for (IAction1 action : new ArrayList(RtcLocalMedia.this.__onActiveAudioPacketizerChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioPacketizerChange.add(value);
        }
    }

    public void addOnActiveVideoConverterChange(IAction1<VideoPipe> value) {
        if (value != null) {
            if (this._onActiveVideoConverterChange == null) {
                this._onActiveVideoConverterChange = new IAction1<VideoPipe>(){

                    @Override
                    public void invoke(VideoPipe p0) {
                        for (IAction1 action : new ArrayList(RtcLocalMedia.this.__onActiveVideoConverterChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveVideoConverterChange.add(value);
        }
    }

    public void addOnActiveVideoEncoderChange(IAction1<VideoEncoder> value) {
        if (value != null) {
            if (this._onActiveVideoEncoderChange == null) {
                this._onActiveVideoEncoderChange = new IAction1<VideoEncoder>(){

                    @Override
                    public void invoke(VideoEncoder p0) {
                        for (IAction1 action : new ArrayList(RtcLocalMedia.this.__onActiveVideoEncoderChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveVideoEncoderChange.add(value);
        }
    }

    public void addOnActiveVideoPacketizerChange(IAction1<VideoPipe> value) {
        if (value != null) {
            if (this._onActiveVideoPacketizerChange == null) {
                this._onActiveVideoPacketizerChange = new IAction1<VideoPipe>(){

                    @Override
                    public void invoke(VideoPipe p0) {
                        for (IAction1 action : new ArrayList(RtcLocalMedia.this.__onActiveVideoPacketizerChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveVideoPacketizerChange.add(value);
        }
    }

    private void attachAudioRecorderSourceEvents(final AudioPipe recorderSource) {
        IAction0 action = null;
        if (recorderSource != null) {
            if (action == null) {
                action = new IAction0(){

                    @Override
                    public void invoke() {
                        if (RtcLocalMedia.this.getIsRecordingAudio() && !recorderSource.getDisabled()) {
                            Iterator iterator = RtcLocalMedia.this.__audioRecorders.iterator();
                            while (iterator.hasNext()) {
                                AudioSink sink;
                                sink.setDisabled(!recorderSource.hasOutput(sink = (AudioSink)iterator.next()));
                            }
                        }
                    }
                };
            }
            recorderSource.addOnDisabledChange(action);
        }
    }

    private void attachVideoRecorderSourceEvents(final VideoPipe recorderSource) {
        IAction0 action = null;
        if (recorderSource != null) {
            if (action == null) {
                action = new IAction0(){

                    @Override
                    public void invoke() {
                        if (RtcLocalMedia.this.getIsRecordingVideo() && !recorderSource.getDisabled()) {
                            Iterator iterator = RtcLocalMedia.this.__videoRecorders.iterator();
                            while (iterator.hasNext()) {
                                VideoSink sink;
                                sink.setDisabled(!recorderSource.hasOutput(sink = (VideoSink)iterator.next()));
                            }
                        }
                    }
                };
            }
            recorderSource.addOnDisabledChange(action);
        }
    }

    protected abstract AudioSink createAudioRecorder(AudioFormat var1);

    protected abstract AudioSource createAudioSource(AudioConfig var1);

    private AudioTrack createAudioTrack(final AudioPipe converter, final AudioEncoder encoder, final AudioPipe packetizer) {
        if (converter == null) {
            throw new RuntimeException(new Exception("Can't create local audio track. Sound converter is null."));
        }
        if (encoder == null) {
            throw new RuntimeException(new Exception("Can't create local audio track. Encoder is null."));
        }
        if (packetizer == null) {
            throw new RuntimeException(new Exception("Can't create local audio track. Packetizer is null."));
        }
        AudioTrack track = new AudioTrack(converter);
        converter.addOnProcessFrame(new IAction1<AudioFrame>(){

            @Override
            public void invoke(AudioFrame frame) {
                if (!Global.equals(RtcLocalMedia.this.getActiveAudioConverter(), converter)) {
                    RtcLocalMedia.this.setActiveAudioConverter(converter);
                    IAction1 onActiveAudioConverterChange = RtcLocalMedia.this._onActiveAudioConverterChange;
                    if (onActiveAudioConverterChange != null) {
                        onActiveAudioConverterChange.invoke(converter);
                    }
                }
            }
        });
        track = (AudioTrack)track.next(encoder);
        encoder.addOnProcessFrame(new IAction1<AudioFrame>(){

            @Override
            public void invoke(AudioFrame frame) {
                if (!Global.equals(RtcLocalMedia.this.getActiveAudioEncoder(), encoder)) {
                    RtcLocalMedia.this.setActiveAudioEncoder(encoder);
                    IAction1 onActiveAudioEncoderChange = RtcLocalMedia.this._onActiveAudioEncoderChange;
                    if (onActiveAudioEncoderChange != null) {
                        onActiveAudioEncoderChange.invoke(encoder);
                    }
                }
            }
        });
        ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        AudioSink audioRecorder = this.getAudioRecorder((AudioFormat)encoder.getOutputFormat());
        if (audioRecorder != null) {
            list.add(new AudioTrack(audioRecorder));
        }
        AudioTrack item = new AudioTrack(packetizer);
        packetizer.addOnProcessFrame(new IAction1<AudioFrame>(){

            @Override
            public void invoke(AudioFrame frame) {
                if (!Global.equals(RtcLocalMedia.this.getActiveAudioPacketizer(), packetizer)) {
                    RtcLocalMedia.this.setActiveAudioPacketizer(packetizer);
                    IAction1 onActiveAudioPacketizerChange = RtcLocalMedia.this._onActiveAudioPacketizerChange;
                    if (onActiveAudioPacketizerChange != null) {
                        onActiveAudioPacketizerChange.invoke(packetizer);
                    }
                }
            }
        });
        list.add(item);
        return (AudioTrack)track.next((MediaTrack[])list.toArray(new AudioTrack[0]));
    }

    protected abstract VideoEncoder createH264Encoder();

    protected VideoPipe createH264Packetizer() {
        return new fm.icelink.h264.Packetizer();
    }

    protected abstract VideoPipe createImageConverter(VideoFormat var1);

    protected abstract AudioEncoder createOpusEncoder(AudioConfig var1);

    protected AudioPipe createOpusPacketizer(AudioConfig config) {
        return new fm.icelink.opus.Packetizer(config);
    }

    protected AudioEncoder createPcmaEncoder(AudioConfig config) {
        return new fm.icelink.pcma.Encoder(config);
    }

    protected AudioPipe createPcmaPacketizer(AudioConfig config) {
        return new fm.icelink.pcma.Packetizer(config);
    }

    protected AudioEncoder createPcmuEncoder(AudioConfig config) {
        return new Encoder(config);
    }

    protected AudioPipe createPcmuPacketizer(AudioConfig config) {
        return new Packetizer(config);
    }

    protected AudioPipe createSoundConverter(AudioConfig config) {
        return new SoundConverter(config);
    }

    protected abstract VideoSink createVideoRecorder(VideoFormat var1);

    protected abstract VideoSource createVideoSource();

    private VideoTrack createVideoTrack(final VideoPipe converter, final VideoEncoder encoder, final VideoPipe packetizer) {
        if (converter == null) {
            throw new RuntimeException(new Exception("Can't create local video track. Image converter is null."));
        }
        if (encoder == null) {
            throw new RuntimeException(new Exception("Can't create local video track. Encoder is null."));
        }
        if (packetizer == null) {
            throw new RuntimeException(new Exception("Can't create local video track. Packetizer is null."));
        }
        VideoTrack track = new VideoTrack(converter);
        converter.addOnProcessFrame(new IAction1<VideoFrame>(){

            @Override
            public void invoke(VideoFrame frame) {
                if (!Global.equals(RtcLocalMedia.this.getActiveVideoConverter(), converter)) {
                    RtcLocalMedia.this.setActiveVideoConverter(converter);
                    IAction1 onActiveVideoConverterChange = RtcLocalMedia.this._onActiveVideoConverterChange;
                    if (onActiveVideoConverterChange != null) {
                        onActiveVideoConverterChange.invoke(converter);
                    }
                }
            }
        });
        track = (VideoTrack)track.next(encoder);
        encoder.addOnProcessFrame(new IAction1<VideoFrame>(){

            @Override
            public void invoke(VideoFrame frame) {
                if (!Global.equals(RtcLocalMedia.this.getActiveVideoEncoder(), encoder)) {
                    RtcLocalMedia.this.setActiveVideoEncoder(encoder);
                    IAction1 onActiveVideoEncoderChange = RtcLocalMedia.this._onActiveVideoEncoderChange;
                    if (onActiveVideoEncoderChange != null) {
                        onActiveVideoEncoderChange.invoke(encoder);
                    }
                }
            }
        });
        ArrayList<VideoTrack> list = new ArrayList<VideoTrack>();
        VideoSink videoRecorder = this.getVideoRecorder((VideoFormat)encoder.getOutputFormat());
        if (videoRecorder != null) {
            list.add(new VideoTrack(videoRecorder));
        }
        VideoTrack item = new VideoTrack(packetizer);
        packetizer.addOnProcessFrame(new IAction1<VideoFrame>(){

            @Override
            public void invoke(VideoFrame frame) {
                if (!Global.equals(RtcLocalMedia.this.getActiveVideoPacketizer(), packetizer)) {
                    RtcLocalMedia.this.setActiveVideoPacketizer(packetizer);
                    IAction1 onActiveVideoPacketizerChange = RtcLocalMedia.this._onActiveVideoPacketizerChange;
                    if (onActiveVideoPacketizerChange != null) {
                        onActiveVideoPacketizerChange.invoke(packetizer);
                    }
                }
            }
        });
        list.add(item);
        return (VideoTrack)track.next((MediaTrack[])list.toArray(new VideoTrack[0]));
    }

    protected abstract ViewSink<TView> createViewSink();

    protected abstract VideoEncoder createVp8Encoder();

    protected VideoPipe createVp8Packetizer() {
        return new fm.icelink.vp8.Packetizer();
    }

    protected abstract VideoEncoder createVp9Encoder();

    protected VideoPipe createVp9Packetizer() {
        return new fm.icelink.vp9.Packetizer();
    }

    @Override
    public void destroy() {
        if (!this.getAecDisabled()) {
            this.getAecContext().destroy();
        }
        for (AudioSink sink : this.__audioRecorders) {
            if (sink.getPersistent()) continue;
            sink.destroy();
        }
        for (VideoSink sink2 : this.__videoRecorders) {
            if (sink2.getPersistent()) continue;
            sink2.destroy();
        }
        super.destroy();
    }

    public AudioPipe getActiveAudioConverter() {
        return this._activeAudioConverter;
    }

    public AudioEncoder getActiveAudioEncoder() {
        return this._activeAudioEncoder;
    }

    public AudioPipe getActiveAudioPacketizer() {
        return this._activeAudioPacketizer;
    }

    public VideoPipe getActiveVideoConverter() {
        return this._activeVideoConverter;
    }

    public VideoEncoder getActiveVideoEncoder() {
        return this._activeVideoEncoder;
    }

    public VideoPipe getActiveVideoPacketizer() {
        return this._activeVideoPacketizer;
    }

    public AecContext getAecContext() {
        return this._aecContext;
    }

    public boolean getAecDisabled() {
        return this.getAecContext() == null || this.getAudioDisabled();
    }

    public boolean getAudioDisabled() {
        return this._audioDisabled;
    }

    public IAudioOutput[] getAudioOutputs() {
        return super.getAudioTrack() == null ? null : (IAudioOutput[])((AudioTrack)super.getAudioTrack()).getOutputs();
    }

    private AudioSink getAudioRecorder(AudioFormat inputFormat) {
        AudioSink item = this.createAudioRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__audioRecorders.add(item);
        }
        return item;
    }

    public VideoPipe getH264Converter() {
        return this._h264Converter;
    }

    public VideoEncoder getH264Encoder() {
        return this._h264Encoder;
    }

    public VideoPipe getH264Packetizer() {
        return this._h264Packetizer;
    }

    public AudioPipe getOpusConverter() {
        return this._opusConverter;
    }

    public AudioEncoder getOpusEncoder() {
        return this._opusEncoder;
    }

    public AudioPipe getOpusPacketizer() {
        return this._opusPacketizer;
    }

    public AudioPipe getPcmaConverter() {
        return this._pcmaConverter;
    }

    public AudioEncoder getPcmaEncoder() {
        return this._pcmaEncoder;
    }

    public AudioPipe getPcmaPacketizer() {
        return this._pcmaPacketizer;
    }

    public AudioPipe getPcmuConverter() {
        return this._pcmuConverter;
    }

    public AudioEncoder getPcmuEncoder() {
        return this._pcmuEncoder;
    }

    public AudioPipe getPcmuPacketizer() {
        return this._pcmuPacketizer;
    }

    public boolean getVideoDisabled() {
        return this._videoDisabled;
    }

    public IVideoOutput[] getVideoOutputs() {
        return super.getVideoTrack() == null ? null : (IVideoOutput[])((VideoTrack)super.getVideoTrack()).getOutputs();
    }

    private VideoSink getVideoRecorder(VideoFormat inputFormat) {
        VideoSink item = this.createVideoRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__videoRecorders.add(item);
        }
        return item;
    }

    @Override
    public TView getView() {
        return this.getViewSink() == null ? null : (TView)((ViewSink)this.getViewSink()).getView();
    }

    @Override
    public ViewSink<TView> getViewSink() {
        return this._viewSink;
    }

    public VideoPipe getVp8Converter() {
        return this._vp8Converter;
    }

    public VideoEncoder getVp8Encoder() {
        return this._vp8Encoder;
    }

    public VideoPipe getVp8Packetizer() {
        return this._vp8Packetizer;
    }

    public VideoPipe getVp9Converter() {
        return this._vp9Converter;
    }

    public VideoEncoder getVp9Encoder() {
        return this._vp9Encoder;
    }

    public VideoPipe getVp9Packetizer() {
        return this._vp9Packetizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        Object object = this.__initializeLock;
        synchronized (object) {
            if (this.__initialized) {
                return false;
            }
            this.__initialized = true;
        }
        try {
            Exception exception;
            if (!this.getAudioDisabled()) {
                AudioTrack audioTrack = new AudioTrack(this.createAudioSource(this.__opusConfig));
                if (!this.getAecDisabled()) {
                    audioTrack = (AudioTrack)((AudioTrack)audioTrack.next(this.createSoundConverter(this.getAecContext().getProcessor().getConfig()))).next(this.getAecContext().getProcessor());
                }
                ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
                try {
                    this.setOpusEncoder(this.createOpusEncoder(this.__opusConfig));
                }
                catch (Exception exception1) {
                    exception = exception1;
                    Log.error("Could not create local Opus encoder.", exception);
                }
                if (this.getOpusEncoder() != null) {
                    this.setOpusConverter(this.createSoundConverter(this.getOpusEncoder().getInputConfig()));
                    this.setOpusPacketizer(this.createOpusPacketizer(this.getOpusEncoder().getOutputConfig()));
                    list.add(this.createAudioTrack(this.getOpusConverter(), this.getOpusEncoder(), this.getOpusPacketizer()));
                }
                try {
                    this.setPcmuEncoder(this.createPcmuEncoder(this.__pcmuConfig));
                }
                catch (Exception exception2) {
                    exception = exception2;
                    Log.error("Could not create local PCMU encoder.", exception);
                }
                if (this.getPcmuEncoder() != null) {
                    this.setPcmuConverter(this.createSoundConverter(this.getPcmuEncoder().getInputConfig()));
                    this.setPcmuPacketizer(this.createPcmuPacketizer(this.getPcmuEncoder().getOutputConfig()));
                    list.add(this.createAudioTrack(this.getPcmuConverter(), this.getPcmuEncoder(), this.getPcmuPacketizer()));
                }
                try {
                    this.setPcmaEncoder(this.createPcmaEncoder(this.__pcmaConfig));
                }
                catch (Exception exception3) {
                    exception = exception3;
                    Log.error("Could not create local PCMA encoder.", exception);
                }
                if (this.getPcmaEncoder() != null) {
                    this.setPcmaConverter(this.createSoundConverter(this.getPcmaEncoder().getInputConfig()));
                    this.setPcmaPacketizer(this.createPcmaPacketizer(this.getPcmaEncoder().getOutputConfig()));
                    list.add(this.createAudioTrack(this.getPcmaConverter(), this.getPcmaEncoder(), this.getPcmaPacketizer()));
                }
                if (ArrayListExtensions.getCount(list) <= 0) {
                    throw new RuntimeException(new Exception("Could not initialize local media. All audio encoders failed to load. Check the logs for more detail."));
                }
                audioTrack = (AudioTrack)audioTrack.next((MediaTrack[])list.toArray(new AudioTrack[0]));
                this.addAudioTrack(audioTrack);
            }
            if (!this.getVideoDisabled()) {
                Object videoTrack = new VideoTrack(this.createVideoSource());
                ArrayList<VideoTrack> list2 = new ArrayList<VideoTrack>();
                VideoTrack item = null;
                try {
                    this.setViewSink(this.createViewSink());
                }
                catch (Exception exception4) {
                    exception = exception4;
                    Log.error("Could not create local view sink.", exception);
                }
                if (this.getViewSink() != null) {
                    item = (VideoTrack)new VideoTrack(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat())).next(this.getViewSink());
                }
                try {
                    this.setVp8Encoder(this.createVp8Encoder());
                }
                catch (Exception exception5) {
                    exception = exception5;
                    Log.error("Could not create local VP8 encoder.", exception);
                }
                if (this.getVp8Encoder() != null) {
                    this.setVp8Converter(this.createImageConverter((VideoFormat)this.getVp8Encoder().getInputFormat()));
                    this.setVp8Packetizer(this.createVp8Packetizer());
                    list2.add(this.createVideoTrack(this.getVp8Converter(), this.getVp8Encoder(), this.getVp8Packetizer()));
                }
                try {
                    this.setH264Encoder(this.createH264Encoder());
                }
                catch (Exception exception6) {
                    exception = exception6;
                    Log.error("Could not create local H.264 encoder.", exception);
                }
                if (this.getH264Encoder() != null) {
                    this.setH264Converter(this.createImageConverter((VideoFormat)this.getH264Encoder().getInputFormat()));
                    this.setH264Packetizer(this.createH264Packetizer());
                    list2.add(this.createVideoTrack(this.getH264Converter(), this.getH264Encoder(), this.getH264Packetizer()));
                }
                try {
                    this.setVp9Encoder(this.createVp9Encoder());
                }
                catch (Exception exception7) {
                    exception = exception7;
                    Log.error("Could not create local VP9 encoder.", exception);
                }
                if (this.getVp9Encoder() != null) {
                    this.setVp9Converter(this.createImageConverter((VideoFormat)this.getVp9Encoder().getInputFormat()));
                    this.setVp9Packetizer(this.createVp9Packetizer());
                    list2.add(this.createVideoTrack(this.getVp9Converter(), this.getVp9Encoder(), this.getVp9Packetizer()));
                }
                if (ArrayListExtensions.getCount(list2) <= 0) {
                    throw new RuntimeException(new Exception("Could not initialize local media. All video encoders failed to load. Check the logs for more detail."));
                }
                if (item != null) {
                    ArrayListExtensions.insert(list2, 0, item);
                }
                videoTrack = (VideoTrack)((MediaTrack)videoTrack).next((MediaTrack[])list2.toArray(new VideoTrack[0]));
                this.addVideoTrack((VideoTrack)videoTrack);
            }
            for (AudioSink sink : this.__audioRecorders) {
                this.attachAudioRecorderSourceEvents(Global.tryCast(sink.getInput(), AudioPipe.class));
            }
            for (VideoSink sink2 : this.__videoRecorders) {
                this.attachVideoRecorderSourceEvents(Global.tryCast(sink2.getInput(), VideoPipe.class));
            }
        }
        catch (Exception exception8) {
            Exception exception = exception8;
            Log.error("Error initializing local media.", exception);
            throw new RuntimeException(exception);
        }
        return true;
    }

    public void removeOnActiveAudioConverterChange(IAction1<AudioPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioConverterChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioConverterChange.remove(value);
        if (this.__onActiveAudioConverterChange.size() == 0) {
            this._onActiveAudioConverterChange = null;
        }
    }

    public void removeOnActiveAudioEncoderChange(IAction1<AudioEncoder> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioEncoderChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioEncoderChange.remove(value);
        if (this.__onActiveAudioEncoderChange.size() == 0) {
            this._onActiveAudioEncoderChange = null;
        }
    }

    public void removeOnActiveAudioPacketizerChange(IAction1<AudioPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioPacketizerChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioPacketizerChange.remove(value);
        if (this.__onActiveAudioPacketizerChange.size() == 0) {
            this._onActiveAudioPacketizerChange = null;
        }
    }

    public void removeOnActiveVideoConverterChange(IAction1<VideoPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveVideoConverterChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveVideoConverterChange.remove(value);
        if (this.__onActiveVideoConverterChange.size() == 0) {
            this._onActiveVideoConverterChange = null;
        }
    }

    public void removeOnActiveVideoEncoderChange(IAction1<VideoEncoder> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveVideoEncoderChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveVideoEncoderChange.remove(value);
        if (this.__onActiveVideoEncoderChange.size() == 0) {
            this._onActiveVideoEncoderChange = null;
        }
    }

    public void removeOnActiveVideoPacketizerChange(IAction1<VideoPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveVideoPacketizerChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveVideoPacketizerChange.remove(value);
        if (this.__onActiveVideoPacketizerChange.size() == 0) {
            this._onActiveVideoPacketizerChange = null;
        }
    }

    public RtcLocalMedia(boolean disableAudio, boolean disableVideo) {
        this(disableAudio, disableVideo, null);
    }

    public RtcLocalMedia() {
        this(false, false);
    }

    public RtcLocalMedia(boolean disableAudio, boolean disableVideo, AecContext aecContext) {
        this.__pcmaConfig = new AudioConfig(8000, 1);
        this.__audioRecorders = new ArrayList();
        this.__videoRecorders = new ArrayList();
        this.__initializeLock = new Object();
        this._audioRecordingLock = new Object();
        this._videoRecordingLock = new Object();
        if (aecContext != null && aecContext.getProcessor() != null && !Global.equals((Object)aecContext.getProcessor().getState(), (Object)MediaPipeState.Initialized)) {
            Log.warn("Local media received a reference to a destroyed AEC context. AEC will be disabled.");
            aecContext = null;
        }
        this.setAudioDisabled(disableAudio);
        this.setVideoDisabled(disableVideo);
        this.setAecContext(aecContext);
    }

    private void setActiveAudioConverter(AudioPipe value) {
        this._activeAudioConverter = value;
    }

    private void setActiveAudioEncoder(AudioEncoder value) {
        this._activeAudioEncoder = value;
    }

    private void setActiveAudioPacketizer(AudioPipe value) {
        this._activeAudioPacketizer = value;
    }

    private void setActiveVideoConverter(VideoPipe value) {
        this._activeVideoConverter = value;
    }

    private void setActiveVideoEncoder(VideoEncoder value) {
        this._activeVideoEncoder = value;
    }

    private void setActiveVideoPacketizer(VideoPipe value) {
        this._activeVideoPacketizer = value;
    }

    private void setAecContext(AecContext value) {
        this._aecContext = value;
    }

    private void setAudioDisabled(boolean value) {
        this._audioDisabled = value;
    }

    private void setH264Converter(VideoPipe value) {
        this._h264Converter = value;
    }

    private void setH264Encoder(VideoEncoder value) {
        this._h264Encoder = value;
    }

    private void setH264Packetizer(VideoPipe value) {
        this._h264Packetizer = value;
    }

    private void setOpusConverter(AudioPipe value) {
        this._opusConverter = value;
    }

    private void setOpusEncoder(AudioEncoder value) {
        this._opusEncoder = value;
    }

    private void setOpusPacketizer(AudioPipe value) {
        this._opusPacketizer = value;
    }

    private void setPcmaConverter(AudioPipe value) {
        this._pcmaConverter = value;
    }

    private void setPcmaEncoder(AudioEncoder value) {
        this._pcmaEncoder = value;
    }

    private void setPcmaPacketizer(AudioPipe value) {
        this._pcmaPacketizer = value;
    }

    private void setPcmuConverter(AudioPipe value) {
        this._pcmuConverter = value;
    }

    private void setPcmuEncoder(AudioEncoder value) {
        this._pcmuEncoder = value;
    }

    private void setPcmuPacketizer(AudioPipe value) {
        this._pcmuPacketizer = value;
    }

    private void setVideoDisabled(boolean value) {
        this._videoDisabled = value;
    }

    private void setViewSink(ViewSink<TView> value) {
        this._viewSink = value;
    }

    private void setVp8Converter(VideoPipe value) {
        this._vp8Converter = value;
    }

    private void setVp8Encoder(VideoEncoder value) {
        this._vp8Encoder = value;
    }

    private void setVp8Packetizer(VideoPipe value) {
        this._vp8Packetizer = value;
    }

    private void setVp9Converter(VideoPipe value) {
        this._vp9Converter = value;
    }

    private void setVp9Encoder(VideoEncoder value) {
        this._vp9Encoder = value;
    }

    private void setVp9Packetizer(VideoPipe value) {
        this._vp9Packetizer = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAudioRecording() {
        Object object = this._audioRecordingLock;
        synchronized (object) {
            super.setIsRecordingAudio(!super.getIsRecordingAudio());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingAudio() || super.getIsRecordingVideo());
            }
            if (super.getAudioTrack() != null && ArrayExtensions.getLength(((AudioTrack)super.getAudioTrack()).getOutputs()) > 0 && ((IAudioOutput[])((AudioTrack)super.getAudioTrack()).getOutputs())[0].getOutput() != null) {
                if (super.getIsRecordingAudio()) {
                    for (AudioSink sink : this.__audioRecorders) {
                        if (Global.tryCast(sink.getInput(), AudioPipe.class).getDisabled()) continue;
                        sink.setDisabled(false);
                        break;
                    }
                } else {
                    for (AudioSink sink : this.__audioRecorders) {
                        sink.setDisabled(true);
                    }
                }
            } else if (ArrayListExtensions.getCount(this.__audioRecorders) > 0) {
                ArrayListExtensions.getItem(this.__audioRecorders).get(0).setDisabled(!super.getIsRecordingAudio());
            }
            return super.getIsRecordingAudio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleVideoRecording() {
        Object object = this._videoRecordingLock;
        synchronized (object) {
            super.setIsRecordingVideo(!super.getIsRecordingVideo());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingAudio() || super.getIsRecordingVideo());
            }
            if (super.getVideoTrack() != null && ArrayExtensions.getLength(((VideoTrack)super.getVideoTrack()).getOutputs()) > 0 && ((IVideoOutput[])((VideoTrack)super.getVideoTrack()).getOutputs())[0].getOutput() != null) {
                if (super.getIsRecordingVideo()) {
                    for (VideoSink sink : this.__videoRecorders) {
                        if (sink.getInput() == null || Global.tryCast(sink.getInput(), VideoPipe.class).getDisabled()) continue;
                        sink.setDisabled(false);
                        break;
                    }
                } else {
                    for (VideoSink sink : this.__videoRecorders) {
                        sink.setDisabled(true);
                    }
                }
            } else if (ArrayListExtensions.getCount(this.__videoRecorders) > 0) {
                ArrayListExtensions.getItem(this.__videoRecorders).get(0).setDisabled(!super.getIsRecordingVideo());
            }
            return super.getIsRecordingVideo();
        }
    }
}

