/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.LongExtensions;
import fm.icelink.StringExtensions;

public class ReportBlock {
    private DataBuffer _dataBuffer;

    public int getCumulativeNumberOfPacketsLost() {
        return this.getDataBuffer().read24Signed(5);
    }

    public DataBuffer getDataBuffer() {
        return this._dataBuffer;
    }

    public long getDelaySinceLastSenderReport() {
        return this.getDataBuffer().read32(20);
    }

    public long getExtendedHighestSequenceNumberReceived() {
        return this.getDataBuffer().read32(8);
    }

    public static int getFixedPayloadLength() {
        return 24;
    }

    public int getFractionLost() {
        return this.getDataBuffer().read8(4);
    }

    public long getInterarrivalJitter() {
        return this.getDataBuffer().read32(12);
    }

    public long getLastSenderReportTimestamp() {
        return this.getDataBuffer().read32(16);
    }

    public double getPercentLost() {
        return (double)this.getFractionLost() / 255.0;
    }

    public long getSynchronizationSource() {
        return this.getDataBuffer().read32(0);
    }

    public ReportBlock(int fractionLost, int cumulativeNumberOfPacketsLost, long extendedHighestSequenceNumberReceived, long interarrivalJitter, long lastSenderReportTimestamp, long delaySinceLastSenderReport) {
        this(0L, fractionLost, cumulativeNumberOfPacketsLost, extendedHighestSequenceNumberReceived, interarrivalJitter, lastSenderReportTimestamp, delaySinceLastSenderReport);
    }

    public ReportBlock(long synchronizationSource, int fractionLost, int cumulativeNumberOfPacketsLost, long extendedHighestSequenceNumberReceived, long interarrivalJitter, long lastSenderReportTimestamp, long delaySinceLastSenderReport) {
        this(DataBuffer.allocate(24));
        this.setSynchronizationSource(synchronizationSource);
        this.setFractionLost(fractionLost);
        this.setCumulativeNumberOfPacketsLost(cumulativeNumberOfPacketsLost);
        this.setExtendedHighestSequenceNumberReceived(extendedHighestSequenceNumberReceived);
        this.setInterarrivalJitter(interarrivalJitter);
        this.setLastSenderReportTimestamp(lastSenderReportTimestamp);
        this.setDelaySinceLastSenderReport(delaySinceLastSenderReport);
    }

    public ReportBlock() {
        this(DataBuffer.allocate(ReportBlock.getFixedPayloadLength()));
    }

    public ReportBlock(DataBuffer dataBuffer) {
        if (dataBuffer == null) {
            throw new RuntimeException(new Exception("DataBuffer cannot be null."));
        }
        if (dataBuffer.getLength() < ReportBlock.getFixedPayloadLength()) {
            throw new RuntimeException(new Exception(StringExtensions.concat("ReportBlock DataBuffer must be at least ", IntegerExtensions.toString(ReportBlock.getFixedPayloadLength()), " bytes.")));
        }
        this.setDataBuffer(dataBuffer);
    }

    public void setCumulativeNumberOfPacketsLost(int value) {
        this.getDataBuffer().write24(value, 5);
    }

    public void setDataBuffer(DataBuffer value) {
        this._dataBuffer = value;
    }

    public void setDelaySinceLastSenderReport(long value) {
        this.getDataBuffer().write32(value, 20);
    }

    public void setExtendedHighestSequenceNumberReceived(long value) {
        this.getDataBuffer().write32(value, 8);
    }

    public void setFractionLost(int value) {
        this.getDataBuffer().write8(value, 4);
    }

    public void setInterarrivalJitter(long value) {
        this.getDataBuffer().write32(value, 12);
    }

    public void setLastSenderReportTimestamp(long value) {
        this.getDataBuffer().write32(value, 16);
    }

    public void setSynchronizationSource(long value) {
        this.getDataBuffer().write32(value, 0);
    }

    public String toString() {
        return StringExtensions.format("SSRC: {0}, Fraction Lost: {1}, Cumulative Packets Lost: {2}, EHSN Received: {3}, Jitter: {4}, Last SR: {5}, Delay Since Last SR: {6}", new Object[]{LongExtensions.toString(this.getSynchronizationSource()), IntegerExtensions.toString(this.getFractionLost()), IntegerExtensions.toString(this.getCumulativeNumberOfPacketsLost()), LongExtensions.toString(this.getExtendedHighestSequenceNumberReceived()), LongExtensions.toString(this.getInterarrivalJitter()), LongExtensions.toString(this.getLastSenderReportTimestamp()), LongExtensions.toString(this.getDelaySinceLastSenderReport())});
    }
}

