/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Log;
import fm.icelink.OperatingSystem;
import fm.icelink.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.attribute.FileAttribute;

public class PathUtility {
    public static String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getAbsolutePath(String path) {
        File file = new File(path);
        return file.getAbsolutePath();
    }

    public static String combinePaths(String path1, String path2) {
        if (path1.isEmpty()) {
            return path2;
        }
        if (path2.isEmpty()) {
            return path1;
        }
        File base = new File(path1);
        File child = new File(base, path2);
        return child.getPath();
    }

    public static String combinePaths(String[] paths) {
        if (paths.length == 0) {
            return "";
        }
        File base = null;
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].isEmpty()) continue;
            base = base == null ? new File(paths[i]) : new File(base, paths[i]);
        }
        return base.getPath();
    }

    public static void delete(String path) throws IOException {
        File toDelete = new File(path);
        toDelete.delete();
    }

    public static void createSymlink(String destinationPath, String linkPath) {
        try {
            if (Platform.getInstance().getOperatingSystem() == OperatingSystem.Android) {
                Class<?> osClass = Class.forName("android.system.Os");
                Method method = osClass.getMethod("symlink", String.class, String.class);
                method.invoke(null, destinationPath, linkPath);
            } else {
                Class<?> fileSystemsClass = Class.forName("java.nio.file.FileSystems");
                Method getDefaultFileSystemMethod = fileSystemsClass.getMethod("getDefault", new Class[0]);
                Object fileSystem = getDefaultFileSystemMethod.invoke(null, new Object[0]);
                Class<?> fileSystemClass = Class.forName("java.nio.file.FileSystem");
                Method getPathMethod = fileSystemClass.getMethod("getPath", String.class, String[].class);
                Object destLocation = getPathMethod.invoke(fileSystem, destinationPath, new String[0]);
                Object linkLocation = getPathMethod.invoke(fileSystem, linkPath, new String[0]);
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Method createSymbolicLinkMethod = filesClass.getMethod("createSymbolicLink", pathClass, pathClass, FileAttribute[].class);
                createSymbolicLinkMethod.invoke(null, linkLocation, destLocation, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            Log.error("Could not create symbolic link.", e);
        }
    }
}

