/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.MediaComponentStats;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import java.util.HashMap;

public class MediaReceiverStats
extends MediaComponentStats {
    private long _bytesReceived;
    private int _jitter;
    private long _packetsDiscarded;
    private long _packetsLost;
    private long _packetsReceived;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "packetsReceived")) {
                if (Global.equals(str, "bytesReceived")) {
                    this.setBytesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
                } else if (Global.equals(str, "packetsLost")) {
                    this.setPacketsLost(JsonSerializer.deserializeLong(valueJson).getValue());
                } else if (Global.equals(str, "jitter")) {
                    this.setJitter(JsonSerializer.deserializeInteger(valueJson).getValue());
                } else if (Global.equals(str, "packetsDiscarded")) {
                    this.setPacketsDiscarded(JsonSerializer.deserializeLong(valueJson).getValue());
                }
            } else {
                this.setPacketsReceived(JsonSerializer.deserializeLong(valueJson).getValue());
            }
        }
    }

    public static MediaReceiverStats fromJson(String mediaReceiverJson) {
        return JsonSerializer.deserializeObject(mediaReceiverJson, new IFunction0<MediaReceiverStats>(){

            @Override
            public MediaReceiverStats invoke() {
                return new MediaReceiverStats();
            }
        }, new IAction3<MediaReceiverStats, String, String>(){

            @Override
            public void invoke(MediaReceiverStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public int getJitter() {
        return this._jitter;
    }

    public long getPacketsDiscarded() {
        return this._packetsDiscarded;
    }

    public long getPacketsLost() {
        return this._packetsLost;
    }

    public long getPacketsReceived() {
        return this._packetsReceived;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "packetsReceived", JsonSerializer.serializeLong(new NullableLong(this.getPacketsReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesReceived", JsonSerializer.serializeLong(new NullableLong(this.getBytesReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "packetsLost", JsonSerializer.serializeLong(new NullableLong(this.getPacketsLost())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "jitter", JsonSerializer.serializeInteger(new NullableInteger(this.getJitter())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "packetsDiscarded", JsonSerializer.serializeLong(new NullableLong(this.getPacketsDiscarded())));
    }

    void setBytesReceived(long value) {
        this._bytesReceived = value;
    }

    void setJitter(int value) {
        this._jitter = value;
    }

    void setPacketsDiscarded(long value) {
        this._packetsDiscarded = value;
    }

    void setPacketsLost(long value) {
        this._packetsLost = value;
    }

    void setPacketsReceived(long value) {
        this._packetsReceived = value;
    }

    public static String toJson(MediaReceiverStats mediaReceiver) {
        return JsonSerializer.serializeObject(mediaReceiver, new IAction2<MediaReceiverStats, HashMap<String, String>>(){

            @Override
            public void invoke(MediaReceiverStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public String toJson() {
        return MediaReceiverStats.toJson(this);
    }
}

