/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Collection;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaFormat;
import java.util.HashMap;

public abstract class MediaFormatCollection<TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends Collection<TFormat, TFormatCollection> {
    private Object __equivalenceLookup;
    private HashMap<String, TFormat> __fullNameLookup;
    private Object __fullNameLookupLock;
    private HashMap<String, TFormat> __payloadTypeLookup = new HashMap();
    private Object __payloadTypeLookupLock = new Object();

    @Override
    protected void addSuccess(TFormat value) {
        super.addSuccess(value);
        this.cacheFullName(((MediaFormat)value).getFullName(), value);
        if (((MediaFormat)value).getRegisteredPayloadType() >= 0) {
            this.cachePayloadType(IntegerExtensions.toString(((MediaFormat)value).getRegisteredPayloadType()), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFullName(String fullName, TFormat format) {
        Object object = this.__fullNameLookupLock;
        synchronized (object) {
            if (!this.__fullNameLookup.containsKey(fullName)) {
                HashMapExtensions.add(this.__fullNameLookup, fullName, format);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePayloadType(String payloadType, TFormat format) {
        Object object = this.__payloadTypeLookupLock;
        synchronized (object) {
            HashMapExtensions.add(this.__payloadTypeLookup, payloadType, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TFormat getByFullName(String fullName) {
        MediaFormat local = null;
        Object object = this.__fullNameLookupLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(local);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__fullNameLookup, fullName, _var0);
            local = _var0.getValue();
            if (_var1) {
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TFormat getByPayloadType(String payloadType) {
        MediaFormat local = null;
        Object object = this.__payloadTypeLookupLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(local);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__payloadTypeLookup, payloadType, _var0);
            local = _var0.getValue();
            if (_var1) {
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat getEquivalent(TFormat format) {
        Object object = this.__equivalenceLookup;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!local.isEquivalent(format)) continue;
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat getEquivalent(TFormat format, boolean ignoreIsPacketized) {
        Object object = this.__equivalenceLookup;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!local.isEquivalent(format, ignoreIsPacketized)) continue;
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEquivalent(TFormat format) {
        Object object = this.__equivalenceLookup;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!local.isEquivalent(format)) continue;
                return true;
            }
        }
        return false;
    }

    protected MediaFormatCollection() {
        this.__fullNameLookup = new HashMap();
        this.__fullNameLookupLock = new Object();
        this.__equivalenceLookup = new Object();
    }

    @Override
    protected void removeSuccess(TFormat value) {
        super.removeSuccess(value);
        this.uncacheFullName(((MediaFormat)value).getFullName());
        if (((MediaFormat)value).getRegisteredPayloadType() >= 0) {
            this.uncachePayloadType(IntegerExtensions.toString(((MediaFormat)value).getRegisteredPayloadType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncacheFullName(String fullName) {
        Object object = this.__fullNameLookupLock;
        synchronized (object) {
            HashMapExtensions.remove(this.__fullNameLookup, fullName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncachePayloadType(String payloadType) {
        Object object = this.__payloadTypeLookupLock;
        synchronized (object) {
            HashMapExtensions.remove(this.__payloadTypeLookup, payloadType);
        }
    }
}

