/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;

public abstract class MediaFormat<TFormat extends MediaFormat<TFormat>> {
    private int _clockRate;
    private boolean _isEncrypted;
    private boolean _isInjected;
    private boolean _isPacketized;
    private String _name;
    private int _registeredPayloadType;
    private int _staticPayloadType;

    public TFormat clone() {
        TFormat local = this.createInstance();
        ((MediaFormat)local).setName(this.getName());
        ((MediaFormat)local).setClockRate(this.getClockRate());
        ((MediaFormat)local).setIsPacketized(this.getIsPacketized());
        ((MediaFormat)local).setIsEncrypted(this.getIsEncrypted());
        ((MediaFormat)local).setIsInjected(this.getIsInjected());
        ((MediaFormat)local).setRegisteredPayloadType(this.getRegisteredPayloadType());
        ((MediaFormat)local).setStaticPayloadType(this.getStaticPayloadType());
        return local;
    }

    protected abstract TFormat createInstance();

    public int getClockRate() {
        return this._clockRate;
    }

    public String getFullName() {
        if (this.getName() == null) {
            throw new RuntimeException(new Exception("Name cannot be null."));
        }
        String parameters = this.getParameters();
        if (StringExtensions.isNullOrEmpty(parameters)) {
            return StringExtensions.format("{0}/{1}", this.getName(), IntegerExtensions.toString(this.getClockRate()));
        }
        return StringExtensions.format("{0}/{1}/{2}", this.getName(), IntegerExtensions.toString(this.getClockRate()), parameters);
    }

    public boolean getIsEncrypted() {
        return this._isEncrypted;
    }

    public boolean getIsInjected() {
        return this._isInjected;
    }

    public boolean getIsPacketized() {
        return this._isPacketized;
    }

    public String getName() {
        return this._name;
    }

    public abstract String getParameters();

    public static String getRedName() {
        return "red";
    }

    int getRegisteredPayloadType() {
        return this._registeredPayloadType;
    }

    public int getStaticPayloadType() {
        return this._staticPayloadType;
    }

    public static String getUlpFecName() {
        return "ulpfec";
    }

    public boolean isEquivalent(TFormat format) {
        return this.isEquivalent(format, false);
    }

    public boolean isEquivalent(TFormat format, boolean ignoreIsPacketized) {
        if (format != null && StringExtensions.isEqual(((MediaFormat)format).getName(), this.getName(), StringComparison.OrdinalIgnoreCase) && ((MediaFormat)format).getClockRate() == this.getClockRate()) {
            if (ignoreIsPacketized) {
                return true;
            }
            if (Global.equals(((MediaFormat)format).getIsPacketized(), this.getIsPacketized())) {
                return true;
            }
        }
        return false;
    }

    public MediaFormat(String name, int clockRate) {
        this.setName(name);
        this.setClockRate(clockRate);
        this.setRegisteredPayloadType(-1);
        this.setStaticPayloadType(-1);
    }

    protected MediaFormat() {
        this.setRegisteredPayloadType(-1);
        this.setStaticPayloadType(-1);
    }

    public void setClockRate(int value) {
        this._clockRate = value;
    }

    public void setIsEncrypted(boolean value) {
        this._isEncrypted = value;
    }

    public void setIsInjected(boolean value) {
        this._isInjected = value;
    }

    public void setIsPacketized(boolean value) {
        this._isPacketized = value;
    }

    public void setName(String value) {
        this._name = value;
    }

    void setRegisteredPayloadType(int value) {
        this._registeredPayloadType = value;
    }

    protected void setStaticPayloadType(int value) {
        this._staticPayloadType = value;
    }

    public String toString() {
        return StringExtensions.concat(this.getFullName(), this.getIsPacketized() ? " (packetized)" : " (not packetized)");
    }
}

