/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;
import fm.icelink.Promise;

public class ManagedTimer {
    private IAction0 __callback = null;
    private volatile boolean __exited = false;
    private Object __lock = new Object();
    private volatile boolean __running = false;
    private ManagedThread __thread = null;
    private int _interval;

    private void doStopAsync(final Promise<Object> promise) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                ManagedTimer.this.stop();
                promise.resolve(null);
            }
        });
    }

    public int getInterval() {
        return this._interval;
    }

    public boolean getRunning() {
        return this.__running;
    }

    private void innerLoop(ManagedThread thread) {
        ManagedStopwatch stopwatch = new ManagedStopwatch();
        long num = 0L;
        stopwatch.start();
        while (this.__running) {
            thread.loopBegin();
            int num2 = (int)(stopwatch.getElapsedMilliseconds() - num);
            while (this.__running && num2 >= this.getInterval()) {
                this.__callback.invoke();
                num2 = (int)(stopwatch.getElapsedMilliseconds() - (num += (long)this.getInterval()));
            }
            int millisecondsTimeout = this.getInterval() - num2;
            if (millisecondsTimeout > 50) {
                ManagedThread.sleep(millisecondsTimeout);
            } else if (millisecondsTimeout > 0) {
                ManagedThread.sleep(1);
            }
            thread.loopEnd();
        }
        this.__exited = true;
    }

    public ManagedTimer(int interval, IAction0 callback) {
        if (callback == null) {
            throw new RuntimeException(new Exception("Callback cannot be null."));
        }
        this.setInterval(interval);
        this.__callback = callback;
    }

    public static int perSecondInterval(int timesPerSecond) {
        return 1000 / timesPerSecond;
    }

    private void setInterval(int value) {
        this._interval = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.getRunning()) {
                return false;
            }
            this.__running = true;
        }
        this.__exited = false;
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.ManagedTimer.innerLoop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                ManagedTimer.this.innerLoop(thread);
            }
        });
        this.__thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__running) {
                return false;
            }
            this.__running = false;
        }
        while (!this.__exited) {
            ManagedThread.sleep(10);
        }
        this.__thread = null;
        return true;
    }

    public Future<Object> stopAsync() {
        Promise<Object> promise = new Promise<Object>();
        try {
            this.doStopAsync(promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }
}

