/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import fm.icelink.IFunction2;
import fm.icelink.IntegerExtensions;
import fm.icelink.LogLevel;
import fm.icelink.StringExtensions;
import java.util.Date;

public abstract class LogProvider {
    private IFunction2<String, LogLevel, Boolean> _filter;
    private LogLevel _level;

    protected abstract void doLog(Date var1, LogLevel var2, String var3, String var4, Exception var5);

    protected String generateLogLine(Date timestamp, LogLevel level, String tag, String message, Exception ex) {
        String str = StringExtensions.format("{0} [{1}] {2} {3}", new Object[]{LogProvider.getPrefix(level), tag, LogProvider.getPrefixTimestamp(timestamp), message});
        if (ex != null) {
            str = StringExtensions.concat(str, StringExtensions.format("\n{0}", ex.toString()));
        }
        return str;
    }

    public IFunction2<String, LogLevel, Boolean> getFilter() {
        return this._filter;
    }

    public LogLevel getLevel() {
        return this._level;
    }

    protected static String getPrefix(LogLevel level, boolean includeTimestamp) {
        String prefix = LogProvider.getPrefix(level);
        if (includeTimestamp) {
            prefix = StringExtensions.format("{0} {1}", prefix, LogProvider.getPrefixTimestamp(DateExtensions.getUtcNow()));
        }
        return prefix;
    }

    protected static String getPrefix(LogLevel level) {
        String str = "IceLink";
        LogLevel _var0 = level;
        if (_var0 == LogLevel.Verbose) {
            return StringExtensions.format("[{0}] VERBOSE", str);
        }
        if (_var0 == LogLevel.Debug) {
            return StringExtensions.format("[{0}] DEBUG  ", str);
        }
        if (_var0 == LogLevel.Info) {
            return StringExtensions.format("[{0}] INFO   ", str);
        }
        if (_var0 == LogLevel.Warn) {
            return StringExtensions.format("[{0}] WARN   ", str);
        }
        if (_var0 == LogLevel.Error) {
            return StringExtensions.format("[{0}] ERROR  ", str);
        }
        if (_var0 == LogLevel.Fatal) {
            return StringExtensions.format("[{0}] FATAL  ", str);
        }
        if (_var0 == LogLevel.None) {
            return StringExtensions.format("[{0}] NONE   ", str);
        }
        return StringExtensions.format("[{0}] ?????  ", str);
    }

    public static String getPrefixTimestamp(Date timestamp) {
        String str = IntegerExtensions.toString(DateExtensions.getYear(timestamp));
        String str2 = IntegerExtensions.toString(DateExtensions.getMonth(timestamp));
        String str3 = IntegerExtensions.toString(DateExtensions.getDay(timestamp));
        String str4 = IntegerExtensions.toString(DateExtensions.getHour(timestamp));
        String str5 = IntegerExtensions.toString(DateExtensions.getMinute(timestamp));
        String str6 = IntegerExtensions.toString(DateExtensions.getSecond(timestamp));
        String str7 = IntegerExtensions.toString(DateExtensions.getMillisecond(timestamp));
        while (StringExtensions.getLength(str) < 4) {
            str = StringExtensions.concat("0", str);
        }
        while (StringExtensions.getLength(str2) < 2) {
            str2 = StringExtensions.concat("0", str2);
        }
        while (StringExtensions.getLength(str3) < 2) {
            str3 = StringExtensions.concat("0", str3);
        }
        while (StringExtensions.getLength(str4) < 2) {
            str4 = StringExtensions.concat("0", str4);
        }
        while (StringExtensions.getLength(str5) < 2) {
            str5 = StringExtensions.concat("0", str5);
        }
        while (StringExtensions.getLength(str6) < 2) {
            str6 = StringExtensions.concat("0", str6);
        }
        while (StringExtensions.getLength(str7) < 3) {
            str7 = StringExtensions.concat("0", str7);
        }
        return StringExtensions.format("{0}/{1}/{2}-{3}:{4}:{5}.{6}", new Object[]{str, str2, str3, str4, str5, str6, str7});
    }

    public void log(Date timestamp, LogLevel level, String tag, String message, Exception ex) {
        if (level.getAssignedValue() >= this.getLevel().getAssignedValue()) {
            try {
                boolean flag = true;
                if (this.getFilter() != null) {
                    flag = this.getFilter().invoke(tag, level);
                }
                if (flag) {
                    this.doLog(timestamp, level, tag, message, ex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void log(Date timestamp, LogLevel level, String tag, String message) {
        this.log(timestamp, level, tag, message, null);
    }

    public LogProvider() {
        this.setLevel(LogLevel.Info);
    }

    public void setFilter(IFunction2<String, LogLevel, Boolean> value) {
        this._filter = value;
    }

    public void setLevel(LogLevel value) {
        this._level = value;
    }
}

