/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IViewableMedia;
import fm.icelink.Layout;
import fm.icelink.LayoutOrigin;
import fm.icelink.LayoutPreset;
import fm.icelink.Log;
import fm.icelink.Unhandled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class LayoutManager<T>
extends LayoutPreset {
    private List<IAction1<Layout>> __onLayout = new ArrayList<IAction1<Layout>>();
    private boolean _inBatch = false;
    private LayoutOrigin _layoutOrigin;
    private T _localView;
    private IAction1<Layout> _onLayout = null;
    private Object _remoteViewsLock;
    private HashMap<String, ArrayList<T>> _remoteViewsTable = new HashMap();

    public void addOnLayout(IAction1<Layout> value) {
        if (value != null) {
            if (this._onLayout == null) {
                this._onLayout = new IAction1<Layout>(){

                    @Override
                    public void invoke(Layout p0) {
                        for (IAction1 action : new ArrayList(LayoutManager.this.__onLayout)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onLayout.add(value);
        }
    }

    public boolean addRemoteMedia(IViewableMedia<T> remoteMedia) {
        if (remoteMedia == null) {
            return false;
        }
        return this.addRemoteView(remoteMedia.getId(), remoteMedia.getView());
    }

    public boolean addRemoteView(String id, T view) {
        if (id == null) {
            Log.warn("Could not add remote view. The ID cannot be null.");
            return false;
        }
        if (view == null) {
            Log.warn("Could not add remote view. The view cannot be null.");
            return false;
        }
        try {
            this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.LayoutManager<T>.addRemoteViewUI";
                }

                @Override
                public void invoke(Object idObj, Object viewObj) {
                    LayoutManager.this.addRemoteViewUI(idObj, viewObj);
                }
            }, id, view);
        }
        catch (Exception exception) {
            Log.error("Could not add remote view.", exception);
        }
        return true;
    }

    public boolean addRemoteViews(String[] ids, T[] views) {
        if (ids == null) {
            Log.warn("Could not add remote views. The IDs cannot be null.");
            return false;
        }
        if (views == null) {
            Log.warn("Could not add remote views. The views cannot be null.");
            return false;
        }
        if (ArrayExtensions.getLength(ids) != ArrayExtensions.getLength(views)) {
            Log.warn("Could not add remote views. The number of IDs and views must match.");
            return false;
        }
        try {
            this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.LayoutManager<T>.addRemoteViewsUI";
                }

                @Override
                public void invoke(Object idsObj, Object viewsObj) {
                    LayoutManager.this.addRemoteViewsUI(idsObj, viewsObj);
                }
            }, ids, views);
        }
        catch (Exception exception) {
            Log.error("Could not add remote views.", exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteViewsUI(Object idsObj, Object viewsObj) {
        Object[] strArray = (String[])idsObj;
        Object[] localArray = (Object[])viewsObj;
        Object object = this._remoteViewsLock;
        synchronized (object) {
            this._inBatch = true;
            for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                this.addRemoteViewUI(strArray[i], localArray[i]);
            }
            this._inBatch = false;
            this.layout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteViewUI(Object idObj, Object viewObj) {
        String id = (String)idObj;
        Object item = viewObj;
        Object object = this._remoteViewsLock;
        synchronized (object) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(item);
            ArrayList<T> remoteViewsInternal = this.getRemoteViewsInternal(id);
            if (remoteViewsInternal != null) {
                ArrayListExtensions.addRange(list, remoteViewsInternal);
            }
            this.addView(item);
            HashMapExtensions.set(HashMapExtensions.getItem(this._remoteViewsTable), id, list);
            if (!this._inBatch) {
                this.layout();
            }
        }
    }

    protected abstract void addView(T var1);

    protected abstract void dispatchToMainThread(IAction2<Object, Object> var1, Object var2, Object var3);

    private void doSwapRemoteView(final String idToRemove, final T viewToRemove, final String idToAdd, final T viewToAdd) {
        IAction2<Object, Object> action = null;
        try {
            if (action == null) {
                action = new IAction2<Object, Object>(){

                    @Override
                    public void invoke(Object unused1, Object unused2) {
                        if (viewToRemove != null) {
                            LayoutManager.this.removeRemoteViewUI(idToRemove, viewToRemove);
                        }
                        LayoutManager.this.addRemoteViewUI(idToAdd, viewToAdd);
                    }
                };
            }
            this.dispatchToMainThread(action, null, null);
        }
        catch (Exception exception) {
            Log.error("Could not swap remote view.", exception);
        }
    }

    private void doSwapRemoteViews(final String[] idsToRemove, final ArrayList<T> viewsToRemove, final String[] idsToAdd, final T[] viewsToAdd) {
        IAction2<Object, Object> action = null;
        try {
            if (action == null) {
                action = new IAction2<Object, Object>(){

                    @Override
                    public void invoke(Object unused1, Object unused2) {
                        LayoutManager.this.removeRemoteViewsUI(idsToRemove, viewsToRemove);
                        LayoutManager.this.addRemoteViewsUI(idsToAdd, viewsToAdd);
                    }
                };
            }
            this.dispatchToMainThread(action, null, null);
        }
        catch (Exception exception) {
            Log.error("Could not swap remote views.", exception);
        }
    }

    protected Layout getLayout(int layoutWidth, int layoutHeight, int remoteCount, String[] remoteViewIds) {
        Layout p = super.calculateLayout(layoutWidth, layoutHeight, remoteCount, this.getLayoutOrigin());
        IAction1<Layout> onLayout = this._onLayout;
        if (onLayout != null) {
            try {
                onLayout.invoke(p);
            }
            catch (Exception exception) {
                Unhandled.logException(exception, "LayoutManager -> OnLayout");
            }
        }
        return p;
    }

    protected Layout getLayout(int layoutWidth, int layoutHeight, int remoteCount) {
        Layout p = super.calculateLayout(layoutWidth, layoutHeight, remoteCount, this.getLayoutOrigin());
        IAction1<Layout> onLayout = this._onLayout;
        if (onLayout != null) {
            try {
                onLayout.invoke(p);
            }
            catch (Exception exception) {
                Unhandled.logException(exception, "LayoutManager -> OnLayout");
            }
        }
        return p;
    }

    public LayoutOrigin getLayoutOrigin() {
        return this._layoutOrigin;
    }

    public T getLocalView() {
        return this._localView;
    }

    private T getNewestRemoteView(String id) {
        ArrayList<T> remoteViewsInternal = this.getRemoteViewsInternal(id);
        if (remoteViewsInternal == null) {
            return null;
        }
        return ArrayListExtensions.getItem(remoteViewsInternal).get(0);
    }

    private T getOldestRemoteView(String id) {
        ArrayList<T> remoteViewsInternal = this.getRemoteViewsInternal(id);
        if (remoteViewsInternal == null) {
            return null;
        }
        return ArrayListExtensions.getItem(remoteViewsInternal).get(ArrayListExtensions.getCount(remoteViewsInternal) - 1);
    }

    public T getRemoteView(String id) {
        if (id == null) {
            return null;
        }
        return this.getNewestRemoteView(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRemoteViewIds() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this._remoteViewsLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(this._remoteViewsTable)) {
                list.add(str);
            }
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> getRemoteViews(String[] ids) {
        if (ids == null) {
            throw new RuntimeException(new Exception("Could not get remote views. The IDs cannot be null."));
        }
        ArrayList<T> list = new ArrayList<T>();
        Object object = this._remoteViewsLock;
        synchronized (object) {
            for (String str : ids) {
                list.add(this.getRemoteView(str));
            }
        }
        return list;
    }

    public ArrayList<T> getRemoteViews() {
        return this.getRemoteViews(this.getRemoteViewIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<T> getRemoteViewsInternal(String id) {
        if (id == null) {
            throw new RuntimeException(new Exception("The ID cannot be null."));
        }
        ArrayList list = null;
        Object object = this._remoteViewsLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this._remoteViewsTable, id, _var0);
            list = _var0.getValue();
            if (!_var1) {
                list = null;
            }
        }
        return list;
    }

    public abstract void layout();

    public LayoutManager(LayoutPreset preset) {
        this._remoteViewsLock = new Object();
        if (preset == null) {
            preset = LayoutPreset.getFacetime();
        }
        preset.copyToPreset(this);
        this.setLayoutOrigin(LayoutOrigin.TopLeft);
    }

    public LayoutManager() {
        this(null);
    }

    public void layoutOnMainThread() {
        this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

            @Override
            public String getId() {
                return "fm.icelink.LayoutManager<T>.layoutOnMainThreadUI";
            }

            @Override
            public void invoke(Object unused1, Object unused2) {
                LayoutManager.this.layoutOnMainThreadUI(unused1, unused2);
            }
        }, null, null);
    }

    private void layoutOnMainThreadUI(Object unused1, Object unused2) {
        this.layout();
    }

    public void removeOnLayout(IAction1<Layout> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onLayout, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onLayout.remove(value);
        if (this.__onLayout.size() == 0) {
            this._onLayout = null;
        }
    }

    public boolean removeRemoteMedia(IViewableMedia<T> remoteMedia) {
        if (remoteMedia == null) {
            return false;
        }
        return this.removeRemoteView(remoteMedia.getId());
    }

    public boolean removeRemoteView(String id) {
        if (id == null) {
            Log.warn("Could not remove remote view. The ID cannot be null.");
            return false;
        }
        T oldestRemoteView = this.getOldestRemoteView(id);
        if (oldestRemoteView != null) {
            try {
                this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.LayoutManager<T>.removeRemoteViewUI";
                    }

                    @Override
                    public void invoke(Object idObj, Object viewObj) {
                        LayoutManager.this.removeRemoteViewUI(idObj, viewObj);
                    }
                }, id, oldestRemoteView);
            }
            catch (Exception exception) {
                Log.error("Could not remove remote view.", exception);
            }
        }
        return true;
    }

    public void removeRemoteViews() {
        this.removeRemoteViews(this.getRemoteViewIds());
    }

    public boolean removeRemoteViews(String[] ids) {
        if (ids == null) {
            Log.warn("Could not remove remote views. The IDs cannot be null.");
            return false;
        }
        try {
            this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.LayoutManager<T>.removeRemoteViewsUI";
                }

                @Override
                public void invoke(Object idsObj, Object viewsObj) {
                    LayoutManager.this.removeRemoteViewsUI(idsObj, viewsObj);
                }
            }, ids, this.getRemoteViews(ids));
        }
        catch (Exception exception) {
            Log.error("Could not remove remote views.", exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRemoteViewsUI(Object idsObj, Object viewsObj) {
        Object[] strArray = (String[])idsObj;
        ArrayList list = (ArrayList)viewsObj;
        Object object = this._remoteViewsLock;
        synchronized (object) {
            this._inBatch = true;
            for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                this.removeRemoteViewUI(strArray[i], ArrayListExtensions.getItem(list).get(i));
            }
            this._inBatch = false;
            this.layout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRemoteViewUI(Object idObj, Object viewObj) {
        String id = (String)idObj;
        Object item = viewObj;
        Object object = this._remoteViewsLock;
        synchronized (object) {
            ArrayList list = new ArrayList();
            ArrayList<T> remoteViewsInternal = this.getRemoteViewsInternal(id);
            if (remoteViewsInternal != null) {
                ArrayListExtensions.addRange(list, remoteViewsInternal);
            }
            list.remove(item);
            this.removeView(item);
            if (ArrayListExtensions.getCount(list) == 0) {
                HashMapExtensions.remove(this._remoteViewsTable, id);
            } else {
                HashMapExtensions.set(HashMapExtensions.getItem(this._remoteViewsTable), id, list);
            }
            if (!this._inBatch) {
                this.layout();
            }
        }
    }

    protected abstract void removeView(T var1);

    public void reset() {
        this.removeRemoteViews();
        this.unsetLocalView();
    }

    protected void setLayoutOrigin(LayoutOrigin value) {
        this._layoutOrigin = value;
    }

    public boolean setLocalMedia(IViewableMedia<T> localMedia) {
        if (localMedia == null) {
            return false;
        }
        return this.setLocalView(localMedia.getView());
    }

    public boolean setLocalView(T view) {
        if (view == null) {
            Log.warn("Could not set local view. The view cannot be null.");
            return false;
        }
        if (view != null) {
            try {
                this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.LayoutManager<T>.setLocalViewUI";
                    }

                    @Override
                    public void invoke(Object viewObj, Object unused) {
                        LayoutManager.this.setLocalViewUI(viewObj, unused);
                    }
                }, view, null);
            }
            catch (Exception exception) {
                Log.error("Could not set local view.", exception);
            }
        }
        return true;
    }

    private void setLocalViewUI(Object viewObj, Object unused) {
        Object view = viewObj;
        T localView = this._localView;
        if (localView != null) {
            this.removeView(localView);
        }
        this._localView = view;
        this.addView(view);
        this.layout();
    }

    public boolean swapRemoteMedia(IViewableMedia<T> remoteMediaToRemove, IViewableMedia<T> remoteMediaToAdd) {
        if (remoteMediaToRemove == null) {
            return false;
        }
        if (remoteMediaToAdd == null) {
            return false;
        }
        return this.swapRemoteView(remoteMediaToRemove.getId(), remoteMediaToAdd.getId(), remoteMediaToAdd.getView());
    }

    public boolean swapRemoteView(String idToRemove, String idToAdd, T viewToAdd) {
        if (idToRemove == null) {
            Log.warn("Could not swap remote view. The ID to remove cannot be null.");
            return false;
        }
        if (idToAdd == null) {
            Log.warn("Could not swap remote view. The ID to add cannot be null.");
            return false;
        }
        if (viewToAdd == null) {
            Log.warn("Could not swap remote view. The view to add cannot be null.");
            return false;
        }
        this.doSwapRemoteView(idToRemove, this.getOldestRemoteView(idToRemove), idToAdd, viewToAdd);
        return true;
    }

    public boolean swapRemoteViews(String[] idsToRemove, String[] idsToAdd, T[] viewsToAdd) {
        if (idsToRemove == null) {
            Log.warn("Could not swap remote views. The IDs to remove cannot be null.");
            return false;
        }
        if (idsToAdd == null) {
            Log.warn("Could not swap remote views. The IDs to add cannot be null.");
            return false;
        }
        if (viewsToAdd == null) {
            Log.warn("Could not swap remote views. The views to add cannot be null.");
            return false;
        }
        if (ArrayExtensions.getLength(idsToAdd) != ArrayExtensions.getLength(viewsToAdd)) {
            Log.warn("Could not swap remote views. The number of IDs and views to add must match.");
            return false;
        }
        this.doSwapRemoteViews(idsToRemove, this.getRemoteViews(idsToRemove), idsToAdd, viewsToAdd);
        return true;
    }

    public boolean unsetLocalView() {
        T localView = this.getLocalView();
        if (localView == null) {
            Log.warn("Could not unset local view. A view does not exist.");
            return false;
        }
        try {
            this.dispatchToMainThread((IAction2<Object, Object>)new IActionDelegate2<Object, Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.LayoutManager<T>.unsetLocalViewUI";
                }

                @Override
                public void invoke(Object viewObj, Object unused) {
                    LayoutManager.this.unsetLocalViewUI(viewObj, unused);
                }
            }, localView, null);
        }
        catch (Exception exception) {
            Log.error("Could not unset local view.", exception);
        }
        return true;
    }

    private void unsetLocalViewUI(Object viewObj, Object unused) {
        Object view = viewObj;
        this._localView = null;
        this.removeView(view);
        this.layout();
    }
}

