/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IntegerExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.LayoutScale;
import fm.icelink.ParseAssistant;
import java.util.HashMap;

public class LayoutFrame {
    private int _height;
    private int _width;
    private int _x;
    private int _y;

    public static LayoutFrame fromJson(String layoutFrameJson) {
        return JsonSerializer.deserializeObject(layoutFrameJson, new IFunction0<LayoutFrame>(){

            @Override
            public LayoutFrame invoke() {
                return new LayoutFrame();
            }
        }, new IAction3<LayoutFrame, String, String>(){

            @Override
            public void invoke(LayoutFrame rectangle, String key, String valueJson) {
                String str = key;
                if (str != null) {
                    if (!Global.equals(str, "x")) {
                        if (Global.equals(str, "y")) {
                            rectangle.setY(ParseAssistant.parseIntegerValue(valueJson));
                        } else if (Global.equals(str, "w") || Global.equals(str, "width")) {
                            rectangle.setWidth(ParseAssistant.parseIntegerValue(valueJson));
                        } else if (Global.equals(str, "h") || Global.equals(str, "height")) {
                            rectangle.setHeight(ParseAssistant.parseIntegerValue(valueJson));
                        }
                    } else {
                        rectangle.setX(ParseAssistant.parseIntegerValue(valueJson));
                    }
                }
            }
        });
    }

    public int getHeight() {
        return this._height;
    }

    public static LayoutFrame getScaledFrame(LayoutScale scale, int outerWidth, int outerHeight, int innerWidth, int innerHeight) {
        int x = 0;
        int y = 0;
        int width = outerWidth;
        int height = outerHeight;
        if (outerWidth == 0 || outerHeight == 0 || innerWidth == 0 || innerHeight == 0) {
            if (outerWidth == 0 || innerWidth == 0) {
                width = 0;
                x = outerWidth / 2;
            }
            if (outerHeight == 0 || innerHeight == 0) {
                height = 0;
                y = outerHeight / 2;
            }
        } else if (Global.equals((Object)scale, (Object)LayoutScale.Contain)) {
            float num5 = (float)outerWidth / (float)outerHeight;
            float num6 = (float)innerWidth / (float)innerHeight;
            if (num5 > num6) {
                width = (int)((float)outerHeight * num6);
                x = (outerWidth - width) / 2;
            } else if (num5 < num6) {
                height = (int)((float)outerWidth / num6);
                y = (outerHeight - height) / 2;
            }
        } else if (Global.equals((Object)scale, (Object)LayoutScale.Cover)) {
            float num5 = (float)outerWidth / (float)outerHeight;
            float num6 = (float)innerWidth / (float)innerHeight;
            if (num5 < num6) {
                width = (int)((float)outerHeight * num6);
                x = (outerWidth - width) / 2;
            } else if (num5 > num6) {
                height = (int)((float)outerWidth / num6);
                y = (outerHeight - height) / 2;
            }
        }
        return new LayoutFrame(x, y, width, height);
    }

    public int getWidth() {
        return this._width;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public boolean isEquivalent(LayoutFrame layoutFrame) {
        return layoutFrame.getX() == this.getX() && layoutFrame.getY() == this.getY() && layoutFrame.getWidth() == this.getWidth() && layoutFrame.getHeight() == this.getHeight();
    }

    private LayoutFrame() {
    }

    public LayoutFrame(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setHeight(int value) {
        this._height = value;
    }

    public void setWidth(int value) {
        this._width = value;
    }

    public void setX(int value) {
        this._x = value;
    }

    public void setY(int value) {
        this._y = value;
    }

    public static String toJson(LayoutFrame layoutFrame) {
        return JsonSerializer.serializeObject(layoutFrame, new IAction2<LayoutFrame, HashMap<String, String>>(){

            @Override
            public void invoke(LayoutFrame r, HashMap<String, String> jsonObject) {
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "x", IntegerExtensions.toString(r.getX()));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "y", IntegerExtensions.toString(r.getY()));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "width", IntegerExtensions.toString(r.getWidth()));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "height", IntegerExtensions.toString(r.getHeight()));
            }
        });
    }

    public String toJson() {
        return LayoutFrame.toJson(this);
    }
}

