/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum LayoutAlignment {
    TopLeft(1),
    Top(2),
    TopRight(3),
    Left(4),
    Center(5),
    Right(6),
    BottomLeft(7),
    Bottom(8),
    BottomRight(9);

    private final int value;
    private static final Map<Integer, LayoutAlignment> lookup;

    private LayoutAlignment(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static LayoutAlignment getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, LayoutAlignment>();
        for (LayoutAlignment s : EnumSet.allOf(LayoutAlignment.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

