/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AtomicLong;
import fm.icelink.CandidatePairState;
import fm.icelink.CandidatePairStats;
import fm.icelink.CandidateStats;
import fm.icelink.CandidateType;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IActionDelegate3;
import fm.icelink.ILog;
import fm.icelink.IceCandidate;
import fm.icelink.IceCandidatePair;
import fm.icelink.IceCheckList;
import fm.icelink.IceComponent;
import fm.icelink.IceDatagramSocketManager;
import fm.icelink.IceGatherer;
import fm.icelink.IceGatheringState;
import fm.icelink.IceKeepAlivePolicy;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceLocalRelayedCandidateState;
import fm.icelink.IceParameters;
import fm.icelink.IcePolicy;
import fm.icelink.IceRole;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IceTransactionManager;
import fm.icelink.IceTransportOptions;
import fm.icelink.IceTransportState;
import fm.icelink.IceValidList;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import fm.icelink.TransportAddress;
import fm.icelink.TransportStats;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.TransactionTransmitCounterAttribute;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

class IceTransport
extends Transport {
    private IceCandidatePair __activeCandidatePair;
    private HashMap<String, IceCandidatePair> __candidatePairCache;
    private IceCheckList __checkList;
    private IceComponent __component;
    private String __connectionId;
    private ScheduledItem __cpCheckScheduledItem;
    private IceGatherer __gatherer;
    private IcePolicy __icePolicy;
    private ArrayList<IceCandidate> __localCandidates;
    private Object __lock;
    private ILog __log;
    private List<IAction2<IceTransport, IceCandidatePair>> __onActiveCandidatePairChange = new ArrayList<IAction2<IceTransport, IceCandidatePair>>();
    private List<IAction1<DataBuffer>> __onReceive = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<IceTransport>> __onStateChange = new ArrayList<IAction1<IceTransport>>();
    private IceCandidate __remoteCandidateFromMLine;
    private ArrayList<IceCandidate> __remoteCandidates;
    private IceParameters __remoteParameters;
    private IceRole __role;
    private IceTransport __rtcpTransport = null;
    private Scheduler __scheduler;
    private ArrayList<DataBuffer> __sendQueue;
    private IceTransportState __state;
    private Date __stateTimestamp = new Date();
    private long __tieBreaker;
    private IceTransactionManager __transactionManager;
    private ScheduledItem __transitionToFailedState;
    private boolean __useIce = true;
    private IceValidList __validList;
    private AtomicLong _bytesReceived;
    private AtomicLong _bytesSent;
    private boolean _closingShouldNotTriggerGlobalNonGracefulShutdown;
    private Error _error;
    private String _id;
    private IAction2<IceTransport, IceCandidatePair> _onActiveCandidatePairChange = null;
    private IAction1<DataBuffer> _onReceive = null;
    private IAction1<IceTransport> _onStateChange = null;
    private IceTransportOptions _options;

    private void addCandidatePair(IceCandidate localCandidate, IceCandidate remoteCandidate) {
        AddressType type2;
        AddressType addressType = LocalNetwork.getAddressType(localCandidate.getIPAddress());
        if (Global.equals((Object)addressType, (Object)(type2 = LocalNetwork.getAddressType(remoteCandidate.getIPAddress()))) && Global.equals((Object)localCandidate.getOperatingProtocol(), (Object)remoteCandidate.getOperatingProtocol()) && (!Global.equals((Object)addressType, (Object)AddressType.IPv6) || Global.equals(TransportAddress.isPrivate(localCandidate.getIPAddress()), TransportAddress.isPrivate(remoteCandidate.getIPAddress())))) {
            if (this.__remoteParameters != null) {
                remoteCandidate.setUsername(this.__remoteParameters.getUsernameFragment());
                remoteCandidate.setPassword(this.__remoteParameters.getPassword());
            }
            IceCandidatePair pair2 = new IceCandidatePair(this.__lock, localCandidate, remoteCandidate, this.getGatherer().getLocalParameters(), this.getRemoteParameters(), this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
            pair2.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
            pair2.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processStunResponse";
                }

                @Override
                public void invoke(IceSendRequestSuccessArgs e) {
                    IceTransport.this.processStunResponse(e);
                }
            });
            pair2.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processCandidatePairStateChange";
                }

                @Override
                public void invoke(IceCandidatePair pair) {
                    IceTransport.this.processCandidatePairStateChange(pair);
                }
            });
            IceCandidatePair candidatePair = pair2;
            this.addCandidatePairToCache(candidatePair);
            if (candidatePair.getAwaitingOriginalRelayPermissions()) {
                candidatePair.setOnOriginalRelayPermissionsObtained((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processGotOriginalRelayPermission";
                    }

                    @Override
                    public void invoke(IceCandidatePair pair) {
                        IceTransport.this.processGotOriginalRelayPermission(pair);
                    }
                });
                this.__checkList.addToAwaitingOriginalRelayPermissionsList(candidatePair);
            } else {
                this.__checkList.addToOrdinaryCheckList(candidatePair);
            }
        }
    }

    private void addCandidatePairToCache(IceCandidatePair candidatePair) {
        String foundation = candidatePair.getFoundation();
        HashMapExtensions.set(HashMapExtensions.getItem(this.__candidatePairCache), foundation, candidatePair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocalCandidate(IceCandidate localCandidate) {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__localCandidates.contains(localCandidate)) {
                this.__localCandidates.add(localCandidate);
                if (!this.getIsClosed()) {
                    for (IceCandidate candidate : this.__remoteCandidates) {
                        this.addCandidatePair(localCandidate, candidate);
                    }
                }
            }
        }
    }

    public void addOnActiveCandidatePairChange(IAction2<IceTransport, IceCandidatePair> value) {
        if (value != null) {
            if (this._onActiveCandidatePairChange == null) {
                this._onActiveCandidatePairChange = new IAction2<IceTransport, IceCandidatePair>(){

                    @Override
                    public void invoke(IceTransport p0, IceCandidatePair p1) {
                        for (IAction2 action : new ArrayList(IceTransport.this.__onActiveCandidatePairChange)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onActiveCandidatePairChange.add(value);
        }
    }

    @Override
    public void addOnReceive(IAction1<DataBuffer> value) {
        if (value != null) {
            if (this._onReceive == null) {
                this._onReceive = new IAction1<DataBuffer>(){

                    @Override
                    public void invoke(DataBuffer p0) {
                        for (IAction1 action : new ArrayList(IceTransport.this.__onReceive)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceive.add(value);
        }
    }

    public void addOnStateChange(IAction1<IceTransport> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<IceTransport>(){

                    @Override
                    public void invoke(IceTransport p0) {
                        for (IAction1 action : new ArrayList(IceTransport.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCandidate(IceCandidate remoteCandidate) {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.getIsClosed()) {
                IceCandidate candidate = null;
                for (IceCandidate candidate2 : this.__remoteCandidates) {
                    if (!candidate2.equals(remoteCandidate)) continue;
                    candidate = candidate2;
                }
                if (candidate == null) {
                    this.__remoteCandidates.add(remoteCandidate);
                    for (IceCandidate candidate3 : this.__localCandidates) {
                        this.addCandidatePair(candidate3, remoteCandidate);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCandidatePair(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            IceCandidatePair waitingCandidatePair = this.__checkList.getWaitingCandidatePair();
            if (waitingCandidatePair == null) {
                this.__cpCheckScheduledItem.setSuspended(true);
            } else {
                waitingCandidatePair.checkForConnectivity();
            }
        }
    }

    private BindingResponse createIceRoleConflictResponse(DataBuffer transactionId) {
        BindingResponse response = new BindingResponse(transactionId, false);
        response.setErrorCode(new ErrorCodeAttribute(487, StringExtensions.format("Ice Role Conflict. Both peers assume the {0} role, but this entity won the tie-breaker.", Global.equals((Object)this.getRole(), (Object)IceRole.Controlled) ? "controlled" : "controlling")));
        if (Global.equals((Object)this.getRole(), (Object)IceRole.Controlled)) {
            response.setIceControlled(new ControlledAttribute(this.__tieBreaker));
            return response;
        }
        response.setIceControlling(new ControllingAttribute(this.__tieBreaker));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceTransport createRtcpTransport() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__rtcpTransport != null || Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) || Global.equals((Object)this.__component, (Object)IceComponent.Rtcp)) {
                return null;
            }
            IceTransport transport = new IceTransport(this.__lock, this.__connectionId, this.__scheduler, this.getOptions());
            transport.__component = IceComponent.Rtcp;
            transport.setIcePolicy(this.getIcePolicy());
            transport.setUseIce(this.getUseIce());
            this.__rtcpTransport = transport;
            return this.__rtcpTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessStunResponse(IceSendRequestSuccessArgs e) {
        Object object = this.__lock;
        synchronized (object) {
            IceCandidatePair pair2;
            IceGatherer gatherer = this.__gatherer;
            IceParameters remoteParameters = this.getRemoteParameters();
            if (Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) || Global.equals((Object)this.getState(), (Object)IceTransportState.Failed)) {
                return false;
            }
            if (gatherer == null) {
                throw new RuntimeException(new Exception("ICE: Received STUN response but Gatherer is not assigned to the IceTransport."));
            }
            if (remoteParameters == null) {
                throw new RuntimeException(new Exception("ICE: Received STUN response but RemoteParameters is not assigned to the IceTransport."));
            }
            IceSendMessageArgs state = (IceSendMessageArgs)e.getItem().getState();
            IceCandidatePair candidatePair = state.getCandidatePair();
            if (!Global.equals(e.getRemoteAddress().getIPAddress(), candidatePair.getRemote().getIPAddress()) || e.getRemoteAddress().getPort() != candidatePair.getRemote().getPort()) {
                candidatePair.setState(CandidatePairState.Failed);
                return false;
            }
            MessageIntegrityAttribute messageIntegrity = e.getResponse().getMessageIntegrity();
            if (messageIntegrity == null) {
                if (this.__log.getIsDebugEnabled()) {
                    this.__log.debug(StringExtensions.format("Check discarded from {0} to {1}. Message integrity not found.", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                }
                candidatePair.setState(CandidatePairState.Failed);
                return false;
            }
            if (!messageIntegrity.isValid(Utility.createShortTermKey(candidatePair.getRemote().getPassword()))) {
                if (this.__log.getIsDebugEnabled()) {
                    this.__log.debug(StringExtensions.format("Check discarded from {0} to {1}. Message integrity check failed.", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                }
                candidatePair.setState(CandidatePairState.Failed);
                return false;
            }
            Error error = IceDatagramSocketManager.validateResponse(state, e.getResponse(), e.getRemoteAddress());
            if (error != null) {
                ErrorCode _var0 = error.getErrorCode();
                if (_var0 == ErrorCode.StunUnauthorized || _var0 == ErrorCode.StunStaleCredentials || _var0 == ErrorCode.StunInvalidMessageIntegrity || _var0 == ErrorCode.StunMissingUsername || _var0 == ErrorCode.StunServerError) {
                    this.__log.debug(StringExtensions.format("Retrying check from {0} to {1}. {2}", candidatePair.getLocal().getTransportAddress().toString(), candidatePair.getRemote().getTransportAddress().toString(), error.getDescription()));
                    return false;
                }
                if (_var0 == ErrorCode.StunIceRoleConflict) {
                    IceRole role = state.getMessage().getIceControlled() == null ? IceRole.Controlled : IceRole.Controlling;
                    this.__log.debug(StringExtensions.format("The remote peer reports ICE Role Conflict. Changing local ICE Role to {3}. Will retry check from {0} to {1}. {2}", new Object[]{candidatePair.getLocal().getTransportAddress().toString(), candidatePair.getRemote().getTransportAddress().toString(), error.getDescription(), Global.equals((Object)role, (Object)IceRole.Controlled) ? "controlled" : "controlling"}));
                    this.setRole(role);
                    Holder<IceCandidatePair> _var1 = new Holder<IceCandidatePair>(candidatePair);
                    this.__checkList.addToTriggeredCheckList(_var1);
                    candidatePair = _var1.getValue();
                    return false;
                }
                this.__log.debug(StringExtensions.format("Check failed from {0} to {1}: {2}", candidatePair.getLocal().getTransportAddress().toString(), candidatePair.getRemote().getTransportAddress().toString(), error.getDescription()));
                this.__transactionManager.remove(e.getItem(), (Object)candidatePair);
                candidatePair.setState(CandidatePairState.Failed);
                return false;
            }
            this.__transactionManager.remove(e.getItem(), (Object)candidatePair);
            XorMappedAddressAttribute xorMappedAddress = e.getResponse().getXorMappedAddress();
            if (xorMappedAddress == null) {
                if (this.__log.getIsDebugEnabled()) {
                    this.__log.debug(StringExtensions.format("Check discarded from {0} to {1}. XOR-mapped address not found.", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                }
                candidatePair.setState(CandidatePairState.Failed);
                return false;
            }
            IceCandidate local = gatherer.findMatchingLocalCandidate(xorMappedAddress.getIPAddress(), xorMappedAddress.getPort());
            if (local == null) {
                int num2;
                if (TransportAddress.isPrivate(xorMappedAddress.getIPAddress()) && e.getRelayed()) {
                    if (this.__log.getIsWarnEnabled()) {
                        this.__log.warn(StringExtensions.format("Check discarded from {0} to {1}. Potential local peer-reflexive candidate had a private XOR-mapped IP address {2} and port {3}. (Is the TURN server on the same network as the remote client?)", new Object[]{candidatePair.getLocal().toString(), candidatePair.getRemote().toString(), xorMappedAddress.getIPAddress(), IntegerExtensions.toString(xorMappedAddress.getPort())}));
                    }
                    candidatePair.setState(CandidatePairState.Failed);
                    return false;
                }
                IceCandidate candidate2 = candidatePair.getLocal();
                int num = 2;
                for (num2 = 0; Global.equals((Object)candidate2.getType(), (Object)CandidateType.PeerReflexive) && num2 < num; ++num2) {
                    candidate2 = candidate2.getBase();
                }
                if (num2 == num) {
                    Error error2 = new Error(ErrorCode.IcePeerReflexiveError, new Exception("Base of a local peer reflexive candidate is peer reflexive. Cannot create a new peer reflexive candiate."));
                    this.setError(error2);
                    candidatePair.setState(CandidatePairState.Failed);
                    this.setState(IceTransportState.Closed);
                    return false;
                }
                String foundation = IceCandidate.generateLocalCandidateFoundation(CandidateType.PeerReflexive, xorMappedAddress.getIPAddress(), null, ProtocolType.Udp);
                IceCandidate candidate4 = new IceCandidate(this.__lock, foundation, ProtocolType.Udp, xorMappedAddress.getIPAddress(), xorMappedAddress.getPort(), CandidateType.PeerReflexive, candidate2.getIPAddress(), candidate2.getPort());
                candidate4.setBase(candidate2);
                candidate4.setAdapterSpeed(candidate2.getAdapterSpeed());
                IceCandidate candidate = candidate4;
                candidate.setUsername(candidate2.getUsername());
                candidate.setPassword(candidate2.getPassword());
                candidate.setPriority(state.getMessage().getPriority().getPriority());
                local = gatherer.registerLocalPeerReflexiveCandidate(candidate);
                if (this.__log.getIsDebugEnabled() && Global.equals((Object)local.getType(), (Object)CandidateType.PeerReflexive)) {
                    this.__log.debug(StringExtensions.format("Learned new local peer reflexive candidate {0} for IceTransport {1}.", candidate.toString(), this.getId()));
                }
            }
            if ((pair2 = this.__checkList.findMatchingCandidatePair(local, candidatePair.getRemote())) == null) {
                IceCandidatePair pair3 = new IceCandidatePair(this.__lock, local, candidatePair.getRemote(), gatherer.getLocalParameters(), remoteParameters, this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
                pair3.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
                pair3.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processStunResponse";
                    }

                    @Override
                    public void invoke(IceSendRequestSuccessArgs e) {
                        IceTransport.this.processStunResponse(e);
                    }
                });
                pair3.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processCandidatePairStateChange";
                    }

                    @Override
                    public void invoke(IceCandidatePair pair) {
                        IceTransport.this.processCandidatePairStateChange(pair);
                    }
                });
                pair2 = pair3;
                this.addCandidatePairToCache(pair2);
                pair2.assignPriority(this.getRole());
                if (Global.equals((Object)pair2.getLocal().getType(), (Object)CandidateType.Relayed)) {
                    pair2.startPermissionRequests();
                }
            }
            pair2.setValid(true);
            if (pair2.getRelatedValidPair() == null) {
                pair2.setRelatedValidPair(pair2);
            }
            pair2.setState(CandidatePairState.Succeeded);
            this.__validList.addCandidatePair(pair2);
            candidatePair.setRelatedValidPair(pair2);
            candidatePair.setState(CandidatePairState.Succeeded);
            if (Global.equals((Object)this.getRole(), (Object)IceRole.Controlling) && state.getMessage().getUseCandidate() != null || Global.equals((Object)this.getRole(), (Object)IceRole.Controlled) && candidatePair.getUseCandidateReceived()) {
                pair2.setNominated(true);
                this.processNominatedPair();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSetActiveCandidatePair(IceCandidatePair value) {
        boolean flag = false;
        Object object = this.__lock;
        synchronized (object) {
            if (value == null) {
                if (this.__activeCandidatePair != null) {
                    this.__activeCandidatePair = null;
                    this.setState(IceTransportState.Disconnected);
                }
            } else {
                ScheduledItem stopCandidatePair = value.getStopCandidatePair();
                if (stopCandidatePair != null) {
                    this.__scheduler.remove(stopCandidatePair);
                    value.setStopCandidatePair(null);
                }
                if (this.getUseIce()) {
                    IceLocalRelayedCandidate local;
                    if (Global.equals((Object)value.getState(), (Object)CandidatePairState.Closed) || Global.equals((Object)value.getState(), (Object)CandidatePairState.Failed)) {
                        return false;
                    }
                    if (Global.equals((Object)value.getLocal().getType(), (Object)CandidateType.Relayed) && (Global.equals((Object)(local = (IceLocalRelayedCandidate)value.getLocal()).getRelayState(), (Object)IceLocalRelayedCandidateState.Closed) || Global.equals((Object)local.getRelayState(), (Object)IceLocalRelayedCandidateState.Closing) || Global.equals((Object)local.getRelayState(), (Object)IceLocalRelayedCandidateState.Failed))) {
                        return false;
                    }
                }
                if (this.__activeCandidatePair != null && !this.__activeCandidatePair.equals(value) || this.__activeCandidatePair == null) {
                    this.__activeCandidatePair = value;
                    flag = true;
                    this.__log.debug(StringExtensions.format("Setting new active candidate pair for ICE transport {1}: {0}", this.__activeCandidatePair.toString(), this.getId()));
                    if (Global.equals((Object)value.getState(), (Object)CandidatePairState.Succeeded) && Global.equals((Object)this.getState(), (Object)IceTransportState.Disconnected)) {
                        this.setState(IceTransportState.Connected);
                    }
                }
            }
            if (flag) {
                IAction2<IceTransport, IceCandidatePair> onActiveCandidatePairChange = this._onActiveCandidatePairChange;
                if (onActiveCandidatePairChange != null) {
                    onActiveCandidatePairChange.invoke(this, value);
                }
                this.processCandidatePairStateChange(this.__activeCandidatePair);
            }
            this.stopNonActivePairs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidate findMatchingRemoteCandidate(String ipAddress, int port) {
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidate candidate : this.__remoteCandidates) {
                if (!Global.equals(candidate.getIPAddress(), ipAddress) || candidate.getPort() != port) continue;
                return candidate;
            }
            return null;
        }
    }

    IceCandidatePair getActiveCandidatePair() {
        return this.__activeCandidatePair;
    }

    public boolean getClosingShouldNotTriggerGlobalNonGracefulShutdown() {
        return this._closingShouldNotTriggerGlobalNonGracefulShutdown;
    }

    public IceComponent getComponent() {
        return this.__component;
    }

    public Error getError() {
        return this._error;
    }

    public IceGatherer getGatherer() {
        return this.__gatherer;
    }

    IcePolicy getIcePolicy() {
        return this.__icePolicy;
    }

    public String getId() {
        return this._id;
    }

    @Override
    public boolean getIsClosed() {
        return Global.equals((Object)this.getState(), (Object)IceTransportState.Closed);
    }

    public int getLastRelayServerRoundTripTime() {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null && Global.equals((Object)activeCandidatePair.getLocal().getType(), (Object)CandidateType.Relayed)) {
            return ((IceLocalRelayedCandidate)activeCandidatePair.getLocal()).getLastRelayServerRoundTripTime();
        }
        return -1;
    }

    public int getLastRoundTripTime() {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null) {
            return activeCandidatePair.getLastRoundTripTime();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidate[] getLocalCandidates() {
        Object object = this.__lock;
        synchronized (object) {
            return this.__localCandidates.toArray(new IceCandidate[0]);
        }
    }

    IceTransportOptions getOptions() {
        return this._options;
    }

    public IceCandidate getRemoteCandidateFromMLine() {
        return this.__remoteCandidateFromMLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidate[] getRemoteCandidates() {
        Object object = this.__lock;
        synchronized (object) {
            return this.__remoteCandidates.toArray(new IceCandidate[0]);
        }
    }

    public IceParameters getRemoteParameters() {
        return this.__remoteParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceRole getRole() {
        Object object = this.__lock;
        synchronized (object) {
            return this.__role;
        }
    }

    public int getSmoothedRelayServerRoundTripTime() {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null && Global.equals((Object)activeCandidatePair.getLocal().getType(), (Object)CandidateType.Relayed)) {
            return ((IceLocalRelayedCandidate)activeCandidatePair.getLocal()).getSmoothedRelayServerRoundTripTime();
        }
        return -1;
    }

    public int getSmoothedRoundTripTime() {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null) {
            return activeCandidatePair.getSmoothedRoundTripTime();
        }
        return -1;
    }

    public IceTransportState getState() {
        return this.__state;
    }

    boolean getUseIce() {
        return this.__useIce;
    }

    public IceTransport(Object lockObject, String connectionId, Scheduler scheduler, IceTransportOptions options) {
        this.__log = Log.getLogger(IceTransport.class);
        this.__role = IceRole.Controlling;
        this.__remoteCandidates = new ArrayList();
        this.__localCandidates = new ArrayList();
        this.__sendQueue = new ArrayList();
        this.__candidatePairCache = new HashMap();
        this.__icePolicy = IcePolicy.Negotiated;
        this._bytesSent = new AtomicLong();
        this._bytesReceived = new AtomicLong();
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.__cpCheckScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceTransport.checkCandidatePair";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceTransport.this.checkCandidatePair(item);
            }
        }, 0, 20, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        this.__cpCheckScheduledItem.setSuspended(this.getUseIce());
        this.__lock = lockObject;
        this.__connectionId = connectionId;
        this.__checkList = new IceCheckList(this.__lock);
        this.__validList = new IceValidList(this.__lock);
        this.__scheduler = scheduler;
        this.__state = IceTransportState.New;
        this.__component = IceComponent.Rtp;
        this.__gatherer = null;
        this.__remoteParameters = null;
        this.setRole(IceRole.Controlling);
        this.__activeCandidatePair = null;
        this.setOptions(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCandidatePairStateChange(IceCandidatePair pair) {
        if (!Global.equals((Object)this.getState(), (Object)IceTransportState.New) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Closed)) {
            Object object = this.__lock;
            synchronized (object) {
                if (!Global.equals((Object)this.getState(), (Object)IceTransportState.New) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) && pair != null) {
                    CandidatePairState state = pair.getState();
                    CandidatePairState _var0 = state;
                    if (_var0 == CandidatePairState.Succeeded) {
                        if (this.getUseIce()) {
                            this.updateActivePair();
                        }
                        if (Global.equals((Object)this.getState(), (Object)IceTransportState.Checking) || Global.equals((Object)this.getState(), (Object)IceTransportState.Disconnected)) {
                            this.setState(IceTransportState.Connected);
                        }
                        return;
                    }
                    if (_var0 == CandidatePairState.InProgress) {
                        if (this.__checkList.getAtLeastOneCandidatePairSucceeded()) {
                            this.setState(IceTransportState.Connected);
                        } else {
                            this.setState(IceTransportState.Checking);
                        }
                        return;
                    }
                    if (_var0 == CandidatePairState.Failed) {
                        if (Global.equals(this.getActiveCandidatePair(), pair)) {
                            this.updateActivePair();
                        }
                        if (this.__checkList.getConnectivityChecksCompletedAndNoneSucceeded()) {
                            this.setState(IceTransportState.Disconnected);
                        }
                        return;
                    }
                    if (_var0 == CandidatePairState.ConnectivityLost) {
                        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
                        if (activeCandidatePair == null || pair.equals(activeCandidatePair)) {
                            this.updateActivePair();
                        }
                        return;
                    }
                    if (_var0 == CandidatePairState.Closed) {
                        this.updateActivePair();
                        if (this.__checkList.getConnectivityChecksCompletedAndNoneSucceeded()) {
                            this.setState(IceTransportState.Failed);
                        }
                        return;
                    }
                    if (Global.equals((Object)state, (Object)CandidatePairState.Waiting) && this.getUseIce()) {
                        this.__cpCheckScheduledItem.setSuspended(false);
                        if (this.__checkList.getAtLeastOneCandidatePairSucceeded()) {
                            this.setState(IceTransportState.Connected);
                        } else {
                            this.setState(IceTransportState.Checking);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGotOriginalRelayPermission(IceCandidatePair pair) {
        Object object = this.__lock;
        synchronized (object) {
            this.__checkList.processGotOriginalRelayPermission(pair);
        }
    }

    private void processGotOriginalRelayPermissionsNonIceCP(IceCandidatePair pair) {
        this.doSetActiveCandidatePair(pair);
    }

    private void processIncomingApplicationData(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null) {
            IceCandidatePair pair2 = null;
            IceCandidate remote = this.findMatchingRemoteCandidate(remoteAddress.getIPAddress(), remoteAddress.getPort());
            if (remote != null) {
                pair2 = this.__validList.findMatchingCandidatePair(localCandidate, remote);
                if (pair2 == null) {
                    pair2 = this.__checkList.findMatchingCandidatePair(localCandidate, remote);
                }
                if (pair2 != null) {
                    pair2.notifyDataReceived(data);
                }
            } else if (!(Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) || Global.equals((Object)this.getState(), (Object)IceTransportState.Failed) || this.getUseIce() || activeCandidatePair == null)) {
                activeCandidatePair.notifyDataReceived(data);
            }
            this._bytesReceived.add(data.getLength());
            IAction1<DataBuffer> onReceive = this._onReceive;
            if (onReceive != null) {
                onReceive.invoke(data);
            }
        }
    }

    private void processLocalCandidate(IceGatherer gatherer, IceCandidate localCandidate) {
        this.addLocalCandidate(localCandidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNominatedPair() {
        IceCandidatePair nominatedPairWithHighestPriority = this.__validList.getNominatedPairWithHighestPriority();
        Object object = this.__lock;
        synchronized (object) {
            if (!this.getIsClosed() || nominatedPairWithHighestPriority == null) {
                this.setActiveCandidatePair(nominatedPairWithHighestPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStunRequest(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
        if (this.getIsClosed() || this.__gatherer == null) {
            return;
        }
        IceParameters localParameters = this.__gatherer.getLocalParameters();
        IceParameters remoteParameters = this.getRemoteParameters();
        if (remoteParameters != null) {
            UsernameAttribute username = message.getUsername();
            if (username == null) {
                if (this.__log.getIsDebugEnabled()) {
                    this.__log.debug(StringExtensions.format("Ignoring request from {0}. Username required.", remoteAddress.toString()));
                }
            } else {
                String str = StringExtensions.format("{0}:{1}", localParameters.getUsernameFragment(), remoteParameters.getUsernameFragment());
                if (!Global.equals(username.getValue(), str)) {
                    if (this.__log.getIsDebugEnabled()) {
                        this.__log.debug(StringExtensions.format("Ignoring request from {0}. Username '{1}' does not match expected value '{2}'.", remoteAddress.toString(), username.getValue(), str));
                    }
                } else if (!message.getMessageIntegrity().isValid(Utility.createShortTermKey(localParameters.getPassword()))) {
                    if (this.__log.getIsDebugEnabled()) {
                        this.__log.debug(StringExtensions.format("Ignoring request from {0}. Message integrity check failed.", remoteAddress.toString()));
                    }
                } else {
                    TransactionTransmitCounterAttribute transactionTransmitCounter = message.getTransactionTransmitCounter();
                    BindingResponse response = this.verifyIceRole(message);
                    boolean flag = false;
                    if (response == null) {
                        response = new BindingResponse(message.getTransactionId(), true);
                    } else {
                        flag = true;
                    }
                    response.setXorMappedAddress(new XorMappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort(), message.getTransactionId()));
                    response.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createShortTermKey(localParameters.getPassword())));
                    response.setFingerprint(new FingerprintAttribute());
                    if (transactionTransmitCounter != null) {
                        response.setTransactionTransmitCounter(transactionTransmitCounter);
                    }
                    TransportAddress turnServer = null;
                    if (Global.equals((Object)localCandidate.getType(), (Object)CandidateType.Relayed)) {
                        turnServer = ((IceLocalRelayedCandidate)localCandidate).getTurnServer();
                    }
                    IceSendMessageArgs args2 = new IceSendMessageArgs(response, remoteAddress);
                    args2.setTurnRelay(turnServer);
                    IceSendMessageArgs args = args2;
                    localCandidate.sendStunMessage(args);
                    if (!flag) {
                        Object object;
                        Object obj2;
                        IceCandidate remote = this.findMatchingRemoteCandidate(remoteAddress.getIPAddress(), remoteAddress.getPort());
                        if (remote == null) {
                            if (TransportAddress.isPrivate(remoteAddress.getIPAddress()) && Global.equals((Object)localCandidate.getType(), (Object)CandidateType.Relayed)) {
                                if (this.__log.getIsWarnEnabled()) {
                                    this.__log.warn(StringExtensions.format("Check request discarded from {0} to {1}. Potential peer-reflexive candidate had a private IP address. (Is the TURN server on the same network as the local client?)", remoteAddress.toString(), localCandidate.toString()));
                                }
                                return;
                            }
                            String foundation = "";
                            boolean flag2 = false;
                            object = obj2 = this.__lock;
                            synchronized (object) {
                                while (!flag2) {
                                    flag2 = true;
                                    foundation = Guid.newGuid().toString().replace("-", "");
                                    for (IceCandidate candidate2 : this.__remoteCandidates) {
                                        if (!Global.equals(candidate2.getFoundation(), foundation)) continue;
                                        flag2 = false;
                                    }
                                }
                                IceCandidate candidate4 = new IceCandidate(this.__lock, foundation, ProtocolType.Udp, remoteAddress.getIPAddress(), remoteAddress.getPort(), CandidateType.PeerReflexive, localCandidate.getIPAddress(), localCandidate.getPort());
                                candidate4.setBase(localCandidate);
                                IceCandidate item = candidate4;
                                item.setPriority(message.getPriority().getPriority());
                                item.setUsername(remoteParameters.getUsernameFragment());
                                item.setPassword(remoteParameters.getPassword());
                                if (this.__log.getIsDebugEnabled()) {
                                    this.__log.debug(StringExtensions.format("Learned new remote peer reflexive candidate {0}.", item.toString()));
                                }
                                this.__remoteCandidates.add(item);
                                remote = item;
                            }
                        }
                        IceCandidatePair pair2 = new IceCandidatePair(this.__lock, localCandidate, remote, localParameters, remoteParameters, this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
                        pair2.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
                        pair2.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.IceTransport.processStunResponse";
                            }

                            @Override
                            public void invoke(IceSendRequestSuccessArgs e) {
                                IceTransport.this.processStunResponse(e);
                            }
                        });
                        pair2.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.IceTransport.processCandidatePairStateChange";
                            }

                            @Override
                            public void invoke(IceCandidatePair pair) {
                                IceTransport.this.processCandidatePairStateChange(pair);
                            }
                        });
                        IceCandidatePair candidatePair = pair2;
                        candidatePair.notifyDataReceived(null);
                        object = obj2 = this.__lock;
                        synchronized (object) {
                            this.addCandidatePairToCache(candidatePair);
                            Holder<IceCandidatePair> _var0 = new Holder<IceCandidatePair>(candidatePair);
                            this.__checkList.addToTriggeredCheckList(_var0);
                            candidatePair = _var0.getValue();
                        }
                        if (Global.equals((Object)this.getRole(), (Object)IceRole.Controlled) && message.getUseCandidate() != null) {
                            if (Global.equals((Object)candidatePair.getState(), (Object)CandidatePairState.Succeeded)) {
                                candidatePair.getRelatedValidPair().setNominated(true);
                                this.processNominatedPair();
                            } else {
                                candidatePair.setUseCandidateReceived(true);
                            }
                        }
                    }
                }
            }
        }
    }

    private void processStunResponse(IceSendRequestSuccessArgs e) {
        this.doProcessStunResponse(e);
    }

    private void raiseStateChange() {
        IAction1<IceTransport> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this);
        }
    }

    public void removeOnActiveCandidatePairChange(IAction2<IceTransport, IceCandidatePair> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onActiveCandidatePairChange, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onActiveCandidatePairChange.remove(value);
        if (this.__onActiveCandidatePairChange.size() == 0) {
            this._onActiveCandidatePairChange = null;
        }
    }

    @Override
    public void removeOnReceive(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceive, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceive.remove(value);
        if (this.__onReceive.size() == 0) {
            this._onReceive = null;
        }
    }

    public void removeOnStateChange(IAction1<IceTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRtcpTransport() {
        Object object = this.__lock;
        synchronized (object) {
            this.__rtcpTransport = null;
        }
    }

    @Override
    public void send(DataBuffer buffer) {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null) {
            try {
                this._bytesSent.add(buffer.getLength());
                activeCandidatePair.send(buffer);
            }
            catch (Exception exception) {
                this.setError(new Error(ErrorCode.IceSendError, exception));
            }
        }
    }

    private void setActiveCandidatePair(IceCandidatePair value) {
        this.doSetActiveCandidatePair(value);
    }

    public void setClosingShouldNotTriggerGlobalNonGracefulShutdown(boolean value) {
        this._closingShouldNotTriggerGlobalNonGracefulShutdown = value;
    }

    private void setError(Error value) {
        this._error = value;
    }

    void setIcePolicy(IcePolicy value) {
        if (!Global.equals((Object)this.__icePolicy, (Object)value)) {
            this.__icePolicy = value;
            if (Global.equals((Object)this.__icePolicy, (Object)IcePolicy.Disabled)) {
                this.setUseIce(false);
            } else if (Global.equals((Object)this.__icePolicy, (Object)IcePolicy.Required)) {
                this.setUseIce(true);
            }
        }
    }

    private void setId(String value) {
        this._id = value;
    }

    void setOptions(IceTransportOptions value) {
        this._options = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteCandidateFromMLine(IceCandidate value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.getIsClosed()) {
                IceCandidate defaultLocalCandidate;
                this.__remoteCandidateFromMLine = value;
                if (!this.getUseIce() && this.getActiveCandidatePair() == null && this.__gatherer != null && (defaultLocalCandidate = this.__gatherer.getDefaultLocalCandidate()) != null) {
                    IceCandidatePair pair2 = new IceCandidatePair(this.__lock, defaultLocalCandidate, this.__remoteCandidateFromMLine, this.getGatherer().getLocalParameters(), this.getRemoteParameters(), this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
                    pair2.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
                    pair2.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceTransport.processStunResponse";
                        }

                        @Override
                        public void invoke(IceSendRequestSuccessArgs e) {
                            IceTransport.this.processStunResponse(e);
                        }
                    });
                    pair2.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceTransport.processCandidatePairStateChange";
                        }

                        @Override
                        public void invoke(IceCandidatePair pair) {
                            IceTransport.this.processCandidatePairStateChange(pair);
                        }
                    });
                    IceCandidatePair candidatePair = pair2;
                    this.addCandidatePairToCache(candidatePair);
                    candidatePair.bypassConnectivityChecks();
                    if (Global.equals((Object)defaultLocalCandidate.getType(), (Object)CandidateType.Relayed)) {
                        candidatePair.setOnOriginalRelayPermissionsObtained((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.IceTransport.processGotOriginalRelayPermissionsNonIceCP";
                            }

                            @Override
                            public void invoke(IceCandidatePair pair) {
                                IceTransport.this.processGotOriginalRelayPermissionsNonIceCP(pair);
                            }
                        });
                        candidatePair.startPermissionRequests();
                    } else {
                        this.doSetActiveCandidatePair(candidatePair);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRole(IceRole value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)value, (Object)this.__role)) {
                this.__role = value;
                for (IceCandidatePair pair : this.__checkList.getCandidatePairs()) {
                    pair.setLocalRole(this.__role);
                    pair.assignPriority(this.__role);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(IceTransportState value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                Scheduler scheduler;
                boolean flag = false;
                if (Global.equals((Object)this.__state, (Object)IceTransportState.Closed)) {
                    flag = true;
                } else if (Global.equals((Object)value, (Object)IceTransportState.Connected)) {
                    scheduler = this.__scheduler;
                    if (this.__transitionToFailedState != null && scheduler != null) {
                        scheduler.remove(this.__transitionToFailedState);
                    }
                    if (this.__activeCandidatePair == null) {
                        flag = true;
                    }
                }
                if (!flag) {
                    if (Log.getIsDebugEnabled()) {
                        if (Global.equals((Object)this.__state, (Object)IceTransportState.Checking) && Global.equals((Object)value, (Object)IceTransportState.Connected)) {
                            int num = (int)((DateExtensions.getTicks(DateExtensions.getUtcNow()) - DateExtensions.getTicks(this.__stateTimestamp)) / (long)Constants.getTicksPerMillisecond());
                            Log.debug(StringExtensions.format("ICE transport {0} took {1}ms to find a successful candidate pair for connection {2}.", this.getId(), IntegerExtensions.toString(num), this.__connectionId));
                        }
                        if (Global.equals((Object)this.__state, (Object)IceTransportState.Failed) && this.getError() != null) {
                            Log.debug(StringExtensions.format("Setting ICE transport {0} state to {1} for connection {2}. ({3})", new Object[]{this.getId(), StringExtensions.toLower(value.toString()), this.__connectionId, this.getError().getErrorCode().toString()}), this.getError().getException());
                        } else {
                            Log.debug(StringExtensions.format("Setting ICE transport {0} state to {1} for connection {2}.", this.getId(), StringExtensions.toLower(value.toString()), this.__connectionId));
                        }
                    }
                    this.__state = value;
                    this.__stateTimestamp = DateExtensions.getUtcNow();
                    if (Global.equals((Object)this.__state, (Object)IceTransportState.Connected) && ArrayListExtensions.getCount(this.__sendQueue) > 0) {
                        for (DataBuffer buffer : this.__sendQueue) {
                            this.send(buffer);
                        }
                        this.__sendQueue.clear();
                    }
                    this.raiseStateChange();
                    if (Global.equals((Object)value, (Object)IceTransportState.Disconnected) && (scheduler = this.__scheduler) != null) {
                        int delay = this.getOptions() == null ? 0 : (this.getOptions().getDeadStreamTimeout() < 0 ? 0 : this.getOptions().getDeadStreamTimeout());
                        this.__transitionToFailedState = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.IceTransport.transitionToFailedStateOnDeadStreamTimeout";
                            }

                            @Override
                            public void invoke(ScheduledItem item) {
                                IceTransport.this.transitionToFailedStateOnDeadStreamTimeout(item);
                            }
                        }, delay, delay, ScheduledItem.getUnset(), 1);
                        scheduler.add(this.__transitionToFailedState);
                    }
                    if (Global.equals((Object)value, (Object)IceTransportState.Failed)) {
                        if (HashMapExtensions.getCount(this.__candidatePairCache) > 0) {
                            this.__log.debug(StringExtensions.format("ICE transport {0}: State of connectivity checks on candidate pairs:", this.getId()));
                            for (IceCandidatePair pair : HashMapExtensions.getValues(this.__candidatePairCache)) {
                                this.__log.debug(StringExtensions.format("ICE transport {0}: {1} - {2}", this.getId(), pair.toString(), pair.getState().toString()));
                            }
                        } else {
                            this.__log.debug(StringExtensions.format("ICE transport {0}: Connectivity checks could not be conducted - there were noi candidate pairs.", this.getId()));
                        }
                    }
                }
            }
        }
    }

    void setUseIce(boolean value) {
        if (!Global.equals(this.__useIce, value)) {
            this.__cpCheckScheduledItem.setSuspended(!value);
            this.__useIce = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(IceGatherer gatherer, IceParameters remoteParameters, IceRole role, long tieBreaker) {
        Object object = this.__lock;
        synchronized (object) {
            IceCandidate defaultLocalCandidate;
            if (!Global.equals((Object)this.getState(), (Object)IceTransportState.New) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Closed)) {
                return false;
            }
            if (Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Closed)) {
                throw new RuntimeException(new Exception("Cannot start ICE transport: supplied gatherer is in an invalid state."));
            }
            if (!Global.equals((Object)gatherer.getComponent(), (Object)this.getComponent())) {
                this.__log.error("Components do not match.");
                return false;
            }
            this.__scheduler.add(this.__cpCheckScheduledItem);
            this.__transactionManager = gatherer.getTransactionManager();
            this.setState(IceTransportState.Checking);
            this.__gatherer = gatherer;
            this.__remoteParameters = remoteParameters;
            this.setRole(role);
            this.__tieBreaker = tieBreaker;
            this.__gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processLocalCandidate";
                }

                @Override
                public void invoke(IceGatherer gatherer, IceCandidate localCandidate) {
                    IceTransport.this.processLocalCandidate(gatherer, localCandidate);
                }
            });
            this.__gatherer.addOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processLocalCandidate";
                }

                @Override
                public void invoke(IceGatherer gatherer, IceCandidate localCandidate) {
                    IceTransport.this.processLocalCandidate(gatherer, localCandidate);
                }
            });
            this.__gatherer.removeOnIncomingApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processIncomingApplicationData";
                }

                @Override
                public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                    IceTransport.this.processIncomingApplicationData(data, localCandidate, remoteAddress);
                }
            });
            this.__gatherer.addOnIncomingApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processIncomingApplicationData";
                }

                @Override
                public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                    IceTransport.this.processIncomingApplicationData(data, localCandidate, remoteAddress);
                }
            });
            this.__gatherer.setOnStunRequest((IAction3<Message, IceCandidate, TransportAddress>)new IActionDelegate3<Message, IceCandidate, TransportAddress>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processStunRequest";
                }

                @Override
                public void invoke(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
                    IceTransport.this.processStunRequest(message, localCandidate, remoteAddress);
                }
            });
            for (IceCandidate candidate : this.__gatherer.getLocalCandidates()) {
                this.addLocalCandidate(candidate);
            }
            if (!this.getUseIce() && this.getActiveCandidatePair() == null && this.getRemoteCandidateFromMLine() != null && (defaultLocalCandidate = gatherer.getDefaultLocalCandidate()) != null) {
                IceCandidatePair pair2 = new IceCandidatePair(this.__lock, defaultLocalCandidate, this.__remoteCandidateFromMLine, this.getGatherer().getLocalParameters(), this.getRemoteParameters(), this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
                pair2.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
                pair2.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processStunResponse";
                    }

                    @Override
                    public void invoke(IceSendRequestSuccessArgs e) {
                        IceTransport.this.processStunResponse(e);
                    }
                });
                pair2.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processCandidatePairStateChange";
                    }

                    @Override
                    public void invoke(IceCandidatePair pair) {
                        IceTransport.this.processCandidatePairStateChange(pair);
                    }
                });
                IceCandidatePair candidatePair = pair2;
                this.addCandidatePairToCache(candidatePair);
                candidatePair.bypassConnectivityChecks();
                if (Global.equals((Object)defaultLocalCandidate.getType(), (Object)CandidateType.Relayed)) {
                    candidatePair.setOnOriginalRelayPermissionsObtained((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceTransport.processGotOriginalRelayPermissionsNonIceCP";
                        }

                        @Override
                        public void invoke(IceCandidatePair pair) {
                            IceTransport.this.processGotOriginalRelayPermissionsNonIceCP(pair);
                        }
                    });
                    candidatePair.startPermissionRequests();
                } else {
                    this.doSetActiveCandidatePair(candidatePair);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.__lock;
        synchronized (object) {
            IceGatherer gatherer;
            if (!(Global.equals((Object)this.getState(), (Object)IceTransportState.New) || Global.equals((Object)this.getState(), (Object)IceTransportState.Checking) || Global.equals((Object)this.getState(), (Object)IceTransportState.Failed) || Global.equals((Object)this.getState(), (Object)IceTransportState.Connected) || Global.equals((Object)this.getState(), (Object)IceTransportState.Disconnected))) {
                return false;
            }
            this.removeRtcpTransport();
            if (this.__transactionManager != null) {
                this.__transactionManager.remove(this);
            }
            this.removeRtcpTransport();
            this.__sendQueue.clear();
            this.__localCandidates.clear();
            this.__remoteCandidates.clear();
            this.__validList.clear();
            this.__checkList.clear();
            if (!Global.equals((Object)this.getState(), (Object)IceTransportState.Failed)) {
                this.setState(IceTransportState.Closed);
            }
            if ((gatherer = this.__gatherer) != null) {
                gatherer.removeOnIncomingApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processIncomingApplicationData";
                    }

                    @Override
                    public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                        IceTransport.this.processIncomingApplicationData(data, localCandidate, remoteAddress);
                    }
                });
                gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processLocalCandidate";
                    }

                    @Override
                    public void invoke(IceGatherer gatherer, IceCandidate localCandidate) {
                        IceTransport.this.processLocalCandidate(gatherer, localCandidate);
                    }
                });
                this.__gatherer = null;
            }
            this.__remoteParameters = null;
            return true;
        }
    }

    private void stopNonActivePair(final IceCandidatePair pair) {
        IAction1<ScheduledItem> defaultCallback = null;
        if (!pair.equals(this.getActiveCandidatePair())) {
            if (this.getActiveCandidatePair() == null || this.getActiveCandidatePair().getPriority() > pair.getPriority()) {
                pair.stop();
            } else if (pair.getStopCandidatePair() == null && Global.equals((Object)pair.getState(), (Object)CandidatePairState.Succeeded)) {
                if (defaultCallback == null) {
                    defaultCallback = new IAction1<ScheduledItem>(){

                        @Override
                        public void invoke(ScheduledItem unused) {
                            pair.stop();
                        }
                    };
                }
                ScheduledItem item = new ScheduledItem(defaultCallback, 5000, ScheduledItem.getUnset(), ScheduledItem.getUnset(), 1);
                pair.setStopCandidatePair(item);
                if (this.__scheduler != null) {
                    this.__scheduler.add(item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopNonActivePairs() {
        if (Global.equals((Object)this.getOptions().getKeepAlivePolicy(), (Object)IceKeepAlivePolicy.ActiveOnly)) {
            Object object = this.__lock;
            synchronized (object) {
                for (IceCandidatePair pair : this.__validList.getCandidatePairs()) {
                    this.stopNonActivePair(pair);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionToFailedStateOnDeadStreamTimeout(ScheduledItem item) {
        Scheduler scheduler = this.__scheduler;
        if (scheduler != null) {
            scheduler.remove(item);
        }
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)IceTransportState.Disconnected)) {
                this.setError(new Error(ErrorCode.ConnectionDeadStream, new Exception("Dead stream detected.")));
                this.setState(IceTransportState.Failed);
            }
        }
    }

    private void updateActivePair() {
        this.processNominatedPair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(TransportStats stats) {
        IceCandidatePair activeCandidatePair;
        IceCandidatePair[] pairArray;
        IceCandidate[] remoteCandidates;
        IceCandidate[] localCandidates;
        stats.setBytesSent(this._bytesSent.getValue());
        stats.setBytesReceived(this._bytesReceived.getValue());
        Object object = this.__lock;
        synchronized (object) {
            localCandidates = this.getLocalCandidates();
            remoteCandidates = this.getRemoteCandidates();
            IceCandidate[] list = new ArrayList();
            for (IceCandidatePair pair2 : HashMapExtensions.getValues(this.__candidatePairCache)) {
                list.add(pair2);
            }
            pairArray = list.toArray(new IceCandidatePair[0]);
            activeCandidatePair = this.getActiveCandidatePair();
        }
        ArrayList<CandidateStats> list2 = new ArrayList<CandidateStats>();
        for (IceCandidate candidate : localCandidates) {
            list2.add(candidate.getStats());
        }
        ArrayList<CandidateStats> list3 = new ArrayList<CandidateStats>();
        for (IceCandidate candidate2 : remoteCandidates) {
            list3.add(candidate2.getStats());
        }
        ArrayList<CandidatePairStats> list4 = new ArrayList<CandidatePairStats>();
        for (IceCandidatePair pair2 : pairArray) {
            list4.add(pair2.getStats(this.getId()));
        }
        stats.setLocalCandidates(list2.toArray(new CandidateStats[0]));
        stats.setRemoteCandidates(list3.toArray(new CandidateStats[0]));
        stats.setCandidatePairs(list4.toArray(new CandidatePairStats[0]));
        if (activeCandidatePair != null) {
            stats.setActiveCandidatePair(activeCandidatePair.getStats(this.getId()));
        }
    }

    private BindingResponse verifyIceRole(Message message) {
        ControlledAttribute iceControlled = message.getIceControlled();
        ControllingAttribute iceControlling = message.getIceControlling();
        boolean flag = false;
        boolean flag2 = false;
        long num = -1L;
        BindingResponse response = null;
        if (iceControlled == null && iceControlling == null) {
            flag2 = true;
            if (this.__log.getIsWarnEnabled()) {
                this.__log.warn("Incoming STUN request contains neither ICE-CONTROLLING not ICE-CONTROLLED attributes. There may exist an ICE-Role conflict, but it is not detectable.");
            }
        } else if (iceControlled != null) {
            flag = true;
            num = iceControlled.getValue();
        } else {
            num = iceControlling.getValue();
        }
        if (!flag2 && Global.equals((Object)this.getRole(), (Object)IceRole.Controlling) && !flag) {
            if (this.__tieBreaker >= num) {
                if (this.__log.getIsWarnEnabled()) {
                    this.__log.warn("Incoming STUN request contains ICE-CONTROLLING attribute, but local IceTransport also assumes the controlling role. Won the tie-breaker. Will send an error message back and retain the controlling role.");
                }
                return this.createIceRoleConflictResponse(message.getTransactionId());
            }
            if (this.__log.getIsWarnEnabled()) {
                this.__log.warn("Incoming STUN request contains ICE-CONTROLLING attribute, but local IceTransport also assumes the controlling role. Lost the tie-breaker. Will switch to the controlled role.");
            }
            this.setRole(IceRole.Controlled);
            return response;
        }
        if (flag2 || !Global.equals((Object)this.getRole(), (Object)IceRole.Controlled) || !flag) {
            return response;
        }
        if (this.__tieBreaker >= num) {
            if (this.__log.getIsWarnEnabled()) {
                this.__log.warn("Incoming STUN request contains ICE-CONTROLLED attribute, but local IceTransport also assumes the controlled role. Won the tie-breaker. Will switch to the controlling role.");
            }
            this.setRole(IceRole.Controlling);
            return response;
        }
        if (this.__log.getIsWarnEnabled()) {
            this.__log.warn("Incoming STUN request contains ICE-CONTROLLED attribute, but local IceTransport also assumes the controllED role. Lost the tie-breaker. Will send an error message back and retain the controlled role.");
        }
        return this.createIceRoleConflictResponse(message.getTransactionId());
    }
}

