/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum HttpMethod {
    Get(1),
    Head(2),
    Post(3),
    Put(4),
    Patch(5),
    Delete(6);

    private final int value;
    private static final Map<Integer, HttpMethod> lookup;

    private HttpMethod(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static HttpMethod getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, HttpMethod>();
        for (HttpMethod s : EnumSet.allOf(HttpMethod.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

