/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum HashType {
    Md5(1),
    Sha1(2),
    Sha256(3);

    private final int value;
    private static final Map<Integer, HashType> lookup;

    private HashType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static HashType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, HashType>();
        for (HashType s : EnumSet.allOf(HashType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

