/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioClock;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioSource;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Future;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate2;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.Promise;
import fm.icelink.pcm.Format;

public class FakeAudioSource
extends AudioSource {
    private AudioClock __clock;
    private long __signalCounter;
    private int _amplitude;
    private float _frequency;
    private int _latency;

    @Override
    protected Future<Object> doStart() {
        Promise<Object> promise = new Promise<Object>();
        try {
            this.__signalCounter = 0L;
            this.__clock = new AudioClock(super.getConfig().getClockRate(), super.getConfig().getChannelCount(), (IAction2<Integer, Integer>)new IActionDelegate2<Integer, Integer>(){

                @Override
                public String getId() {
                    return "fm.icelink.FakeAudioSource.raiseData";
                }

                @Override
                public void invoke(Integer frameSize, Integer frameDuration) {
                    FakeAudioSource.this.raiseData(frameSize, frameDuration);
                }
            });
            this.__clock.start();
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    protected Future<Object> doStop() {
        Promise<Object> promise = new Promise<Object>();
        try {
            this.__clock.stop();
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public FakeAudioSource(AudioConfig config, float frequency, int amplitude) {
        this(config, frequency, amplitude, 100);
    }

    public FakeAudioSource(AudioConfig config, float frequency) {
        this(config, frequency, 16384);
    }

    public FakeAudioSource(AudioConfig config) {
        this(config, 440.0f);
    }

    public FakeAudioSource(AudioConfig config, float frequency, int amplitude, int latency) {
        super(new Format(config));
        this.setFrequency(frequency);
        this.setAmplitude(amplitude);
        this.setLatency(latency);
    }

    private void fillDataBuffer(int frameDuration, DataBuffer dataBuffer) {
        int num = ((AudioFormat)super.getOutputFormat()).getClockRate() * frameDuration / 1000;
        double num2 = 2.0 * MathAssistant.getPi() * (double)this.getFrequency() / (double)((AudioFormat)super.getOutputFormat()).getClockRate();
        int offset = 0;
        for (int i = 0; i < num; ++i) {
            short num5 = (short)((double)this.getAmplitude() * MathAssistant.sin(num2 * (double)this.__signalCounter));
            ++this.__signalCounter;
            if (this.__signalCounter >= Long.MAX_VALUE) {
                this.__signalCounter = 0L;
            }
            for (int j = 0; j < ((AudioFormat)super.getOutputFormat()).getChannelCount(); ++j) {
                dataBuffer.write16(num5, offset);
                offset += 2;
            }
        }
    }

    public int getAmplitude() {
        return this._amplitude;
    }

    public float getFrequency() {
        return this._frequency;
    }

    @Override
    public String getLabel() {
        return "Fake Audio Source";
    }

    public int getLatency() {
        return this._latency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseData(int frameSize, int frameDuration) {
        DataBuffer dataBuffer = DataBufferPool.getInstance().take(frameSize, true);
        try {
            this.fillDataBuffer(frameDuration, dataBuffer);
            this.raiseFrame(new AudioFrame(frameDuration, new AudioBuffer(dataBuffer, (AudioFormat)super.getOutputFormat())));
        }
        catch (Exception exception) {
            Log.error("Could not raise frame.", exception);
        }
        finally {
            dataBuffer.free();
        }
    }

    private void setAmplitude(int value) {
        this._amplitude = value;
    }

    private void setFrequency(float value) {
        this._frequency = value;
    }

    private void setLatency(int value) {
        this._latency = value;
    }
}

