/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.AsymmetricKey;
import fm.icelink.AsymmetricKeyType;
import fm.icelink.Base64;
import fm.icelink.DataBuffer;
import fm.icelink.EcdsaCrypto;
import fm.icelink.EcdsaNamedCurve;
import fm.icelink.Global;
import fm.icelink.Holder;
import fm.icelink.StringExtensions;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509DsaSignature;
import fm.icelink.X509ECNamedCurve;
import fm.icelink.X509ECParameters;
import fm.icelink.X509ECPoint;
import fm.icelink.X509ECPrivateKey;
import fm.icelink.X509PrivateKeyInfo;
import fm.icelink.X509PublicKeyInfo;
import fm.icelink.X509SubjectPublicKeyInfo;
import java.util.ArrayList;

public class EcdsaKey
extends AsymmetricKey {
    private EcdsaNamedCurve _namedCurve;
    private byte[] _privateKey;
    private static String _privateKeyFooter;
    private static String _privateKeyHeader;
    private byte[] _publicKey;
    private static String _publicKeyFooter;
    private static String _publicKeyHeader;

    public byte[] getBytes() {
        if (this.hasPrivate()) {
            X509PrivateKeyInfo info = new X509PrivateKeyInfo();
            info.setPrivateKeyAlgorithm(X509AlgorithmIdentifier.getEcdsa(new X509ECParameters(X509ECNamedCurve.fromEnum(this.getNamedCurve()))));
            info.setPrivateKey(new X509ECPrivateKey(this.getPrivateKey(), new X509ECParameters(X509ECNamedCurve.fromEnum(this.getNamedCurve())), this.getPublicKey()).toAsn1().getBytes());
            return info.toAsn1().getBytes();
        }
        X509PublicKeyInfo info2 = new X509PublicKeyInfo();
        info2.setAlgorithm(X509AlgorithmIdentifier.getEcdsa(new X509ECParameters(X509ECNamedCurve.fromEnum(this.getNamedCurve()))));
        info2.setPublicKey(new X509ECPoint(this.getPublicKey()).compress());
        return info2.toAsn1().getBytes();
    }

    public EcdsaNamedCurve getNamedCurve() {
        return this._namedCurve;
    }

    @Override
    X509AlgorithmIdentifier getPreferredSignatureAlgorithm() {
        if (Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P256)) {
            return X509AlgorithmIdentifier.getEcdsaWithSha256();
        }
        if (Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P384)) {
            return X509AlgorithmIdentifier.getEcdsaWithSha384();
        }
        if (!Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P521)) {
            throw new RuntimeException(new Exception("Unsupported named curve."));
        }
        return X509AlgorithmIdentifier.getEcdsaWithSha512();
    }

    public byte[] getPrivateKey() {
        return this._privateKey;
    }

    public byte[] getPublicKey() {
        return this._publicKey;
    }

    public int getSize() {
        byte[] privateKey = this.getPrivateKey();
        if (privateKey != null) {
            return ArrayExtensions.getLength(privateKey) * 8;
        }
        byte[] publicKey = this.getPublicKey();
        if (publicKey != null) {
            return ArrayExtensions.getLength(publicKey) / 2 * 8;
        }
        return 0;
    }

    public String getString() {
        if (this.hasPrivate()) {
            return StringExtensions.concat(new String[]{_privateKeyHeader, "\n", StringExtensions.join("\n", this.splitString(Base64.encode(this.getBytes()), 64)), "\n", _privateKeyFooter, "\n"});
        }
        return StringExtensions.concat(new String[]{_publicKeyHeader, "\n", StringExtensions.join("\n", this.splitString(Base64.encode(this.getBytes()), 64)), "\n", _publicKeyFooter, "\n"});
    }

    @Override
    public AsymmetricKeyType getType() {
        return AsymmetricKeyType.Ecdsa;
    }

    @Override
    public boolean hasPrivate() {
        return this.hasPublic() && this.getPrivateKey() != null;
    }

    @Override
    public boolean hasPublic() {
        return this.getPublicKey() != null;
    }

    public static EcdsaKey parseBuffer(DataBuffer buffer, boolean isPrivate) {
        Asn1Any any = Asn1Any.parseBuffer(buffer);
        if (any != null) {
            if (isPrivate) {
                X509ECPrivateKey key;
                X509PrivateKeyInfo info = X509PrivateKeyInfo.fromAsn1(any);
                if (info != null && (key = X509ECPrivateKey.fromAsn1(Asn1Any.parseBytes(info.getPrivateKey()))) != null) {
                    EcdsaKey key2 = new EcdsaKey();
                    key2.setPublicKey(key.getPublicKey());
                    key2.setNamedCurve(X509ECNamedCurve.toEnum(X509ECParameters.fromAsn1(Asn1Any.parseBytes(info.getPrivateKeyAlgorithm().getParameters())).getNamedCurve()));
                    key2.setPrivateKey(key.getPrivateKey());
                    return key2;
                }
            } else {
                X509PublicKeyInfo info2 = X509PublicKeyInfo.fromAsn1(any);
                if (info2 != null) {
                    EcdsaKey key3 = new EcdsaKey();
                    key3.setNamedCurve(X509ECNamedCurve.toEnum(X509ECParameters.fromAsn1(Asn1Any.parseBytes(info2.getAlgorithm().getParameters())).getNamedCurve()));
                    key3.setPublicKey(X509ECPoint.decompress(info2.getPublicKey()).getValue());
                    return key3;
                }
            }
        }
        return null;
    }

    public static EcdsaKey parseBytes(byte[] bytes, boolean isPrivate) {
        return EcdsaKey.parseBuffer(DataBuffer.wrap(bytes), isPrivate);
    }

    public static boolean parseSignature(byte[] signature, Holder<byte[]> r, Holder<byte[]> s) {
        X509DsaSignature signature2 = X509DsaSignature.fromAsn1(Asn1Any.parseBytes(signature));
        if (signature2 == null) {
            r.setValue(null);
            s.setValue(null);
            return false;
        }
        r.setValue(signature2.getR());
        s.setValue(signature2.getS());
        return true;
    }

    public static EcdsaKey parseString(String str) {
        if ((str = str.replace("\n", "").replace("\r", "").trim()).startsWith(_privateKeyHeader) && str.endsWith(_privateKeyFooter)) {
            return EcdsaKey.parseBytes(Base64.decode(StringExtensions.substring(str, StringExtensions.getLength(_privateKeyHeader), StringExtensions.getLength(str) - StringExtensions.getLength(_privateKeyHeader) - StringExtensions.getLength(_privateKeyFooter))), true);
        }
        if (str.startsWith(_publicKeyHeader) && str.endsWith(_publicKeyFooter)) {
            return EcdsaKey.parseBytes(Base64.decode(StringExtensions.substring(str, StringExtensions.getLength(_publicKeyHeader), StringExtensions.getLength(str) - StringExtensions.getLength(_publicKeyHeader) - StringExtensions.getLength(_publicKeyFooter))), false);
        }
        return null;
    }

    @Override
    AsymmetricKey regenerate() {
        return EcdsaCrypto.createKey(this.getNamedCurve());
    }

    public void setNamedCurve(EcdsaNamedCurve value) {
        this._namedCurve = value;
    }

    public void setPrivateKey(byte[] value) {
        this._privateKey = value;
    }

    public void setPublicKey(byte[] value) {
        this._publicKey = value;
    }

    @Override
    byte[] sign(byte[] data, X509AlgorithmIdentifier algorithm) {
        if (!(Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P256) && X509AlgorithmIdentifier.algorithmsAreEqual(algorithm, X509AlgorithmIdentifier.getEcdsaWithSha256()) || Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P384) && X509AlgorithmIdentifier.algorithmsAreEqual(algorithm, X509AlgorithmIdentifier.getEcdsaWithSha384()) || Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P521) && X509AlgorithmIdentifier.algorithmsAreEqual(algorithm, X509AlgorithmIdentifier.getEcdsaWithSha512()))) {
            throw new RuntimeException(new Exception("Unsupported signature algorithm."));
        }
        return EcdsaCrypto.sign(data, this);
    }

    private String[] splitString(String s, int lineLength) {
        ArrayList<String> list = new ArrayList<String>();
        while (StringExtensions.getLength(s) > lineLength) {
            list.add(StringExtensions.substring(s, 0, lineLength));
            s = s.substring(lineLength);
        }
        if (StringExtensions.getLength(s) > 0) {
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public EcdsaKey toPublic() {
        EcdsaKey key = new EcdsaKey();
        key.setNamedCurve(this.getNamedCurve());
        key.setPublicKey(this.getPublicKey());
        return key;
    }

    @Override
    X509SubjectPublicKeyInfo toSubjectPublicKeyInfo() {
        X509SubjectPublicKeyInfo info = new X509SubjectPublicKeyInfo();
        info.setAlgorithm(X509AlgorithmIdentifier.getEcdsa(new X509ECParameters(X509ECNamedCurve.fromEnum(this.getNamedCurve()))));
        info.setSubjectPublicKey(new X509ECPoint(this.getPublicKey()).toAsn1().getValueBytes());
        return info;
    }

    @Override
    boolean verify(byte[] data, byte[] signature, X509AlgorithmIdentifier algorithm) {
        if (!(Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P256) && X509AlgorithmIdentifier.algorithmsAreEqual(algorithm, X509AlgorithmIdentifier.getEcdsaWithSha256()) || Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P384) && X509AlgorithmIdentifier.algorithmsAreEqual(algorithm, X509AlgorithmIdentifier.getEcdsaWithSha384()) || Global.equals((Object)this.getNamedCurve(), (Object)EcdsaNamedCurve.P521) && X509AlgorithmIdentifier.algorithmsAreEqual(algorithm, X509AlgorithmIdentifier.getEcdsaWithSha512()))) {
            throw new RuntimeException(new Exception("Unsupported signature algorithm."));
        }
        return EcdsaCrypto.verify(data, signature, this);
    }

    static {
        _privateKeyHeader = "-----BEGIN PRIVATE KEY-----";
        _privateKeyFooter = "-----END PRIVATE KEY-----";
        _publicKeyHeader = "-----BEGIN PUBLIC KEY-----";
        _publicKeyFooter = "-----END PUBLIC KEY-----";
    }
}

