/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AsymmetricKey;
import fm.icelink.AsymmetricKeyType;
import fm.icelink.DataBuffer;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.DtlsClientAuthentication;
import fm.icelink.DtlsClientProtocol;
import fm.icelink.DtlsContentType;
import fm.icelink.DtlsFingerprint;
import fm.icelink.DtlsHandshakeType;
import fm.icelink.DtlsMessage;
import fm.icelink.DtlsProtocolVersion;
import fm.icelink.DtlsUdpTransport;
import fm.icelink.DtlsUtility;
import fm.icelink.EcdsaKey;
import fm.icelink.EcdsaNamedCurve;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.IAction1;
import fm.icelink.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DefaultTlsClient;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsECCUtils;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsSession;
import org.bouncycastle.crypto.tls.UseSRTPData;

class DtlsClient
extends DefaultTlsClient {
    private TlsSession session = null;
    private int[] supportedSrtpProtectionProfiles;
    private int selectedSrtpProtectionProfile;
    private boolean closed;
    public String remoteFingerprintAlgorithm;
    public String remoteFingerprint;
    private IAction1<DtlsCertificate> onRemoteCertificate;
    private DtlsCertificate certificate;
    private DtlsCipherSuite[] preferredCipherSuites;
    private DtlsProtocolVersion version;
    private IAction1<DataBuffer> onDataDecrypted;
    private IAction1<Exception> onError;
    private byte[] receiveBuffer;
    private DtlsUdpTransport transport;
    private DtlsClientProtocol protocol;
    private DTLSTransport connection;
    private Object connectionLock;
    private List<DtlsMessage> handshakeFlight = new ArrayList<DtlsMessage>();

    public int[] getSupportedSrtpProtectionProfiles() {
        return this.supportedSrtpProtectionProfiles;
    }

    public int getSelectedSrtpProtectionProfile() {
        return this.selectedSrtpProtectionProfile;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public String getRemoteFingerprintAlgorithm() {
        return this.remoteFingerprintAlgorithm;
    }

    public String getRemoteFingerprint() {
        return this.remoteFingerprint;
    }

    public IAction1<DtlsCertificate> getOnRemoteCertificate() {
        return this.onRemoteCertificate;
    }

    public DtlsCertificate getCertificate() {
        return this.certificate;
    }

    public DtlsCipherSuite[] getPreferredCipherSuites() {
        return this.preferredCipherSuites;
    }

    public DtlsProtocolVersion getVersion() {
        return this.version;
    }

    public void setOnDataDecrypted(IAction1<DataBuffer> onDataDecrypted) {
        this.onDataDecrypted = onDataDecrypted;
    }

    public void setOnError(IAction1<Exception> onError) {
        this.onError = onError;
    }

    public DtlsClient(DtlsCertificate certificate, DtlsCipherSuite[] cipherSuites, DtlsProtocolVersion version, DtlsFingerprint remoteFingerprint, int[] protectionProfiles, IAction1<DtlsCertificate> onRemoteCertificate) {
        this.certificate = certificate;
        this.preferredCipherSuites = cipherSuites;
        this.version = version;
        this.remoteFingerprintAlgorithm = remoteFingerprint.getAlgorithm();
        this.remoteFingerprint = remoteFingerprint.getValue();
        this.supportedSrtpProtectionProfiles = protectionProfiles;
        this.connectionLock = new Object();
        this.onRemoteCertificate = onRemoteCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error open(final IAction1<DataBuffer> sendCallback) {
        try {
            this.protocol = new DtlsClientProtocol();
            this.transport = new DtlsUdpTransport(new IAction1<byte[]>(){

                @Override
                public void invoke(byte[] packet) {
                    if (!DtlsClient.this.getClosed()) {
                        if (DtlsClient.this.connection == null) {
                            Log.debug(String.format(Locale.getDefault(), "Sending DTLS packet (%d bytes).", packet.length));
                            DtlsMessage[] messages = DtlsMessage.parseMultiple(DataBuffer.wrap(packet));
                            if (messages != null) {
                                for (DtlsMessage message : messages) {
                                    DtlsClient.this.handshakeFlight.add(message);
                                }
                            }
                            if (DtlsClient.this.handshakeFlight.size() >= 1) {
                                DtlsMessage secondLastMessage;
                                DtlsMessage lastMessage = (DtlsMessage)DtlsClient.this.handshakeFlight.get(DtlsClient.this.handshakeFlight.size() - 1);
                                if (lastMessage.getContentType() == DtlsContentType.getHandshake() && lastMessage.getHandshakeType() == DtlsHandshakeType.getClientHello()) {
                                    DtlsClient.this.sendHandshakeFlight(sendCallback);
                                } else if (DtlsClient.this.handshakeFlight.size() >= 2 && (secondLastMessage = (DtlsMessage)DtlsClient.this.handshakeFlight.get(DtlsClient.this.handshakeFlight.size() - 2)).getContentType() == DtlsContentType.getChangeCipherSpec() && lastMessage.getContentType() == DtlsContentType.getHandshake()) {
                                    DtlsClient.this.sendHandshakeFlight(sendCallback);
                                }
                            }
                        } else {
                            sendCallback.invoke(DataBuffer.wrap(packet));
                        }
                    }
                }
            });
            this.connection = this.protocol.connect(this, this.transport);
            Object object = this.connectionLock;
            synchronized (object) {
                this.receiveBuffer = new byte[this.connection.getReceiveLimit()];
                this.processReceived();
            }
            Error error = null;
            if (this.closed) {
                error = new Error(ErrorCode.DtlsKeyExchangeFailed, new Exception("Could not connect to DTLS server."));
            }
            return error;
        }
        catch (Exception ex) {
            Error error = new Error(ErrorCode.DtlsKeyExchangeFailed, ex);
            return error;
        }
    }

    private void sendHandshakeFlight(IAction1<DataBuffer> sendCallback) {
        DataBuffer data = this.handshakeFlight.get(0).getRaw();
        for (int i = 1; i < this.handshakeFlight.size(); ++i) {
            data.append(this.handshakeFlight.get(i).getRaw());
        }
        this.handshakeFlight.clear();
        sendCallback.invoke(data);
    }

    public void send(DataBuffer packet) {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.send(packet.getData(), packet.getIndex(), packet.getLength());
                }
                catch (Exception ex) {
                    IAction1<Exception> handler = this.onError;
                    if (handler == null) break block3;
                    handler.invoke(new Exception(String.format("DTLS client could not process outgoing message.", ex.getMessage())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DataBuffer packet) {
        if (this.connection == null) {
            Log.debug(String.format(Locale.getDefault(), "Received DTLS packet (%d bytes).", packet.getLength()));
        }
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.transport != null) {
                this.transport.push(packet);
            }
            this.processReceived();
        }
    }

    private void processReceived() {
        block4: {
            if (this.connection != null && this.receiveBuffer != null) {
                try {
                    int dataLength = 0;
                    while (dataLength != -1) {
                        dataLength = this.connection.receive(this.receiveBuffer, 0, this.receiveBuffer.length, 0);
                        if (dataLength <= 0) continue;
                        this.onDataDecrypted.invoke(DataBuffer.wrap(this.receiveBuffer, 0, dataLength));
                    }
                }
                catch (Exception ex) {
                    IAction1<Exception> handler = this.onError;
                    if (handler == null) break block4;
                    handler.invoke(new Exception(String.format("DTLS client could not process incoming message.", ex.getMessage())));
                }
            }
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
        if (this.protocol != null) {
            try {
                this.protocol.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.protocol = null;
        }
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.transport = null;
        }
        this.closed = true;
    }

    public byte[] getKeyingMaterial() {
        return this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 60);
    }

    @Override
    public TlsSession getSessionToResume() {
        return this.session;
    }

    public void notifyAlertRaised(byte alertLevel, byte alertDescription, String message, Exception cause) {
        if (!this.closed) {
            IAction1<Exception> handler;
            boolean raiseError = false;
            String causeText = cause == null ? "" : String.format(", Inner exception: %s", cause.getMessage());
            String text = String.format(Locale.getDefault(), "DTLS client raised alert. (Level: %s, Description: %s, Message: '%s')", String.valueOf(alertLevel), String.valueOf(alertDescription), message);
            if (alertLevel == 1) {
                if (alertDescription == 0) {
                    text = "Local DTLS client closed connection.";
                    if (cause == null) {
                        Log.debug(text);
                    } else {
                        Log.debug(text, cause);
                    }
                    raiseError = false;
                } else if (cause == null) {
                    Log.warn(text);
                } else {
                    Log.warn(text, cause);
                }
            } else if (alertLevel == 2) {
                raiseError = true;
            } else if (cause == null) {
                Log.debug(text);
            } else {
                Log.debug(text, cause);
            }
            if (raiseError && (handler = this.onError) != null) {
                handler.invoke(new Exception(text));
            }
        }
    }

    public void notifyAlertReceived(byte alertLevel, byte alertDescription) {
        if (!this.closed) {
            IAction1<Exception> handler;
            boolean raiseError = false;
            String text = String.format(Locale.getDefault(), "DTLS client received alert. (Level: %s, Description: %s)", String.valueOf(alertLevel), String.valueOf(alertDescription));
            if (alertLevel == 1) {
                if (alertDescription == 0) {
                    text = "Remote DTLS server closed connection.";
                    raiseError = true;
                } else {
                    Log.warn(text);
                }
            } else if (alertLevel == 2) {
                Log.error(text);
                raiseError = false;
            } else {
                Log.debug(text);
            }
            if (raiseError && (handler = this.onError) != null) {
                handler.invoke(new Exception(text));
            }
        }
    }

    @Override
    public ProtocolVersion getClientVersion() {
        if (this.version == DtlsProtocolVersion.Dtls12) {
            return ProtocolVersion.DTLSv12;
        }
        return ProtocolVersion.DTLSv10;
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    @Override
    public int[] getCipherSuites() {
        int count = this.getPreferredCipherSuites().length;
        int[] cipherSuites = new int[count];
        for (int i = 0; i < count; ++i) {
            cipherSuites[i] = DtlsUtility.convertCipherSuite(this.getPreferredCipherSuites()[i]);
        }
        return cipherSuites;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        AsymmetricKey key;
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        if (this.supportedSrtpProtectionProfiles != null) {
            TlsSRTPUtils.addUseSRTPExtension(clientExtensions, new UseSRTPData(this.supportedSrtpProtectionProfiles, null));
        }
        if (TlsECCUtils.containsECCCipherSuites(this.getCipherSuites()) && (key = this.getCertificate().getKey()).getType() == AsymmetricKeyType.Ecdsa) {
            EcdsaKey ecdsaKey = (EcdsaKey)key;
            if (ecdsaKey.getNamedCurve() == EcdsaNamedCurve.P256) {
                this.namedCurves = new int[]{23};
            } else if (ecdsaKey.getNamedCurve() == EcdsaNamedCurve.P384) {
                this.namedCurves = new int[]{24};
            } else if (ecdsaKey.getNamedCurve() == EcdsaNamedCurve.P521) {
                this.namedCurves = new int[]{25};
            }
            this.clientECPointFormats = new short[]{0};
            TlsECCUtils.addSupportedEllipticCurvesExtension(clientExtensions, this.namedCurves);
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        return clientExtensions;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        UseSRTPData useSrtp;
        super.processServerExtensions(serverExtensions);
        if (serverExtensions != null && this.supportedSrtpProtectionProfiles != null && (useSrtp = TlsSRTPUtils.getUseSRTPExtension(serverExtensions)) != null) {
            if (useSrtp.getProtectionProfiles() == null || useSrtp.getProtectionProfiles().length == 0) {
                throw new TlsFatalAlert(50);
            }
            this.selectedSrtpProtectionProfile = useSrtp.getProtectionProfiles()[0];
            if (!this.validateSelectedSrtpProtectionProfile()) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    private boolean validateSelectedSrtpProtectionProfile() {
        for (int supportedSrtpProtectionProfile : this.supportedSrtpProtectionProfiles) {
            if (this.selectedSrtpProtectionProfile != supportedSrtpProtectionProfile) continue;
            return true;
        }
        return false;
    }

    @Override
    public TlsAuthentication getAuthentication() {
        return new DtlsClientAuthentication(this.context, this.certificate, this.remoteFingerprintAlgorithm, this.remoteFingerprint, this.onRemoteCertificate);
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        TlsSession newSession = this.context.getResumableSession();
        if (newSession != null) {
            this.session = newSession;
        }
    }
}

