/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DtlsCipherSuite {
    RsaAes128Sha(1),
    EcdheRsaAes128Sha(2),
    EcdheEcdsaAes128Sha(3),
    RsaAes128GcmSha256(4),
    EcdheRsaAes128GcmSha256(5),
    EcdheEcdsaAes128GcmSha256(6),
    RsaAes128CbcSha256(7),
    EcdheRsaAes128CbcSha256(8),
    EcdheEcdsaAes128CbcSha256(9);

    private final int value;
    private static final Map<Integer, DtlsCipherSuite> lookup;

    private DtlsCipherSuite(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static DtlsCipherSuite getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, DtlsCipherSuite>();
        for (DtlsCipherSuite s : EnumSet.allOf(DtlsCipherSuite.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

