/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AsymmetricKey;
import fm.icelink.AsymmetricKeyType;
import fm.icelink.Certificate;
import fm.icelink.DtlsFingerprint;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import java.util.Date;

public class DtlsCertificate
extends Certificate<DtlsCertificate, DtlsFingerprint> {
    private static AsymmetricKeyType __defaultKeyType = AsymmetricKeyType.Ecdsa;

    @Override
    protected DtlsCertificate createCertificate() {
        return new DtlsCertificate();
    }

    @Override
    protected DtlsFingerprint createFingerprint(String algorithm, String value) {
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("Calculated DTLS certificate fingerprint {0} for algorithm {1}.", value.toString(), algorithm));
        }
        return new DtlsFingerprint(algorithm, value.toString());
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, AsymmetricKeyType keyType) {
        return DtlsCertificate.generateCertificate(issuerName, subjectName, AsymmetricKey.createKey(keyType));
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName) {
        return DtlsCertificate.generateCertificate(issuerName, subjectName, DtlsCertificate.getDefaultKeyType());
    }

    public static DtlsCertificate generateCertificate(String name, AsymmetricKey key) {
        return Certificate.generateCertificate(name, key, new DtlsCertificate());
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, AsymmetricKey key) {
        return Certificate.generateCertificate(issuerName, subjectName, key, new DtlsCertificate());
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate, AsymmetricKey key) {
        return Certificate.generateCertificate(issuerName, subjectName, expirationDate, key, new DtlsCertificate());
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate, AsymmetricKeyType keyType) {
        return DtlsCertificate.generateCertificate(issuerName, subjectName, expirationDate, AsymmetricKey.createKey(keyType));
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate) {
        return DtlsCertificate.generateCertificate(issuerName, subjectName, expirationDate, DtlsCertificate.getDefaultKeyType());
    }

    public static DtlsCertificate generateCertificate(String name, AsymmetricKeyType keyType) {
        return DtlsCertificate.generateCertificate(name, AsymmetricKey.createKey(keyType));
    }

    public static DtlsCertificate generateCertificate(AsymmetricKeyType keyType) {
        return DtlsCertificate.generateCertificate(AsymmetricKey.createKey(keyType));
    }

    public static DtlsCertificate generateCertificate() {
        return DtlsCertificate.generateCertificate(DtlsCertificate.getDefaultKeyType());
    }

    public static DtlsCertificate generateCertificate(String name) {
        return DtlsCertificate.generateCertificate(name, DtlsCertificate.getDefaultKeyType());
    }

    public static DtlsCertificate generateCertificate(AsymmetricKey key) {
        return Certificate.generateCertificate(key, new DtlsCertificate());
    }

    public static DtlsCertificate generateCertificateFromOldCertificate(DtlsCertificate oldCertificate) {
        return Certificate.generateCertificateFromOldCertificate(oldCertificate, new DtlsCertificate());
    }

    public static DtlsCertificate generateCertificateFromOldCertificate(DtlsCertificate oldCertificate, Date expirationDate) {
        return Certificate.generateCertificateFromOldCertificate(oldCertificate, expirationDate, new DtlsCertificate());
    }

    public static AsymmetricKeyType getDefaultKeyType() {
        return __defaultKeyType;
    }

    public static DtlsCertificate parseBytes(byte[] bytes) {
        return Certificate.parseBytes(bytes, new DtlsCertificate());
    }

    public static void setDefaultKeyType(AsymmetricKeyType value) {
        __defaultKeyType = value;
    }
}

