/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DnsRequest;
import fm.icelink.Future;
import fm.icelink.IAction2;
import fm.icelink.ILog;
import fm.icelink.Log;
import fm.icelink.Promise;
import fm.icelink.StringExtensions;

public abstract class Dns {
    private static ILog __log = Log.getLogger(Dns.class);

    private static void doResolve(final Promise<String[]> promise, final String name) {
        IAction2<String[], Object> callback = null;
        if (name == null) {
            promise.resolve(null);
        } else {
            if (callback == null) {
                callback = new IAction2<String[], Object>(){

                    @Override
                    public void invoke(String[] ips, Object state) {
                        if (ips != null) {
                            if (__log.getIsDebugEnabled()) {
                                __log.debug(StringExtensions.format("Domain '{0}' resolved as '{1}'.", name, ips[0]));
                            }
                            promise.resolve(ips);
                        } else {
                            if (__log.getIsDebugEnabled()) {
                                __log.debug(StringExtensions.format("Domain '{0}' failed to resolve.", name));
                            }
                            promise.resolve(null);
                        }
                    }
                };
            }
            Dns.resolve(name, callback, null);
        }
    }

    public static void resolve(String name, IAction2<String[], Object> callback, Object state) {
        try {
            new DnsRequest(name, callback, state).resolve();
        }
        catch (Exception exception) {
            __log.error(StringExtensions.format("Could not resolve DNS name '{0}'.", name), exception);
            callback.invoke(new String[0], state);
        }
    }

    public static Future<String[]> resolve(String name) {
        Promise<String[]> promise = new Promise<String[]>();
        Dns.doResolve(promise, name);
        return promise;
    }
}

