/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.DtlsProtocolVersion;
import fm.icelink.DtlsTransport;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IceGatherer;
import fm.icelink.IceGatheringState;
import fm.icelink.IceTransport;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;
import fm.icelink.TransportStats;

class CoreTransport {
    private String __connectionId;
    private Object __lock;
    private Scheduler __scheduler;
    private DtlsTransport _dtlsTransport;
    private IceGatherer _gatherer;
    private IceTransport _iceTransport;
    private String _id;

    public CoreTransport(Object lockObject, String connectionId, Scheduler scheduler, IceGatherer gatherer, IceTransport iceTransport, DtlsTransport dtlsTransport) {
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.__lock = lockObject;
        this.__connectionId = connectionId;
        this.__scheduler = scheduler;
        this.setGatherer(gatherer);
        this.setIceTransport(iceTransport);
        this.setDtlsTransport(dtlsTransport);
    }

    public CoreTransport createComplementaryCoreTransport(DtlsCertificate[] certificates, DtlsCipherSuite[] cipherSuites, DtlsProtocolVersion serverMinVersion, DtlsProtocolVersion serverMaxVersion, DtlsProtocolVersion clientVersion) {
        CoreTransport transport2;
        try {
            CoreTransport transport = this.createComplementaryCoreTransport();
            transport.setDtlsTransport(new DtlsTransport(this.__lock, this.__connectionId, transport.getIceTransport(), certificates, cipherSuites, serverMinVersion, serverMaxVersion, clientVersion));
            transport2 = transport;
        }
        catch (Exception exception) {
            throw new RuntimeException(new Exception(StringExtensions.format("Could not create Complementary (RTCP) Core Transport: {0}", exception.getMessage())));
        }
        return transport2;
    }

    public CoreTransport createComplementaryCoreTransport() {
        CoreTransport transport2;
        if (!Global.equals((Object)this.getGatherer().getState(), (Object)IceGatheringState.New)) {
            throw new RuntimeException(new Exception("IceLink: complementary core transport for non-multiplexing cases can only be created when reference core transport is in the new state."));
        }
        try {
            IceGatherer gatherer = this.getGatherer().createRtcpGatherer();
            IceTransport iceTransport = this.getIceTransport().createRtcpTransport();
            transport2 = new CoreTransport(this.__lock, this.__connectionId, this.__scheduler, gatherer, iceTransport, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(new Exception(StringExtensions.format("Could not create Complementary (RTCP) Core Transport: {0}", exception.getMessage())));
        }
        return transport2;
    }

    public DtlsTransport getDtlsTransport() {
        return this._dtlsTransport;
    }

    public IceGatherer getGatherer() {
        return this._gatherer;
    }

    public IceTransport getIceTransport() {
        return this._iceTransport;
    }

    public String getId() {
        return this._id;
    }

    public TransportStats getStats() {
        TransportStats stats2 = new TransportStats();
        stats2.setId(this.getId());
        stats2.setTimestamp(DateExtensions.getUtcNow());
        TransportStats stats = stats2;
        if (this.getDtlsTransport() != null) {
            this.getDtlsTransport().updateStats(stats);
        }
        if (this.getIceTransport() != null) {
            this.getIceTransport().updateStats(stats);
        }
        return stats;
    }

    public void removeDtlsTransport() {
        this.setDtlsTransport(null);
    }

    private void setDtlsTransport(DtlsTransport value) {
        this._dtlsTransport = value;
    }

    private void setGatherer(IceGatherer value) {
        this._gatherer = value;
    }

    private void setIceTransport(IceTransport value) {
        this._iceTransport = value;
    }

    public void setId(String value) {
        this._id = value;
    }
}

