/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioFrame;
import fm.icelink.AudioStream;
import fm.icelink.BandwidthAdaptationPolicy;
import fm.icelink.Binary;
import fm.icelink.BundlePolicy;
import fm.icelink.Candidate;
import fm.icelink.Certificate;
import fm.icelink.ConnectionBase;
import fm.icelink.ConnectionState;
import fm.icelink.ConnectionStats;
import fm.icelink.Constants;
import fm.icelink.CoreTransport;
import fm.icelink.DataBuffer;
import fm.icelink.DataChannel;
import fm.icelink.DataChannelBase;
import fm.icelink.DataChannelState;
import fm.icelink.DataStream;
import fm.icelink.DatagramSocket;
import fm.icelink.DatagramSocketCreateArgs;
import fm.icelink.DateExtensions;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.DtlsFingerprint;
import fm.icelink.DtlsParameters;
import fm.icelink.DtlsProtocolVersion;
import fm.icelink.DtlsRole;
import fm.icelink.DtlsTransport;
import fm.icelink.DtlsTransportState;
import fm.icelink.EncryptionMode;
import fm.icelink.EncryptionPolicy;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Fingerprint;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IFunction1;
import fm.icelink.IMediaTransport;
import fm.icelink.IceCandidate;
import fm.icelink.IceCandidatePair;
import fm.icelink.IceComponent;
import fm.icelink.IceConnectionState;
import fm.icelink.IceGatherOptions;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IceGatherer;
import fm.icelink.IceGatheringState;
import fm.icelink.IceKeepAlivePolicy;
import fm.icelink.IceParameters;
import fm.icelink.IcePolicy;
import fm.icelink.IcePortRange;
import fm.icelink.IceRole;
import fm.icelink.IceServer;
import fm.icelink.IceTransport;
import fm.icelink.IceTransportOptions;
import fm.icelink.IceTransportState;
import fm.icelink.IntegerExtensions;
import fm.icelink.License;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaStreamBase;
import fm.icelink.MediaStreamStats;
import fm.icelink.MediaTransportState;
import fm.icelink.MultiplexPolicy;
import fm.icelink.Promise;
import fm.icelink.ReliableChannel;
import fm.icelink.ReliableTransport;
import fm.icelink.ReliableTransportState;
import fm.icelink.RtpAudioTransport;
import fm.icelink.RtpTransport;
import fm.icelink.RtpVideoTransport;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.SctpTransport;
import fm.icelink.SctpTransportState;
import fm.icelink.SdesPolicy;
import fm.icelink.SessionDescription;
import fm.icelink.SessionDescriptionType;
import fm.icelink.SignallingState;
import fm.icelink.SrtpAudioTransport;
import fm.icelink.SrtpListener;
import fm.icelink.SrtpProtectionParameters;
import fm.icelink.SrtpProtectionProfile;
import fm.icelink.SrtpTransport;
import fm.icelink.SrtpVideoTransport;
import fm.icelink.Stream;
import fm.icelink.StreamCollection;
import fm.icelink.StreamDirection;
import fm.icelink.StreamSocket;
import fm.icelink.StreamSocketCreateArgs;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import fm.icelink.TransportType;
import fm.icelink.TrickleIcePolicy;
import fm.icelink.VideoFrame;
import fm.icelink.VideoStream;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.CryptoAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.Origin;
import fm.icelink.sdp.ice.CandidateAttribute;
import fm.icelink.sdp.ice.OptionTag;
import fm.icelink.sdp.ice.OptionsAttribute;
import fm.icelink.sdp.ice.TrickleIceOptionTag;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class Connection
extends ConnectionBase<Connection, Stream, AudioStream, VideoStream, DataStream, DataChannel> {
    private ArrayList<Candidate> __cachedLocalCandidates;
    private DtlsCipherSuite[] __cipherSuites;
    private HashMap<String, CoreTransport> __coreTransportForDtlsTransport;
    private HashMap<String, CoreTransport> __coreTransportForIceTransport;
    private HashMap<String, ArrayList<CoreTransport>> __coreTransportsForGatherer;
    private boolean __createAnswer = false;
    private boolean __createOffer = false;
    private Object __dtlsCertificatesLock;
    private DtlsProtocolVersion __dtlsClientVersion;
    private DtlsProtocolVersion __dtlsServerMaxVersion;
    private DtlsProtocolVersion __dtlsServerMinVersion;
    private HashMap<String, DtlsTransport> __dtlsTransports;
    private HashMap<String, IceGatherer> __gatherers;
    private IceGatheringState __gatheringState;
    private IceConnectionState __iceConnectionState;
    private IcePolicy __icePolicy = IcePolicy.Required;
    private long __iceTieBreaker = -1L;
    private HashMap<String, IceTransport> __iceTransports = new HashMap();
    private int __keepAliveInterval = 1000;
    private SessionDescription __localDescription;
    private DtlsCertificate[] __localDtlsCertificates;
    private Object __localDtlsFingerprintLock;
    private DtlsFingerprint[] __localDtlsFingerprints;
    private long __localSignallingSessionId = -1L;
    private long __localSignallingSessionVersion = 1L;
    private ScheduledItem __logRTT = null;
    private SessionDescription __oldLocalDescription;
    private ArrayList<CoreTransport> __primaryCoreTransports;
    private Promise<SessionDescription> __promiseToBeResolved = null;
    private SessionDescription __remoteDescription;
    private Scheduler __scheduler;
    private ArrayList<CoreTransport> __secondaryCoreTransports;
    private HashMap<String, AudioStream> __streamForAudioTransport;
    private HashMap<String, DataStream> __streamForReliableDataTransport;
    private HashMap<String, DataStream> __streamForSctpTransport;
    private HashMap<String, VideoStream> __streamForVideoTransport;
    private StreamCollection __streams;
    private HashMap<String, ArrayList<Stream>> __streamsForDtlsTransport;
    private HashMap<String, ArrayList<Stream>> __streamsForIceTransport;
    private ScheduledItem __verifyGatherersDownScheduledItem;
    private BundlePolicy _bundlePolicy;
    private IFunction1<DatagramSocketCreateArgs, DatagramSocket> _createDatagramSocket;
    private IFunction1<StreamSocketCreateArgs, StreamSocket> _createStreamSocket;
    private static DtlsCertificate[] _defaultLocalDtlsCertificates;
    private AddressType[] _iceAddressTypes;
    private IcePortRange _icePortRange;
    private IceRole _iceRole;
    private MultiplexPolicy _multiplexPolicy;
    private boolean _originalSignallingExchangeComplete = false;
    private String[] _privateIPAddresses;
    private String[] _publicIPAddresses;
    private int _stunBindingRequestLimit;
    private int _stunRequestTimeout;
    private int _tcpConnectTimeout;
    private int _turnAllocateRequestLimit;
    private boolean _verboseDebugMessages = false;

    private <T> void addToDictionaryList(HashMap<String, ArrayList<T>> dictionary, String key, T value) {
        ArrayList<T> list = null;
        Holder<Object> _var0 = new Holder<Object>(list);
        boolean _var1 = HashMapExtensions.tryGetValue(dictionary, key, _var0);
        list = _var0.getValue();
        if (!_var1) {
            list = new ArrayList<T>();
        }
        list.add(value);
        HashMapExtensions.set(HashMapExtensions.getItem(dictionary), key, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error assignCoreTransportToStream(Stream stream, CoreTransport rtpCoreTransport, CoreTransport rtcpCoreTransport) {
        Object object = this._connectionLock;
        synchronized (object) {
            return this.doAssignCoreTransportToStream(stream, rtpCoreTransport, rtcpCoreTransport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginConnectingToPeer() {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) {
                return false;
            }
            this.setState(ConnectionState.Connecting);
            Error error = null;
            ArrayList<CoreTransport> list = this.__primaryCoreTransports;
            ArrayListExtensions.addRange(list, this.__secondaryCoreTransports);
            for (CoreTransport transport : list) {
                error = this.startStreamCore(transport);
                if (error == null) continue;
                Log.error(StringExtensions.format("Cannot start internal transport core: {0}", error.getDescription()));
                super.setError(error);
                this.setState(ConnectionState.Failing);
                this.setState(ConnectionState.Failed);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error buildCoreTransport(IceGatherer rtpGatherer, IceGatherer rtcpGatherer, Holder<CoreTransport> core, Holder<CoreTransport> coreRtcp, boolean multiplex, boolean useDtls) {
        Object object = this._connectionLock;
        synchronized (object) {
            Error _var0 = this.doBuildCoreTransport(rtpGatherer, rtcpGatherer, core, coreRtcp, multiplex, useDtls);
            return _var0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error buildDataStream(DataStream stream, CoreTransport coreTransport) {
        Object object = this._connectionLock;
        synchronized (object) {
            Error error = this.assignCoreTransportToStream(stream, coreTransport, null);
            if (error == null) {
                String message = null;
                ErrorCode connectionInternalError = ErrorCode.ConnectionInternalError;
                SctpTransport innerTransport = null;
                Object[] channelArray = null;
                ReliableTransport transport2 = null;
                DtlsTransport dtlsTransport = coreTransport.getDtlsTransport();
                if (dtlsTransport == null) {
                    message = "Core not prepared prior to building data stream architecture. No DTLS Transport present.";
                } else {
                    innerTransport = new SctpTransport(this._connectionLock, this.__scheduler, dtlsTransport, 65535, 65535, 5000L);
                    stream.setSctpTransport(innerTransport);
                    channelArray = stream.getChannels();
                    if (channelArray == null || ArrayExtensions.getLength(channelArray) == 0) {
                        message = "Prior to building data stream architecture, data stream must have data channels declared.";
                    }
                    HashMapExtensions.add(this.__streamForSctpTransport, innerTransport.getId(), stream);
                    innerTransport.removeOnStateChange((IAction1<SctpTransport>)new IActionDelegate1<SctpTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processSctpTransportStateChange";
                        }

                        @Override
                        public void invoke(SctpTransport transport) {
                            Connection.this.processSctpTransportStateChange(transport);
                        }
                    });
                    innerTransport.addOnStateChange((IAction1<SctpTransport>)new IActionDelegate1<SctpTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processSctpTransportStateChange";
                        }

                        @Override
                        public void invoke(SctpTransport transport) {
                            Connection.this.processSctpTransportStateChange(transport);
                        }
                    });
                }
                if (message != null) {
                    error = new Error(connectionInternalError, new Exception(message));
                    this.shutdownOnFailure(error, TransportType.ReliableDataTransport, transport2 == null ? null : transport2.getId());
                    return error;
                }
                Object[] channels = new ReliableChannel[ArrayExtensions.getLength(channelArray)];
                for (int i = 0; i < ArrayExtensions.getLength(channels); ++i) {
                    channels[i] = channelArray[i].getInnerDataChannel();
                    ((DataChannelBase)channelArray[i]).removeOnStateChange(new IActionDelegate1<DataChannel>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processReliableDataChannelStateChange";
                        }

                        @Override
                        public void invoke(DataChannel channel) {
                            Connection.this.processReliableDataChannelStateChange(channel);
                        }
                    });
                    ((DataChannelBase)channelArray[i]).addOnStateChange(new IActionDelegate1<DataChannel>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processReliableDataChannelStateChange";
                        }

                        @Override
                        public void invoke(DataChannel channel) {
                            Connection.this.processReliableDataChannelStateChange(channel);
                        }
                    });
                }
                transport2 = new ReliableTransport(this._connectionLock, innerTransport, (ReliableChannel[])channels);
                stream.setReliableDataTransport(transport2);
                HashMapExtensions.add(this.__streamForReliableDataTransport, transport2.getId(), stream);
                transport2.removeOnStateChange((IAction1<ReliableTransport>)new IActionDelegate1<ReliableTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processReliableDataTransportStateChange";
                    }

                    @Override
                    public void invoke(ReliableTransport transport) {
                        Connection.this.processReliableDataTransportStateChange(transport);
                    }
                });
                transport2.addOnStateChange((IAction1<ReliableTransport>)new IActionDelegate1<ReliableTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processReliableDataTransportStateChange";
                    }

                    @Override
                    public void invoke(ReliableTransport transport) {
                        Connection.this.processReliableDataTransportStateChange(transport);
                    }
                });
                return null;
            }
            return error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error buildMediaStream(Stream stream, CoreTransport rtpCoreTransport, CoreTransport rtcpCoreTransport) {
        Object object = this._connectionLock;
        synchronized (object) {
            IceTransport rtcpTransport;
            Error error = this.assignCoreTransportToStream(stream, rtpCoreTransport, rtcpCoreTransport);
            SrtpListener listener = null;
            IceTransport iceTransport = rtcpTransport = rtcpCoreTransport == null ? rtpCoreTransport.getIceTransport() : rtcpCoreTransport.getIceTransport();
            if (error == null) {
                if (stream instanceof VideoStream) {
                    VideoStream stream2 = (VideoStream)stream;
                    RtpVideoTransport transport2 = new RtpVideoTransport(this._connectionLock, stream2.getNackConfig(), stream2.getRedFecConfig(), stream2.getJitterConfig(), stream2.getDisableAutomaticReports());
                    transport2.setSrtpTransport(new SrtpVideoTransport(this._connectionLock, rtpCoreTransport.getIceTransport(), rtcpTransport));
                    stream2.setRtpTransport(transport2);
                    listener = new SrtpListener(this._connectionLock, (Transport)rtpCoreTransport.getIceTransport(), (Transport)(rtcpCoreTransport == null ? null : rtcpCoreTransport.getIceTransport()), (SrtpVideoTransport)stream2.getRtpTransport().getSrtpTransport());
                    stream2.getRtpTransport().getSrtpTransport().setListener(listener);
                    HashMapExtensions.add(this.__streamForVideoTransport, stream2.getRtpTransport().getId(), stream2);
                    HashMapExtensions.add(this.__streamForVideoTransport, stream2.getRtpTransport().getSrtpTransport().getId(), stream2);
                    HashMapExtensions.add(this.__streamForVideoTransport, stream2.getRtpTransport().getSrtpTransport().getListener().getId(), stream2);
                    stream2.getRtpTransport().addOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processMediaTransportStateChange";
                        }

                        @Override
                        public void invoke(IMediaTransport transport) {
                            Connection.this.processMediaTransportStateChange(transport);
                        }
                    });
                    stream2.getRtpTransport().getSrtpTransport().addOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processMediaTransportStateChange";
                        }

                        @Override
                        public void invoke(IMediaTransport transport) {
                            Connection.this.processMediaTransportStateChange(transport);
                        }
                    });
                } else if (stream instanceof AudioStream) {
                    AudioStream stream3 = (AudioStream)stream;
                    stream3.setRtpTransport(new RtpAudioTransport(this._connectionLock, stream3.getNackConfig(), stream3.getRedFecConfig(), stream3.getJitterConfig(), stream3.getDisableAutomaticReports()));
                    stream3.getRtpTransport().setSrtpTransport(new SrtpAudioTransport(this._connectionLock, rtpCoreTransport.getIceTransport(), rtcpTransport));
                    listener = new SrtpListener(this._connectionLock, (Transport)rtpCoreTransport.getIceTransport(), (Transport)(rtcpCoreTransport == null ? null : rtcpCoreTransport.getIceTransport()), (SrtpAudioTransport)stream3.getRtpTransport().getSrtpTransport());
                    stream3.getRtpTransport().getSrtpTransport().setListener(listener);
                    HashMapExtensions.add(this.__streamForAudioTransport, stream3.getRtpTransport().getId(), stream3);
                    HashMapExtensions.add(this.__streamForAudioTransport, stream3.getRtpTransport().getSrtpTransport().getId(), stream3);
                    HashMapExtensions.add(this.__streamForAudioTransport, stream3.getRtpTransport().getSrtpTransport().getListener().getId(), stream3);
                    stream3.getRtpTransport().addOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processMediaTransportStateChange";
                        }

                        @Override
                        public void invoke(IMediaTransport transport) {
                            Connection.this.processMediaTransportStateChange(transport);
                        }
                    });
                    stream3.getRtpTransport().getSrtpTransport().addOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processMediaTransportStateChange";
                        }

                        @Override
                        public void invoke(IMediaTransport transport) {
                            Connection.this.processMediaTransportStateChange(transport);
                        }
                    });
                }
                listener.addOnStateChange((IAction1<SrtpListener>)new IActionDelegate1<SrtpListener>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processSrtpListenerStateChange";
                    }

                    @Override
                    public void invoke(SrtpListener transport) {
                        Connection.this.processSrtpListenerStateChange(transport);
                    }
                });
                return null;
            }
            return error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error buildStreamTransports() {
        Object object = this._connectionLock;
        synchronized (object) {
            return this.doBuildStreamTransports();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._connectionLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing)) {
                Log.warn("Connection already closing.");
                return;
            }
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed)) {
                return;
            }
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.New)) {
                this.setState(ConnectionState.Closing);
                this.setState(ConnectionState.Closed);
                return;
            }
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
                this.setState(ConnectionState.Closing);
                this.setState(ConnectionState.Closed);
                return;
            }
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) {
                return;
            }
            this.setState(ConnectionState.Closing);
        }
        if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing)) {
            Stream[] streams;
            for (Stream stream : streams = this.getStreams()) {
                SrtpListener listener;
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Application)) {
                    ReliableTransport reliableDataTransport = ((DataStream)stream).getReliableDataTransport();
                    if (reliableDataTransport != null) {
                        reliableDataTransport.stop();
                        continue;
                    }
                    this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down Reliable Data Transport for data stream {0}, because it is not assigned. Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                    continue;
                }
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                    AudioStream stream2 = (AudioStream)stream;
                    RtpTransport rtpTransport = stream2.getRtpTransport();
                    if (rtpTransport != null) {
                        rtpTransport.stop();
                        SrtpTransport srtpTransport = rtpTransport.getSrtpTransport();
                        if (srtpTransport != null) {
                            srtpTransport.stop();
                            listener = srtpTransport.getListener();
                            if (listener != null) {
                                listener.stop();
                            } else {
                                this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down SRTP Listener for audio stream {0}, because it is not assigned. Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                            }
                        } else {
                            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down SRTP Transport for audio stream {0}, because it is not assigned. Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                        }
                    } else {
                        this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down RTP Transport for audio stream {0}, because it is not assigned. Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                    }
                    stream2.setDisabled(true);
                    stream2.destroy();
                    continue;
                }
                if (!Global.equals((Object)stream.getType(), (Object)StreamType.Video)) continue;
                VideoStream stream3 = (VideoStream)stream;
                RtpTransport transport4 = stream3.getRtpTransport();
                if (transport4 != null) {
                    transport4.stop();
                    SrtpTransport transport5 = transport4.getSrtpTransport();
                    if (transport5 != null) {
                        transport5.stop();
                        listener = transport5.getListener();
                        if (listener != null) {
                            listener.stop();
                        } else {
                            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down SRTP Listener for video stream {0}, because it is not assigned.Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                        }
                    } else {
                        this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down SRTP Transport for video stream {0}, because it is not assigned.Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                    }
                } else {
                    this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Connection cannot shut down RTP Transport for video stream {0}, because it is not assigned.Proceeding with shutting down subsequent transports.", stream.getId()))), TransportType.Unset, StringExtensions.empty);
                }
                stream3.setDisabled(true);
                stream3.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error commenceGathering(CoreTransport coreTransport) {
        Object object = this._connectionLock;
        synchronized (object) {
            IceGatherer gatherer = coreTransport.getGatherer();
            if (gatherer == null) {
                String message = "Core transport not prepared prior to commencing to gather.";
                return new Error(ErrorCode.ConnectionInternalError, new Exception(message));
            }
            try {
                gatherer.start();
            }
            catch (Exception exception) {
                return new Error(ErrorCode.ConnectionTransportStartError, exception);
            }
            return null;
        }
    }

    public Connection(Stream[] streams) {
        super(new Object());
        this.__iceConnectionState = IceConnectionState.New;
        this.__dtlsTransports = new HashMap();
        this.__dtlsCertificatesLock = new Object();
        this.__dtlsServerMinVersion = DtlsProtocolVersion.Dtls10;
        this.__dtlsServerMaxVersion = DtlsProtocolVersion.Dtls12;
        this.__dtlsClientVersion = DtlsProtocolVersion.Dtls10;
        this.__cipherSuites = new DtlsCipherSuite[]{DtlsCipherSuite.EcdheEcdsaAes128Sha, DtlsCipherSuite.EcdheEcdsaAes128GcmSha256, DtlsCipherSuite.EcdheEcdsaAes128CbcSha256, DtlsCipherSuite.EcdheRsaAes128Sha, DtlsCipherSuite.EcdheRsaAes128GcmSha256, DtlsCipherSuite.EcdheRsaAes128CbcSha256, DtlsCipherSuite.RsaAes128Sha, DtlsCipherSuite.RsaAes128GcmSha256, DtlsCipherSuite.RsaAes128CbcSha256};
        this.__localDtlsFingerprintLock = new Object();
        this.__primaryCoreTransports = new ArrayList();
        this.__secondaryCoreTransports = new ArrayList();
        this.__coreTransportsForGatherer = new HashMap();
        this.__coreTransportForIceTransport = new HashMap();
        this.__coreTransportForDtlsTransport = new HashMap();
        this.__streamsForDtlsTransport = new HashMap();
        this.__streamsForIceTransport = new HashMap();
        this.__streamForSctpTransport = new HashMap();
        this.__streamForReliableDataTransport = new HashMap();
        this.__streamForAudioTransport = new HashMap();
        this.__streamForVideoTransport = new HashMap();
        this.__gatherers = new HashMap();
        this.__cachedLocalCandidates = new ArrayList();
        this.__streams = new StreamCollection();
        this.__logRTT = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.logRTT";
            }

            @Override
            public void invoke(ScheduledItem item) {
                Connection.this.logRTT(item);
            }
        }, 0, 60000, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        this.initialize(streams);
    }

    public Connection(Stream stream) {
        this(new Stream[]{stream});
    }

    public Connection() {
        this(new Stream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOfferAnswer(Promise<SessionDescription> promise, boolean isOffer) {
        SessionDescription result = null;
        Message sdpMessage = null;
        try {
            Object object = this._connectionLock;
            synchronized (object) {
                SessionDescription description3 = new SessionDescription();
                description3.setType(isOffer ? SessionDescriptionType.Offer : SessionDescriptionType.Answer);
                description3.setTieBreaker(super.getTieBreaker());
                description3.setRenegotiation(this._originalSignallingExchangeComplete);
                result = description3;
                Origin origin = null;
                if (this._originalSignallingExchangeComplete) {
                    ++this.__localSignallingSessionVersion;
                    Origin origin2 = new Origin("127.0.0.1");
                    origin2.setSessionId(this.__localSignallingSessionId);
                    origin2.setSessionVersion(this.__localSignallingSessionVersion);
                    origin = origin2;
                } else {
                    Origin origin3 = new Origin("127.0.0.1");
                    origin3.setSessionVersion(this.__localSignallingSessionVersion);
                    origin = origin3;
                    this.__localSignallingSessionId = origin.getSessionId();
                }
                sdpMessage = new Message(origin, "IceLink");
                if (Global.equals((Object)super.getTrickleIcePolicy(), (Object)TrickleIcePolicy.FullTrickle) || Global.equals((Object)super.getTrickleIcePolicy(), (Object)TrickleIcePolicy.HalfTrickle)) {
                    ArrayList<OptionTag> list2 = new ArrayList<OptionTag>();
                    list2.add(new TrickleIceOptionTag());
                    ArrayList<OptionTag> tags = list2;
                    sdpMessage.addSessionAttribute(new OptionsAttribute(tags));
                }
                for (Stream stream : this.getStreams()) {
                    boolean flag2 = !Global.equals((Object)stream.getType(), (Object)StreamType.Application) && Global.equals((Object)stream.getSdesPolicy(), (Object)SdesPolicy.Negotiated) && !Global.equals((Object)stream.getEncryptionPolicy(), (Object)EncryptionPolicy.Disabled);
                    boolean flag3 = this._originalSignallingExchangeComplete && !stream.getUseDtls();
                    boolean flag4 = !this._originalSignallingExchangeComplete && (isOffer || !stream.getUseDtls());
                    boolean supportSdes = flag2 && (flag3 || flag4) && stream.getUseSdes();
                    stream.setUseSdes(supportSdes);
                    MediaDescription mediaDescription = stream.createSdpMediaDescription(sdpMessage, supportSdes, isOffer, this._originalSignallingExchangeComplete);
                    if (StringExtensions.isNullOrEmpty(mediaDescription.getMedia().getFormatDescription())) {
                        if (isOffer) {
                            promise.reject(new Exception(StringExtensions.format("No codecs in {0} stream.", stream.getType().toString())));
                        } else {
                            promise.reject(new Exception(StringExtensions.format("No matching codecs in {0} stream.", stream.getType().toString())));
                        }
                        return;
                    }
                    sdpMessage.addMediaDescription(mediaDescription);
                }
            }
            if (result != null) {
                result.setSdpMessage(sdpMessage);
                promise.resolve(result);
            }
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
    }

    private void disableSecondaryComponent(Stream stream, int sdpMediaIndex) {
        IceGatherer gatherer;
        IceTransport iceTransport;
        Candidate[] candidateArray;
        for (Candidate candidate : candidateArray = this.__cachedLocalCandidates.toArray(new Candidate[0])) {
            if (candidate.getSdpMediaIndex() != sdpMediaIndex || candidate.getSdpCandidateAttribute().getComponentId() != 2) continue;
            this.__cachedLocalCandidates.remove(candidate);
        }
        stream.eraseLocalCandidatesForSecondaryComponent();
        CoreTransport coreTransportRtcp = stream.getCoreTransportRtcp();
        CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
        if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
            SrtpTransport srtpTransport;
            AudioStream stream2 = (AudioStream)stream;
            RtpTransport rtpTransport = stream2.getRtpTransport();
            if (rtpTransport != null && (srtpTransport = rtpTransport.getSrtpTransport()) != null) {
                srtpTransport.setRtcpTransport(srtpTransport.getRtpTransport());
            }
        } else {
            SrtpTransport transport6;
            VideoStream stream3 = (VideoStream)stream;
            RtpTransport transport5 = stream3.getRtpTransport();
            if (transport5 != null && (transport6 = transport5.getSrtpTransport()) != null) {
                transport6.setRtcpTransport(transport6.getRtpTransport());
            }
        }
        if (coreTransportRtp != null) {
            iceTransport = coreTransportRtp.getIceTransport();
            gatherer = coreTransportRtp.getGatherer();
            iceTransport.removeRtcpTransport();
            gatherer.removeRtcpGatherer();
        }
        if (coreTransportRtcp != null) {
            Log.debug(StringExtensions.format("Multiplexing is supported for stream {0} of type {1}. Secondary (Rtcp) component will be disabled and related sockets will be closed.", stream.getId(), Global.equals((Object)stream.getType(), (Object)StreamType.Audio) ? "Audio" : (Global.equals((Object)stream.getType(), (Object)StreamType.Video) ? "Video" : "Data")));
            stream.setCoreTransportRtcp(null);
            this.__secondaryCoreTransports.remove(coreTransportRtcp);
            DtlsTransport dtlsTransport = coreTransportRtcp.getDtlsTransport();
            iceTransport = coreTransportRtcp.getIceTransport();
            gatherer = coreTransportRtcp.getGatherer();
            if (dtlsTransport != null) {
                dtlsTransport.setClosingShouldNotTriggerGlobalNonGracefulShutdown(true);
            }
            if (iceTransport != null) {
                iceTransport.setClosingShouldNotTriggerGlobalNonGracefulShutdown(true);
            }
            if (gatherer != null) {
                gatherer.setClosingShouldNotTriggerGlobalNonGracefulShutdown(true);
            }
            if (dtlsTransport != null) {
                dtlsTransport.stop();
            } else if (iceTransport != null) {
                iceTransport.stop();
            } else if (gatherer != null) {
                gatherer.stop();
            }
        }
    }

    @Override
    protected void doAddRemoteCandidate(Promise<Candidate> promise, Candidate remoteCandidate) {
        CoreTransport transport;
        int sdpMediaIndex = remoteCandidate.getSdpMediaIndex();
        CandidateAttribute sdpCandidateAttribute = remoteCandidate.getSdpCandidateAttribute();
        if (sdpMediaIndex >= ArrayExtensions.getLength(this.getStreams())) {
            throw new RuntimeException(new Exception("Candidate received with invalid media index."));
        }
        Stream stream = this.getStreams()[sdpMediaIndex];
        CoreTransport coreTransport = transport = sdpCandidateAttribute.getComponentId() == 1 ? stream.getCoreTransportRtp() : stream.getCoreTransportRtcp();
        if (transport == null) {
            promise.resolve(null);
        } else {
            IceCandidate candidate = IceCandidate.fromSdpCandidateAttribute(this._connectionLock, sdpCandidateAttribute);
            IceTransport iceTransport = transport.getIceTransport();
            if (iceTransport == null) {
                throw new RuntimeException(new Exception(StringExtensions.format("Could not add SDP candidate '{0}' for {1} stream. No Ice transport has been prepared.", sdpCandidateAttribute.toString(), stream.getType().toString(), IntegerExtensions.toString(sdpCandidateAttribute.getComponentId()))));
            }
            iceTransport.addRemoteCandidate(candidate);
            promise.resolve(remoteCandidate);
        }
    }

    private Error doAssignCoreTransportToStream(Stream stream, CoreTransport rtpCoreTransport, CoreTransport rtcpCoreTransport) {
        try {
            DtlsTransport dtlsTransport;
            stream.setCoreTransportRtp(rtpCoreTransport);
            String id = rtpCoreTransport.getIceTransport().getId();
            this.addToDictionaryList(this.__streamsForIceTransport, id, stream);
            StreamType type = stream.getType();
            if (Global.equals((Object)type, (Object)StreamType.Audio) || Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                String str2 = "RTP component ";
                Log.debug(StringExtensions.format("Assigned {3}IceTransport with ID {0} to {1} stream with ID {2}.", new Object[]{id, Global.equals((Object)type, (Object)StreamType.Audio) ? "Audio" : "Video", stream.getId(), rtcpCoreTransport == null ? "" : str2}));
            } else if (Global.equals((Object)type, (Object)StreamType.Application)) {
                Log.debug(StringExtensions.format("Assigned IceTransport with ID {0} to a {1} stream with ID {2}.", id, "Data", stream.getId()));
            }
            if (stream.getUseDtls()) {
                this.addToDictionaryList(this.__streamsForDtlsTransport, rtpCoreTransport.getDtlsTransport().getId(), stream);
                dtlsTransport = rtpCoreTransport.getDtlsTransport();
                if (dtlsTransport != null && stream instanceof MediaStreamBase) {
                    dtlsTransport.setEncryptionModes(stream.getEncryptionModes());
                }
            }
            if (rtcpCoreTransport != null) {
                id = rtcpCoreTransport.getIceTransport().getId();
                if (Global.equals((Object)type, (Object)StreamType.Audio) || Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                    Log.debug(StringExtensions.format("Assigned RTCP component IceTransport with ID {0} to {1} stream with ID {2}.", id, Global.equals((Object)type, (Object)StreamType.Audio) ? "Audio" : "Video", stream.getId()));
                }
                stream.setCoreTransportRtcp(rtcpCoreTransport);
                this.addToDictionaryList(this.__streamsForIceTransport, id, stream);
                if (stream.getUseDtls()) {
                    this.addToDictionaryList(this.__streamsForDtlsTransport, rtcpCoreTransport.getDtlsTransport().getId(), stream);
                    dtlsTransport = rtcpCoreTransport.getDtlsTransport();
                    if (dtlsTransport != null && stream instanceof MediaStreamBase) {
                        dtlsTransport.setEncryptionModes(stream.getEncryptionModes());
                    }
                }
            }
            return null;
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Could not assign core transport for stream {0}.", stream.getId()), exception);
            Error error2 = new Error(ErrorCode.ConnectionInternalError, exception);
            error2.setException(exception);
            Error error = error2;
            this.shutdownOnFailure(error, TransportType.Unset, null);
            return error;
        }
    }

    private Error doBuildCoreTransport(IceGatherer rtpGatherer, IceGatherer rtcpGatherer, Holder<CoreTransport> core, Holder<CoreTransport> coreRtcp, boolean multiplex, boolean useDtls) {
        try {
            core.setValue(null);
            coreRtcp.setValue(null);
            if (rtpGatherer == null) {
                IceGatherer gatherer = new IceGatherer(this._connectionLock, this.__scheduler, this.getIceGatherOptions());
                IceGatherOptions options = gatherer.getOptions();
                Object[] servers = options.getServers();
                IceGatherPolicy policy = options.getPolicy();
                String str = "";
                String url = "";
                if (servers == null || ArrayExtensions.getLength(servers) == 0) {
                    str = "no stun or turn servers";
                } else {
                    Object[] strArray = new String[ArrayExtensions.getLength(servers)];
                    for (int i = 0; i < ArrayExtensions.getLength(servers); ++i) {
                        url = ((IceServer)servers[i]).getUrl();
                        strArray[i] = url == null ? "" : url;
                    }
                    str = StringExtensions.concat(ArrayExtensions.getLength(strArray) == 1 ? "server: " : "servers: ", StringExtensions.join(", ", (String[])strArray));
                }
                String str3 = Global.equals((Object)policy, (Object)IceGatherPolicy.All) ? "All" : (Global.equals((Object)policy, (Object)IceGatherPolicy.NoHost) ? "No host" : "Relay only");
                Log.debug(StringExtensions.format("Prepared Gatherer {0} with gather policy {1} and {2}.", gatherer.getId(), str3, str));
                IceTransport transport3 = new IceTransport(this._connectionLock, super.getId(), this.__scheduler, this.getIceTransportOptions());
                transport3.setIcePolicy(this.getIcePolicy());
                IceTransport innerTransport = transport3;
                if (useDtls) {
                    DtlsTransport dtlsTransport = new DtlsTransport(this._connectionLock, super.getId(), innerTransport, this.getLocalDtlsCertificates(), this.__cipherSuites, this.__dtlsServerMinVersion, this.__dtlsServerMaxVersion, this.__dtlsClientVersion);
                    core.setValue(new CoreTransport(this._connectionLock, super.getId(), this.__scheduler, gatherer, innerTransport, dtlsTransport));
                } else {
                    core.setValue(new CoreTransport(this._connectionLock, super.getId(), this.__scheduler, gatherer, innerTransport, null));
                }
                HashMapExtensions.set(HashMapExtensions.getItem(this.__gatherers), core.getValue().getGatherer().getId(), core.getValue().getGatherer());
                core.getValue().getGatherer().removeOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processGathererStateChange";
                    }

                    @Override
                    public void invoke(IceGatherer gatherer) {
                        Connection.this.processGathererStateChange(gatherer);
                    }
                });
                core.getValue().getGatherer().addOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processGathererStateChange";
                    }

                    @Override
                    public void invoke(IceGatherer gatherer) {
                        Connection.this.processGathererStateChange(gatherer);
                    }
                });
                core.getValue().getGatherer().removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processNewLocalCandidate";
                    }

                    @Override
                    public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                        Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                    }
                });
                core.getValue().getGatherer().addOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processNewLocalCandidate";
                    }

                    @Override
                    public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                        Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                    }
                });
                if (!multiplex) {
                    if (useDtls) {
                        coreRtcp.setValue(core.getValue().createComplementaryCoreTransport(this.getLocalDtlsCertificates(), this.__cipherSuites, this.__dtlsServerMinVersion, this.__dtlsServerMaxVersion, this.__dtlsClientVersion));
                    } else {
                        coreRtcp.setValue(core.getValue().createComplementaryCoreTransport());
                    }
                    HashMapExtensions.set(HashMapExtensions.getItem(this.__gatherers), coreRtcp.getValue().getGatherer().getId(), coreRtcp.getValue().getGatherer());
                    coreRtcp.getValue().getGatherer().removeOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processGathererStateChange";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer) {
                            Connection.this.processGathererStateChange(gatherer);
                        }
                    });
                    coreRtcp.getValue().getGatherer().addOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processGathererStateChange";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer) {
                            Connection.this.processGathererStateChange(gatherer);
                        }
                    });
                    coreRtcp.getValue().getGatherer().removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processNewLocalCandidate";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                            Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                        }
                    });
                    coreRtcp.getValue().getGatherer().addOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processNewLocalCandidate";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                            Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                        }
                    });
                }
            }
            this.addToDictionaryList(this.__coreTransportsForGatherer, core.getValue().getGatherer().getId(), core.getValue());
            HashMapExtensions.set(HashMapExtensions.getItem(this.__iceTransports), core.getValue().getIceTransport().getId(), core.getValue().getIceTransport());
            HashMapExtensions.set(HashMapExtensions.getItem(this.__coreTransportForIceTransport), core.getValue().getIceTransport().getId(), core.getValue());
            core.getValue().getIceTransport().removeOnStateChange((IAction1<IceTransport>)new IActionDelegate1<IceTransport>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processIceTransportStateChange";
                }

                @Override
                public void invoke(IceTransport transport) {
                    Connection.this.processIceTransportStateChange(transport);
                }
            });
            core.getValue().getIceTransport().addOnStateChange((IAction1<IceTransport>)new IActionDelegate1<IceTransport>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processIceTransportStateChange";
                }

                @Override
                public void invoke(IceTransport transport) {
                    Connection.this.processIceTransportStateChange(transport);
                }
            });
            core.getValue().getIceTransport().removeOnActiveCandidatePairChange((IAction2<IceTransport, IceCandidatePair>)new IActionDelegate2<IceTransport, IceCandidatePair>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processActiveCandidatePairChange";
                }

                @Override
                public void invoke(IceTransport transport, IceCandidatePair p) {
                    Connection.this.processActiveCandidatePairChange(transport, p);
                }
            });
            core.getValue().getIceTransport().addOnActiveCandidatePairChange((IAction2<IceTransport, IceCandidatePair>)new IActionDelegate2<IceTransport, IceCandidatePair>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processActiveCandidatePairChange";
                }

                @Override
                public void invoke(IceTransport transport, IceCandidatePair p) {
                    Connection.this.processActiveCandidatePairChange(transport, p);
                }
            });
            if (useDtls) {
                HashMapExtensions.set(HashMapExtensions.getItem(this.__dtlsTransports), core.getValue().getDtlsTransport().getId(), core.getValue().getDtlsTransport());
                HashMapExtensions.set(HashMapExtensions.getItem(this.__coreTransportForDtlsTransport), core.getValue().getDtlsTransport().getId(), core.getValue());
                core.getValue().getDtlsTransport().removeOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processDtlsTransportStateChange";
                    }

                    @Override
                    public void invoke(DtlsTransport transport) {
                        Connection.this.processDtlsTransportStateChange(transport);
                    }
                });
                core.getValue().getDtlsTransport().addOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processDtlsTransportStateChange";
                    }

                    @Override
                    public void invoke(DtlsTransport transport) {
                        Connection.this.processDtlsTransportStateChange(transport);
                    }
                });
            }
            this.__primaryCoreTransports.add(core.getValue());
            if (coreRtcp.getValue() != null) {
                this.addToDictionaryList(this.__coreTransportsForGatherer, coreRtcp.getValue().getGatherer().getId(), coreRtcp.getValue());
                HashMapExtensions.set(HashMapExtensions.getItem(this.__iceTransports), coreRtcp.getValue().getIceTransport().getId(), coreRtcp.getValue().getIceTransport());
                HashMapExtensions.set(HashMapExtensions.getItem(this.__coreTransportForIceTransport), coreRtcp.getValue().getIceTransport().getId(), coreRtcp.getValue());
                coreRtcp.getValue().getIceTransport().removeOnStateChange((IAction1<IceTransport>)new IActionDelegate1<IceTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processIceTransportStateChange";
                    }

                    @Override
                    public void invoke(IceTransport transport) {
                        Connection.this.processIceTransportStateChange(transport);
                    }
                });
                coreRtcp.getValue().getIceTransport().addOnStateChange((IAction1<IceTransport>)new IActionDelegate1<IceTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processIceTransportStateChange";
                    }

                    @Override
                    public void invoke(IceTransport transport) {
                        Connection.this.processIceTransportStateChange(transport);
                    }
                });
                coreRtcp.getValue().getIceTransport().removeOnActiveCandidatePairChange((IAction2<IceTransport, IceCandidatePair>)new IActionDelegate2<IceTransport, IceCandidatePair>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processActiveCandidatePairChange";
                    }

                    @Override
                    public void invoke(IceTransport transport, IceCandidatePair p) {
                        Connection.this.processActiveCandidatePairChange(transport, p);
                    }
                });
                coreRtcp.getValue().getIceTransport().addOnActiveCandidatePairChange((IAction2<IceTransport, IceCandidatePair>)new IActionDelegate2<IceTransport, IceCandidatePair>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processActiveCandidatePairChange";
                    }

                    @Override
                    public void invoke(IceTransport transport, IceCandidatePair p) {
                        Connection.this.processActiveCandidatePairChange(transport, p);
                    }
                });
                if (useDtls) {
                    HashMapExtensions.set(HashMapExtensions.getItem(this.__dtlsTransports), coreRtcp.getValue().getDtlsTransport().getId(), coreRtcp.getValue().getDtlsTransport());
                    HashMapExtensions.set(HashMapExtensions.getItem(this.__coreTransportForDtlsTransport), coreRtcp.getValue().getDtlsTransport().getId(), coreRtcp.getValue());
                    coreRtcp.getValue().getDtlsTransport().removeOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processDtlsTransportStateChange";
                        }

                        @Override
                        public void invoke(DtlsTransport transport) {
                            Connection.this.processDtlsTransportStateChange(transport);
                        }
                    });
                    coreRtcp.getValue().getDtlsTransport().addOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processDtlsTransportStateChange";
                        }

                        @Override
                        public void invoke(DtlsTransport transport) {
                            Connection.this.processDtlsTransportStateChange(transport);
                        }
                    });
                }
                this.__secondaryCoreTransports.add(coreRtcp.getValue());
            }
            return null;
        }
        catch (Exception exception) {
            core.setValue(null);
            coreRtcp.setValue(null);
            this.__gatherers.clear();
            this.__primaryCoreTransports.clear();
            this.__secondaryCoreTransports.clear();
            this.__coreTransportForIceTransport.clear();
            this.__coreTransportForDtlsTransport.clear();
            this.__dtlsTransports.clear();
            this.__iceTransports.clear();
            Log.error(StringExtensions.format("Could not build core transport for connection {0}.", super.getId()), exception);
            Error error2 = new Error(ErrorCode.ConnectionInternalError, exception);
            error2.setException(exception);
            return error2;
        }
    }

    private Error doBuildStreamTransports() {
        try {
            int num3;
            Error error = null;
            int num = 0;
            int num2 = 0;
            Object[] streamArray = this.getStreamsByType(StreamType.Audio).toArray(new AudioStream[0]);
            Object[] streamArray2 = this.getStreamsByType(StreamType.Video).toArray(new VideoStream[0]);
            Object[] streamArray3 = this.getStreamsByType(StreamType.Application).toArray(new DataStream[0]);
            Object[] transportArray = null;
            Object[] transportArray2 = null;
            num = ArrayExtensions.getLength(streamArray) + ArrayExtensions.getLength(streamArray2) + ArrayExtensions.getLength(streamArray3);
            if (!Global.equals((Object)this.getMultiplexPolicy(), (Object)MultiplexPolicy.Required)) {
                num2 = ArrayExtensions.getLength(streamArray2) + ArrayExtensions.getLength(streamArray);
            }
            transportArray = new CoreTransport[num];
            transportArray2 = new CoreTransport[num2];
            boolean useDtls = false;
            for (Stream stream : this.getStreams()) {
                useDtls = useDtls || stream.getUseDtls();
            }
            CoreTransport core = null;
            CoreTransport coreRtcp = null;
            for (num3 = 0; num3 < ArrayExtensions.getLength(transportArray); ++num3) {
                boolean multiplex = num3 > ArrayExtensions.getLength(transportArray2) - 1;
                Holder<Object> _var0 = new Holder<Object>(core);
                Holder<Object> _var1 = new Holder<Object>(coreRtcp);
                Error _var2 = this.buildCoreTransport(null, null, _var0, _var1, multiplex, useDtls);
                core = _var0.getValue();
                coreRtcp = _var1.getValue();
                error = _var2;
                if (error != null) {
                    return error;
                }
                transportArray[num3] = core;
                if (multiplex) continue;
                transportArray2[num3] = coreRtcp;
            }
            Object stream2 = null;
            for (num3 = 0; num3 < ArrayExtensions.getLength(this.getStreams()); ++num3) {
                Object rtcpCoreTransport;
                Object object = rtcpCoreTransport = num3 < ArrayExtensions.getLength(transportArray2) ? transportArray2[num3] : null;
                if (num3 < ArrayExtensions.getLength(streamArray)) {
                    error = this.buildMediaStream((Stream)streamArray[num3], (CoreTransport)transportArray[num3], (CoreTransport)rtcpCoreTransport);
                    stream2 = streamArray[num3];
                } else if (num3 < ArrayExtensions.getLength(streamArray) + ArrayExtensions.getLength(streamArray2)) {
                    int index = num3 - ArrayExtensions.getLength(streamArray);
                    error = this.buildMediaStream((Stream)streamArray2[index], (CoreTransport)transportArray[num3], (CoreTransport)rtcpCoreTransport);
                    stream2 = streamArray2[index];
                } else {
                    int num5 = num3 - ArrayExtensions.getLength(streamArray) - ArrayExtensions.getLength(streamArray2);
                    error = this.buildDataStream((DataStream)streamArray3[num5], (CoreTransport)transportArray[num3]);
                    stream2 = streamArray3[num5];
                }
                if (error != null) {
                    return error;
                }
                ((Stream)stream2).assignLocalParametersToCoreTransports();
                if (Global.equals((Object)((Stream)stream2).getEncryptionPolicy(), (Object)EncryptionPolicy.Disabled)) continue;
                ((Stream)stream2).setLocalDtlsParameters(new DtlsParameters(DtlsRole.Auto, this.getLocalDtlsFingerprints()));
            }
            return null;
        }
        catch (Exception exception) {
            return new Error(ErrorCode.ConnectionInvalidArchitecture, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCreateAnswer(Promise<SessionDescription> promise) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!super.getUseTrickleIce() && !Global.equals((Object)this.getGatheringState(), (Object)IceGatheringState.Complete)) {
                this.__promiseToBeResolved = promise;
                this.__createAnswer = true;
            } else {
                this.createOfferAnswer(promise, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCreateOffer(Promise<SessionDescription> promise) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.New)) {
                this.setState(ConnectionState.Initializing);
            } else if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Connected)) {
                promise.reject(new Exception("SDP Renegotiation is only allowed when Connection is in the Connected state."));
                return false;
            }
            boolean flag = true;
            if (ArrayListExtensions.getCount(this.__primaryCoreTransports) == 0) {
                flag = this.prepareTransports();
            }
            if (!flag) {
                promise.reject(super.getError().getException());
                this.__promiseToBeResolved = null;
                this.__createOffer = false;
                this.__createAnswer = false;
            } else if (super.getUseTrickleIce() || Global.equals((Object)this.getGatheringState(), (Object)IceGatheringState.Complete)) {
                this.__promiseToBeResolved = null;
                this.__createOffer = false;
                this.__createAnswer = false;
                this.createOfferAnswer(promise, true);
            } else {
                this.__promiseToBeResolved = promise;
                this.__createOffer = true;
            }
        }
        return true;
    }

    private void doProcessIceTransportClosed(IceTransport transport) {
        if (!super.getIsInTerminatingOrTerminatedState() && !transport.getClosingShouldNotTriggerGlobalNonGracefulShutdown()) {
            String message = "IceTransport shut down unexpectedly. Connection will shut down.";
            Error error = new Error(ErrorCode.ConnectionTransportClosed, new Exception(message));
            this.shutdownOnFailure(error, TransportType.IceTransport, transport.getId());
        } else {
            if (transport.getClosingShouldNotTriggerGlobalNonGracefulShutdown()) {
                HashMapExtensions.remove(this.__iceTransports, transport.getId());
            }
            this.processIceTransportDown(transport);
        }
    }

    private void doProcessIceTransportConnected(IceTransport transport) {
        CoreTransport transport2 = null;
        String message = null;
        TransportType unset = TransportType.Unset;
        ErrorCode connectionInternalError = ErrorCode.ConnectionInternalError;
        DtlsTransport transport3 = null;
        Holder<Object> _var0 = new Holder<Object>(transport2);
        boolean _var1 = HashMapExtensions.tryGetValue(this.__coreTransportForIceTransport, transport.getId(), _var0);
        transport2 = _var0.getValue();
        if (_var1) {
            DtlsTransport dtlsTransport = transport3 = transport2 == null ? null : transport2.getDtlsTransport();
        }
        if (transport3 != null) {
            ArrayList list = null;
            DtlsParameters remoteParameters = null;
            Holder<Object> _var2 = new Holder<Object>(list);
            boolean _var3 = HashMapExtensions.tryGetValue(this.__streamsForIceTransport, transport.getId(), _var2);
            list = _var2.getValue();
            if (!_var3 || ArrayListExtensions.getCount(list) < 1) {
                message = StringExtensions.format("Core transport cannot start because there are no streams associated with core transport.", new Object[0]);
            } else {
                remoteParameters = ((Stream)ArrayListExtensions.getItem(list).get(0)).getRemoteDtlsParameters();
                if (remoteParameters == null) {
                    message = StringExtensions.format("Remote DTLS parameters are not set for connection {0}. Connection will shut down.", super.getId());
                    unset = TransportType.DtlsTransport;
                }
            }
            if (message == null) {
                try {
                    transport3.start(remoteParameters);
                }
                catch (Exception exception) {
                    connectionInternalError = ErrorCode.ConnectionTransportStartError;
                    message = exception.getMessage();
                    unset = TransportType.DtlsTransport;
                }
            }
        } else {
            ArrayList list = null;
            Holder<Object> _var4 = new Holder<Object>(list);
            boolean _var5 = HashMapExtensions.tryGetValue(this.__streamsForIceTransport, transport.getId(), _var4);
            list = _var4.getValue();
            if (_var5) {
                Log.debug(StringExtensions.format("ICE transport {0} connected. Starting remaining transports on associated streams.", transport.getId()));
                for (Stream stream : list) {
                    if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio) || Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                        CryptoAttribute attribute2;
                        CoreTransport coreTransportRtcp = stream.getCoreTransportRtcp();
                        CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
                        if (stream.getCoreTransportRtcp() != null && (!Global.equals((Object)coreTransportRtp.getIceTransport().getState(), (Object)IceTransportState.Connected) || !Global.equals((Object)coreTransportRtcp.getIceTransport().getState(), (Object)IceTransportState.Connected))) continue;
                        CryptoAttribute attribute = stream.getLocalCryptoAttributes() == null || ArrayExtensions.getLength(stream.getLocalCryptoAttributes()) == 0 ? null : stream.getLocalCryptoAttributes()[0];
                        CryptoAttribute cryptoAttribute = attribute2 = stream.getRemoteCryptoAttributes() == null || ArrayExtensions.getLength(stream.getRemoteCryptoAttributes()) == 0 ? null : stream.getRemoteCryptoAttributes()[0];
                        if (attribute == null || attribute2 == null) {
                            if (!Global.equals((Object)stream.getEncryptionMode(), (Object)EncryptionMode.Null)) {
                                String str2 = "";
                                str2 = attribute == null && attribute2 == null ? "local and remote" : (attribute == null ? "local" : "remote");
                                Error error = new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("SDES is in use for stream {0} of type {1}. But {2} attributes are missing", stream.getId(), stream.getType().toString(), str2)));
                                this.shutdownOnFailure(error, TransportType.SrtpTransport, StringExtensions.empty);
                                return;
                            }
                            this.startRtpTransport(stream, 0, null, null, null, null);
                            continue;
                        }
                        DataBuffer key = attribute.getKey();
                        DataBuffer remoteKey = attribute2.getKey();
                        DataBuffer salt = attribute.getSalt();
                        DataBuffer remoteSalt = attribute2.getSalt();
                        EncryptionMode[] encryptionModes = stream.getEncryptionModes();
                        EncryptionMode encryptionMode = encryptionModes != null && ArrayExtensions.getLength((Object[])encryptionModes) > 0 ? encryptionModes[0] : EncryptionMode.Null;
                        int protectionProfileCode = SrtpProtectionProfile.encryptionModeToProtectionProfileCode(encryptionMode);
                        this.startRtpTransport(stream, protectionProfileCode, key, salt, remoteKey, remoteSalt);
                        continue;
                    }
                    if (Global.equals((Object)stream.getType(), (Object)StreamType.Application)) {
                        Error error = new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Data streams must use DTLS, but no DTLS transport has been prepared.", stream.getType().toString())));
                        this.shutdownOnFailure(error, TransportType.DtlsTransport, StringExtensions.empty);
                    } else {
                        Error error = new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Unsupported data stream type {0}.", stream.getType().toString())));
                        this.shutdownOnFailure(error, TransportType.DtlsTransport, StringExtensions.empty);
                    }
                    return;
                }
            }
        }
        if (message != null) {
            Error error = new Error(connectionInternalError, new Exception(message));
            this.shutdownOnFailure(error, unset, Global.equals((Object)unset, (Object)TransportType.Unset) || transport3 == null ? StringExtensions.empty : transport3.getId());
        }
    }

    private void doProcessIceTransportDisconnected(IceTransport transport) {
        if (!super.getIsInTerminatingOrTerminatedState()) {
            Log.debug(StringExtensions.format("Connectivity currently not available with peer for connection {0}.", super.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessMediaTransportStateChange(IMediaTransport transport) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
                return false;
            }
        }
        if (Global.equals((Object)transport.getState(), (Object)MediaTransportState.Stopped)) {
            this.processMediaTransportDown(transport);
        } else if (Global.equals((Object)transport.getState(), (Object)MediaTransportState.Failed)) {
            this.shutdownOnFailure(new Error(ErrorCode.MediaTransportFailed, new Exception("Media Transport failed.")), TransportType.MediaTransport, transport.getId());
        }
        return true;
    }

    @Override
    protected void doSendCachedLocalCandidates() {
        Candidate[] candidateArray = this.__cachedLocalCandidates.toArray(new Candidate[0]);
        this.__cachedLocalCandidates.clear();
        for (Candidate candidate : candidateArray) {
            super.raiseLocalCandidate(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetLocalDescription(Promise<SessionDescription> promise, SessionDescription localDescription) {
        try {
            Object object = this._connectionLock;
            synchronized (object) {
                if (localDescription.getIsOffer() && Global.equals((Object)super.getSignallingState(), (Object)SignallingState.HaveRemoteOffer)) {
                    throw new RuntimeException(new Exception("Cannot set a local offer when we have a remote offer."));
                }
                this.processAndSetDescription(localDescription, true, promise);
            }
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetRemoteDescription(Promise<SessionDescription> promise, SessionDescription remoteDescription) {
        try {
            Object object = this._connectionLock;
            synchronized (object) {
                remoteDescription.setRenegotiation(this._originalSignallingExchangeComplete);
                if (Global.equals((Object)this.getState(), (Object)ConnectionState.New)) {
                    this.setState(ConnectionState.Initializing);
                } else if (!(Global.equals((Object)this.getState(), (Object)ConnectionState.Connected) || Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing) && this.__remoteDescription == null)) {
                    promise.reject(new Exception("SDP Renegotiation is only allowed when Connection is in the Connected state."));
                    return;
                }
                if (!remoteDescription.getRenegotiation() && this.getRemoteDescription() != null) {
                    throw new RuntimeException(new Exception("Remote description is already set."));
                }
                if (remoteDescription.getIsOffer()) {
                    this.setIceRole(IceRole.Controlled);
                    boolean flag = true;
                    if (ArrayListExtensions.getCount(this.__primaryCoreTransports) == 0) {
                        flag = this.prepareTransports();
                    }
                    if (!flag) {
                        promise.reject(super.getError() == null ? null : super.getError().getException());
                    }
                    this.processAndSetDescription(remoteDescription, false, promise);
                } else {
                    this.processAndSetDescription(remoteDescription, false, promise);
                }
            }
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
    }

    private boolean doStopGatherer(IceGatherer gatherer) {
        try {
            ArrayList list = null;
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__coreTransportsForGatherer, gatherer.getId(), _var0);
            list = _var0.getValue();
            if (_var1 && ArrayListExtensions.getCount(list) > 0) {
                Log.debug(StringExtensions.format("A request to stop gatherer {0} has been made; however, {1} transports still use it.", gatherer.getId(), IntegerExtensions.toString(ArrayListExtensions.getCount(list))));
                return false;
            }
            Log.debug(StringExtensions.format("Shutting down gatherer {0}.", gatherer.getId()));
            gatherer.stop();
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("No Gatherer transport found for Core Transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.Gatherer, gatherer.getId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnectionTimeout(ScheduledItem item) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Connecting) || Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) {
                this.shutdownOnFailure(new Error(ErrorCode.ConnectionNotEstablished, new Exception("Could not establish connectivity with remote peer. Shutting down connection.")), TransportType.Unset, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalise(ConnectionState requestedState) {
        Object object = this._connectionLock;
        synchronized (object) {
            super.setState(requestedState);
        }
    }

    public AudioStream[] getAudioStreams() {
        ArrayList<AudioStream> list = new ArrayList<AudioStream>();
        for (Stream stream : this.getStreams()) {
            if (!Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) continue;
            list.add((AudioStream)stream);
        }
        return list.toArray(new AudioStream[0]);
    }

    private BundlePolicy getBundlePolicy() {
        return this._bundlePolicy;
    }

    public IFunction1<DatagramSocketCreateArgs, DatagramSocket> getCreateDatagramSocket() {
        return this._createDatagramSocket;
    }

    public IFunction1<StreamSocketCreateArgs, StreamSocket> getCreateStreamSocket() {
        return this._createStreamSocket;
    }

    public DataStream[] getDataStreams() {
        ArrayList<DataStream> list = new ArrayList<DataStream>();
        for (Stream stream : this.getStreams()) {
            if (!Global.equals((Object)stream.getType(), (Object)StreamType.Application)) continue;
            list.add((DataStream)stream);
        }
        return list.toArray(new DataStream[0]);
    }

    public static DtlsCertificate getDefaultLocalDtlsCertificate() {
        Object[] defaultLocalDtlsCertificates = Connection.getDefaultLocalDtlsCertificates();
        if (defaultLocalDtlsCertificates != null && ArrayExtensions.getLength(defaultLocalDtlsCertificates) > 0) {
            return Connection.getDefaultLocalDtlsCertificates()[0];
        }
        return null;
    }

    public static DtlsCertificate[] getDefaultLocalDtlsCertificates() {
        return _defaultLocalDtlsCertificates;
    }

    public DtlsCipherSuite[] getDtlsCipherSuites() {
        return this.__cipherSuites;
    }

    public DtlsProtocolVersion getDtlsClientVersion() {
        return this.__dtlsClientVersion;
    }

    public DtlsProtocolVersion getDtlsServerMaxVersion() {
        return this.__dtlsServerMaxVersion;
    }

    public DtlsProtocolVersion getDtlsServerMinVersion() {
        return this.__dtlsServerMinVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IceGatheringState getGatheringState() {
        Object object = this._connectionLock;
        synchronized (object) {
            return this.__gatheringState;
        }
    }

    public AddressType[] getIceAddressTypes() {
        return this._iceAddressTypes;
    }

    @Override
    public IceConnectionState getIceConnectionState() {
        return this.__iceConnectionState;
    }

    private IceGatherOptions getIceGatherOptions() {
        IceGatherOptions options2 = new IceGatherOptions(super.getIceGatherPolicy(), super.getIceServers(), this.getIcePortRange(), this.getIceAddressTypes(), this.getStunRequestTimeout(), this.getTcpConnectTimeout(), this.getTurnAllocateRequestLimit(), this.getStunBindingRequestLimit());
        options2.setPublicIPAddresses(this.getPublicIPAddresses());
        options2.setPrivateIPAddresses(this.getPrivateIPAddresses());
        options2.setCreateDatagramSocket(this.getCreateDatagramSocket());
        options2.setCreateStreamSocket(this.getCreateStreamSocket());
        return options2;
    }

    public IcePolicy getIcePolicy() {
        return this.__icePolicy;
    }

    public IcePortRange getIcePortRange() {
        return this._icePortRange;
    }

    public IceRole getIceRole() {
        return this._iceRole;
    }

    private IceTransportOptions getIceTransportOptions() {
        return new IceTransportOptions(IceKeepAlivePolicy.All, super.getDeadStreamTimeout(), this.getKeepAliveInterval());
    }

    @Override
    protected Connection getInstance() {
        return this;
    }

    public int getKeepAliveInterval() {
        return this.__keepAliveInterval;
    }

    @Override
    public SessionDescription getLocalDescription() {
        return this.__localDescription;
    }

    public DtlsCertificate getLocalDtlsCertificate() {
        Object[] localDtlsCertificates = this.getLocalDtlsCertificates();
        if (ArrayExtensions.getLength(localDtlsCertificates) == 0) {
            return null;
        }
        return localDtlsCertificates[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DtlsCertificate[] getLocalDtlsCertificates() {
        Object object = this.__dtlsCertificatesLock;
        synchronized (object) {
            if (this.__localDtlsCertificates == null) {
                if (Log.getIsInfoEnabled()) {
                    Log.info(StringExtensions.format("Generating {0} certificate for connection {1}...", StringExtensions.toUpper(DtlsCertificate.getDefaultKeyType().toString()), super.getId()));
                }
                Date utcNow = DateExtensions.getUtcNow();
                this.__localDtlsCertificates = new DtlsCertificate[]{DtlsCertificate.generateCertificate()};
                if (Log.getIsInfoEnabled()) {
                    int num = (int)((DateExtensions.getTicks(DateExtensions.getUtcNow()) - DateExtensions.getTicks(utcNow)) / (long)Constants.getTicksPerMillisecond());
                    Log.info(StringExtensions.format("{0} certificate generated in {1}ms for connection {2}.", StringExtensions.toUpper(DtlsCertificate.getDefaultKeyType().toString()), IntegerExtensions.toString(num), super.getId()));
                }
            }
            for (int i = 0; i < ArrayExtensions.getLength(this.__localDtlsCertificates); ++i) {
                if (!this.__localDtlsCertificates[i].getIsExpiring() || !this.__localDtlsCertificates[i].getAutoRegenerate()) continue;
                this.__localDtlsCertificates[i].regenerate();
            }
            return this.__localDtlsCertificates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DtlsFingerprint[] getLocalDtlsFingerprints() {
        Object object = this.__localDtlsFingerprintLock;
        synchronized (object) {
            if (this.__localDtlsFingerprints == null) {
                Object[] localDtlsCertificates = this.getLocalDtlsCertificates();
                String algorithm = Fingerprint.getSha256Algorithm();
                if (localDtlsCertificates != null && ArrayExtensions.getLength(localDtlsCertificates) > 0) {
                    this.__localDtlsFingerprints = new DtlsFingerprint[ArrayExtensions.getLength(localDtlsCertificates)];
                    for (int i = 0; i < ArrayExtensions.getLength(localDtlsCertificates); ++i) {
                        this.__localDtlsFingerprints[i] = (DtlsFingerprint)((Certificate)localDtlsCertificates[i]).calculateFingerprint(algorithm);
                    }
                }
            }
            return this.__localDtlsFingerprints;
        }
    }

    public MultiplexPolicy getMultiplexPolicy() {
        return this._multiplexPolicy;
    }

    public String getPrivateIPAddress() {
        Object[] privateIPAddresses = this.getPrivateIPAddresses();
        if (privateIPAddresses != null && ArrayExtensions.getLength(privateIPAddresses) > 0) {
            return privateIPAddresses[0];
        }
        return null;
    }

    public String[] getPrivateIPAddresses() {
        return this._privateIPAddresses;
    }

    public String getPublicIPAddress() {
        Object[] publicIPAddresses = this.getPublicIPAddresses();
        if (publicIPAddresses != null && ArrayExtensions.getLength(publicIPAddresses) > 0) {
            return publicIPAddresses[0];
        }
        return null;
    }

    public String[] getPublicIPAddresses() {
        return this._publicIPAddresses;
    }

    @Override
    public SessionDescription getRemoteDescription() {
        return this.__remoteDescription;
    }

    @Override
    public ConnectionState getState() {
        return super.getState();
    }

    @Override
    public Future<ConnectionStats> getStats() {
        Promise<ConnectionStats> promise = new Promise<ConnectionStats>();
        try {
            ConnectionStats stats2 = new ConnectionStats();
            stats2.setId(super.getId());
            stats2.setTimestamp(DateExtensions.getUtcNow());
            ConnectionStats result = stats2;
            ArrayList<MediaStreamStats> list = new ArrayList<MediaStreamStats>();
            for (Stream stream : this.getStreams()) {
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                    list.add(((AudioStream)stream).getStats());
                    continue;
                }
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                    list.add(((VideoStream)stream).getStats());
                    continue;
                }
                result.setDataStream(((DataStream)stream).getStats());
            }
            result.setMediaStreams(list.toArray(new MediaStreamStats[0]));
            promise.resolve(result);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public <TStream extends Stream> TStream getStreamByType(StreamType type) {
        return (TStream)this.__streams.getByType(type);
    }

    public Stream[] getStreams() {
        return (Stream[])this.__streams.getValues();
    }

    public <TStream extends Stream> ArrayList<TStream> getStreamsByType(StreamType type) {
        return this.__streams.getManyByType(type);
    }

    public int getStunBindingRequestLimit() {
        return this._stunBindingRequestLimit;
    }

    public int getStunRequestTimeout() {
        return this._stunRequestTimeout;
    }

    public int getTcpConnectTimeout() {
        return this._tcpConnectTimeout;
    }

    public int getTurnAllocateRequestLimit() {
        return this._turnAllocateRequestLimit;
    }

    public VideoStream[] getVideoStreams() {
        ArrayList<VideoStream> list = new ArrayList<VideoStream>();
        for (Stream stream : this.getStreams()) {
            if (!Global.equals((Object)stream.getType(), (Object)StreamType.Video)) continue;
            list.add((VideoStream)stream);
        }
        return list.toArray(new VideoStream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialiseInternalTransports() {
        Object object = this._connectionLock;
        synchronized (object) {
            Error error = null;
            error = this.buildStreamTransports();
            if (error != null && !Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Closing)) {
                Log.error(StringExtensions.format("Connection: internal transports could not be initialised: {0}", error.getDescription()));
                super.setError(error);
                this.setState(ConnectionState.Failing);
                this.setState(ConnectionState.Failed);
                return false;
            }
            for (CoreTransport transport : this.__primaryCoreTransports) {
                error = this.commenceGathering(transport);
                if (error == null || Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Closing)) continue;
                Log.error(StringExtensions.format("Cannot start gathering: {0}", error.getDescription()));
                super.setError(error);
                this.setState(ConnectionState.Failing);
                this.setState(ConnectionState.Failed);
                return false;
            }
            return true;
        }
    }

    private void initialize(Stream[] streams) {
        License.checkKey();
        this.__scheduler = new Scheduler(this._connectionLock);
        this.setBundlePolicy(BundlePolicy.MaxCompatibility);
        this.setMultiplexPolicy(MultiplexPolicy.Required);
        this.setGatheringState(IceGatheringState.New);
        super.setSignallingState(SignallingState.New);
        this.setIcePortRange(new IcePortRange());
        this.setIceAddressTypes(new AddressType[]{AddressType.IPv4, AddressType.IPv6});
        this.setTcpConnectTimeout(1000);
        this.setTurnAllocateRequestLimit(5);
        this.setStunBindingRequestLimit(5);
        this.setStunRequestTimeout(2000);
        this.setIceRole(IceRole.Controlling);
        byte[] buffer = new byte[8];
        LockedRandomizer.nextBytes(buffer);
        this.__iceTieBreaker = Binary.fromBytes64(buffer, 0, false);
        int count = this.__streams.getCount();
        for (Stream stream : streams) {
            stream.setIndex(count++);
            stream.setCanonicalName(super.getId());
            if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                AudioStream stream2 = (AudioStream)stream;
                stream2.removeOnBandwidthAdaptationPolicyStateChange((IAction1<Stream>)new IActionDelegate1<Stream>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processBandwidthAdaptationPolicyStateChanged";
                    }

                    @Override
                    public void invoke(Stream stream) {
                        Connection.this.processBandwidthAdaptationPolicyStateChanged(stream);
                    }
                });
                stream2.addOnBandwidthAdaptationPolicyStateChange((IAction1<Stream>)new IActionDelegate1<Stream>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processBandwidthAdaptationPolicyStateChanged";
                    }

                    @Override
                    public void invoke(Stream stream) {
                        Connection.this.processBandwidthAdaptationPolicyStateChanged(stream);
                    }
                });
                continue;
            }
            if (!Global.equals((Object)stream.getType(), (Object)StreamType.Video)) continue;
            VideoStream stream3 = (VideoStream)stream;
            stream3.removeOnBandwidthAdaptationPolicyStateChange((IAction1<Stream>)new IActionDelegate1<Stream>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processBandwidthAdaptationPolicyStateChanged";
                }

                @Override
                public void invoke(Stream stream) {
                    Connection.this.processBandwidthAdaptationPolicyStateChanged(stream);
                }
            });
            stream3.addOnBandwidthAdaptationPolicyStateChange((IAction1<Stream>)new IActionDelegate1<Stream>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processBandwidthAdaptationPolicyStateChanged";
                }

                @Override
                public void invoke(Stream stream) {
                    Connection.this.processBandwidthAdaptationPolicyStateChanged(stream);
                }
            });
        }
        this.__streams.addMany(streams);
    }

    private void logIceTransportRtt(IceTransport iceTransport, StreamType type, boolean primary) {
        if (iceTransport != null) {
            String str3;
            String str2;
            int smoothedRoundTripTime = iceTransport.getSmoothedRoundTripTime();
            String id = iceTransport.getId();
            String string = str2 = primary ? "primary" : "secondary";
            String string2 = Global.equals((Object)type, (Object)StreamType.Audio) ? "Audio" : (Global.equals((Object)type, (Object)StreamType.Application) ? "Data" : (str3 = Global.equals((Object)type, (Object)StreamType.Video) ? "Video" : "Undefined"));
            if (smoothedRoundTripTime != -1) {
                Log.debug(StringExtensions.format("Round Trip Time on the {3} IceTransport {0} for {2} stream is {1} ms.", new Object[]{id, IntegerExtensions.toString(smoothedRoundTripTime), str3, str2}));
                int smoothedRelayServerRoundTripTime = iceTransport.getSmoothedRelayServerRoundTripTime();
                if (smoothedRelayServerRoundTripTime != -1) {
                    Log.debug(StringExtensions.format("Round Trip Time to the relay server on the {3} IceTransport {0} for {2} stream is {1} ms.", new Object[]{id, IntegerExtensions.toString(smoothedRelayServerRoundTripTime), str3, str2}));
                }
            }
        }
    }

    private void logRTT(ScheduledItem item) {
        Stream[] values;
        for (Stream stream : values = (Stream[])this.__streams.getValues()) {
            CoreTransport coreTransportRtcp;
            CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
            if (coreTransportRtp != null) {
                this.logIceTransportRtt(coreTransportRtp.getIceTransport(), stream.getType(), true);
            }
            if ((coreTransportRtcp = stream.getCoreTransportRtcp()) == null) continue;
            this.logIceTransportRtt(coreTransportRtcp.getIceTransport(), stream.getType(), false);
        }
    }

    private boolean prepareTransports() {
        return this.initialiseInternalTransports();
    }

    private void processActiveCandidatePairChange(IceTransport transport, IceCandidatePair p) {
    }

    private void processAndSetDescription(SessionDescription description, boolean isLocalDescription, Promise<SessionDescription> promise) {
        Error error = super.processDescription(description, isLocalDescription);
        if (error != null) {
            this.shutdownOnFailure(error, TransportType.Unset, null);
            if (error.getException() != null) {
                throw new RuntimeException(error.getException());
            }
            throw new RuntimeException(new Exception(error.toString()));
        }
        this.verifyDtlsStillNeeded();
        if (isLocalDescription) {
            this.setDescription(description, true);
            if (description.getIsOffer()) {
                super.setSignallingState(SignallingState.HaveLocalOffer);
            } else {
                super.setSignallingState(SignallingState.Stable);
                this._originalSignallingExchangeComplete = true;
            }
        } else {
            this.setDescription(description, false);
            if (description.getIsOffer()) {
                super.setSignallingState(SignallingState.HaveRemoteOffer);
            } else {
                super.setSignallingState(SignallingState.Stable);
                this._originalSignallingExchangeComplete = true;
            }
        }
        promise.resolve(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBandwidthAdaptationPolicyStateChanged(Stream stream) {
        Object object = this._connectionLock;
        synchronized (object) {
            boolean flag;
            boolean bl = flag = Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing);
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Connected) || flag) {
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                    boolean flag2;
                    VideoStream stream2 = (VideoStream)stream;
                    RtpTransport rtpTransport = stream2.getRtpTransport();
                    boolean bl2 = flag2 = Global.equals((Object)stream2.getBandwidthAdaptationPolicy(), (Object)BandwidthAdaptationPolicy.Enabled) && !flag;
                    if (rtpTransport != null && flag2) {
                        ScheduledItem processBandwidthStatsSI;
                        if (stream2.getRembEnabled()) {
                            processBandwidthStatsSI = rtpTransport._dispatchRembSI;
                            this.__scheduler.add(processBandwidthStatsSI);
                        }
                        processBandwidthStatsSI = rtpTransport._processBandwidthStatsSI;
                        this.__scheduler.add(processBandwidthStatsSI);
                        processBandwidthStatsSI = rtpTransport._startCollectingBWStatsSI;
                        this.__scheduler.add(processBandwidthStatsSI);
                    } else if (rtpTransport != null) {
                        ScheduledItem processBandwidthStatsSI = rtpTransport._dispatchRembSI;
                        this.__scheduler.remove(processBandwidthStatsSI);
                        processBandwidthStatsSI = rtpTransport._processBandwidthStatsSI;
                        this.__scheduler.remove(processBandwidthStatsSI);
                        processBandwidthStatsSI = rtpTransport._startCollectingBWStatsSI;
                        this.__scheduler.remove(processBandwidthStatsSI);
                    }
                } else if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                    boolean flag2;
                    AudioStream stream3 = (AudioStream)stream;
                    RtpTransport transport2 = stream3.getRtpTransport();
                    boolean bl3 = flag2 = Global.equals((Object)stream3.getBandwidthAdaptationPolicy(), (Object)BandwidthAdaptationPolicy.Enabled) && !flag;
                    if (transport2 != null && flag2) {
                        ScheduledItem processBandwidthStatsSI = transport2._processBandwidthStatsSI;
                        this.__scheduler.add(processBandwidthStatsSI);
                        processBandwidthStatsSI = transport2._startCollectingBWStatsSI;
                        this.__scheduler.add(processBandwidthStatsSI);
                    } else if (transport2 != null) {
                        ScheduledItem processBandwidthStatsSI = transport2._processBandwidthStatsSI;
                        this.__scheduler.remove(processBandwidthStatsSI);
                        processBandwidthStatsSI = transport2._startCollectingBWStatsSI;
                        this.__scheduler.remove(processBandwidthStatsSI);
                    }
                }
            }
        }
    }

    private void processDtlsTransportDown(DtlsTransport transport) {
        transport.removeOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processDtlsTransportStateChange";
            }

            @Override
            public void invoke(DtlsTransport transport) {
                Connection.this.processDtlsTransportStateChange(transport);
            }
        });
        HashMapExtensions.remove(this.__streamsForDtlsTransport, transport.getId());
        try {
            IceTransport iceTransport = null;
            CoreTransport transport3 = null;
            Holder<Object> _var0 = new Holder<Object>(transport3);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__coreTransportForDtlsTransport, transport.getId(), _var0);
            transport3 = _var0.getValue();
            if (_var1) {
                HashMapExtensions.remove(this.__coreTransportForDtlsTransport, transport.getId());
                if (transport3 != null) {
                    iceTransport = transport3.getIceTransport();
                }
            }
            if (iceTransport != null) {
                Log.debug(StringExtensions.format("Shutting down Ice Transport {0} for connection {1}.", iceTransport.getId(), super.getId()));
                iceTransport.stop();
            }
        }
        catch (Exception exception) {
            Log.debug(StringExtensions.format("No Ice transport found for a core transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.DtlsTransport, transport.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDtlsTransportStateChange(DtlsTransport transport) {
        Object object = this._connectionLock;
        synchronized (object) {
            DtlsTransportState state = transport.getState();
            if (Global.equals((Object)state, (Object)DtlsTransportState.Connected)) {
                if (!super.getIsInTerminatingOrTerminatedState()) {
                    ArrayList list = null;
                    Holder<Object> _var0 = new Holder<Object>(list);
                    boolean _var1 = HashMapExtensions.tryGetValue(this.__streamsForDtlsTransport, transport.getId(), _var0);
                    list = _var0.getValue();
                    if (_var1) {
                        Log.debug(StringExtensions.format("Dtls transport {0} connected. Starting remaining transports on associated streams.", transport.getId()));
                        for (Stream stream : list) {
                            Error error;
                            if (Global.equals((Object)stream.getType(), (Object)StreamType.Application)) {
                                SctpTransport sctpTransport = ((DataStream)stream).getSctpTransport();
                                if (sctpTransport == null) {
                                    error = new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("Data stream does not have Sctp Transport assigned."));
                                    this.shutdownOnFailure(error, TransportType.DtlsTransport, transport.getId());
                                    continue;
                                }
                                sctpTransport.start();
                                continue;
                            }
                            if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio) || Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                                DtlsTransport transport6;
                                CoreTransport coreTransportRtcp = stream.getCoreTransportRtcp();
                                CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
                                DtlsTransport transport5 = coreTransportRtp == null ? null : coreTransportRtp.getDtlsTransport();
                                DtlsTransport dtlsTransport = transport6 = coreTransportRtcp == null ? null : coreTransportRtcp.getDtlsTransport();
                                if (stream.getCoreTransportRtcp() != null && (transport5 == null || !Global.equals((Object)transport5.getState(), (Object)DtlsTransportState.Connected) || transport6 == null || !Global.equals((Object)transport6.getState(), (Object)DtlsTransportState.Connected))) continue;
                                int selectedSrtpProtectionProfile = transport5.getSelectedSrtpProtectionProfile();
                                DataBuffer localKey = transport5.getLocalKey();
                                DataBuffer remoteKey = transport5.getRemoteKey();
                                DataBuffer localSalt = transport5.getLocalSalt();
                                DataBuffer remoteSalt = transport5.getRemoteSalt();
                                this.startRtpTransport(stream, selectedSrtpProtectionProfile, localKey, localSalt, remoteKey, remoteSalt);
                                continue;
                            }
                            error = new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("Unsupported data stream type {0}.", stream.getType().toString())));
                            this.shutdownOnFailure(error, TransportType.DtlsTransport, transport.getId());
                        }
                    }
                }
            } else if (Global.equals((Object)state, (Object)DtlsTransportState.Failed) || Global.equals((Object)state, (Object)DtlsTransportState.Closed)) {
                if (!super.getIsInTerminatingOrTerminatedState()) {
                    if (transport.getClosingShouldNotTriggerGlobalNonGracefulShutdown()) {
                        Log.debug(StringExtensions.format("DTLS transport {0} shut down expectedly. Proceeding with Ice Transport shutdown.", transport.getId()));
                        HashMapExtensions.remove(this.__dtlsTransports, transport.getId());
                        this.processDtlsTransportDown(transport);
                    } else {
                        Error error = null;
                        if (Global.equals((Object)state, (Object)DtlsTransportState.Failed)) {
                            error = transport.getError();
                            Log.error(StringExtensions.format("{0}. Connection {1} will shut down.", error.getDescription(), super.getId()));
                        } else {
                            String message = "Dtls Transport shut down unexpectedly. Connection will shut down.";
                            error = new Error(ErrorCode.ConnectionTransportClosed, new Exception(message));
                        }
                        this.shutdownOnFailure(error, TransportType.DtlsTransport, transport.getId());
                    }
                } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) {
                    DtlsTransportState _var2 = state;
                    if (_var2 == DtlsTransportState.Closed || _var2 == DtlsTransportState.Failed) {
                        this.processDtlsTransportDown(transport);
                    }
                } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
                    Log.debug(StringExtensions.format("Dtls transport reports being in {1} state, but Connection {0} is already closed.", super.getId(), state.toString()));
                    transport.removeOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processDtlsTransportStateChange";
                        }

                        @Override
                        public void invoke(DtlsTransport transport) {
                            Connection.this.processDtlsTransportStateChange(transport);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGathererStateChange(IceGatherer gatherer) {
        Object object = this._connectionLock;
        synchronized (object) {
            IceGatheringState state;
            IceGatheringState iceGatheringState = state = gatherer != null ? gatherer.getState() : IceGatheringState.Failed;
            if (Global.equals((Object)state, (Object)IceGatheringState.Failed) || Global.equals((Object)state, (Object)IceGatheringState.Closing) || Global.equals((Object)state, (Object)IceGatheringState.Closed)) {
                if (!(Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) || gatherer.getClosingShouldNotTriggerGlobalNonGracefulShutdown())) {
                    String message = "";
                    if (Global.equals((Object)state, (Object)IceGatheringState.Failed)) {
                        Log.error(StringExtensions.format("Connection {0}: Gatherer {1} error {2}", super.getId(), gatherer.getId(), gatherer.getError() != null ? gatherer.getError().getDescription() : "Generic gatherer error."));
                    } else {
                        message = StringExtensions.format("Connection {0}: Gatherer {1} shut down unexpectedly. Connection will shut down.", super.getId(), gatherer.getId());
                        Error error = new Error(ErrorCode.ConnectionTransportClosed, new Exception(message));
                        this.shutdownOnFailure(error, TransportType.Gatherer, gatherer.getId());
                    }
                } else if (gatherer.getClosingShouldNotTriggerGlobalNonGracefulShutdown()) {
                    IceGatheringState _var0 = state;
                    if (_var0 == IceGatheringState.Closed || _var0 == IceGatheringState.Failed) {
                        HashMapExtensions.remove(this.__gatherers, gatherer.getId());
                        gatherer.removeOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processGathererStateChange";
                            }

                            @Override
                            public void invoke(IceGatherer gatherer) {
                                Connection.this.processGathererStateChange(gatherer);
                            }
                        });
                        gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processNewLocalCandidate";
                            }

                            @Override
                            public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                                Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                            }
                        });
                        Log.debug(StringExtensions.format("Gatherer {0} shut down gracefully.", gatherer.getId()));
                    }
                } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) {
                    if (Global.equals((Object)state, (Object)IceGatheringState.Closed)) {
                        Log.debug(StringExtensions.format("Gatherer {0} shut down gracefully.", gatherer.getId()));
                        this.__verifyGatherersDownScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.verifyGatherersDown";
                            }

                            @Override
                            public void invoke(ScheduledItem item) {
                                Connection.this.verifyGatherersDown(item);
                            }
                        }, 1, ScheduledItem.getUnset(), ScheduledItem.getUnset(), 1);
                        this.__scheduler.add(this.__verifyGatherersDownScheduledItem);
                    }
                } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
                    Log.debug(StringExtensions.format("Gatherer reports being in {1} state, but Connection {0} is already closed.", super.getId(), state.toString()));
                    gatherer.removeOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processGathererStateChange";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer) {
                            Connection.this.processGathererStateChange(gatherer);
                        }
                    });
                    gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processNewLocalCandidate";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                            Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                        }
                    });
                }
                this.updateConnectionGatheringState();
            } else if (Global.equals((Object)state, (Object)IceGatheringState.Gathering)) {
                IceGatherer relatedRtcpGatherer = gatherer.getRelatedRtcpGatherer();
                if (relatedRtcpGatherer != null) {
                    relatedRtcpGatherer.start();
                }
                this.updateConnectionGatheringState();
            } else {
                this.updateConnectionGatheringState();
            }
        }
    }

    private void processIceTransportDown(IceTransport transport) {
        Log.debug(StringExtensions.format("IceTransport {0} shut down gracefully.", transport.getId()));
        transport.removeOnStateChange((IAction1<IceTransport>)new IActionDelegate1<IceTransport>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processIceTransportStateChange";
            }

            @Override
            public void invoke(IceTransport transport) {
                Connection.this.processIceTransportStateChange(transport);
            }
        });
        transport.removeOnActiveCandidatePairChange((IAction2<IceTransport, IceCandidatePair>)new IActionDelegate2<IceTransport, IceCandidatePair>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processActiveCandidatePairChange";
            }

            @Override
            public void invoke(IceTransport transport, IceCandidatePair p) {
                Connection.this.processActiveCandidatePairChange(transport, p);
            }
        });
        try {
            HashMapExtensions.remove(this.__streamsForIceTransport, transport.getId());
            CoreTransport transport2 = null;
            Holder<Object> _var0 = new Holder<Object>(transport2);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__coreTransportForIceTransport, transport.getId(), _var0);
            transport2 = _var0.getValue();
            if (_var1) {
                HashMapExtensions.remove(this.__coreTransportForIceTransport, transport.getId());
                if (transport2 != null) {
                    IceGatherer gatherer = transport2.getGatherer();
                    this.removeFromDictionaryList(this.__coreTransportsForGatherer, gatherer.getId(), transport2);
                    this.stopGatherer(gatherer);
                }
            } else {
                this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("No Gatherer transport found for Core Transport while shutting down. Will attempt to close all remaining inner transports.")), TransportType.IceTransport, transport.getId());
            }
        }
        catch (Exception exception) {
            Log.debug(StringExtensions.format("No Gatherer transport found for Core Transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.IceTransport, transport.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIceTransportStateChange(IceTransport transport) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (this._verboseDebugMessages) {
                Log.debug(StringExtensions.format("Ice transport {0} state change to {1}", transport.getId(), transport.getState().toString()));
            }
            IceTransportState state = transport.getState();
            this.updateIceConnectionsState();
            IceTransportState _var0 = state;
            if (_var0 == IceTransportState.Connected) {
                if (transport.getDynamicValue("fm.icelink.IceTransportAlreadyConnected") == null) {
                    transport.setDynamicValue("fm.icelink.IceTransportAlreadyConnected", new Object());
                    this.doProcessIceTransportConnected(transport);
                } else {
                    Log.debug(StringExtensions.format("Connectivity is now available with peer for connection {0}.", super.getId()));
                }
            } else if (_var0 == IceTransportState.Disconnected) {
                this.doProcessIceTransportDisconnected(transport);
            } else if (_var0 == IceTransportState.Closed) {
                this.doProcessIceTransportClosed(transport);
            } else if (_var0 == IceTransportState.Failed) {
                this.shutdownOnFailure(transport.getError(), TransportType.IceTransport, transport.getId());
            }
        }
    }

    private void processMediaTransportDown(IMediaTransport transport) {
        transport.removeOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processMediaTransportStateChange";
            }

            @Override
            public void invoke(IMediaTransport transport) {
                Connection.this.processMediaTransportStateChange(transport);
            }
        });
        try {
            Stream stream = null;
            if (transport instanceof SrtpAudioTransport || transport instanceof RtpAudioTransport) {
                if (this.__streamForAudioTransport.containsKey(transport.getId())) {
                    stream = HashMapExtensions.getItem(this.__streamForAudioTransport).get(transport.getId());
                    HashMapExtensions.remove(this.__streamForAudioTransport, transport.getId());
                    AudioStream stream2 = (AudioStream)stream;
                    RtpTransport rtpTransport = stream2.getRtpTransport();
                    if (rtpTransport != null) {
                        final AudioStream _var0 = stream2;
                        rtpTransport.removeOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.MediaStream<fm.icelink.IAudioOutput,fm.icelink.IAudioOutputCollection,fm.icelink.IAudioInput,fm.icelink.IAudioInputCollection,fm.icelink.AudioFrame,fm.icelink.AudioBuffer,fm.icelink.AudioBufferCollection,fm.icelink.AudioFormat,fm.icelink.AudioFormatCollection>.receiveControlFrames";
                            }

                            @Override
                            public void invoke(MediaControlFrame[] controlFrames) {
                                _var0.receiveControlFrames(controlFrames);
                            }
                        });
                        final AudioStream _var1 = stream2;
                        rtpTransport.removeOnReceiveFrame(new IActionDelegate1<AudioFrame>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.MediaStream<fm.icelink.IAudioOutput,fm.icelink.IAudioOutputCollection,fm.icelink.IAudioInput,fm.icelink.IAudioInputCollection,fm.icelink.AudioFrame,fm.icelink.AudioBuffer,fm.icelink.AudioBufferCollection,fm.icelink.AudioFormat,fm.icelink.AudioFormatCollection>.receiveFrame";
                            }

                            @Override
                            public void invoke(AudioFrame frame) {
                                _var1.receiveFrame(frame);
                            }
                        });
                    }
                }
            } else if ((transport instanceof SrtpVideoTransport || transport instanceof RtpVideoTransport) && this.__streamForVideoTransport.containsKey(transport.getId())) {
                stream = HashMapExtensions.getItem(this.__streamForVideoTransport).get(transport.getId());
                HashMapExtensions.remove(this.__streamForVideoTransport, transport.getId());
                VideoStream stream3 = (VideoStream)stream;
                RtpTransport transport3 = stream3.getRtpTransport();
                if (transport3 != null) {
                    final VideoStream _var2 = stream3;
                    transport3.removeOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.MediaStream<fm.icelink.IVideoOutput,fm.icelink.IVideoOutputCollection,fm.icelink.IVideoInput,fm.icelink.IVideoInputCollection,fm.icelink.VideoFrame,fm.icelink.VideoBuffer,fm.icelink.VideoBufferCollection,fm.icelink.VideoFormat,fm.icelink.VideoFormatCollection>.receiveControlFrames";
                        }

                        @Override
                        public void invoke(MediaControlFrame[] controlFrames) {
                            _var2.receiveControlFrames(controlFrames);
                        }
                    });
                    final VideoStream _var3 = stream3;
                    transport3.removeOnReceiveFrame(new IActionDelegate1<VideoFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.MediaStream<fm.icelink.IVideoOutput,fm.icelink.IVideoOutputCollection,fm.icelink.IVideoInput,fm.icelink.IVideoInputCollection,fm.icelink.VideoFrame,fm.icelink.VideoBuffer,fm.icelink.VideoBufferCollection,fm.icelink.VideoFormat,fm.icelink.VideoFormatCollection>.receiveFrame";
                        }

                        @Override
                        public void invoke(VideoFrame frame) {
                            _var3.receiveFrame(frame);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("No Dtls transport found for Reliable Data Transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.SctpTransport, transport.getId());
        }
    }

    private void processMediaTransportStateChange(IMediaTransport transport) {
        this.doProcessMediaTransportStateChange(transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewLocalCandidate(IceGatherer gatherer, IceCandidate iceCandidate) {
        boolean flag = false;
        ArrayList<Candidate> collection = new ArrayList<Candidate>();
        Object object = this._connectionLock;
        synchronized (object) {
            if (!(Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) || Global.equals((Object)this.getState(), (Object)ConnectionState.New))) {
                ArrayList list2 = null;
                Holder<Object> _var0 = new Holder<Object>(list2);
                boolean _var1 = HashMapExtensions.tryGetValue(this.__coreTransportsForGatherer, gatherer.getId(), _var0);
                list2 = _var0.getValue();
                if (_var1) {
                    for (CoreTransport transport : list2) {
                        IceTransport iceTransport = transport.getIceTransport();
                        ArrayList list3 = null;
                        Holder<Object> _var2 = new Holder<Object>(list3);
                        boolean _var3 = HashMapExtensions.tryGetValue(this.__streamsForIceTransport, iceTransport.getId(), _var2);
                        list3 = _var2.getValue();
                        if (!_var3) continue;
                        int componentId = Global.equals((Object)transport.getIceTransport().getComponent(), (Object)IceComponent.Rtp) ? 1 : 2;
                        for (Stream stream : list3) {
                            Candidate item = iceCandidate.toCandidate(componentId, stream.getIndex());
                            item.setDispatched(false);
                            collection.add(item);
                            stream.addLocalCandidate(item);
                        }
                    }
                }
                if ((Global.equals((Object)this.getState(), (Object)ConnectionState.Connected) || Global.equals((Object)this.getState(), (Object)ConnectionState.Connecting)) && super.getUseTrickleIce()) {
                    flag = true;
                } else {
                    ArrayListExtensions.addRange(this.__cachedLocalCandidates, collection);
                }
            }
            if (flag) {
                for (Candidate candidate : collection) {
                    super.raiseLocalCandidate(candidate);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOnNewDataChannel(DataChannel channel) {
        Object object = this._connectionLock;
        synchronized (object) {
            channel.removeOnStateChange(new IActionDelegate1<DataChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processReliableDataChannelStateChange";
                }

                @Override
                public void invoke(DataChannel channel) {
                    Connection.this.processReliableDataChannelStateChange(channel);
                }
            });
            channel.addOnStateChange(new IActionDelegate1<DataChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processReliableDataChannelStateChange";
                }

                @Override
                public void invoke(DataChannel channel) {
                    Connection.this.processReliableDataChannelStateChange(channel);
                }
            });
        }
    }

    private void processReliableDataChannelStateChange(DataChannel channel) {
        DataChannelState _var0;
        DataChannelState dataChannelState = _var0 = channel == null ? DataChannelState.Failed : channel.getState();
        if (_var0 == DataChannelState.Connected) {
            this.processTopTransportConnected();
        } else if (_var0 == DataChannelState.Closing) {
            channel.removeOnStateChange(new IActionDelegate1<DataChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processReliableDataChannelStateChange";
                }

                @Override
                public void invoke(DataChannel channel) {
                    Connection.this.processReliableDataChannelStateChange(channel);
                }
            });
        } else if (_var0 == DataChannelState.Closed) {
            channel.removeOnStateChange(new IActionDelegate1<DataChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processReliableDataChannelStateChange";
                }

                @Override
                public void invoke(DataChannel channel) {
                    Connection.this.processReliableDataChannelStateChange(channel);
                }
            });
        } else if (_var0 == DataChannelState.Failed) {
            channel.removeOnStateChange(new IActionDelegate1<DataChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.processReliableDataChannelStateChange";
                }

                @Override
                public void invoke(DataChannel channel) {
                    Connection.this.processReliableDataChannelStateChange(channel);
                }
            });
        }
    }

    private void processReliableDataTransportDown(ReliableTransport transport) {
        transport.removeOnStateChange((IAction1<ReliableTransport>)new IActionDelegate1<ReliableTransport>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processReliableDataTransportStateChange";
            }

            @Override
            public void invoke(ReliableTransport transport) {
                Connection.this.processReliableDataTransportStateChange(transport);
            }
        });
        try {
            DataStream stream = HashMapExtensions.getItem(this.__streamForReliableDataTransport).get(transport.getId());
            HashMapExtensions.remove(this.__streamForReliableDataTransport, transport.getId());
            stream.getSctpTransport().stop();
        }
        catch (Exception exception) {
            Log.debug(StringExtensions.format("No Sctp transport found for Reliable Data Transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.ReliableDataTransport, transport.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReliableDataTransportStateChange(ReliableTransport transport) {
        ReliableTransportState state = transport.getState();
        Object object = this._connectionLock;
        synchronized (object) {
            if (!(Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) || Global.equals((Object)state, (Object)ReliableTransportState.New) || Global.equals((Object)state, (Object)ReliableTransportState.Opening) || Global.equals((Object)state, (Object)ReliableTransportState.Connected) || !Global.equals((Object)state, (Object)ReliableTransportState.Failed) && !Global.equals((Object)state, (Object)ReliableTransportState.Closing) && !Global.equals((Object)state, (Object)ReliableTransportState.Closed))) {
                if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Closed)) {
                    Error error = null;
                    if (Global.equals((Object)state, (Object)ReliableTransportState.Failed)) {
                        error = transport.getError();
                        if (error != null) {
                            Log.error(StringExtensions.format("{0}. Connection {1} will shut down.", error.getDescription(), super.getId()));
                        } else {
                            Log.error(StringExtensions.format("Connection {0} will shut down.", super.getId()));
                        }
                    } else {
                        String message = "Reliable Transport shut down unexpectedly. Connection will shut down.";
                        error = new Error(ErrorCode.ConnectionTransportClosed, new Exception(message));
                    }
                    this.shutdownOnFailure(error, TransportType.ReliableDataTransport, transport.getId());
                } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) {
                    if (Global.equals((Object)state, (Object)ReliableTransportState.Closed)) {
                        this.processReliableDataTransportDown(transport);
                    }
                } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
                    Log.debug(StringExtensions.format("ReliableData transport reports being in {1} state, but Connection {0} is already closed.", super.getId(), state.toString()));
                    transport.removeOnStateChange((IAction1<ReliableTransport>)new IActionDelegate1<ReliableTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processReliableDataTransportStateChange";
                        }

                        @Override
                        public void invoke(ReliableTransport transport) {
                            Connection.this.processReliableDataTransportStateChange(transport);
                        }
                    });
                }
            }
        }
    }

    private void processRtpListenerDown(SrtpListener listener) {
        listener.removeOnStateChange((IAction1<SrtpListener>)new IActionDelegate1<SrtpListener>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processSrtpListenerStateChange";
            }

            @Override
            public void invoke(SrtpListener transport) {
                Connection.this.processSrtpListenerStateChange(transport);
            }
        });
        try {
            Stream stream = null;
            if (this.__streamForVideoTransport.containsKey(listener.getId())) {
                stream = HashMapExtensions.getItem(this.__streamForVideoTransport).get(listener.getId());
                HashMapExtensions.remove(this.__streamForVideoTransport, listener.getId());
            } else if (this.__streamForAudioTransport.containsKey(listener.getId())) {
                stream = HashMapExtensions.getItem(this.__streamForAudioTransport).get(listener.getId());
                HashMapExtensions.remove(this.__streamForAudioTransport, listener.getId());
            }
            if (stream != null) {
                CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
                CoreTransport coreTransportRtcp = stream.getCoreTransportRtcp();
                if (coreTransportRtp != null) {
                    DtlsTransport dtlsTransport = coreTransportRtp.getDtlsTransport();
                    if (dtlsTransport != null) {
                        this.removeFromDictionaryList(this.__streamsForDtlsTransport, dtlsTransport.getId(), stream);
                    }
                    this.stopStreamCore(coreTransportRtp);
                    if (coreTransportRtcp != null) {
                        this.stopStreamCore(coreTransportRtcp);
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("No Dtls transport found for Reliable Data Transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.SctpTransport, listener.getId());
        }
    }

    private void processSctpTransportDown(SctpTransport transport) {
        transport.removeOnStateChange((IAction1<SctpTransport>)new IActionDelegate1<SctpTransport>(){

            @Override
            public String getId() {
                return "fm.icelink.Connection.processSctpTransportStateChange";
            }

            @Override
            public void invoke(SctpTransport transport) {
                Connection.this.processSctpTransportStateChange(transport);
            }
        });
        try {
            DataStream stream = HashMapExtensions.getItem(this.__streamForSctpTransport).get(transport.getId());
            HashMapExtensions.remove(this.__streamForSctpTransport, transport.getId());
            CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
            this.removeFromDictionaryList(this.__streamsForDtlsTransport, coreTransportRtp.getDtlsTransport().getId(), stream);
            this.stopStreamCore(coreTransportRtp);
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("No Dtls transport found for Reliable Data Transport while shutting down. Will attempt to close all remaining inner transports.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.SctpTransport, transport.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSctpTransportStateChange(SctpTransport transport) {
        SctpTransportState state = transport.getState();
        Object object = this._connectionLock;
        synchronized (object) {
            if (!(Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) || Global.equals((Object)state, (Object)SctpTransportState.New) || Global.equals((Object)state, (Object)SctpTransportState.Connecting))) {
                if (Global.equals((Object)state, (Object)SctpTransportState.Connected)) {
                    try {
                        DataStream stream = HashMapExtensions.getItem(this.__streamForSctpTransport).get(transport.getId());
                        ReliableTransport reliableDataTransport = stream.getReliableDataTransport();
                        DtlsRole role = stream.getLocalDtlsParameters().getRole();
                        reliableDataTransport.start(Global.equals((Object)role, (Object)DtlsRole.Server));
                    }
                    catch (Exception exception) {
                        Log.error(StringExtensions.format("Sctp Transport started but corresponding ReliableData transport cannot be found for the data stream on connection {0}.", super.getId()), exception);
                        Error error = new Error(ErrorCode.ConnectionInvalidArchitecture, exception);
                        this.shutdownOnFailure(error, TransportType.SctpTransport, transport.getId());
                    }
                } else if (!Global.equals((Object)state, (Object)SctpTransportState.Failing) && (Global.equals((Object)state, (Object)SctpTransportState.Failed) || Global.equals((Object)state, (Object)SctpTransportState.Closing) || Global.equals((Object)state, (Object)SctpTransportState.Closed))) {
                    if (!super.getIsInTerminatingOrTerminatedState()) {
                        Error error = null;
                        if (Global.equals((Object)state, (Object)SctpTransportState.Failed)) {
                            error = transport.getError();
                            Log.error(StringExtensions.format("{0}. Connection {1} will shut down.", error.getDescription(), super.getId()));
                        } else {
                            String message = "Sctp Transport shut down unexpectedly. Connection will shut down.";
                            error = new Error(ErrorCode.ConnectionTransportClosed, new Exception(message));
                        }
                        this.shutdownOnFailure(error, TransportType.SctpTransport, transport.getId());
                    } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) {
                        this.processSctpTransportDown(transport);
                    } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
                        Log.debug(StringExtensions.format("Sctp transport reports being in {1} state, but Connection {0} is already closed.", super.getId(), state.toString()));
                        transport.removeOnStateChange((IAction1<SctpTransport>)new IActionDelegate1<SctpTransport>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processSctpTransportStateChange";
                            }

                            @Override
                            public void invoke(SctpTransport transport) {
                                Connection.this.processSctpTransportStateChange(transport);
                            }
                        });
                    }
                }
            }
        }
    }

    private void processSctpTransportStateTransitionsAsTopTransport(SctpTransport transport) {
        if (Global.equals((Object)transport.getState(), (Object)SctpTransportState.Connected)) {
            this.processTopTransportConnected();
        }
    }

    @Override
    protected Error processSdpMediaDescription(Stream stream, MediaDescription sdpMediaDescription, int sdpMediaIndex, boolean isLocalDescription, boolean isRenegotiation) {
        boolean supportsRtcpMultiplexing = sdpMediaDescription.getSupportsRtcpMultiplexing();
        Attribute[] candidateAttributes = null;
        CandidateAttribute attribute = null;
        if (!isLocalDescription && (candidateAttributes = sdpMediaDescription.getCandidateAttributes()) != null) {
            for (Attribute attribute2 : candidateAttributes) {
                attribute = (CandidateAttribute)attribute2;
                Candidate remoteCandidate = new Candidate();
                remoteCandidate.setSdpMediaIndex(sdpMediaIndex);
                remoteCandidate.setSdpCandidateAttribute(attribute);
                super.addRemoteCandidate(remoteCandidate);
            }
        }
        if (isLocalDescription) {
            if (!supportsRtcpMultiplexing) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("Local Sdp media description must include Rtcp Multiplexing attribute."));
            }
        } else {
            if (!Global.equals((Object)stream.getType(), (Object)StreamType.Application) && !supportsRtcpMultiplexing && Global.equals((Object)this.getMultiplexPolicy(), (Object)MultiplexPolicy.Required)) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("Local policy requires Rtcp component multiplexing, but peer does not support it."));
            }
            if (!Global.equals((Object)stream.getType(), (Object)StreamType.Application) && supportsRtcpMultiplexing && Global.equals((Object)this.getMultiplexPolicy(), (Object)MultiplexPolicy.Negotiated)) {
                this.disableSecondaryComponent(stream, sdpMediaIndex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSrtpListenerStateChange(SrtpListener transport) {
        MediaTransportState state = transport == null ? MediaTransportState.Failed : transport.getState();
        Object object = this._connectionLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) || transport == null) {
                return;
            }
        }
        MediaTransportState _var0 = state;
        if (_var0 == MediaTransportState.New || _var0 == MediaTransportState.Starting || _var0 == MediaTransportState.Stopping) {
            return;
        }
        if (_var0 == MediaTransportState.Started) {
            this.processTopTransportConnected();
            return;
        }
        if (_var0 == MediaTransportState.Stopped) {
            this.processRtpListenerDown(transport);
            return;
        }
    }

    @Override
    void processStateChange() {
        block4: {
            block5: {
                block3: {
                    if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) break block3;
                    this.__scheduler.start();
                    ScheduledItem item = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.establishConnectionTimeout";
                        }

                        @Override
                        public void invoke(ScheduledItem item) {
                            Connection.this.establishConnectionTimeout(item);
                        }
                    }, super.getTimeout(), ScheduledItem.getUnset(), ScheduledItem.getUnset(), 1);
                    this.__scheduler.add(item);
                    break block4;
                }
                if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Connected) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) break block5;
                for (Stream stream : this.getStreams()) {
                    this.processBandwidthAdaptationPolicyStateChanged(stream);
                }
                break block4;
            }
            if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) break block4;
            for (Stream stream : this.getStreams()) {
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                    AudioStream stream2 = (AudioStream)stream;
                    stream2.removeOnBandwidthAdaptationPolicyStateChange((IAction1<Stream>)new IActionDelegate1<Stream>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processBandwidthAdaptationPolicyStateChanged";
                        }

                        @Override
                        public void invoke(Stream stream) {
                            Connection.this.processBandwidthAdaptationPolicyStateChanged(stream);
                        }
                    });
                    continue;
                }
                if (!Global.equals((Object)stream.getType(), (Object)StreamType.Video)) continue;
                VideoStream stream3 = (VideoStream)stream;
                stream3.removeOnBandwidthAdaptationPolicyStateChange((IAction1<Stream>)new IActionDelegate1<Stream>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processBandwidthAdaptationPolicyStateChanged";
                    }

                    @Override
                    public void invoke(Stream stream) {
                        Connection.this.processBandwidthAdaptationPolicyStateChanged(stream);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopTransportConnected() {
        Object object = this._connectionLock;
        synchronized (object) {
            for (Stream stream : this.getStreams()) {
                SrtpListener listener;
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Application) && !stream.getDisabled() && !Global.equals((Object)stream.getDirection(), (Object)StreamDirection.Inactive)) {
                    DataStream stream2 = (DataStream)stream;
                    Object[] channels = stream2.getChannels();
                    if (channels == null || ArrayExtensions.getLength(channels) == 0) {
                        DataChannel[] sctpTransport = stream2.getSctpTransport();
                        if (sctpTransport == null) {
                            return false;
                        }
                        if (!Global.equals((Object)sctpTransport.getState(), (Object)SctpTransportState.Connected)) {
                            return false;
                        }
                    }
                    for (DataChannel channel : stream2.getChannels()) {
                        if (Global.equals((Object)channel.getState(), (Object)DataChannelState.Connected)) continue;
                        return false;
                    }
                    continue;
                }
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio) && !stream.getDisabled() && !Global.equals((Object)stream.getDirection(), (Object)StreamDirection.Inactive)) {
                    AudioStream stream3 = (AudioStream)stream;
                    RtpTransport rtpTransport = stream3.getRtpTransport();
                    if (rtpTransport == null) {
                        return false;
                    }
                    SrtpTransport srtpTransport = rtpTransport.getSrtpTransport();
                    if (srtpTransport == null) {
                        return false;
                    }
                    listener = srtpTransport.getListener();
                    if (listener == null) {
                        return false;
                    }
                    if (Global.equals((Object)listener.getState(), (Object)MediaTransportState.Started)) continue;
                    return false;
                }
                if (!Global.equals((Object)stream.getType(), (Object)StreamType.Video) || stream.getDisabled() || Global.equals((Object)stream.getDirection(), (Object)StreamDirection.Inactive)) continue;
                VideoStream stream4 = (VideoStream)stream;
                RtpTransport transport4 = stream4.getRtpTransport();
                if (transport4 == null) {
                    return false;
                }
                SrtpTransport transport5 = transport4.getSrtpTransport();
                if (transport5 == null) {
                    return false;
                }
                listener = transport5.getListener();
                if (listener == null) {
                    return false;
                }
                if (Global.equals((Object)listener.getState(), (Object)MediaTransportState.Started)) continue;
                return false;
            }
            if (Global.equals((Object)this.getState(), (Object)ConnectionState.Connecting)) {
                this.setState(ConnectionState.Connected);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void removeFromDictionaryList(HashMap<String, ArrayList<T>> dictionary, String key, T value) {
        Object object = this._connectionLock;
        synchronized (object) {
            ArrayList list = null;
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(dictionary, key, _var0);
            list = _var0.getValue();
            if (_var1) {
                if (list != null) {
                    list.remove(value);
                }
                if (list == null || ArrayListExtensions.getCount(list) == 0) {
                    HashMapExtensions.remove(dictionary, key);
                }
            }
        }
    }

    private void rollbackLocalDescription() {
        this.__localDescription = this.__oldLocalDescription;
    }

    private void setBundlePolicy(BundlePolicy value) {
        this._bundlePolicy = value;
    }

    public void setCreateDatagramSocket(IFunction1<DatagramSocketCreateArgs, DatagramSocket> value) {
        this._createDatagramSocket = value;
    }

    public void setCreateStreamSocket(IFunction1<StreamSocketCreateArgs, StreamSocket> value) {
        this._createStreamSocket = value;
    }

    public static void setDefaultLocalDtlsCertificate(DtlsCertificate value) {
        if (value == null) {
            Connection.setDefaultLocalDtlsCertificates(null);
        } else {
            Connection.setDefaultLocalDtlsCertificates(new DtlsCertificate[]{value});
        }
    }

    public static void setDefaultLocalDtlsCertificates(DtlsCertificate[] value) {
        _defaultLocalDtlsCertificates = value;
    }

    private void setDescription(SessionDescription description, boolean local) {
        boolean flag = false;
        if (local) {
            this.__oldLocalDescription = this.__localDescription;
            this.__localDescription = description;
            flag = true;
        } else {
            long num4;
            long num = this.__remoteDescription == null ? -1L : this.__remoteDescription.getSessionId();
            long num2 = description.getSdpMessage() == null ? -1L : description.getSessionId();
            long num3 = description.getSdpMessage() == null ? -1L : description.getSessionVersion();
            long l = num4 = this.__remoteDescription == null ? -1L : this.__remoteDescription.getSessionVersion();
            if (num != -1L && num != num2) {
                Log.error("Sdp session Id changed in remote descriotion. Cannot renegotiate.");
            } else if (num3 > num4) {
                this.__remoteDescription = description;
                flag = true;
            } else {
                Log.debug(StringExtensions.format("Received SDP message with Id {0} and version {1}, but existing remote description has version {2}. Discarding stale received description.", LongExtensions.toString(num2), LongExtensions.toString(num3), LongExtensions.toString(num4)));
            }
        }
        if (flag && this.__localDescription != null && this.getRemoteDescription() != null) {
            this.updateRtpHeaderExtensions();
            this.beginConnectingToPeer();
        }
    }

    public void setDtlsCipherSuites(DtlsCipherSuite[] value) {
        this.__cipherSuites = value;
    }

    public void setDtlsClientVersion(DtlsProtocolVersion value) {
        this.__dtlsClientVersion = value;
    }

    public void setDtlsServerMaxVersion(DtlsProtocolVersion value) {
        this.__dtlsServerMaxVersion = value;
    }

    public void setDtlsServerMinVersion(DtlsProtocolVersion value) {
        this.__dtlsServerMinVersion = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setGatheringState(IceGatheringState value) {
        IceGatheringState state = this.__gatheringState;
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__gatheringState, (Object)value)) {
                this.__gatheringState = value;
                super.raiseGatheringStateChange(this);
            }
        }
        if (!Global.equals((Object)state, (Object)value)) {
            if (Global.equals((Object)value, (Object)IceGatheringState.Complete)) {
                if (this.__promiseToBeResolved != null) {
                    if (this.__createOffer) {
                        this.createOfferAnswer(this.__promiseToBeResolved, true);
                    } else if (this.__createAnswer) {
                        this.createOfferAnswer(this.__promiseToBeResolved, false);
                    }
                    this.__promiseToBeResolved = null;
                }
            } else if (Global.equals((Object)value, (Object)IceGatheringState.Failed)) {
                if (this.__promiseToBeResolved != null) {
                    this.__promiseToBeResolved.reject(new Exception("Gathering failed."));
                }
                this.__promiseToBeResolved = null;
            } else if (Global.equals((Object)value, (Object)IceGatheringState.Closing) || Global.equals((Object)value, (Object)IceGatheringState.Closed)) {
                if (this.__promiseToBeResolved != null) {
                    this.__promiseToBeResolved.reject(new Exception("Gathering could not be completed because gathering on this connection was shutdown."));
                }
                this.__promiseToBeResolved = null;
            }
            this.__createOffer = false;
            this.__createAnswer = false;
        }
    }

    public void setIceAddressTypes(AddressType[] value) {
        this._iceAddressTypes = value;
    }

    @Override
    protected void setIceConnectionState(IceConnectionState value) {
        if (!Global.equals((Object)value, (Object)this.__iceConnectionState)) {
            this.__iceConnectionState = value;
            super.raiseIceConnectionStateChange(this);
        }
    }

    public void setIcePolicy(IcePolicy value) {
        this.__icePolicy = value;
    }

    public void setIcePortRange(IcePortRange value) {
        this._icePortRange = value;
    }

    private void setIceRole(IceRole value) {
        this._iceRole = value;
    }

    public void setKeepAliveInterval(int value) {
        this.__keepAliveInterval = value;
    }

    public void setLocalDtlsCertificate(DtlsCertificate value) {
        if (value == null) {
            this.setLocalDtlsCertificates(null);
        } else {
            this.setLocalDtlsCertificates(new DtlsCertificate[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalDtlsCertificates(DtlsCertificate[] value) {
        Object object = this.__dtlsCertificatesLock;
        synchronized (object) {
            this.__localDtlsCertificates = value;
        }
    }

    public void setMultiplexPolicy(MultiplexPolicy value) {
        this._multiplexPolicy = value;
    }

    public void setPrivateIPAddress(String value) {
        if (value == null) {
            this.setPrivateIPAddresses(null);
        } else {
            this.setPrivateIPAddresses(new String[]{value});
        }
    }

    public void setPrivateIPAddresses(String[] value) {
        this._privateIPAddresses = value;
    }

    public void setPublicIPAddress(String value) {
        if (value == null) {
            this.setPublicIPAddresses(null);
        } else {
            this.setPublicIPAddresses(new String[]{value});
        }
    }

    public void setPublicIPAddresses(String[] value) {
        this._publicIPAddresses = value;
    }

    @Override
    protected void setState(final ConnectionState value) {
        IAction1<Exception> rejectAction = null;
        IAction1<Object> resolveAction = null;
        Scheduler scheduler = this.__scheduler;
        if ((Global.equals((Object)value, (Object)ConnectionState.Closed) || Global.equals((Object)value, (Object)ConnectionState.Failed)) && scheduler != null) {
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object x) {
                        Connection.this.finalise(value);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception x) {
                        Connection.this.finalise(value);
                    }
                };
            }
            scheduler.stop().then(resolveAction).fail(rejectAction);
        } else {
            if (Global.equals((Object)value, (Object)ConnectionState.Connected)) {
                scheduler.add(this.__logRTT);
            } else if (Global.equals((Object)value, (Object)ConnectionState.Failing) || Global.equals((Object)value, (Object)ConnectionState.Closing)) {
                scheduler.remove(this.__logRTT);
            }
            super.setState(value);
        }
    }

    public void setStunBindingRequestLimit(int value) {
        this._stunBindingRequestLimit = value;
    }

    public void setStunRequestTimeout(int value) {
        this._stunRequestTimeout = value;
    }

    public void setTcpConnectTimeout(int value) {
        this._tcpConnectTimeout = value;
    }

    public void setTurnAllocateRequestLimit(int value) {
        this._turnAllocateRequestLimit = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownOnFailure(Error error, TransportType causingTransport, String transportId) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!super.getIsInTerminatingOrTerminatedState()) {
                super.setError(error);
                this.setState(ConnectionState.Failing);
                Log.error(StringExtensions.format("Error encountered: {0} Causing transport: {1}. Connection will shut down.", error.getDescription(), causingTransport.toString()));
                this.simpleNonGracefulShutdown();
            }
        }
    }

    private void simpleNonGracefulShutdown() {
        Stream[] streams;
        for (Stream stream : streams = this.getStreams()) {
            SrtpListener listener;
            if (Global.equals((Object)stream.getType(), (Object)StreamType.Application)) {
                SctpTransport sctpTransport;
                ReliableTransport reliableDataTransport = ((DataStream)stream).getReliableDataTransport();
                if (reliableDataTransport != null) {
                    reliableDataTransport.removeOnStateChange((IAction1<ReliableTransport>)new IActionDelegate1<ReliableTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processReliableDataTransportStateChange";
                        }

                        @Override
                        public void invoke(ReliableTransport transport) {
                            Connection.this.processReliableDataTransportStateChange(transport);
                        }
                    });
                    reliableDataTransport.stop();
                }
                if ((sctpTransport = ((DataStream)stream).getSctpTransport()) != null) {
                    sctpTransport.removeOnStateChange((IAction1<SctpTransport>)new IActionDelegate1<SctpTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processSctpTransportStateChange";
                        }

                        @Override
                        public void invoke(SctpTransport transport) {
                            Connection.this.processSctpTransportStateChange(transport);
                        }
                    });
                    sctpTransport.stop();
                }
            } else if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                AudioStream stream2 = (AudioStream)stream;
                stream2.setDisabled(true);
                stream2.destroy();
                RtpTransport rtpTransport = stream2.getRtpTransport();
                if (rtpTransport != null) {
                    rtpTransport.removeOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processMediaTransportStateChange";
                        }

                        @Override
                        public void invoke(IMediaTransport transport) {
                            Connection.this.processMediaTransportStateChange(transport);
                        }
                    });
                    rtpTransport.stop();
                    SrtpTransport srtpTransport = rtpTransport.getSrtpTransport();
                    if (srtpTransport != null) {
                        srtpTransport.removeOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processMediaTransportStateChange";
                            }

                            @Override
                            public void invoke(IMediaTransport transport) {
                                Connection.this.processMediaTransportStateChange(transport);
                            }
                        });
                        srtpTransport.stop();
                        listener = srtpTransport.getListener();
                        if (listener != null) {
                            listener.removeOnStateChange((IAction1<SrtpListener>)new IActionDelegate1<SrtpListener>(){

                                @Override
                                public String getId() {
                                    return "fm.icelink.Connection.processSrtpListenerStateChange";
                                }

                                @Override
                                public void invoke(SrtpListener transport) {
                                    Connection.this.processSrtpListenerStateChange(transport);
                                }
                            });
                            listener.stop();
                        }
                    }
                }
            } else if (Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
                VideoStream stream3 = (VideoStream)stream;
                stream3.setDisabled(true);
                stream3.destroy();
                RtpTransport transport5 = stream3.getRtpTransport();
                if (transport5 != null) {
                    transport5.removeOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processMediaTransportStateChange";
                        }

                        @Override
                        public void invoke(IMediaTransport transport) {
                            Connection.this.processMediaTransportStateChange(transport);
                        }
                    });
                    transport5.stop();
                    SrtpTransport transport6 = transport5.getSrtpTransport();
                    if (transport6 != null) {
                        transport6.removeOnStateChange((IAction1<IMediaTransport>)new IActionDelegate1<IMediaTransport>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processMediaTransportStateChange";
                            }

                            @Override
                            public void invoke(IMediaTransport transport) {
                                Connection.this.processMediaTransportStateChange(transport);
                            }
                        });
                        transport6.stop();
                        listener = transport6.getListener();
                        if (listener != null) {
                            listener.removeOnStateChange((IAction1<SrtpListener>)new IActionDelegate1<SrtpListener>(){

                                @Override
                                public String getId() {
                                    return "fm.icelink.Connection.processSrtpListenerStateChange";
                                }

                                @Override
                                public void invoke(SrtpListener transport) {
                                    Connection.this.processSrtpListenerStateChange(transport);
                                }
                            });
                            listener.stop();
                        }
                    }
                }
            }
            CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
            CoreTransport coreTransportRtcp = stream.getCoreTransportRtcp();
            if (coreTransportRtp != null) {
                CoreTransport[] transportArray;
                CoreTransport[] coreTransportArray;
                if (coreTransportRtcp == null) {
                    CoreTransport[] coreTransportArray2 = new CoreTransport[1];
                    coreTransportArray = coreTransportArray2;
                    coreTransportArray2[0] = coreTransportRtp;
                } else {
                    CoreTransport[] coreTransportArray3 = new CoreTransport[2];
                    coreTransportArray3[0] = coreTransportRtp;
                    coreTransportArray = coreTransportArray3;
                    coreTransportArray3[1] = coreTransportRtcp;
                }
                for (CoreTransport transport9 : transportArray = coreTransportArray) {
                    IceGatherer gatherer;
                    IceTransport iceTransport;
                    DtlsTransport dtlsTransport = transport9.getDtlsTransport();
                    if (dtlsTransport != null) {
                        dtlsTransport.removeOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processDtlsTransportStateChange";
                            }

                            @Override
                            public void invoke(DtlsTransport transport) {
                                Connection.this.processDtlsTransportStateChange(transport);
                            }
                        });
                        dtlsTransport.stop();
                    }
                    if ((iceTransport = transport9.getIceTransport()) != null) {
                        iceTransport.removeOnStateChange((IAction1<IceTransport>)new IActionDelegate1<IceTransport>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processIceTransportStateChange";
                            }

                            @Override
                            public void invoke(IceTransport transport) {
                                Connection.this.processIceTransportStateChange(transport);
                            }
                        });
                        iceTransport.removeOnActiveCandidatePairChange((IAction2<IceTransport, IceCandidatePair>)new IActionDelegate2<IceTransport, IceCandidatePair>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processActiveCandidatePairChange";
                            }

                            @Override
                            public void invoke(IceTransport transport, IceCandidatePair p) {
                                Connection.this.processActiveCandidatePairChange(transport, p);
                            }
                        });
                        iceTransport.stop();
                    }
                    if ((gatherer = transport9.getGatherer()) == null) continue;
                    gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.Connection.processNewLocalCandidate";
                        }

                        @Override
                        public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                            Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                        }
                    });
                    gatherer.stop();
                }
            }
            this.__verifyGatherersDownScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.Connection.verifyGatherersDown";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    Connection.this.verifyGatherersDown(item);
                }
            }, 5000, ScheduledItem.getUnset(), ScheduledItem.getUnset(), 1);
            this.__scheduler.add(this.__verifyGatherersDownScheduledItem);
        }
    }

    private void startRtpTransport(Stream stream, int protectionProfileCode, DataBuffer localKey, DataBuffer localSalt, DataBuffer remoteKey, DataBuffer remoteSalt) {
        SrtpProtectionParameters localParameters = new SrtpProtectionParameters(protectionProfileCode, localKey, localSalt);
        SrtpProtectionParameters remoteParameters = new SrtpProtectionParameters(protectionProfileCode, remoteKey, remoteSalt);
        if (Global.equals((Object)stream.getType(), (Object)StreamType.Video)) {
            VideoStream stream2;
            final VideoStream _var0 = stream2 = (VideoStream)stream;
            stream2.getRtpTransport().addOnReceiveFrame(new IActionDelegate1<VideoFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaStream<fm.icelink.IVideoOutput,fm.icelink.IVideoOutputCollection,fm.icelink.IVideoInput,fm.icelink.IVideoInputCollection,fm.icelink.VideoFrame,fm.icelink.VideoBuffer,fm.icelink.VideoBufferCollection,fm.icelink.VideoFormat,fm.icelink.VideoFormatCollection>.receiveFrame";
                }

                @Override
                public void invoke(VideoFrame frame) {
                    _var0.receiveFrame(frame);
                }
            });
            final VideoStream _var1 = stream2;
            stream2.getRtpTransport().addOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaStream<fm.icelink.IVideoOutput,fm.icelink.IVideoOutputCollection,fm.icelink.IVideoInput,fm.icelink.IVideoInputCollection,fm.icelink.VideoFrame,fm.icelink.VideoBuffer,fm.icelink.VideoBufferCollection,fm.icelink.VideoFormat,fm.icelink.VideoFormatCollection>.receiveControlFrames";
                }

                @Override
                public void invoke(MediaControlFrame[] controlFrames) {
                    _var1.receiveControlFrames(controlFrames);
                }
            });
            stream2.getRtpTransport().setParameters(stream2.getRtpParameters());
            stream2.getRtpTransport().getSrtpTransport().setParameters(stream2.getRtpParameters());
            stream2.getRtpTransport().setMaxInputBitrate(stream2.getMaxOutputBitrate());
            stream2.getRtpTransport().getSrtpTransport().setProtectionParameters(localParameters, remoteParameters);
            stream2.getRtpTransport().getSrtpTransport().getListener().start();
            stream2.getRtpTransport().getSrtpTransport().start();
            stream2.getRtpTransport().start();
        } else if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
            AudioStream stream3;
            final AudioStream _var2 = stream3 = (AudioStream)stream;
            stream3.getRtpTransport().addOnReceiveFrame(new IActionDelegate1<AudioFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaStream<fm.icelink.IAudioOutput,fm.icelink.IAudioOutputCollection,fm.icelink.IAudioInput,fm.icelink.IAudioInputCollection,fm.icelink.AudioFrame,fm.icelink.AudioBuffer,fm.icelink.AudioBufferCollection,fm.icelink.AudioFormat,fm.icelink.AudioFormatCollection>.receiveFrame";
                }

                @Override
                public void invoke(AudioFrame frame) {
                    _var2.receiveFrame(frame);
                }
            });
            final AudioStream _var3 = stream3;
            stream3.getRtpTransport().addOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaStream<fm.icelink.IAudioOutput,fm.icelink.IAudioOutputCollection,fm.icelink.IAudioInput,fm.icelink.IAudioInputCollection,fm.icelink.AudioFrame,fm.icelink.AudioBuffer,fm.icelink.AudioBufferCollection,fm.icelink.AudioFormat,fm.icelink.AudioFormatCollection>.receiveControlFrames";
                }

                @Override
                public void invoke(MediaControlFrame[] controlFrames) {
                    _var3.receiveControlFrames(controlFrames);
                }
            });
            stream3.getRtpTransport().setParameters(stream3.getRtpParameters());
            stream3.getRtpTransport().getSrtpTransport().setParameters(stream3.getRtpParameters());
            stream3.getRtpTransport().setMaxInputBitrate(stream3.getMaxOutputBitrate());
            stream3.getRtpTransport().getSrtpTransport().setProtectionParameters(localParameters, remoteParameters);
            stream3.getRtpTransport().getSrtpTransport().getListener().start();
            stream3.getRtpTransport().getSrtpTransport().start();
            stream3.getRtpTransport().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error startStreamCore(CoreTransport coreTransport) {
        Object object = this._connectionLock;
        synchronized (object) {
            IceParameters remoteIceParameters;
            IceGatherer gatherer = coreTransport.getGatherer();
            IceTransport iceTransport = coreTransport.getIceTransport();
            DtlsTransport dtlsTransport = coreTransport.getDtlsTransport();
            ArrayList list = null;
            if (gatherer == null || iceTransport == null) {
                String str = "Core transport not prepared prior to starting internal stream transports.";
                return new Error(ErrorCode.ConnectionInternalError, new Exception(str));
            }
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__streamsForIceTransport, iceTransport.getId(), _var0);
            list = _var0.getValue();
            if (!_var1 || ArrayListExtensions.getCount(list) < 1) {
                String str = StringExtensions.format("Core transport cannot start because there are no streams associated with core transport.", new Object[0]);
                return new Error(ErrorCode.ConnectionInternalError, new Exception(str));
            }
            if (dtlsTransport == null) {
                boolean flag2 = false;
                for (Stream stream : list) {
                    this.setIceRole(stream.getIceRole());
                    if (!stream.getUseDtls()) continue;
                    flag2 = true;
                }
                if (flag2) {
                    String str = "Core transport not prepared prior to starting internal stream transports. Dtls transport is missing.";
                    return new Error(ErrorCode.ConnectionInternalError, new Exception(str));
                }
            }
            if ((remoteIceParameters = ((Stream)ArrayListExtensions.getItem(list).get(0)).getRemoteIceParameters()) == null) {
                String str = StringExtensions.format("Core transport cannot start because RemoteIceParameters for this connection are not set.", new Object[0]);
                return new Error(ErrorCode.ConnectionInternalError, new Exception(str));
            }
            try {
                coreTransport.getIceTransport().start(gatherer, remoteIceParameters, this.getIceRole(), this.__iceTieBreaker);
            }
            catch (Exception exception) {
                return new Error(ErrorCode.ConnectionTransportStartError, exception);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopGatherer(IceGatherer gatherer) {
        Object object = this._connectionLock;
        synchronized (object) {
            return this.doStopGatherer(gatherer);
        }
    }

    private void stopStreamCore(CoreTransport coreTransport) {
        try {
            ArrayList list = null;
            IceTransport iceTransport = coreTransport.getIceTransport();
            DtlsTransport dtlsTransport = coreTransport.getDtlsTransport();
            HashMapExtensions.remove(this.__streamsForIceTransport, iceTransport.getId());
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__streamsForIceTransport, iceTransport.getId(), _var0);
            list = _var0.getValue();
            if (!_var1 || ArrayListExtensions.getCount(list) <= 1) {
                if (dtlsTransport != null) {
                    if (!dtlsTransport.stop()) {
                        this.processDtlsTransportDown(dtlsTransport);
                    }
                } else if (!iceTransport.stop()) {
                    this.processIceTransportDown(iceTransport);
                }
            } else {
                Log.debug(StringExtensions.format("Request to shut down a core transport has been made; however, it is still in use by {0} streams. Waiting for these streams to shut down.", IntegerExtensions.toString(ArrayListExtensions.getCount(list))));
            }
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Could not shut down Dtls transport. Will attempt to shut down ICE transport.", new Object[0]), exception);
            this.shutdownOnFailure(new Error(ErrorCode.ConnectionInvalidArchitecture, exception), TransportType.Unset, null);
        }
    }

    private void updateConnectionGatheringState() {
        boolean flag = false;
        boolean flag2 = true;
        boolean flag3 = true;
        boolean flag4 = true;
        for (IceGatherer gatherer : HashMapExtensions.getValues(this.__gatherers)) {
            if (Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.New)) {
                flag2 = false;
                flag3 = false;
                continue;
            }
            if (Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Gathering)) {
                flag4 = false;
                flag = true;
                flag2 = false;
                flag3 = false;
                continue;
            }
            if (Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Complete)) {
                flag4 = false;
                flag3 = false;
                continue;
            }
            if (!Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Closing) && !Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Closed) && !Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Failed)) continue;
            flag4 = false;
        }
        if (flag4) {
            this.setGatheringState(IceGatheringState.New);
        } else if (flag) {
            this.setGatheringState(IceGatheringState.Gathering);
        } else if (flag2 && !flag3) {
            this.setGatheringState(IceGatheringState.Complete);
        } else if (flag3) {
            this.setGatheringState(IceGatheringState.Closed);
        }
    }

    private void updateIceConnectionsState() {
        boolean flag = true;
        boolean flag2 = true;
        boolean flag3 = true;
        boolean flag4 = false;
        boolean flag5 = false;
        boolean flag6 = false;
        for (IceTransport transport : HashMapExtensions.getValues(this.__iceTransports)) {
            if (Global.equals((Object)transport.getState(), (Object)IceTransportState.New)) {
                flag2 = false;
                flag3 = false;
                continue;
            }
            if (Global.equals((Object)transport.getState(), (Object)IceTransportState.Checking)) {
                flag2 = false;
                flag3 = false;
                flag = false;
                flag4 = true;
                continue;
            }
            if (Global.equals((Object)transport.getState(), (Object)IceTransportState.Connected)) {
                flag = false;
                flag3 = false;
                continue;
            }
            if (Global.equals((Object)transport.getState(), (Object)IceTransportState.Disconnected)) {
                flag = false;
                flag3 = false;
                flag2 = false;
                flag5 = true;
                continue;
            }
            if (Global.equals((Object)transport.getState(), (Object)IceTransportState.Failed)) {
                flag = false;
                flag2 = false;
                flag3 = false;
                flag6 = true;
                continue;
            }
            if (!Global.equals((Object)transport.getState(), (Object)IceTransportState.Closed)) continue;
            flag = false;
            flag2 = false;
        }
        if (flag) {
            this.setIceConnectionState(IceConnectionState.New);
        } else if (flag2) {
            this.setIceConnectionState(IceConnectionState.Connected);
        } else if (flag3) {
            this.setIceConnectionState(IceConnectionState.Closed);
        } else if (flag6) {
            this.setIceConnectionState(IceConnectionState.Failed);
        } else if (flag4) {
            this.setIceConnectionState(IceConnectionState.Checking);
        } else if (flag5) {
            this.setIceConnectionState(IceConnectionState.Disconnected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRtpHeaderExtensions() {
        Object object = this._connectionLock;
        synchronized (object) {
            for (Stream stream : this.getStreams()) {
                if (Global.equals((Object)stream.getType(), (Object)StreamType.Audio)) {
                    AudioStream stream2 = (AudioStream)stream;
                    RtpTransport rtpTransport = stream2.getRtpTransport();
                    rtpTransport.setRtpHeaderExtensionRegistry(stream2.getRtpHeaderExtensionRegistry());
                    rtpTransport.setAbsoluteSenderTimeDirection(stream2.getAbsoluteSenderTimeDirection());
                    continue;
                }
                if (!Global.equals((Object)stream.getType(), (Object)StreamType.Video)) continue;
                VideoStream stream3 = (VideoStream)stream;
                RtpTransport transport2 = stream3.getRtpTransport();
                transport2.setRtpHeaderExtensionRegistry(stream3.getRtpHeaderExtensionRegistry());
                transport2.setAbsoluteSenderTimeDirection(stream3.getAbsoluteSenderTimeDirection());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDtlsStillNeeded() {
        Object object = this._connectionLock;
        synchronized (object) {
            ArrayList<DtlsTransport> list = new ArrayList<DtlsTransport>();
            for (Stream stream : this.getStreams()) {
                DtlsTransport dtlsTransport;
                if (stream.getUseDtls()) continue;
                Log.debug(StringExtensions.format("Dtls encryption is not supported for stream {0} of type {1}. Dtls transport will be disabled.", stream.getId(), Global.equals((Object)stream.getType(), (Object)StreamType.Audio) ? "Audio" : (Global.equals((Object)stream.getType(), (Object)StreamType.Video) ? "Video" : "Data")));
                CoreTransport coreTransportRtp = stream.getCoreTransportRtp();
                CoreTransport coreTransportRtcp = stream.getCoreTransportRtcp();
                if (coreTransportRtp != null) {
                    dtlsTransport = coreTransportRtp.getDtlsTransport();
                    if (dtlsTransport != null) {
                        list.add(dtlsTransport);
                    }
                    coreTransportRtp.removeDtlsTransport();
                }
                if (coreTransportRtcp == null) continue;
                dtlsTransport = coreTransportRtcp.getDtlsTransport();
                if (dtlsTransport != null) {
                    list.add(dtlsTransport);
                }
                coreTransportRtcp.removeDtlsTransport();
            }
            for (DtlsTransport transport4 : list) {
                HashMapExtensions.remove(this.__streamsForDtlsTransport, transport4.getId());
                transport4.setClosingShouldNotTriggerGlobalNonGracefulShutdown(true);
                transport4.removeOnStateChange((IAction1<DtlsTransport>)new IActionDelegate1<DtlsTransport>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Connection.processDtlsTransportStateChange";
                    }

                    @Override
                    public void invoke(DtlsTransport transport) {
                        Connection.this.processDtlsTransportStateChange(transport);
                    }
                });
                transport4.disableInnerTransport();
                transport4.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyGatherersDown(ScheduledItem item) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Closed)) {
                boolean flag = true;
                if (this.__gatherers != null) {
                    for (String str : HashMapExtensions.getKeys(this.__gatherers)) {
                        IceGatherer gatherer = HashMapExtensions.getItem(this.__gatherers).get(str);
                        if (!(Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Closed) || Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Failed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing))) {
                            flag = false;
                            continue;
                        }
                        gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processNewLocalCandidate";
                            }

                            @Override
                            public void invoke(IceGatherer gatherer, IceCandidate iceCandidate) {
                                Connection.this.processNewLocalCandidate(gatherer, iceCandidate);
                            }
                        });
                        gatherer.removeOnStateChange((IAction1<IceGatherer>)new IActionDelegate1<IceGatherer>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.Connection.processGathererStateChange";
                            }

                            @Override
                            public void invoke(IceGatherer gatherer) {
                                Connection.this.processGathererStateChange(gatherer);
                            }
                        });
                    }
                }
                if (flag) {
                    this.__primaryCoreTransports.clear();
                    this.__secondaryCoreTransports.clear();
                    for (Stream stream : (Stream[])this.__streams.getValues()) {
                        stream.reset();
                    }
                    if (Global.equals((Object)this.getState(), (Object)ConnectionState.Closing)) {
                        this.setState(ConnectionState.Closed);
                    } else if (Global.equals((Object)this.getState(), (Object)ConnectionState.Failing)) {
                        this.setState(ConnectionState.Failed);
                    }
                    Log.debug("Connection shut down.");
                }
            }
        }
    }
}

