/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.CandidatePairState;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableDouble;
import fm.icelink.NullableLong;
import java.util.ArrayList;
import java.util.HashMap;

public class CandidatePairStats
extends BaseStats {
    private long _bytesReceived;
    private long _bytesSent;
    private long _consentRequestsReceived;
    private long _consentRequestsSent;
    private long _consentResponsesReceived;
    private long _consentResponsesSent;
    private double _currentRoundTripTime;
    private String _localCandidateId;
    private boolean _nominated;
    private long _priority;
    private String _remoteCandidateId;
    private long _requestsSent;
    private long _responsesReceived;
    private CandidatePairState _state;
    private double _totalRoundTripTime;
    private String _transportId;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String _var0 = key;
        if (_var0.equals("transportId")) {
            this.setTransportId(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("localCandidateId")) {
            this.setLocalCandidateId(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("remoteCandidateId")) {
            this.setRemoteCandidateId(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("state")) {
            this.setState(this.stateFromString(JsonSerializer.deserializeString(valueJson)));
        } else if (_var0.equals("priority")) {
            this.setPriority(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("nominated")) {
            this.setNominated(JsonSerializer.deserializeBoolean(valueJson).getValue());
        } else if (_var0.equals("bytesSent")) {
            this.setBytesSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("bytesReceived")) {
            this.setBytesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("requestsSent")) {
            this.setRequestsSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("responsesReceived")) {
            this.setResponsesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("consentRequestsSent")) {
            this.setConsentRequestsSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("consentRequestsReceived")) {
            this.setConsentRequestsReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("consentResponsesSent")) {
            this.setConsentResponsesSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("consentresponsesReceived")) {
            this.setConsentResponsesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("totalRTT")) {
            this.setTotalRoundTripTime(JsonSerializer.deserializeDouble(valueJson).getValue());
        } else if (_var0.equals("currentRTT")) {
            this.setCurrentRoundTripTime(JsonSerializer.deserializeDouble(valueJson).getValue());
        }
    }

    public static CandidatePairStats fromJson(String candidatePairJson) {
        return JsonSerializer.deserializeObject(candidatePairJson, new IFunction0<CandidatePairStats>(){

            @Override
            public CandidatePairStats invoke() {
                return new CandidatePairStats();
            }
        }, new IAction3<CandidatePairStats, String, String>(){

            @Override
            public void invoke(CandidatePairStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public static CandidatePairStats[] fromJsonArray(String candidatePairsJson) {
        ArrayList<CandidatePairStats> list = JsonSerializer.deserializeObjectArray(candidatePairsJson, new IFunctionDelegate1<String, CandidatePairStats>(){

            @Override
            public String getId() {
                return "fm.icelink.CandidatePairStats.fromJson";
            }

            @Override
            public CandidatePairStats invoke(String candidatePairJson) {
                return CandidatePairStats.fromJson(candidatePairJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new CandidatePairStats[0]);
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public long getConsentRequestsReceived() {
        return this._consentRequestsReceived;
    }

    public long getConsentRequestsSent() {
        return this._consentRequestsSent;
    }

    public long getConsentResponsesReceived() {
        return this._consentResponsesReceived;
    }

    public long getConsentResponsesSent() {
        return this._consentResponsesSent;
    }

    public double getCurrentRoundTripTime() {
        return this._currentRoundTripTime;
    }

    public String getLocalCandidateId() {
        return this._localCandidateId;
    }

    public boolean getNominated() {
        return this._nominated;
    }

    public long getPriority() {
        return this._priority;
    }

    public String getRemoteCandidateId() {
        return this._remoteCandidateId;
    }

    public long getRequestsSent() {
        return this._requestsSent;
    }

    public long getResponsesReceived() {
        return this._responsesReceived;
    }

    public CandidatePairState getState() {
        return this._state;
    }

    public double getTotalRoundTripTime() {
        return this._totalRoundTripTime;
    }

    public String getTransportId() {
        return this._transportId;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        if (this.getTransportId() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "transportId", JsonSerializer.serializeString(this.getTransportId()));
        }
        if (this.getLocalCandidateId() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "localCandidateId", JsonSerializer.serializeString(this.getLocalCandidateId()));
        }
        if (this.getRemoteCandidateId() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "remoteCandidateId", JsonSerializer.serializeString(this.getRemoteCandidateId()));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "state", JsonSerializer.serializeString(this.stateToString(this.getState())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "priority", JsonSerializer.serializeLong(new NullableLong(this.getPriority())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "nominated", JsonSerializer.serializeBoolean(new NullableBoolean(this.getNominated())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesSent", JsonSerializer.serializeLong(new NullableLong(this.getBytesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesReceived", JsonSerializer.serializeLong(new NullableLong(this.getBytesReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "consentRequestsSent", JsonSerializer.serializeLong(new NullableLong(this.getConsentRequestsSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "consentRequestsReceived", JsonSerializer.serializeLong(new NullableLong(this.getConsentRequestsReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "requestsSent", JsonSerializer.serializeLong(new NullableLong(this.getRequestsSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "consentResponsesSent", JsonSerializer.serializeLong(new NullableLong(this.getConsentResponsesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "consentResponsesReceived", JsonSerializer.serializeLong(new NullableLong(this.getConsentResponsesReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "responsesReceived", JsonSerializer.serializeLong(new NullableLong(this.getResponsesReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "totalRTT", JsonSerializer.serializeDouble(new NullableDouble(this.getTotalRoundTripTime())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "currentRTT", JsonSerializer.serializeDouble(new NullableDouble(this.getCurrentRoundTripTime())));
    }

    void setBytesReceived(long value) {
        this._bytesReceived = value;
    }

    void setBytesSent(long value) {
        this._bytesSent = value;
    }

    void setConsentRequestsReceived(long value) {
        this._consentRequestsReceived = value;
    }

    void setConsentRequestsSent(long value) {
        this._consentRequestsSent = value;
    }

    void setConsentResponsesReceived(long value) {
        this._consentResponsesReceived = value;
    }

    void setConsentResponsesSent(long value) {
        this._consentResponsesSent = value;
    }

    void setCurrentRoundTripTime(double value) {
        this._currentRoundTripTime = value;
    }

    void setLocalCandidateId(String value) {
        this._localCandidateId = value;
    }

    void setNominated(boolean value) {
        this._nominated = value;
    }

    void setPriority(long value) {
        this._priority = value;
    }

    void setRemoteCandidateId(String value) {
        this._remoteCandidateId = value;
    }

    void setRequestsSent(long value) {
        this._requestsSent = value;
    }

    void setResponsesReceived(long value) {
        this._responsesReceived = value;
    }

    void setState(CandidatePairState value) {
        this._state = value;
    }

    void setTotalRoundTripTime(double value) {
        this._totalRoundTripTime = value;
    }

    void setTransportId(String value) {
        this._transportId = value;
    }

    private CandidatePairState stateFromString(String stateString) {
        String _var0 = stateString;
        if (_var0.equals("new")) {
            return CandidatePairState.New;
        }
        if (_var0.equals("waiting")) {
            return CandidatePairState.Waiting;
        }
        if (_var0.equals("inProgress")) {
            return CandidatePairState.InProgress;
        }
        if (_var0.equals("succeeded")) {
            return CandidatePairState.Succeeded;
        }
        if (_var0.equals("failed")) {
            return CandidatePairState.Failed;
        }
        if (_var0.equals("closed")) {
            return CandidatePairState.Closed;
        }
        if (_var0.equals("connectivityLost")) {
            return CandidatePairState.ConnectivityLost;
        }
        return CandidatePairState.New;
    }

    private String stateToString(CandidatePairState state) {
        CandidatePairState _var0 = state;
        if (_var0 == CandidatePairState.New) {
            return "new";
        }
        if (_var0 == CandidatePairState.Waiting) {
            return "waiting";
        }
        if (_var0 == CandidatePairState.InProgress) {
            return "inProgress";
        }
        if (_var0 == CandidatePairState.Succeeded) {
            return "succeeded";
        }
        if (_var0 == CandidatePairState.Failed) {
            return "failed";
        }
        if (_var0 == CandidatePairState.Closed) {
            return "closed";
        }
        if (_var0 == CandidatePairState.ConnectivityLost) {
            return "connectivityLost";
        }
        return null;
    }

    public String toJson() {
        return CandidatePairStats.toJson(this);
    }

    public static String toJson(CandidatePairStats candidatePair) {
        return JsonSerializer.serializeObject(candidatePair, new IAction2<CandidatePairStats, HashMap<String, String>>(){

            @Override
            public void invoke(CandidatePairStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public static String toJsonArray(CandidatePairStats[] candidatePairs) {
        return JsonSerializer.serializeObjectArray(candidatePairs, new IFunctionDelegate1<CandidatePairStats, String>(){

            @Override
            public String getId() {
                return "fm.icelink.CandidatePairStats.toJson";
            }

            @Override
            public String invoke(CandidatePairStats candidatePair) {
                return CandidatePairStats.toJson(candidatePair);
            }
        });
    }
}

