/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IVideoOutput;
import fm.icelink.RtpPacketHeader;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPacketizer;

public class BasicVideoPacketizer
extends VideoPacketizer {
    public BasicVideoPacketizer(IVideoOutput input) {
        super(input);
    }

    public BasicVideoPacketizer(VideoFormat format) {
        super(format);
    }

    public BasicVideoPacketizer(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        Object[] dataBuffers = inputBuffer.getDataBuffers();
        VideoBuffer buffer = inputBuffer.clone();
        buffer.setDataBuffers((DataBuffer[])dataBuffers);
        buffer.setFormat(super.getOutputFormat());
        buffer.setRtpHeaders(new RtpPacketHeader[ArrayExtensions.getLength(dataBuffers)]);
        for (int i = 0; i < ArrayExtensions.getLength(buffer.getRtpHeaders()); ++i) {
            RtpPacketHeader header = new RtpPacketHeader();
            header.setMarker(true);
            buffer.getRtpHeaders()[i] = header;
        }
        frame.addBuffer(buffer);
        this.raiseFrame(frame);
    }

    @Override
    public String getLabel() {
        return "Basic Video Packetizer";
    }
}

