/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioFormat;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaFrame;
import fm.icelink.SoundUtility;
import fm.icelink.StringExtensions;

public class AudioFrame
extends MediaFrame<AudioBuffer, AudioBufferCollection, AudioFormat, AudioFrame> {
    private int __duration;

    public AudioFrame(int duration) {
        this.setDuration(duration);
    }

    public AudioFrame(int duration, AudioBuffer buffer) {
        super(buffer);
        this.setDuration(duration);
    }

    public AudioFrame(int duration, AudioBuffer[] buffers) {
        super(buffers);
        this.setDuration(duration);
    }

    @Override
    public AudioFrame clone() {
        AudioFrame frame = (AudioFrame)super.clone();
        frame.setDuration(this.getDuration());
        return frame;
    }

    @Override
    public AudioFrame createInstance() {
        return new AudioFrame(-1);
    }

    @Override
    protected AudioBufferCollection createMediaBufferCollection() {
        return new AudioBufferCollection();
    }

    public int getDuration() {
        AudioBuffer buffer;
        if (this.__duration == -1 && (buffer = (AudioBuffer)super.getBuffer(AudioFormat.getPcmName())) != null) {
            this.__duration = SoundUtility.calculateDuration(buffer.getDataBuffer().getLength(), ((AudioFormat)buffer.getFormat()).getConfig());
        }
        return this.__duration;
    }

    public void setDuration(int value) {
        this.__duration = value;
    }

    public String toString() {
        return StringExtensions.concat("Audio Frame (", IntegerExtensions.toString(this.getDuration()), "ms)");
    }
}

