/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.DataBufferPool;
import fm.icelink.MediaTrackStats;
import fm.icelink.SoundUtility;

public abstract class AudioDecoder
extends AudioPipe {
    private int __decoderLastDuration = -1;
    private long __decoderLastTimestamp = -1L;
    private AtomicLong __framesDecoded = new AtomicLong();
    private boolean _disablePlc;
    private int _missingDuration;

    public AudioDecoder(AudioFormat inputFormat, AudioFormat outputFormat) {
        super(inputFormat, outputFormat);
        this.setDisablePlc(!outputFormat.getIsPcm());
    }

    @Override
    protected void doProcessStatsFromInput(MediaTrackStats stats) {
        super.doProcessStatsFromInput(stats);
        stats.setFramesDecoded(this.getFramesDecoded());
    }

    protected AudioBuffer generatePlc(int duration) {
        return new AudioBuffer(DataBufferPool.getInstance().take(SoundUtility.calculateDataLength(duration, super.getConfig()), ((AudioFormat)super.getOutputFormat()).getLittleEndian()), (AudioFormat)super.getOutputFormat());
    }

    public boolean getDisablePlc() {
        return this._disablePlc;
    }

    public long getFramesDecoded() {
        return this.__framesDecoded.getValue();
    }

    protected int getMissingDuration() {
        return this._missingDuration;
    }

    @Override
    public boolean processFrame(AudioFrame frame) {
        if (((AudioFormat)super.getOutputFormat()).getIsPcm() && this.__decoderLastTimestamp != -1L && this.__decoderLastDuration != -1) {
            this.setMissingDuration((int)((frame.getTimestamp() - this.__decoderLastTimestamp) * 1000L / (long)super.getConfig().getClockRate()) - this.__decoderLastDuration);
        }
        return super.processFrame(frame);
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        this.__framesDecoded.increment();
        if (((AudioFormat)super.getOutputFormat()).getIsPcm()) {
            this.__decoderLastTimestamp = frame.getTimestamp();
            this.__decoderLastDuration = frame.getDuration();
        }
        if (!this.getDisablePlc() && this.getMissingDuration() > 0) {
            AudioFrame frame2 = frame.clone();
            frame2.removeBuffers();
            AudioBuffer buffer = this.generatePlc(this.getMissingDuration());
            frame2.addBuffer(buffer);
            super.raiseFrame(frame2);
            buffer.free();
        }
        super.raiseFrame(frame);
    }

    public void setDisablePlc(boolean value) {
        this._disablePlc = value;
    }

    protected void setMissingDuration(int value) {
        this._missingDuration = value;
    }
}

