/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;

public class AudioClock {
    private IAction2<Integer, Integer> __raiseCallback;
    private ManagedThread __thread;
    private int _blockAlign;
    private int _channelCount;
    private int _clockRate;
    private boolean _running;
    private int _strictDuration;

    public AudioClock(int clockRate, int channelCount, int blockAlign, IAction2<Integer, Integer> raiseCallback) {
        this.setClockRate(clockRate);
        this.setChannelCount(channelCount);
        this.setBlockAlign(blockAlign);
        this.setStrictDuration(0);
        this.__raiseCallback = raiseCallback;
    }

    public AudioClock(int clockRate, int channelCount, IAction2<Integer, Integer> raiseCallback) {
        this(clockRate, channelCount, channelCount * 2, raiseCallback);
    }

    public int getBlockAlign() {
        return this._blockAlign;
    }

    public int getChannelCount() {
        return this._channelCount;
    }

    public int getClockRate() {
        return this._clockRate;
    }

    public boolean getRunning() {
        return this._running;
    }

    public int getStrictDuration() {
        return this._strictDuration;
    }

    private void innerLoop(ManagedThread thread) {
        boolean flag = this.getStrictDuration() > 0;
        ManagedStopwatch stopwatch = new ManagedStopwatch();
        long num = 0L;
        stopwatch.start();
        while (this.getRunning()) {
            int num4;
            int num2 = (int)(stopwatch.getElapsedMilliseconds() - num);
            if (num2 > 10000) {
                num = 0L;
                stopwatch.restart();
                continue;
            }
            if (num2 <= 0) continue;
            if (flag && num2 >= this.getStrictDuration()) {
                int num3 = num2 / this.getStrictDuration();
                num4 = (this.getClockRate() * this.getChannelCount() * 2 * this.getStrictDuration() / 1000 + this.getBlockAlign() - 1) / this.getBlockAlign() * this.getBlockAlign();
                for (int i = 0; i < num3; ++i) {
                    this.__raiseCallback.invoke(num4, this.getStrictDuration());
                    num += (long)this.getStrictDuration();
                }
            } else {
                num4 = (this.getClockRate() * this.getChannelCount() * 2 * num2 / 1000 + this.getBlockAlign() - 1) / this.getBlockAlign() * this.getBlockAlign();
                this.__raiseCallback.invoke(num4, num2);
                num += (long)num2;
            }
            ManagedThread.sleep(flag ? this.getStrictDuration() : 20);
        }
    }

    private void setBlockAlign(int value) {
        this._blockAlign = value;
    }

    private void setChannelCount(int value) {
        this._channelCount = value;
    }

    private void setClockRate(int value) {
        this._clockRate = value;
    }

    private void setRunning(boolean value) {
        this._running = value;
    }

    public void setStrictDuration(int value) {
        this._strictDuration = value;
    }

    public void start() {
        if (this.getRunning()) {
            throw new RuntimeException(new Exception("Already running."));
        }
        this.setRunning(true);
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.AudioClock.innerLoop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                AudioClock.this.innerLoop(thread);
            }
        });
        this.__thread.start();
    }

    public void stop() {
        this.setRunning(false);
        this.__thread = null;
    }
}

