/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Array;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.CompareResult;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.Sort;
import java.util.ArrayList;

class Asn1Set
extends Asn1Array {
    public Asn1Set(Asn1Any[] values) {
        super.setValues(values);
    }

    public Asn1Set() {
    }

    @Override
    public byte[] getContents() {
        if (ArrayExtensions.getLength(super.getValues()) == 0) {
            Log.error("Set must contain at least one value.");
            return null;
        }
        ArrayList<Asn1Any> array = new ArrayList<Asn1Any>();
        for (Asn1Any any : super.getValues()) {
            array.add(any);
        }
        Sort.quickSort(array, new IFunctionDelegate2<Asn1Any, Asn1Any, CompareResult>(){

            @Override
            public String getId() {
                return "fm.icelink.Asn1Set.sortValues";
            }

            @Override
            public CompareResult invoke(Asn1Any value1, Asn1Any value2) {
                return Asn1Set.sortValues(value1, value2);
            }
        });
        ByteCollection bytes = new ByteCollection();
        for (Asn1Any any : array) {
            if (any == null) continue;
            bytes.addRange(any.getBytes());
        }
        return bytes.toArray();
    }

    @Override
    public void getProperties(IntegerHolder tag, IntegerHolder klass, BooleanHolder isConstructed, BooleanHolder isIndefinite) {
        tag.setValue(17);
        klass.setValue(0);
        isConstructed.setValue(true);
        isIndefinite.setValue(false);
    }

    private static int getTag(Asn1Any value) {
        int tag = 0;
        int klass = 0;
        boolean isConstructed = false;
        boolean isIndefinite = false;
        IntegerHolder _var0 = new IntegerHolder(tag);
        IntegerHolder _var1 = new IntegerHolder(klass);
        BooleanHolder _var2 = new BooleanHolder(isConstructed);
        BooleanHolder _var3 = new BooleanHolder(isIndefinite);
        value.getProperties(_var0, _var1, _var2, _var3);
        tag = _var0.getValue();
        klass = _var1.getValue();
        isConstructed = _var2.getValue();
        isIndefinite = _var3.getValue();
        return tag;
    }

    public static Asn1Set parseContents(byte[] contents) {
        int byteCount;
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        for (int offset = 0; offset < ArrayExtensions.getLength(contents); offset += byteCount) {
            byteCount = 0;
            IntegerHolder _var0 = new IntegerHolder(byteCount);
            Asn1Any _var1 = Asn1Any.parseBytes(contents, offset, _var0);
            byteCount = _var0.getValue();
            Asn1Any item = _var1;
            if (item == null) {
                return null;
            }
            list.add(item);
        }
        return new Asn1Set(list.toArray(new Asn1Any[0]));
    }

    private static CompareResult sortValues(Asn1Any value1, Asn1Any value2) {
        int num2;
        if (value1 == null) {
            return CompareResult.Negative;
        }
        if (value2 == null) {
            return CompareResult.Positive;
        }
        int tag = Asn1Set.getTag(value1);
        if (tag < (num2 = Asn1Set.getTag(value2))) {
            return CompareResult.Negative;
        }
        if (tag > num2) {
            return CompareResult.Positive;
        }
        return CompareResult.Equal;
    }
}

