/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.Binary;
import fm.BitAssistant;
import fm.ByteCollection;
import fm.ByteInputStream;
import fm.ByteOutputStream;
import fm.IntegerHolder;

public class NetworkBuffer {
    public static int fromBuffer16(ByteCollection buffer, int offset) {
        return Binary.fromBytes16(NetworkBuffer.getValue32FromBuffer(buffer, offset, 2), 0, false);
    }

    public static int fromBuffer24(ByteCollection buffer, int offset) {
        return Binary.fromBytes24(NetworkBuffer.getValue32FromBuffer(buffer, offset, 3), 0, false);
    }

    public static long fromBuffer32(ByteCollection buffer, int offset) {
        return Binary.fromBytes32(NetworkBuffer.getValue64FromBuffer(buffer, offset, 4), 0, false);
    }

    public static long fromBuffer40(ByteCollection buffer, int offset) {
        return Binary.fromBytes40(NetworkBuffer.getValue64FromBuffer(buffer, offset, 5), 0, false);
    }

    public static long fromBuffer48(ByteCollection buffer, int offset) {
        return Binary.fromBytes48(NetworkBuffer.getValue64FromBuffer(buffer, offset, 6), 0, false);
    }

    public static long fromBuffer56(ByteCollection buffer, int offset) {
        return Binary.fromBytes56(NetworkBuffer.getValue64FromBuffer(buffer, offset, 7), 0, false);
    }

    public static long fromBuffer64(ByteCollection buffer, int offset) {
        return Binary.fromBytes64(NetworkBuffer.getValue64FromBuffer(buffer, offset, 8), 0, false);
    }

    public static int fromBuffer8(ByteCollection buffer, int offset) {
        return buffer.get(offset);
    }

    public static int fromData16(byte[] data, int offset) {
        return Binary.fromBytes16(data, offset, false);
    }

    public static int fromData24(byte[] data, int offset) {
        return Binary.fromBytes24(data, offset, false);
    }

    public static long fromData32(byte[] data, int offset) {
        return Binary.fromBytes32(data, offset, false);
    }

    public static long fromData40(byte[] data, int offset) {
        return Binary.fromBytes40(data, offset, false);
    }

    public static long fromData48(byte[] data, int offset) {
        return Binary.fromBytes48(data, offset, false);
    }

    public static long fromData56(byte[] data, int offset) {
        return Binary.fromBytes56(data, offset, false);
    }

    public static long fromData64(byte[] data, int offset) {
        return Binary.fromBytes64(data, offset, false);
    }

    public static int fromData8(byte[] data, int offset) {
        return data[offset];
    }

    public static int fromStream16(ByteInputStream stream) throws Exception {
        return Binary.fromBytes16(NetworkBuffer.getValue32FromStream(stream, 2), 0, false);
    }

    public static int fromStream24(ByteInputStream stream) throws Exception {
        return Binary.fromBytes24(NetworkBuffer.getValue32FromStream(stream, 3), 0, false);
    }

    public static long fromStream32(ByteInputStream stream) throws Exception {
        return Binary.fromBytes32(NetworkBuffer.getValue64FromStream(stream, 4), 0, false);
    }

    public static long fromStream40(ByteInputStream stream) throws Exception {
        return Binary.fromBytes40(NetworkBuffer.getValue64FromStream(stream, 5), 0, false);
    }

    public static long fromStream48(ByteInputStream stream) throws Exception {
        return Binary.fromBytes48(NetworkBuffer.getValue64FromStream(stream, 6), 0, false);
    }

    public static long fromStream56(ByteInputStream stream) throws Exception {
        return Binary.fromBytes56(NetworkBuffer.getValue64FromStream(stream, 7), 0, false);
    }

    public static long fromStream64(ByteInputStream stream) throws Exception {
        return Binary.fromBytes64(NetworkBuffer.getValue64FromStream(stream, 8), 0, false);
    }

    public static int fromStream8(ByteInputStream stream) {
        return stream.read();
    }

    private static byte[] getValue32FromBuffer(ByteCollection buffer, int offset, int count) {
        return NetworkBuffer.getValueFromBuffer(buffer, 4, offset, count);
    }

    private static byte[] getValue32FromData(byte[] data, int offset, int count) {
        return NetworkBuffer.getValueFromData(data, 4, offset, count);
    }

    private static byte[] getValue32FromStream(ByteInputStream stream, int count) throws Exception {
        return NetworkBuffer.getValueFromStream(stream, 4, count);
    }

    private static byte[] getValue64FromBuffer(ByteCollection buffer, int offset, int count) {
        return NetworkBuffer.getValueFromBuffer(buffer, 8, offset, count);
    }

    private static byte[] getValue64FromData(byte[] data, int offset, int count) {
        return NetworkBuffer.getValueFromData(data, 8, offset, count);
    }

    private static byte[] getValue64FromStream(ByteInputStream stream, int count) throws Exception {
        return NetworkBuffer.getValueFromStream(stream, 8, count);
    }

    private static byte[] getValueFromBuffer(ByteCollection buffer, int length, int offset, int count) {
        int num;
        byte[] buffer2 = new byte[length];
        for (num = 0; num < length; ++num) {
            buffer2[num] = 0;
        }
        for (num = 0; num < count; ++num) {
            buffer2[length - count + num] = buffer.get(offset + num);
        }
        return buffer2;
    }

    private static byte[] getValueFromData(byte[] data, int length, int offset, int count) {
        int num;
        byte[] buffer = new byte[length];
        for (num = 0; num < length; ++num) {
            buffer[num] = 0;
        }
        for (num = 0; num < count; ++num) {
            buffer[length - count + num] = data[offset + num];
        }
        return buffer;
    }

    private static byte[] getValueFromStream(ByteInputStream stream, int length, int count) throws Exception {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = 0;
        }
        if (stream.read(buffer, length - count, count) != count) {
            throw new Exception("Cannot read value beyond end of stream.");
        }
        return buffer;
    }

    public static byte[] readBuffer(int length, ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + length);
        return buffer.getRange(offset, length);
    }

    public static byte[] readBuffer(int length, ByteCollection buffer, int offset) {
        return buffer.getRange(offset, length);
    }

    public static int readBuffer16(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = NetworkBuffer.readBuffer16(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer16(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return NetworkBuffer.fromBuffer16(buffer, offset);
    }

    public static int readBuffer24(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = NetworkBuffer.readBuffer24(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer24(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return NetworkBuffer.fromBuffer24(buffer, offset);
    }

    public static long readBuffer32(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return NetworkBuffer.fromBuffer32(buffer, offset);
    }

    public static long readBuffer32(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readBuffer32(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer40(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return NetworkBuffer.fromBuffer40(buffer, offset);
    }

    public static long readBuffer40(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readBuffer40(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer48(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readBuffer48(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer48(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return NetworkBuffer.fromBuffer48(buffer, offset);
    }

    public static long readBuffer56(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return NetworkBuffer.fromBuffer56(buffer, offset);
    }

    public static long readBuffer56(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readBuffer56(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer64(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return NetworkBuffer.fromBuffer64(buffer, offset);
    }

    public static long readBuffer64(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readBuffer64(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer8(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = NetworkBuffer.readBuffer8(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer8(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return NetworkBuffer.fromBuffer8(buffer, offset);
    }

    public static byte[] readBufferOpaque16(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readBufferOpaque16(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readBufferOpaque16(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        int _var0 = NetworkBuffer.readBuffer16(buffer, offset, offsetPlus);
        byte[] _var1 = NetworkBuffer.readBuffer(_var0, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque24(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readBufferOpaque24(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readBufferOpaque24(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        int _var0 = NetworkBuffer.readBuffer24(buffer, offset, offsetPlus);
        byte[] _var1 = NetworkBuffer.readBuffer(_var0, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque32(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        long _var0 = NetworkBuffer.readBuffer32(buffer, offset, offsetPlus);
        int length = (int)_var0;
        byte[] _var1 = NetworkBuffer.readBuffer(length, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque32(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readBufferOpaque32(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readBufferOpaque8(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        int _var0 = NetworkBuffer.readBuffer8(buffer, offset, offsetPlus);
        byte[] _var1 = NetworkBuffer.readBuffer(_var0, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque8(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readBufferOpaque8(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readData(int length, byte[] data, int offset) {
        return BitAssistant.subArray(data, offset, length);
    }

    public static byte[] readData(int length, byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + length);
        return BitAssistant.subArray(data, offset, length);
    }

    public static int readData16(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return NetworkBuffer.fromData16(data, offset);
    }

    public static int readData16(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = NetworkBuffer.readData16(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readData24(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return NetworkBuffer.fromData24(data, offset);
    }

    public static int readData24(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = NetworkBuffer.readData24(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData32(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return NetworkBuffer.fromData32(data, offset);
    }

    public static long readData32(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readData32(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData40(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return NetworkBuffer.fromData40(data, offset);
    }

    public static long readData40(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readData40(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData48(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readData48(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData48(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return NetworkBuffer.fromData48(data, offset);
    }

    public static long readData56(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readData56(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData56(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return NetworkBuffer.fromData56(data, offset);
    }

    public static long readData64(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return NetworkBuffer.fromData64(data, offset);
    }

    public static long readData64(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = NetworkBuffer.readData64(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readData8(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = NetworkBuffer.readData8(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readData8(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return NetworkBuffer.fromData8(data, offset);
    }

    public static byte[] readDataOpaque16(byte[] data, int offset, IntegerHolder offsetPlus) {
        int _var0 = NetworkBuffer.readData16(data, offset, offsetPlus);
        byte[] _var1 = NetworkBuffer.readData(_var0, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readDataOpaque16(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readDataOpaque16(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque24(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readDataOpaque24(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque24(byte[] data, int offset, IntegerHolder offsetPlus) {
        int _var0 = NetworkBuffer.readData24(data, offset, offsetPlus);
        byte[] _var1 = NetworkBuffer.readData(_var0, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readDataOpaque32(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readDataOpaque32(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque32(byte[] data, int offset, IntegerHolder offsetPlus) {
        long _var0 = NetworkBuffer.readData32(data, offset, offsetPlus);
        int length = (int)_var0;
        byte[] _var1 = NetworkBuffer.readData(length, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readDataOpaque8(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = NetworkBuffer.readDataOpaque8(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque8(byte[] data, int offset, IntegerHolder offsetPlus) {
        int _var0 = NetworkBuffer.readData8(data, offset, offsetPlus);
        byte[] _var1 = NetworkBuffer.readData(_var0, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readStream(int length, ByteInputStream stream) {
        byte[] buffer = new byte[length];
        int count = stream.read(buffer, 0, length);
        if (count != length) {
            buffer = BitAssistant.subArray(buffer, 0, count);
        }
        return buffer;
    }

    public static int readStream16(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream16(stream);
    }

    public static int readStream24(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream24(stream);
    }

    public static long readStream32(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream32(stream);
    }

    public static long readStream40(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream40(stream);
    }

    public static long readStream48(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream48(stream);
    }

    public static long readStream56(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream56(stream);
    }

    public static long readStream64(ByteInputStream stream) throws Exception {
        return NetworkBuffer.fromStream64(stream);
    }

    public static int readStream8(ByteInputStream stream) {
        return NetworkBuffer.fromStream8(stream);
    }

    public static byte[] readStreamOpaque16(ByteInputStream stream) throws Exception {
        int length = NetworkBuffer.readStream16(stream);
        if (length < 0) {
            return null;
        }
        return NetworkBuffer.readStream(length, stream);
    }

    public static byte[] readStreamOpaque24(ByteInputStream stream) throws Exception {
        int length = NetworkBuffer.readStream24(stream);
        if (length < 0) {
            return null;
        }
        return NetworkBuffer.readStream(length, stream);
    }

    public static byte[] readStreamOpaque32(ByteInputStream stream) throws Exception {
        int length = (int)NetworkBuffer.readStream32(stream);
        if (length < 0) {
            return null;
        }
        return NetworkBuffer.readStream(length, stream);
    }

    public static byte[] readStreamOpaque8(ByteInputStream stream) {
        int length = NetworkBuffer.readStream8(stream);
        if (length < 0) {
            return null;
        }
        return NetworkBuffer.readStream(length, stream);
    }

    public static byte[] toBytes16(int value) {
        return Binary.toBytes16(value, false);
    }

    public static byte[] toBytes24(int value) {
        return Binary.toBytes24(value, false);
    }

    public static byte[] toBytes32(long value) {
        return Binary.toBytes32(value, false);
    }

    public static byte[] toBytes40(long value) {
        return Binary.toBytes40(value, false);
    }

    public static byte[] toBytes48(long value) {
        return Binary.toBytes48(value, false);
    }

    public static byte[] toBytes56(long value) {
        return Binary.toBytes56(value, false);
    }

    public static byte[] toBytes64(long value) {
        return Binary.toBytes64(value, false);
    }

    public static byte[] toBytes8(int value) {
        return new byte[]{(byte)value};
    }

    public static void writeBuffer(byte[] value, ByteCollection buffer) {
        buffer.addRange(value);
    }

    public static void writeBuffer16(int value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes16(value), buffer);
    }

    public static void writeBuffer24(int value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes24(value), buffer);
    }

    public static void writeBuffer32(long value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes32(value), buffer);
    }

    public static void writeBuffer40(long value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes40(value), buffer);
    }

    public static void writeBuffer48(long value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes48(value), buffer);
    }

    public static void writeBuffer56(long value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes56(value), buffer);
    }

    public static void writeBuffer64(long value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes64(value), buffer);
    }

    public static void writeBuffer8(int value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer(NetworkBuffer.toBytes8(value), buffer);
    }

    public static void writeBufferOpaque16(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer16(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque24(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer24(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque32(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer32(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque40(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer40(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque48(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer48(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque56(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer56(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque64(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer64(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque8(byte[] value, ByteCollection buffer) {
        NetworkBuffer.writeBuffer8(ArrayExtensions.getLength(value), buffer);
        NetworkBuffer.writeBuffer(value, buffer);
    }

    public static void writeData(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        BitAssistant.copy(value, 0, data, offset, ArrayExtensions.getLength(value));
        offsetPlus.setValue(offset + ArrayExtensions.getLength(value));
    }

    public static void writeData16(int value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes16(value), data, offset, offsetPlus);
    }

    public static void writeData16(int value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData16(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData24(int value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData24(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData24(int value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes24(value), data, offset, offsetPlus);
    }

    public static void writeData32(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes32(value), data, offset, offsetPlus);
    }

    public static void writeData32(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData32(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData40(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes40(value), data, offset, offsetPlus);
    }

    public static void writeData40(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData40(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData48(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData48(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData48(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes48(value), data, offset, offsetPlus);
    }

    public static void writeData56(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData56(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData56(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes56(value), data, offset, offsetPlus);
    }

    public static void writeData64(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData64(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData64(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes64(value), data, offset, offsetPlus);
    }

    public static void writeData8(int value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData(NetworkBuffer.toBytes8(value), data, offset, offsetPlus);
    }

    public static void writeData8(int value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeData8(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque16(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque16(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque16(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData16(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque24(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque24(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque24(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData24(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque32(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData32(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque32(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque32(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque40(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData40(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque40(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque40(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque48(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData48(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque48(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque48(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque56(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData56(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque56(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque56(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque64(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData64(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque64(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque64(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque8(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        NetworkBuffer.writeData8(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        NetworkBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque8(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        NetworkBuffer.writeDataOpaque8(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeStream(byte[] value, ByteOutputStream stream) {
        stream.writeBuffer(value);
    }

    public static void writeStream16(int value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes16(value), stream);
    }

    public static void writeStream24(int value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes24(value), stream);
    }

    public static void writeStream32(long value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes32(value), stream);
    }

    public static void writeStream40(long value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes40(value), stream);
    }

    public static void writeStream48(long value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes48(value), stream);
    }

    public static void writeStream56(long value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes56(value), stream);
    }

    public static void writeStream64(long value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes64(value), stream);
    }

    public static void writeStream8(int value, ByteOutputStream stream) {
        NetworkBuffer.writeStream(NetworkBuffer.toBytes8(value), stream);
    }

    public static void writeStreamOpaque16(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream16(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque24(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream24(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque32(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream32(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque40(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream40(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque48(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream48(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque56(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream56(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque64(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream64(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque8(byte[] value, ByteOutputStream stream) {
        NetworkBuffer.writeStream8(ArrayExtensions.getLength(value), stream);
        NetworkBuffer.writeStream(value, stream);
    }
}

