/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.LogLevel;
import fm.LogProvider;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ConsoleLogProvider
extends LogProvider {
    public ConsoleLogProvider() {
        this(LogLevel.Warn);
    }

    public ConsoleLogProvider(LogLevel level) {
        this.setLevel(level);
    }

    @Override
    public void writeLine(String text) {
        System.out.print(text + "\n");
    }

    @Override
    protected void log(LogLevel level, String message) {
        this.writeLine(String.format("%s %s", LogProvider.getPrefix(level, true), message));
    }

    @Override
    protected void log(LogLevel level, String message, Exception ex) {
        StringWriter trace = new StringWriter();
        ex.printStackTrace(new PrintWriter(trace));
        this.log(level, String.format("%s\n%s", message, trace.toString()));
    }
}

