/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Error;
import fm.icelink.Holder;
import fm.icelink.IAudioOutput;
import fm.icelink.IMediaOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.ParseAssistant;
import fm.icelink.SoundUtility;
import fm.icelink.StringExtensions;
import fm.icelink.opus.Format;
import fm.icelink.opus.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MaxPacketTimeAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.PacketTimeAttribute;
import fm.icelink.sdp.rtp.MapAttribute;
import java.util.ArrayList;

public class Decoder
extends AudioDecoder {
    private ArrayList<AudioBuffer> __decodedBuffers;
    private Native __decoder;
    private double __packetTime = -1.0;

    private AudioBuffer decode(AudioBuffer encodedFrame, boolean fec) {
        AudioBuffer buffer = this.__decoder.decode(encodedFrame, (AudioFormat)super.getOutputFormat(), fec);
        if (buffer != null) {
            buffer.getDataBuffer().setLittleEndian(((AudioFormat)super.getOutputFormat()).getLittleEndian());
            return buffer;
        }
        return null;
    }

    private ArrayList<AudioBuffer> decode(AudioFrame frame, AudioBuffer encodedBuffer, AudioFormat outputFormat) {
        AudioBuffer item;
        if (encodedBuffer == null) {
            return null;
        }
        if (this.__decoder == null) {
            if (this.__packetTime == -1.0) {
                this.__packetTime = frame.getDuration() > 0 ? (double)frame.getDuration() : 20.0;
            }
            this.__decoder = new Native(false, super.getConfig().getClockRate(), super.getConfig().getChannelCount(), this.__packetTime);
        }
        if (this.__decodedBuffers == null) {
            this.__decodedBuffers = new ArrayList();
        }
        this.__decodedBuffers.clear();
        int num = 0;
        if (super.getMissingDuration() > 0 && (item = this.decodeFec(encodedBuffer)) != null) {
            num = SoundUtility.calculateDuration((int)item.getDataBuffer().getLength(), (AudioConfig)super.getConfig());
            if (Log.getIsVerboseEnabled()) {
                Log.verbose((String)StringExtensions.format((String)"Opus decoder recovered {0}ms of audio using forward error correction (FEC).", (Object)IntegerExtensions.toString((Integer)num)));
            }
            super.setMissingDuration(super.getMissingDuration() - num);
            this.__decodedBuffers.add(item);
        }
        double num2 = 0.0;
        while (super.getMissingDuration() > 0) {
            AudioBuffer buffer2 = this.decodePlc();
            if (buffer2 == null) {
                buffer2 = super.generatePlc(super.getMissingDuration());
            }
            int num3 = SoundUtility.calculateDuration((int)buffer2.getDataBuffer().getLength(), (AudioConfig)super.getConfig());
            if (Log.getIsVerboseEnabled()) {
                Log.verbose((String)StringExtensions.format((String)"Opus decoder generated {0}ms of audio using packet loss concealment (PLC).", (Object)IntegerExtensions.toString((Integer)num3)));
            }
            super.setMissingDuration(super.getMissingDuration() - num3);
            num2 += (double)num3;
            ArrayListExtensions.insert(this.__decodedBuffers, (int)0, (Object)buffer2);
        }
        this.__decodedBuffers.add(this.decodeNormal(encodedBuffer));
        return this.__decodedBuffers;
    }

    private AudioBuffer decodeFec(AudioBuffer encodedFrame) {
        AudioBuffer buffer = this.decode(encodedFrame, true);
        if (buffer != null) {
            buffer.setRecoveredByFec(true);
        }
        return buffer;
    }

    private AudioBuffer decodeNormal(AudioBuffer encodedFrame) {
        return this.decode(encodedFrame, false);
    }

    private AudioBuffer decodePlc() {
        AudioBuffer buffer = this.decode(null, false);
        if (buffer != null) {
            buffer.setGeneratedByPlc(true);
        }
        return buffer;
    }

    public Decoder() {
        this(new Format().getConfig());
    }

    public Decoder(IAudioOutput input) {
        this(input.getConfig());
        super.addInput((IMediaOutput)input);
    }

    public Decoder(AudioConfig config) {
        super((AudioFormat)new Format(config), (AudioFormat)new fm.icelink.pcm.Format(config));
        super.setDisablePlc(true);
    }

    protected void doDestroy() {
        if (this.__decoder != null) {
            this.__decoder.destroy();
            this.__decoder = null;
        }
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        ArrayList<AudioBuffer> list = this.decode(frame, inputBuffer, (AudioFormat)super.getOutputFormat());
        if (list != null) {
            for (AudioBuffer buffer : list) {
                if (buffer == null) continue;
                AudioFrame frame2 = ArrayListExtensions.getCount(list) == 1 ? frame : frame.clone();
                frame2.addBuffer((MediaBuffer)buffer);
                this.raiseFrame(frame2);
            }
            for (AudioBuffer buffer : list) {
                if (buffer == null) continue;
                buffer.getDataBuffer().free();
            }
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        MapAttribute attribute = mediaDescription.getRtpMapAttribute(((AudioFormat)super.getInputFormat()).getName(), ((AudioFormat)super.getInputFormat()).getClockRate(), ((AudioFormat)super.getInputFormat()).getParameters());
        if (attribute != null) {
            FormatParametersAttribute relatedFormatParametersAttribute = attribute.getRelatedFormatParametersAttribute();
            if (isLocalDescription) {
                if (relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(attribute.getPayloadType());
                    attribute.setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                relatedFormatParametersAttribute.setFormatSpecificParameter("useinbandfec", "1");
            } else {
                int intResult = 10;
                if (relatedFormatParametersAttribute != null) {
                    String str = null;
                    Holder _var0 = new Holder(str);
                    boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("minptime", _var0);
                    str = (String)_var0.getValue();
                    IntegerHolder _var2 = new IntegerHolder(intResult);
                    boolean _var3 = ParseAssistant.tryParseIntegerValue((String)str, (IntegerHolder)_var2);
                    intResult = _var2.getValue();
                    if (_var1 && !_var3) {
                        intResult = 10;
                    }
                }
                int packetTime = 20;
                PacketTimeAttribute packetTimeAttribute = mediaDescription.getPacketTimeAttribute();
                if (packetTimeAttribute != null) {
                    packetTime = packetTimeAttribute.getPacketTime();
                }
                int maxPacketTime = 60;
                MaxPacketTimeAttribute maxPacketTimeAttribute = mediaDescription.getMaxPacketTimeAttribute();
                if (maxPacketTimeAttribute != null) {
                    maxPacketTime = maxPacketTimeAttribute.getMaxPacketTime();
                }
                this.__packetTime = packetTime;
            }
        }
        return null;
    }

    public String getLabel() {
        return "Opus Decoder";
    }
}

