/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.BitAssistant;
import fm.icelink.DateExtensions;
import fm.icelink.EcdsaCrypto;
import fm.icelink.EcdsaKey;
import fm.icelink.EcdsaNamedCurve;
import fm.icelink.Encoding;
import fm.icelink.Global;
import fm.icelink.Holder;
import fm.icelink.LongExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringExtensions;
import fm.icelink.UnixTimestamp;
import fm.icelink.callstats.DataJwtClaim;
import fm.icelink.callstats.DataJwtHeader;
import java.util.Date;

abstract class Utility {
    Utility() {
    }

    static byte[] base64UrlDecode(String input) {
        String s = input;
        int _var0 = StringExtensions.getLength((String)(s = s.replace("-", "+").replace("_", "/"))) % 4;
        if (_var0 != 0) {
            if (_var0 == 2) {
                s = StringExtensions.concat((String)s, (String)"==");
            } else if (_var0 == 3) {
                s = StringExtensions.concat((String)s, (String)"=");
            } else {
                throw new RuntimeException(new Exception("Illegal base64url string!"));
            }
        }
        return Base64.decode((String)s);
    }

    static String base64UrlEncode(byte[] input) {
        String str = StringExtensions.split((String)Base64.encode((byte[])input), (char[])new char[]{'='})[0];
        return str.replace("+", "-").replace("/", "_");
    }

    static Date callStatsMillisToDateTime(String unixTimeStamp) {
        return UnixTimestamp.unixMillisToDateTime((long)ParseAssistant.parseLongValue((String)StringExtensions.split((String)unixTimeStamp, (char[])new char[]{'.'})[0]));
    }

    static String dateTimeToCallStatsMillis(Date datetime) {
        return StringExtensions.concat((String)LongExtensions.toString((Long)UnixTimestamp.dateTimeToUnixMillis((Date)datetime)), (String)".000");
    }

    static boolean isExpired(String jwtToken) {
        String str;
        if (!StringExtensions.isNullOrEmpty((String)jwtToken) && !StringExtensions.isNullOrEmpty((String)(str = StringExtensions.split((String)jwtToken, (char[])new char[]{'.'})[1]))) {
            DataJwtClaim claim = DataJwtClaim.fromJson(Encoding.getUtf8().getString(Utility.base64UrlDecode(str)));
            return UnixTimestamp.dateTimeToUnix((Date)DateExtensions.getUtcNow()) >= claim.getExpiry();
        }
        return true;
    }

    static String signJWT(EcdsaKey privateKey, DataJwtClaim claim) {
        String str2;
        try {
            DataJwtHeader header2 = new DataJwtHeader();
            header2.setAlgorithm("ES256");
            header2.setType("JWT");
            DataJwtHeader request = header2;
            byte[] bytes = Encoding.getUtf8().getBytes(DataJwtHeader.toJson(request));
            byte[] input = Encoding.getUtf8().getBytes(DataJwtClaim.toJson(claim));
            String s = StringExtensions.concat((String)Utility.base64UrlEncode(bytes), (String)".", (String)Utility.base64UrlEncode(input));
            byte[] data = Encoding.getUtf8().getBytes(s);
            if (privateKey == null || !privateKey.hasPrivate()) {
                throw new RuntimeException(new Exception("Private key is missing."));
            }
            if (!Global.equals((Object)privateKey.getNamedCurve(), (Object)EcdsaNamedCurve.P256)) {
                throw new RuntimeException(new Exception("Unsupported named curve."));
            }
            byte[] signature = EcdsaCrypto.sign((byte[])data, (EcdsaKey)privateKey);
            byte[] r = null;
            byte[] buffer6 = null;
            Holder _var0 = new Holder(r);
            Holder _var1 = new Holder(buffer6);
            boolean _var2 = EcdsaKey.parseSignature((byte[])signature, (Holder)_var0, (Holder)_var1);
            r = (byte[])_var0.getValue();
            buffer6 = (byte[])_var1.getValue();
            if (!_var2) {
                throw new RuntimeException(new Exception("Invalid signature."));
            }
            byte[] destination = new byte[ArrayExtensions.getLength((byte[])r) + ArrayExtensions.getLength((byte[])buffer6)];
            BitAssistant.copy((byte[])r, (int)0, (byte[])destination, (int)0, (int)ArrayExtensions.getLength((byte[])r));
            BitAssistant.copy((byte[])buffer6, (int)0, (byte[])destination, (int)ArrayExtensions.getLength((byte[])r), (int)ArrayExtensions.getLength((byte[])buffer6));
            str2 = StringExtensions.concat((String)s, (String)".", (String)Utility.base64UrlEncode(destination));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return str2;
    }
}

