/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum EventType {
    User_Action_Join_Conference(1),
    User_Action_Alive(2),
    User_Action_Details(3),
    User_Action_Left(4),
    User_Media_ConnectedDevices(5),
    User_Media_Actions(6),
    Fabric_Setup(7),
    Fabric_Setup_Failed(8),
    Fabric_Terminated(9),
    Fabric_State_Change(10),
    Fabric_Dropped(11),
    Fabric_Action(12),
    Stats_Conference(13),
    Stats_System(14),
    Special_Feedback(15),
    Special_Dominant_Speaker(16),
    SSRC_Map(17),
    SDP(18);

    private final int value;
    private static final Map<Integer, EventType> lookup;

    private EventType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static EventType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, EventType>();
        for (EventType s : EnumSet.allOf(EventType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

