/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.CandidatePairState;
import fm.icelink.CandidateType;
import fm.icelink.CodecType;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableDouble;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import fm.icelink.ProtocolType;
import fm.icelink.callstats.Utility;
import java.util.Date;
import java.util.HashMap;

class DataStatsCSStatistics {
    private NullableLong _audioLevel = new NullableLong();
    private NullableLong _bytesReceived = new NullableLong();
    private NullableLong _bytesSent = new NullableLong();
    private CandidateType _candidateType;
    private NullableInteger _clockRate = new NullableInteger();
    private String _codecId;
    private CodecType _codecType;
    private NullableLong _consentRequestsSent = new NullableLong();
    private String _csId;
    private Date _csTimestamp = new Date();
    private String _csType;
    private NullableDouble _currentRoundTripTime = new NullableDouble();
    private NullableLong _firCount = new NullableLong();
    private NullableInteger _fractionLost = new NullableInteger();
    private NullableInteger _frameHeight = new NullableInteger();
    private NullableLong _framesDecoded = new NullableLong();
    private NullableLong _framesDropped = new NullableLong();
    private NullableLong _framesReceived = new NullableLong();
    private NullableLong _framesSent = new NullableLong();
    private NullableInteger _frameWidth = new NullableInteger();
    private String _ip;
    private NullableBoolean _isRemote = new NullableBoolean();
    private NullableInteger _jitter = new NullableInteger();
    private String _kind;
    private String _localCandidateId;
    private String _localCertificateId;
    private String _mediaType;
    private String _mimeType;
    private NullableLong _nackCount = new NullableLong();
    private NullableBoolean _nominated = new NullableBoolean();
    private NullableLong _packetsLost = new NullableLong();
    private NullableLong _packetsReceived = new NullableLong();
    private NullableLong _packetsSent = new NullableLong();
    private NullableInteger _payloadType = new NullableInteger();
    private NullableLong _pliCount = new NullableLong();
    private NullableInteger _port = new NullableInteger();
    private NullableLong _priority = new NullableLong();
    private ProtocolType _protocolType;
    private NullableLong _qpSum = new NullableLong();
    private String _remoteCandidateId;
    private String _remoteCertificateId;
    private NullableLong _requestsReceived = new NullableLong();
    private NullableLong _requestsSent = new NullableLong();
    private NullableLong _responsesReceived = new NullableLong();
    private NullableLong _responsesSent = new NullableLong();
    private String _selectedCandidatePairId;
    private NullableLong _sliCount = new NullableLong();
    private NullableLong _ssrc = new NullableLong();
    private CandidatePairState _state;
    private NullableDouble _totalRoundTripTime = new NullableDouble();
    private String _trackId;
    private String _transportId;

    private String candidatePairStateToString(CandidatePairState type) {
        CandidatePairState _var0 = type;
        if (_var0 == CandidatePairState.New) {
            return "new";
        }
        if (_var0 == CandidatePairState.Waiting) {
            return "waiting";
        }
        if (_var0 == CandidatePairState.InProgress) {
            return "inprogress";
        }
        if (_var0 == CandidatePairState.Succeeded) {
            return "succeeded";
        }
        if (_var0 == CandidatePairState.Failed) {
            return "failed";
        }
        if (_var0 == CandidatePairState.Closed) {
            return "closed";
        }
        if (_var0 == CandidatePairState.ConnectivityLost) {
            return "connectivityLost";
        }
        return "unknown";
    }

    private String candidateTypeToString(CandidateType type) {
        CandidateType _var0 = type;
        if (_var0 == CandidateType.Host) {
            return "host";
        }
        if (_var0 == CandidateType.ServerReflexive) {
            return "serverReflexive";
        }
        if (_var0 == CandidateType.Relayed) {
            return "relayed";
        }
        if (_var0 == CandidateType.PeerReflexive) {
            return "peerReflexive";
        }
        if (_var0 == CandidateType.Unknown) {
            return "unknown";
        }
        return "unknown";
    }

    private String codecTypeToString(CodecType type) {
        CodecType _var0 = type;
        if (_var0 == CodecType.Encode) {
            return "encode";
        }
        if (_var0 == CodecType.Decode) {
            return "decode";
        }
        return null;
    }

    public NullableLong getAudioLevel() {
        return this._audioLevel;
    }

    public NullableLong getBytesReceived() {
        return this._bytesReceived;
    }

    public NullableLong getBytesSent() {
        return this._bytesSent;
    }

    CandidateType getCandidateType() {
        return this._candidateType;
    }

    NullableInteger getClockRate() {
        return this._clockRate;
    }

    String getCodecId() {
        return this._codecId;
    }

    CodecType getCodecType() {
        return this._codecType;
    }

    public NullableLong getConsentRequestsSent() {
        return this._consentRequestsSent;
    }

    public String getCsId() {
        return this._csId;
    }

    public Date getCsTimestamp() {
        return this._csTimestamp;
    }

    String getCsType() {
        return this._csType;
    }

    public NullableDouble getCurrentRoundTripTime() {
        return this._currentRoundTripTime;
    }

    NullableLong getFirCount() {
        return this._firCount;
    }

    NullableInteger getFractionLost() {
        return this._fractionLost;
    }

    public NullableInteger getFrameHeight() {
        return this._frameHeight;
    }

    public NullableLong getFramesDecoded() {
        return this._framesDecoded;
    }

    public NullableLong getFramesDropped() {
        return this._framesDropped;
    }

    public NullableLong getFramesReceived() {
        return this._framesReceived;
    }

    public NullableLong getFramesSent() {
        return this._framesSent;
    }

    public NullableInteger getFrameWidth() {
        return this._frameWidth;
    }

    public String getIP() {
        return this._ip;
    }

    NullableBoolean getIsRemote() {
        return this._isRemote;
    }

    NullableInteger getJitter() {
        return this._jitter;
    }

    public String getKind() {
        return this._kind;
    }

    public String getLocalCandidateId() {
        return this._localCandidateId;
    }

    public String getLocalCertificateId() {
        return this._localCertificateId;
    }

    String getMediaType() {
        return this._mediaType;
    }

    String getMimeType() {
        return this._mimeType;
    }

    NullableLong getNackCount() {
        return this._nackCount;
    }

    public NullableBoolean getNominated() {
        return this._nominated;
    }

    NullableLong getPacketsLost() {
        return this._packetsLost;
    }

    NullableLong getPacketsReceived() {
        return this._packetsReceived;
    }

    NullableLong getPacketsSent() {
        return this._packetsSent;
    }

    NullableInteger getPayloadType() {
        return this._payloadType;
    }

    NullableLong getPliCount() {
        return this._pliCount;
    }

    NullableInteger getPort() {
        return this._port;
    }

    NullableLong getPriority() {
        return this._priority;
    }

    ProtocolType getProtocolType() {
        return this._protocolType;
    }

    NullableLong getQpSum() {
        return this._qpSum;
    }

    public String getRemoteCandidateId() {
        return this._remoteCandidateId;
    }

    public String getRemoteCertificateId() {
        return this._remoteCertificateId;
    }

    public NullableLong getRequestsReceived() {
        return this._requestsReceived;
    }

    public NullableLong getRequestsSent() {
        return this._requestsSent;
    }

    public NullableLong getResponsesReceived() {
        return this._responsesReceived;
    }

    public NullableLong getResponsesSent() {
        return this._responsesSent;
    }

    public String getSelectedCandidatePairId() {
        return this._selectedCandidatePairId;
    }

    NullableLong getSliCount() {
        return this._sliCount;
    }

    NullableLong getSsrc() {
        return this._ssrc;
    }

    public CandidatePairState getState() {
        return this._state;
    }

    public NullableDouble getTotalRoundTripTime() {
        return this._totalRoundTripTime;
    }

    String getTrackId() {
        return this._trackId;
    }

    String getTransportId() {
        return this._transportId;
    }

    private String protocolTypeToString(ProtocolType type) {
        ProtocolType _var0 = type;
        if (_var0 == ProtocolType.Udp) {
            return "udp";
        }
        if (_var0 == ProtocolType.Tcp) {
            return "tcp";
        }
        if (_var0 == ProtocolType.Tls) {
            return "tls";
        }
        if (_var0 == ProtocolType.Unknown) {
            return "unknown";
        }
        return "unknown";
    }

    void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        if (this.getCsType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"type", (Object)JsonSerializer.serializeString((String)this.getCsType()));
        }
        if (this.getPriority().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"priority", (Object)JsonSerializer.serializeLong((NullableLong)this.getPriority()));
        }
        if (this.getTransportId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"transportId", (Object)JsonSerializer.serializeString((String)this.getTransportId()));
        }
        if (this.getIsRemote().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"isRemote", (Object)JsonSerializer.serializeBoolean((NullableBoolean)this.getIsRemote()));
        }
        if (this.getIP() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"ip", (Object)JsonSerializer.serializeString((String)this.getIP()));
        }
        if (this.getPort().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"port", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getPort()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"protocol", (Object)JsonSerializer.serializeString((String)this.protocolTypeToString(this.getProtocolType())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"candidateType", (Object)JsonSerializer.serializeString((String)this.candidateTypeToString(this.getCandidateType())));
        if (this.getLocalCandidateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"localCandidateId", (Object)JsonSerializer.serializeString((String)this.getLocalCandidateId()));
        }
        if (this.getRemoteCandidateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"remoteCandidateId", (Object)JsonSerializer.serializeString((String)this.getRemoteCandidateId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"state", (Object)JsonSerializer.serializeString((String)this.candidatePairStateToString(this.getState())));
        if (this.getNominated().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"nominated", (Object)JsonSerializer.serializeBoolean((NullableBoolean)this.getNominated()));
        }
        if (this.getBytesSent().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"bytesSent", (Object)JsonSerializer.serializeLong((NullableLong)this.getBytesSent()));
        }
        if (this.getBytesReceived().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"bytesReceived", (Object)JsonSerializer.serializeLong((NullableLong)this.getBytesReceived()));
        }
        if (this.getTotalRoundTripTime().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"totalRoundTripTime", (Object)JsonSerializer.serializeDouble((NullableDouble)this.getTotalRoundTripTime()));
        }
        if (this.getCurrentRoundTripTime().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"currentRoundTripTime", (Object)JsonSerializer.serializeDouble((NullableDouble)this.getCurrentRoundTripTime()));
        }
        if (this.getRequestsReceived().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"requestsReceived", (Object)JsonSerializer.serializeLong((NullableLong)this.getRequestsReceived()));
        }
        if (this.getRequestsSent().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"requestsSent", (Object)JsonSerializer.serializeLong((NullableLong)this.getRequestsSent()));
        }
        if (this.getResponsesReceived().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"responsesReceived", (Object)JsonSerializer.serializeLong((NullableLong)this.getResponsesReceived()));
        }
        if (this.getResponsesSent().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"responsesSent", (Object)JsonSerializer.serializeLong((NullableLong)this.getResponsesSent()));
        }
        if (this.getConsentRequestsSent().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"consentRequestsSent", (Object)JsonSerializer.serializeLong((NullableLong)this.getConsentRequestsSent()));
        }
        if (this.getKind() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"kind", (Object)JsonSerializer.serializeString((String)this.getKind()));
        }
        if (this.getFramesReceived().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesReceived", (Object)JsonSerializer.serializeLong((NullableLong)this.getFramesReceived()));
        }
        if (this.getFramesDecoded().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesDecoded", (Object)JsonSerializer.serializeLong((NullableLong)this.getFramesDecoded()));
        }
        if (this.getFramesDropped().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesDropped", (Object)JsonSerializer.serializeLong((NullableLong)this.getFramesDropped()));
        }
        if (this.getAudioLevel().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"audioLevel", (Object)JsonSerializer.serializeLong((NullableLong)this.getAudioLevel()));
        }
        if (this.getFrameWidth().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"frameWidth", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getFrameWidth()));
        }
        if (this.getFrameHeight().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"frameHeight", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getFrameHeight()));
        }
        if (this.getFramesSent().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesSent", (Object)JsonSerializer.serializeLong((NullableLong)this.getFramesSent()));
        }
        if (this.getSsrc().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"ssrc", (Object)JsonSerializer.serializeLong((NullableLong)this.getSsrc()));
        }
        if (this.getMediaType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"mediaType", (Object)JsonSerializer.serializeString((String)this.getMediaType()));
        }
        if (this.getTrackId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"trackId", (Object)JsonSerializer.serializeString((String)this.getTrackId()));
        }
        if (this.getCodecId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"codecId", (Object)JsonSerializer.serializeString((String)this.getCodecId()));
        }
        if (this.getPacketsLost().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"packetsLost", (Object)JsonSerializer.serializeLong((NullableLong)this.getPacketsLost()));
        }
        if (this.getJitter().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"jitter", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getJitter()));
        }
        if (this.getPacketsReceived().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"packetsReceived", (Object)JsonSerializer.serializeLong((NullableLong)this.getPacketsReceived()));
        }
        if (this.getFractionLost().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"fractionLost", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getFractionLost()));
        }
        if (this.getFirCount().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"firCount", (Object)JsonSerializer.serializeLong((NullableLong)this.getFirCount()));
        }
        if (this.getPliCount().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"pliCount", (Object)JsonSerializer.serializeLong((NullableLong)this.getPliCount()));
        }
        if (this.getNackCount().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"nackCount", (Object)JsonSerializer.serializeLong((NullableLong)this.getNackCount()));
        }
        if (this.getQpSum().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"qpSum", (Object)JsonSerializer.serializeLong((NullableLong)this.getQpSum()));
        }
        if (this.getSliCount().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"sliCount", (Object)JsonSerializer.serializeLong((NullableLong)this.getSliCount()));
        }
        if (this.getPacketsSent().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"packetsSent", (Object)JsonSerializer.serializeLong((NullableLong)this.getPacketsSent()));
        }
        if (this.getSelectedCandidatePairId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"selectedCandidatePairId", (Object)JsonSerializer.serializeString((String)this.getSelectedCandidatePairId()));
        }
        if (this.getLocalCertificateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"localCertificateId", (Object)JsonSerializer.serializeString((String)this.getLocalCertificateId()));
        }
        if (this.getRemoteCertificateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"remoteCertificateId", (Object)JsonSerializer.serializeString((String)this.getRemoteCertificateId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"codecType", (Object)JsonSerializer.serializeString((String)this.codecTypeToString(this.getCodecType())));
        if (this.getPayloadType().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"payloadType", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getPayloadType()));
        }
        if (this.getMimeType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"mimeType", (Object)JsonSerializer.serializeString((String)this.getMimeType()));
        }
        if (this.getClockRate().getHasValue()) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"clockRate", (Object)JsonSerializer.serializeInteger((NullableInteger)this.getClockRate()));
        }
    }

    public void setAudioLevel(NullableLong value) {
        this._audioLevel = value;
    }

    void setBytesReceived(NullableLong value) {
        this._bytesReceived = value;
    }

    void setBytesSent(NullableLong value) {
        this._bytesSent = value;
    }

    void setCandidateType(CandidateType value) {
        this._candidateType = value;
    }

    void setClockRate(NullableInteger value) {
        this._clockRate = value;
    }

    void setCodecId(String value) {
        this._codecId = value;
    }

    void setCodecType(CodecType value) {
        this._codecType = value;
    }

    public void setConsentRequestsSent(NullableLong value) {
        this._consentRequestsSent = value;
    }

    public void setCsId(String value) {
        this._csId = value;
    }

    public void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    void setCsType(String value) {
        this._csType = value;
    }

    void setCurrentRoundTripTime(NullableDouble value) {
        this._currentRoundTripTime = value;
    }

    void setFirCount(NullableLong value) {
        this._firCount = value;
    }

    void setFractionLost(NullableInteger value) {
        this._fractionLost = value;
    }

    public void setFrameHeight(NullableInteger value) {
        this._frameHeight = value;
    }

    public void setFramesDecoded(NullableLong value) {
        this._framesDecoded = value;
    }

    public void setFramesDropped(NullableLong value) {
        this._framesDropped = value;
    }

    public void setFramesReceived(NullableLong value) {
        this._framesReceived = value;
    }

    public void setFramesSent(NullableLong value) {
        this._framesSent = value;
    }

    public void setFrameWidth(NullableInteger value) {
        this._frameWidth = value;
    }

    public void setIP(String value) {
        this._ip = value;
    }

    void setIsRemote(NullableBoolean value) {
        this._isRemote = value;
    }

    void setJitter(NullableInteger value) {
        this._jitter = value;
    }

    public void setKind(String value) {
        this._kind = value;
    }

    void setLocalCandidateId(String value) {
        this._localCandidateId = value;
    }

    public void setLocalCertificateId(String value) {
        this._localCertificateId = value;
    }

    void setMediaType(String value) {
        this._mediaType = value;
    }

    void setMimeType(String value) {
        this._mimeType = value;
    }

    void setNackCount(NullableLong value) {
        this._nackCount = value;
    }

    void setNominated(NullableBoolean value) {
        this._nominated = value;
    }

    void setPacketsLost(NullableLong value) {
        this._packetsLost = value;
    }

    void setPacketsReceived(NullableLong value) {
        this._packetsReceived = value;
    }

    void setPacketsSent(NullableLong value) {
        this._packetsSent = value;
    }

    void setPayloadType(NullableInteger value) {
        this._payloadType = value;
    }

    void setPliCount(NullableLong value) {
        this._pliCount = value;
    }

    void setPort(NullableInteger value) {
        this._port = value;
    }

    void setPriority(NullableLong value) {
        this._priority = value;
    }

    void setProtocolType(ProtocolType value) {
        this._protocolType = value;
    }

    void setQpSum(NullableLong value) {
        this._qpSum = value;
    }

    void setRemoteCandidateId(String value) {
        this._remoteCandidateId = value;
    }

    public void setRemoteCertificateId(String value) {
        this._remoteCertificateId = value;
    }

    public void setRequestsReceived(NullableLong value) {
        this._requestsReceived = value;
    }

    public void setRequestsSent(NullableLong value) {
        this._requestsSent = value;
    }

    public void setResponsesReceived(NullableLong value) {
        this._responsesReceived = value;
    }

    public void setResponsesSent(NullableLong value) {
        this._responsesSent = value;
    }

    public void setSelectedCandidatePairId(String value) {
        this._selectedCandidatePairId = value;
    }

    void setSliCount(NullableLong value) {
        this._sliCount = value;
    }

    void setSsrc(NullableLong value) {
        this._ssrc = value;
    }

    void setState(CandidatePairState value) {
        this._state = value;
    }

    void setTotalRoundTripTime(NullableDouble value) {
        this._totalRoundTripTime = value;
    }

    void setTrackId(String value) {
        this._trackId = value;
    }

    void setTransportId(String value) {
        this._transportId = value;
    }

    static String toJson(DataStatsCSStatistics iceCandidateStats) {
        return JsonSerializer.serializeObject((Object)iceCandidateStats, (IAction2)new IAction2<DataStatsCSStatistics, HashMap<String, String>>(){

            public void invoke(DataStatsCSStatistics obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    String toJson() {
        return DataStatsCSStatistics.toJson(this);
    }

    static String toJsonArray(DataStatsCSStatistics[] iceCandidateStats) {
        return JsonSerializer.serializeObjectArray((Object[])iceCandidateStats, (IFunction1)new IFunctionDelegate1<DataStatsCSStatistics, String>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSStatistics.toJson";
            }

            public String invoke(DataStatsCSStatistics iceCandidateStats) {
                return DataStatsCSStatistics.toJson(iceCandidateStats);
            }
        });
    }
}

