/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.HashMapExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableLong;
import fm.icelink.callstats.Utility;
import java.util.Date;
import java.util.HashMap;

abstract class DataStatsCSMediaTrackStats {
    private String _csId;
    private Date _csTimestamp = new Date();
    private long _framesDecoded;
    private long _framesDropped;
    private long _framesReceived;
    private String _kind;
    private String _type;

    protected DataStatsCSMediaTrackStats() {
    }

    protected void deserializeProperties(String key, String valueJson) {
        String _var0 = key;
        if (_var0.equals("id")) {
            this.setCsId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("timestamp")) {
            this.setCsTimestamp(Utility.callStatsMillisToDateTime(valueJson));
        } else if (_var0.equals("type")) {
            this.setType(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("kind")) {
            this.setKind(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("framesReceived")) {
            this.setFramesReceived(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("framesDecoded")) {
            this.setFramesDecoded(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("framesDropped")) {
            this.setFramesDropped(JsonSerializer.deserializeLong((String)valueJson).getValue());
        }
    }

    public String getCsId() {
        return this._csId;
    }

    public Date getCsTimestamp() {
        return this._csTimestamp;
    }

    public long getFramesDecoded() {
        return this._framesDecoded;
    }

    public long getFramesDropped() {
        return this._framesDropped;
    }

    public long getFramesReceived() {
        return this._framesReceived;
    }

    public String getKind() {
        return this._kind;
    }

    public String getType() {
        return this._type;
    }

    protected void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        if (this.getType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"type", (Object)JsonSerializer.serializeString((String)this.getType()));
        }
        if (this.getKind() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"kind", (Object)JsonSerializer.serializeString((String)this.getKind()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesReceived", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getFramesReceived())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesDecoded", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getFramesDecoded())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"framesDropped", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getFramesDropped())));
    }

    public void setCsId(String value) {
        this._csId = value;
    }

    public void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    public void setFramesDecoded(long value) {
        this._framesDecoded = value;
    }

    public void setFramesDropped(long value) {
        this._framesDropped = value;
    }

    public void setFramesReceived(long value) {
        this._framesReceived = value;
    }

    public void setKind(String value) {
        this._kind = value;
    }

    public void setType(String value) {
        this._type = value;
    }
}

