/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.CodecType;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableInteger;
import fm.icelink.callstats.Utility;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class DataStatsCSCodecStats {
    private int _clockRate;
    private CodecType _codecType;
    private String _csId;
    private Date _csTimestamp = new Date();
    private String _mimeType;
    private int _payloadType;
    private String _type;

    private CodecType codecTypeFromString(String typeString) {
        String _var0 = typeString;
        if (_var0.equals("udp")) {
            return CodecType.Encode;
        }
        if (_var0.equals("tcp")) {
            return CodecType.Decode;
        }
        return CodecType.Encode;
    }

    private String codecTypeToString(CodecType type) {
        CodecType _var0 = type;
        if (_var0 == CodecType.Encode) {
            return "encode";
        }
        if (_var0 == CodecType.Decode) {
            return "decode";
        }
        return null;
    }

    void deserializeProperties(String key, String valueJson) {
        String str = key;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"id")) {
                if (Global.equals((Object)str, (Object)"timestamp")) {
                    this.setCsTimestamp(Utility.callStatsMillisToDateTime(valueJson));
                } else if (Global.equals((Object)str, (Object)"type")) {
                    this.setType(JsonSerializer.deserializeString((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"payloadType")) {
                    this.setPayloadType(JsonSerializer.deserializeInteger((String)valueJson).getValue());
                } else if (Global.equals((Object)str, (Object)"mimeType")) {
                    this.setMimeType(JsonSerializer.deserializeString((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"clockRate")) {
                    this.setClockRate(JsonSerializer.deserializeInteger((String)valueJson).getValue());
                }
            } else {
                this.setCsId(JsonSerializer.deserializeString((String)valueJson));
            }
        }
    }

    static DataStatsCSCodecStats fromJson(String csCodecStatsJson) {
        return (DataStatsCSCodecStats)JsonSerializer.deserializeObject((String)csCodecStatsJson, (IFunction0)new IFunction0<DataStatsCSCodecStats>(){

            public DataStatsCSCodecStats invoke() {
                return new DataStatsCSCodecStats();
            }
        }, (IAction3)new IAction3<DataStatsCSCodecStats, String, String>(){

            public void invoke(DataStatsCSCodecStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    static DataStatsCSCodecStats[] fromJsonArray(String csCodecStatsJson) {
        ArrayList list = JsonSerializer.deserializeObjectArray((String)csCodecStatsJson, (IFunction1)new IFunctionDelegate1<String, DataStatsCSCodecStats>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSCodecStats.fromJson";
            }

            public DataStatsCSCodecStats invoke(String csCodecStatsJson) {
                return DataStatsCSCodecStats.fromJson(csCodecStatsJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new DataStatsCSCodecStats[0]);
    }

    int getClockRate() {
        return this._clockRate;
    }

    CodecType getCodecType() {
        return this._codecType;
    }

    public String getCsId() {
        return this._csId;
    }

    public Date getCsTimestamp() {
        return this._csTimestamp;
    }

    String getMimeType() {
        return this._mimeType;
    }

    int getPayloadType() {
        return this._payloadType;
    }

    String getType() {
        return this._type;
    }

    void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        if (this.getType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"type", (Object)JsonSerializer.serializeString((String)this.getType()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"payloadType", (Object)JsonSerializer.serializeInteger((NullableInteger)new NullableInteger(this.getPayloadType())));
        if (this.getMimeType() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"mimeType", (Object)JsonSerializer.serializeString((String)this.getMimeType()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"clockRate", (Object)JsonSerializer.serializeInteger((NullableInteger)new NullableInteger(this.getClockRate())));
    }

    void setClockRate(int value) {
        this._clockRate = value;
    }

    void setCodecType(CodecType value) {
        this._codecType = value;
    }

    public void setCsId(String value) {
        this._csId = value;
    }

    public void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    void setMimeType(String value) {
        this._mimeType = value;
    }

    void setPayloadType(int value) {
        this._payloadType = value;
    }

    void setType(String value) {
        this._type = value;
    }

    static String toJson(DataStatsCSCodecStats csCodecStats) {
        return JsonSerializer.serializeObject((Object)csCodecStats, (IAction2)new IAction2<DataStatsCSCodecStats, HashMap<String, String>>(){

            public void invoke(DataStatsCSCodecStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    static String toJsonArray(DataStatsCSCodecStats[] csCodecStats) {
        return JsonSerializer.serializeObjectArray((Object[])csCodecStats, (IFunction1)new IFunctionDelegate1<DataStatsCSCodecStats, String>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSCodecStats.toJson";
            }

            public String invoke(DataStatsCSCodecStats csCodecStats) {
                return DataStatsCSCodecStats.toJson(csCodecStats);
            }
        });
    }
}

