/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.openh264.ComplexityMode;
import fm.icelink.openh264.NativeDecoderConfig;
import fm.icelink.openh264.NativeEncoderConfig;
import fm.icelink.openh264.NativeEncoderSpatialLayerConfig;
import java.util.Arrays;
import java.util.HashMap;

class Native
extends fm.icelink.Native {
    private long _encoderState = 0L;
    private long _decoderState = 0L;
    static HashMap<Integer, DataBuffer> allocMap;

    public boolean getForceKeyFrame() {
        return Native.OpenH264FMEncoderGetForceKeyFrame(this._encoderState) != 0;
    }

    public void setForceKeyFrame(boolean value) {
        Native.OpenH264FMEncoderSetForceKeyFrame(this._encoderState, value ? 1 : 0);
    }

    public int getBitrate() {
        return Native.OpenH264FMEncoderGetBitrate(this._encoderState);
    }

    public void setBitrate(int value) {
        Native.OpenH264FMEncoderSetBitrate(this._encoderState, value);
    }

    public boolean getNeedsKeyFrame() {
        return Native.OpenH264FMDecoderGetNeedsKeyFrame(this._decoderState) != 0;
    }

    public void setNeedsKeyFrame(boolean value) {
        Native.OpenH264FMDecoderSetNeedsKeyFrame(this._decoderState, value ? 1 : 0);
    }

    public int setComplexityMode(ComplexityMode mode) {
        if (this._encoderState == 0L) {
            return -1;
        }
        return Native.OpenH264FMEncoderSetComplexityMode(this._encoderState, mode.getValue());
    }

    public int setEncoderConfig(NativeEncoderConfig config) {
        if (this._encoderState == 0L) {
            return -1;
        }
        return Native.OpenH264FMEncoderSetConfig(this._encoderState, config);
    }

    public int setEncoderSpatialLayerConfig(NativeEncoderSpatialLayerConfig config, int layerIndex) {
        if (this._encoderState == 0L) {
            return -1;
        }
        return Native.OpenH264FMEncoderSetSpatialLayerConfig(this._encoderState, config, layerIndex);
    }

    public int applyEncoderConfig() {
        if (this._encoderState == 0L) {
            return -1;
        }
        return Native.OpenH264FMEncoderApplyConfigChanges(this._encoderState);
    }

    public int setDecoderConfig(NativeDecoderConfig config) {
        if (this._decoderState == 0L) {
            return -1;
        }
        return Native.OpenH264FMDecoderSetConfig(this._decoderState, config);
    }

    public Native(boolean encoder) {
        if (encoder) {
            this._encoderState = Native.OpenH264FMEncoderCreate(0L, 0L, 0L, 0L);
        } else {
            this._decoderState = Native.OpenH264FMDecoderCreate(0L, 0L, 0L, 0L);
        }
    }

    public void destroy() {
        if (this._encoderState != 0L) {
            Native.OpenH264FMEncoderDestroy(this._encoderState);
        }
        if (this._decoderState != 0L) {
            Native.OpenH264FMDecoderDestroy(this._decoderState);
        }
        this._encoderState = 0L;
        this._decoderState = 0L;
    }

    public VideoBuffer encode(VideoBuffer buffer, VideoFormat outputFormat) {
        byte[][] planeDatas = new byte[4][];
        int[] planeStrides = new int[4];
        int[] planeIndexes = new int[4];
        int[] planeLengths = new int[4];
        for (int i = 0; i < buffer.getDataBuffers().length; ++i) {
            DataBuffer plane = buffer.getDataBuffers()[i];
            planeDatas[i] = plane.getData();
            planeStrides[i] = buffer.getStrides()[i];
            planeIndexes[i] = plane.getIndex();
            planeLengths[i] = plane.getLength();
        }
        int[] encodedLengthArray = new int[1];
        byte[] outputData = Native.OpenH264FMEncoderEncodei420(this._encoderState, buffer.getWidth(), buffer.getHeight(), planeDatas, planeStrides, planeIndexes, planeLengths, encodedLengthArray);
        if (outputData != null) {
            return new VideoBuffer(buffer.getWidth(), buffer.getHeight(), Native.getBuffer(outputData), outputFormat);
        }
        return null;
    }

    public VideoBuffer decode(VideoBuffer encodedFrame, VideoFormat outputFormat) {
        int[] widthArray = new int[1];
        int[] heightArray = new int[1];
        int[] planeStrides = new int[4];
        int[] planeLengths = new int[4];
        int[] planeCountArray = new int[1];
        DataBuffer buffer = encodedFrame.getDataBuffers()[0];
        byte[] outputData = Native.OpenH264FMDecoderDecode(this._decoderState, Arrays.copyOfRange(buffer.getData(), buffer.getIndex(), buffer.getLength()), buffer.getLength(), widthArray, heightArray, planeStrides, planeLengths, planeCountArray);
        if (outputData != null) {
            buffer = Native.getBuffer(outputData);
            int width = widthArray[0];
            int height = heightArray[0];
            final int[] strides = new int[planeStrides.length];
            int planeCount = planeCountArray[0];
            DataBuffer[] planes = new DataBuffer[planeCount];
            int offset = 0;
            for (int i = 0; i < planeCount; ++i) {
                strides[i] = planeStrides[i];
                planes[i] = buffer.subset(offset, planeLengths[i]);
                offset += planeLengths[i];
            }
            return new VideoBuffer(width, height, planes, outputFormat){
                {
                    super(x0, x1, x2, x3);
                    this.setStrides(strides);
                }
            };
        }
        return null;
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibOpenH264FM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibOpenH264FM: " + msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] AllocCallback(int size) {
        HashMap<Integer, DataBuffer> hashMap = allocMap;
        synchronized (hashMap) {
            DataBuffer buffer = DataBufferPool.getInstance().take(size);
            byte[] data = buffer.getData();
            allocMap.put(data.hashCode(), buffer);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataBuffer getBuffer(byte[] data) {
        HashMap<Integer, DataBuffer> hashMap = allocMap;
        synchronized (hashMap) {
            DataBuffer buffer = allocMap.remove(data.hashCode());
            return buffer;
        }
    }

    private static native int OpenH264FMEncoderGetBitrate(long var0);

    private static native void OpenH264FMEncoderSetBitrate(long var0, int var2);

    private static native int OpenH264FMEncoderGetForceKeyFrame(long var0);

    private static native void OpenH264FMEncoderSetForceKeyFrame(long var0, int var2);

    private static native long OpenH264FMEncoderCreate(long var0, long var2, long var4, long var6);

    private static native void OpenH264FMEncoderDestroy(long var0);

    private static native byte[] OpenH264FMEncoderEncodei420(long var0, int var2, int var3, byte[][] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    private static native int OpenH264FMEncoderSetComplexityMode(long var0, int var2);

    private static native int OpenH264FMEncoderSetConfig(long var0, NativeEncoderConfig var2);

    private static native int OpenH264FMEncoderSetSpatialLayerConfig(long var0, NativeEncoderSpatialLayerConfig var2, int var3);

    private static native int OpenH264FMEncoderApplyConfigChanges(long var0);

    private static native long OpenH264FMDecoderCreate(long var0, long var2, long var4, long var6);

    private static native void OpenH264FMDecoderDestroy(long var0);

    private static native byte[] OpenH264FMDecoderDecode(long var0, byte[] var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    private static native int OpenH264FMDecoderGetNeedsKeyFrame(long var0);

    private static native void OpenH264FMDecoderSetNeedsKeyFrame(long var0, int var2);

    private static native int OpenH264FMDecoderSetConfig(long var0, NativeDecoderConfig var2);

    static {
        Global.loadLibrary((String)"openh264fmJNI");
        allocMap = new HashMap();
    }
}

