/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.wave;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;
import fm.icelink.StringExtensions;

public class AudioRecorder
extends fm.icelink.AudioRecorder {
    private long __dataSize = 0L;
    private long __headerSize = 44L;
    private AudioFormat __inputFormat;
    private boolean __isPcm;
    private boolean __isPcma;
    private boolean __isPcmu;

    public AudioRecorder(String path, AudioFormat inputFormat) {
        super(path);
        this.__inputFormat = inputFormat;
        if (inputFormat.getIsPcmu()) {
            this.__isPcmu = true;
        } else if (inputFormat.getIsPcma()) {
            this.__isPcma = true;
        } else {
            if (!inputFormat.getIsPcm()) {
                throw new RuntimeException(new Exception(StringExtensions.format("WAVE audio recorder does not support the '{0}' codec.", inputFormat.getName())));
            }
            this.__isPcm = true;
        }
    }

    @Override
    protected void doUpdateHeader() {
        if (super.getFile() != null) {
            super.getFileStream().write32To(4, this.__headerSize - 8L + this.__dataSize);
            super.getFileStream().write32To(40, this.__dataSize);
        }
    }

    @Override
    protected boolean doWrite(AudioBuffer buffer, long presentationTimestamp) {
        DataBuffer dataBuffer = buffer.getDataBuffer();
        if (super.getFile() != null) {
            this.__dataSize += (long)dataBuffer.getLength();
            super.getFileStream().write(dataBuffer.getData(), dataBuffer.getIndex(), dataBuffer.getLength());
        }
        return true;
    }

    @Override
    protected void doWriteHeader() {
        DataBufferStream stream = new DataBufferStream(44, true);
        stream.write8(82);
        stream.write8(73);
        stream.write8(70);
        stream.write8(70);
        stream.write32(this.__headerSize - 8L);
        stream.write8(87);
        stream.write8(65);
        stream.write8(86);
        stream.write8(69);
        stream.write8(102);
        stream.write8(109);
        stream.write8(116);
        stream.write8(32);
        stream.write32(16L);
        int num = 0;
        if (this.__isPcm) {
            stream.write16(1);
            num = 16;
        } else if (this.__isPcmu) {
            stream.write16(7);
            num = 8;
        } else if (this.__isPcma) {
            stream.write16(6);
            num = 8;
        }
        stream.write16(this.__inputFormat.getChannelCount());
        stream.write32(this.__inputFormat.getClockRate());
        stream.write32(this.__inputFormat.getClockRate() * this.__inputFormat.getChannelCount() * (num / 8));
        stream.write16(this.__inputFormat.getChannelCount() * (num / 8));
        if (this.__isPcm) {
            stream.write16(num);
        } else {
            stream.write16(num);
        }
        stream.write8(100);
        stream.write8(97);
        stream.write8(116);
        stream.write8(97);
        stream.write32(0L);
        if (super.getFile() != null) {
            super.getFileStream().write(stream.getBuffer().toArray());
        }
    }
}

