/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.ice;

import fm.icelink.ErrorCode;
import fm.icelink.LongExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Error;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;

public class RoleConflictError
extends Error {
    private ControlledAttribute _iceControlled;
    private ControllingAttribute _iceControlling;

    @Override
    public String getDescription() {
        String str = super.getErrorCode().toString();
        if (super.getMessage() == null) {
            super.setMessage("Server responded with 487 Role Conflict.");
        }
        str = StringExtensions.concat(str, " ", super.getMessage().trim());
        if (this.getIceControlling() != null) {
            str = StringExtensions.concat(str, StringExtensions.format(" Ice Controlling attribute: {0}", LongExtensions.toString(this.getIceControlling().getValue())));
        }
        if (this.getIceControlled() != null) {
            str = StringExtensions.concat(str, StringExtensions.format(" Ice Controlled attribute: {0}", LongExtensions.toString(this.getIceControlled().getValue())));
        }
        return str;
    }

    public ControlledAttribute getIceControlled() {
        return this._iceControlled;
    }

    public ControllingAttribute getIceControlling() {
        return this._iceControlling;
    }

    public RoleConflictError(ControlledAttribute iceControlled, ControllingAttribute iceControlling) {
        this(null, iceControlled, iceControlling);
    }

    public RoleConflictError(String message, ControlledAttribute iceControlled, ControllingAttribute iceControlling) {
        super(ErrorCode.StunIceRoleConflict, message);
        this.setIceControlled(iceControlled);
        this.setIceControlling(iceControlling);
    }

    private void setIceControlled(ControlledAttribute value) {
        this._iceControlled = value;
    }

    private void setIceControlling(ControllingAttribute value) {
        this._iceControlling = value;
    }
}

