/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtp;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;

public class Media
extends fm.icelink.sdp.Media {
    public static String generateRtpProfile(StreamType type, boolean rtcpFeedbackSupported, boolean useDtls, boolean useEncryption) {
        if (!useEncryption && useDtls) {
            throw new RuntimeException(new Exception("Cannot generate RTP Profile for the case when DTLS support is required but encryption is not used. Likely, useEncryption must be set."));
        }
        if (!Global.equals((Object)type, (Object)StreamType.Video) && !Global.equals((Object)type, (Object)StreamType.Audio)) {
            throw new RuntimeException(new Exception(StringExtensions.format("Cannot generate RTP Profile streams of type other than Audio or Video. {0} type supplied.", type.toString())));
        }
        if (useEncryption) {
            if (useDtls) {
                if (rtcpFeedbackSupported) {
                    return Media.getUdpTlsRtpSavpfTransportProtocol();
                }
                return Media.getUdpTlsRtpSavpTransportProtocol();
            }
            if (rtcpFeedbackSupported) {
                return Media.getRtpSavpfTransportProtocol();
            }
            return Media.getRtpSavpTransportProtocol();
        }
        if (rtcpFeedbackSupported) {
            return Media.getRtpAvpfTransportProtocol();
        }
        return Media.getRtpAvpTransportProtocol();
    }

    public static int[] getPayloadTypes(String formatDesciption) {
        if (formatDesciption != null && StringExtensions.getLength(formatDesciption) > 0) {
            Object[] strArray = StringExtensions.split(formatDesciption.trim(), new char[]{' '});
            int[] numArray = new int[ArrayExtensions.getLength(strArray)];
            for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                numArray[i] = ParseAssistant.parseIntegerValue((String)strArray[i]);
            }
            return numArray;
        }
        return new int[0];
    }

    public static String getRtpAvpfTransportProtocol() {
        return "RTP/AVPF";
    }

    public static String getRtpAvpTransportProtocol() {
        return "RTP/AVP";
    }

    public static String getRtpSavpfTransportProtocol() {
        return "RTP/SAVPF";
    }

    public static String getRtpSavpTransportProtocol() {
        return "RTP/SAVP";
    }

    public static String getUdpTlsRtpSavpfTransportProtocol() {
        return "UDP/TLS/RTP/SAVPF";
    }

    public static String getUdpTlsRtpSavpTransportProtocol() {
        return "UDP/TLS/RTP/SAVP";
    }

    public static int getWellKnownPayloadClockRate(int payloadType) {
        int _var0 = payloadType;
        if (_var0 == 0 || _var0 == 3 || _var0 == 4 || _var0 == 5) {
            return 8000;
        }
        if (_var0 == 6) {
            return 16000;
        }
        if (_var0 == 7 || _var0 == 8 || _var0 == 9) {
            return 8000;
        }
        if (_var0 == 10 || _var0 == 11) {
            return 44100;
        }
        if (_var0 == 12 || _var0 == 13) {
            return 8000;
        }
        if (_var0 == 14) {
            return 90000;
        }
        if (_var0 == 15) {
            return 8000;
        }
        if (_var0 == 16) {
            return 11025;
        }
        if (_var0 == 17) {
            return 22050;
        }
        if (_var0 == 18) {
            return 8000;
        }
        if (_var0 == 25 || _var0 == 26 || _var0 == 28 || _var0 == 31 || _var0 == 32 || _var0 == 33 || _var0 == 34) {
            return 90000;
        }
        return -1;
    }

    public static String getWellKnownPayloadName(int payloadType) {
        int _var0 = payloadType;
        if (_var0 == 0) {
            return "PCMU";
        }
        if (_var0 == 3) {
            return "GSM";
        }
        if (_var0 == 4) {
            return "G723";
        }
        if (_var0 == 5 || _var0 == 6) {
            return "DVI4";
        }
        if (_var0 == 7) {
            return "LPC";
        }
        if (_var0 == 8) {
            return "PCMA";
        }
        if (_var0 == 9) {
            return "G722";
        }
        if (_var0 == 10 || _var0 == 11) {
            return "L16";
        }
        if (_var0 == 12) {
            return "QCELP";
        }
        if (_var0 == 13) {
            return "CN";
        }
        if (_var0 == 14) {
            return "MPA";
        }
        if (_var0 == 15) {
            return "G728";
        }
        if (_var0 == 16 || _var0 == 17) {
            return "DVI4";
        }
        if (_var0 == 18) {
            return "G729";
        }
        if (_var0 == 25) {
            return "CelB";
        }
        if (_var0 == 26) {
            return "JPEG";
        }
        if (_var0 == 28) {
            return "nv";
        }
        if (_var0 == 31) {
            return "H261";
        }
        if (_var0 == 32) {
            return "MPV";
        }
        if (_var0 == 33) {
            return "MP2T";
        }
        if (_var0 == 34) {
            return "H263";
        }
        return null;
    }

    public Media(String mediaType, int transportPort, String transportProtocol, int[] rtpPayloadTypeNumbers) {
        super(mediaType, transportPort, transportProtocol);
        if (rtpPayloadTypeNumbers == null) {
            throw new RuntimeException(new Exception("rtpPayloadTypeNumbers cannot be null."));
        }
        String[] strArray = new String[ArrayExtensions.getLength(rtpPayloadTypeNumbers)];
        for (int i = 0; i < ArrayExtensions.getLength(rtpPayloadTypeNumbers); ++i) {
            strArray[i] = IntegerExtensions.toString(rtpPayloadTypeNumbers[i]);
        }
        super.setFormatDescription(StringExtensions.join(" ", strArray));
    }

    public static boolean supportsEncryption(String protocol) {
        return Global.equals(protocol, Media.getUdpTlsRtpSavpTransportProtocol()) || Global.equals(protocol, Media.getUdpTlsRtpSavpfTransportProtocol()) || Global.equals(protocol, Media.getRtpSavpTransportProtocol()) || Global.equals(protocol, Media.getRtpSavpfTransportProtocol());
    }

    public static boolean supportsRtcpBasedFeedback(String protocol) {
        return Global.equals(protocol, Media.getRtpSavpfTransportProtocol()) || Global.equals(protocol, Media.getRtpAvpfTransportProtocol()) || Global.equals(protocol, Media.getUdpTlsRtpSavpfTransportProtocol());
    }
}

