/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;
import fm.icelink.Encoding;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Cluster;
import fm.icelink.matroska.Ebml;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.Segment;
import fm.icelink.matroska.SegmentInfo;
import fm.icelink.matroska.SimpleBlock;
import fm.icelink.matroska.Track;
import fm.icelink.matroska.TrackEntry;
import fm.icelink.matroska.TrackType;
import java.util.ArrayList;

public class AudioRecorder
extends fm.icelink.AudioRecorder {
    private AudioFormat __inputFormat;
    private boolean __isOpus;
    private boolean __isPcma;
    private boolean __isPcmu;
    private int _clusterInterval = 30000;
    private Cluster _currentCluster;
    private ArrayList<SimpleBlock> _currentClusterBlocks;
    private double[] _opusFrameSizes = new double[]{10.0, 20.0, 40.0, 60.0, 10.0, 20.0, 40.0, 60.0, 10.0, 20.0, 40.0, 60.0, 10.0, 20.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0};
    private int _segmentSize;
    private int _segmentSizeOffset;

    public AudioRecorder(String path, AudioFormat inputFormat) {
        super(path);
        this.__inputFormat = inputFormat;
        if (inputFormat.getIsOpus()) {
            this.__isOpus = true;
        } else if (inputFormat.getIsPcmu()) {
            this.__isPcmu = true;
        } else {
            if (!inputFormat.getIsPcma()) {
                throw new RuntimeException(new Exception(StringExtensions.concat("Matroska audio recorder does not support the '", inputFormat.getName(), "' codec.")));
            }
            this.__isPcma = true;
        }
    }

    @Override
    protected void doUpdateHeader() {
        this.flushCluster();
        byte[] data = Element.serializeVariableInteger(this._segmentSize, 8);
        super.getFile().writeTo(this._segmentSizeOffset, data, 0, ArrayExtensions.getLength(data));
    }

    @Override
    protected boolean doWrite(AudioBuffer buffer, long presentationTimestamp) {
        DataBuffer dataBuffer = buffer.getDataBuffer();
        int num = 0;
        if (this.__isOpus) {
            if (dataBuffer.getLength() > 0) {
                int num2 = dataBuffer.read8(0);
                int index = (num2 & 0xF8) >> 3;
                int num4 = num2 & 3;
                double num5 = this._opusFrameSizes[index];
                int num6 = 0;
                if (num4 == 0) {
                    num6 = 1;
                } else if (num4 == 1) {
                    num6 = 2;
                } else if (num4 == 2) {
                    num6 = 2;
                } else if (num4 == 3 && dataBuffer.getLength() > 1) {
                    num6 = dataBuffer.read8(1) & 0x3F;
                }
                num = (int)((double)this.__inputFormat.getClockRate() * num5 * (double)num6 / 1000.0);
            }
        } else {
            num = dataBuffer.getLength() * 2 / (this.__inputFormat.getChannelCount() * 2);
        }
        if (num > 0) {
            this.writeFrame(buffer.getDataBuffer(), presentationTimestamp);
            return true;
        }
        return false;
    }

    @Override
    protected void doWriteHeader() {
        Ebml ebml2 = new Ebml();
        ebml2.setWriteDefaultValues(true);
        ebml2.setDocTypeVersion(4L);
        ebml2.setDocTypeReadVersion(2L);
        byte[] bytes = ebml2.getBytes();
        super.getFileStream().write(bytes, 0, ArrayExtensions.getLength(bytes));
        String opusCodecId = "";
        DataBufferStream stream = null;
        if (this.__isOpus) {
            opusCodecId = TrackEntry.getOpusCodecId();
            stream = new DataBufferStream(19, true);
            stream.writeBytes(Encoding.getUtf8().getBytes("OpusHead"));
            stream.write8(1);
            stream.write8(this.__inputFormat.getChannelCount());
            stream.write16(0);
            stream.write32(this.__inputFormat.getClockRate());
            stream.write16(0);
            stream.write8(0);
        } else if (this.__isPcmu || this.__isPcma) {
            opusCodecId = TrackEntry.getPcmCodecId();
            stream = new DataBufferStream(18, true);
            int num = this.__isPcmu ? TrackEntry.getPcmuFormatTag() : TrackEntry.getPcmaFormatTag();
            stream.write16(num);
            stream.write16(this.__inputFormat.getChannelCount());
            stream.write32(this.__inputFormat.getClockRate());
            stream.write32(0L);
            stream.write16(0);
            stream.write16(8);
            stream.write16(0);
        }
        TrackEntry entry2 = new TrackEntry();
        entry2.setTrackNumber(1L);
        entry2.setTrackType(TrackType.getAudio());
        entry2.setCodecId(opusCodecId);
        entry2.setFlagLacing(false);
        entry2.setCodecPrivate(stream.getBuffer().toArray());
        TrackEntry entry = entry2;
        Track track2 = new Track();
        track2.setTrackEntries(new TrackEntry[]{entry});
        Track track = track2;
        Segment segment2 = new Segment();
        segment2.setSizeLength(8);
        segment2.setSegmentInfo(new SegmentInfo());
        segment2.setTracks(new Track[]{track});
        Segment segment = segment2;
        byte[] buffer2 = segment.getBytes();
        super.getFileStream().write(buffer2, 0, ArrayExtensions.getLength(buffer2));
        this._segmentSize = segment.getSize();
        this._segmentSizeOffset = ArrayExtensions.getLength(bytes) + ArrayExtensions.getLength(segment.getId());
        Cluster cluster = new Cluster();
        cluster.setTimecode(0L);
        this._currentCluster = cluster;
        this._currentClusterBlocks = new ArrayList();
    }

    private void flushCluster() {
        if (ArrayListExtensions.getCount(this._currentClusterBlocks) > 0) {
            this._currentCluster.setSimpleBlocks(this._currentClusterBlocks.toArray(new SimpleBlock[0]));
            this._currentClusterBlocks.clear();
            byte[] bytes = this._currentCluster.getBytes();
            super.getFile().write(bytes, 0, ArrayExtensions.getLength(bytes));
            this._segmentSize += ArrayExtensions.getLength(bytes);
        }
    }

    private void writeFrame(DataBuffer encodedFrame, long presentationTimestamp) {
        long num = presentationTimestamp * 1000L / (long)this.__inputFormat.getClockRate();
        if (num - this._currentCluster.getTimecode() > (long)this._clusterInterval) {
            this.flushCluster();
            Cluster cluster = new Cluster();
            cluster.setTimecode(num);
            this._currentCluster = cluster;
        }
        SimpleBlock item = new SimpleBlock();
        item.setTimecode((int)(num - this._currentCluster.getTimecode()));
        item.setTrackNumber(1L);
        item.setData(encodedFrame.toArray());
        this._currentClusterBlocks.add(item);
    }
}

