/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Holder;
import fm.icelink.IVideoOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.PacketizedVideoBuffer;
import fm.icelink.ParseAssistant;
import fm.icelink.RtpPacketHeader;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPacketizer;
import fm.icelink.h264.Format;
import fm.icelink.h264.Packet;
import fm.icelink.h264.PacketizationMode;
import fm.icelink.h264.Utility;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.rtp.MapAttribute;
import java.util.ArrayList;

public class Packetizer
extends VideoPacketizer {
    private ArrayList<String> __remotePacketizationModes = new ArrayList();
    private int _packetizationMode;
    private int[] _supportedPacketizationModes;

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer = this.packetize(Utility.trimAud(inputBuffer.getDataBuffer()), inputBuffer.getWidth(), inputBuffer.getHeight());
        if (buffer != null) {
            frame.addBuffer(buffer);
            this.raiseFrame(frame);
        }
    }

    @Override
    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        Object[] attributeArray = mediaDescription.getRtpMapAttributes(((VideoFormat)super.getOutputFormat()).getName(), ((VideoFormat)super.getOutputFormat()).getClockRate(), ((VideoFormat)super.getOutputFormat()).getParameters());
        if (attributeArray != null) {
            for (int i = 0; i < ArrayExtensions.getLength(attributeArray); ++i) {
                Object attribute = attributeArray[i];
                FormatParametersAttribute relatedFormatParametersAttribute = ((MapAttribute)attribute).getRelatedFormatParametersAttribute();
                if (isLocalDescription && relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(((MapAttribute)attribute).getPayloadType());
                    ((MapAttribute)attribute).setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                String str = null;
                if (relatedFormatParametersAttribute != null) {
                    Holder<Object> _var0 = new Holder<Object>(str);
                    boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("packetization-mode", _var0);
                    str = _var0.getValue();
                }
                if (isLocalDescription && str == null) {
                    int packetizationMode = this.getPacketizationMode();
                    if (isOffer) {
                        packetizationMode = PacketizationMode.getNonInterleaved();
                    }
                    relatedFormatParametersAttribute.setFormatSpecificParameter("packetization-mode", IntegerExtensions.toString(packetizationMode));
                    continue;
                }
                if (str == null) continue;
                int intResult = 0;
                IntegerHolder _var2 = new IntegerHolder(intResult);
                boolean _var3 = ParseAssistant.tryParseIntegerValue(str, _var2);
                intResult = _var2.getValue();
                if (!_var3) continue;
                if (isLocalDescription) {
                    if (this.validatePacketizationMode(intResult)) continue;
                    return new Error(ErrorCode.LocalDescriptionError, new Exception(StringExtensions.format("Could not validate packetization mode {0}.", IntegerExtensions.toString(intResult))));
                }
                if (isOffer) continue;
                if (!this.validatePacketizationMode(intResult)) {
                    return new Error(ErrorCode.RemoteDescriptionError, new Exception(StringExtensions.format("Could not validate packetization mode {0}.", IntegerExtensions.toString(intResult))));
                }
                this.__remotePacketizationModes.add(IntegerExtensions.toString(intResult));
            }
            if (!isLocalDescription) {
                this.setPacketizationMode(PacketizationMode.getNonInterleaved());
            }
        }
        return null;
    }

    public static int getHeaderPadding() {
        return 20;
    }

    @Override
    public String getLabel() {
        return "H.264 Packetizer";
    }

    public static int getMaxPacketSize() {
        return 1050;
    }

    public int getPacketizationMode() {
        return this._packetizationMode;
    }

    public int[] getSupportedPacketizationModes() {
        return this._supportedPacketizationModes;
    }

    private void initialize() {
        this.setSupportedPacketizationModes(new int[]{PacketizationMode.getNonInterleaved()});
        this.setPacketizationMode(PacketizationMode.getNonInterleaved());
    }

    private VideoBuffer packetize(DataBuffer encodedBuffer, int width, int height) {
        Object[] packetArray = Packet.packetize(encodedBuffer, this.getPacketizationMode());
        if (packetArray == null) {
            return null;
        }
        DataBuffer[] dataBuffers = new DataBuffer[ArrayExtensions.getLength(packetArray)];
        RtpPacketHeader[] rtpHeaders = new RtpPacketHeader[ArrayExtensions.getLength(packetArray)];
        for (int i = 0; i < ArrayExtensions.getLength(packetArray); ++i) {
            dataBuffers[i] = ((Packet)packetArray[i]).getBuffer();
            RtpPacketHeader header = new RtpPacketHeader();
            header.setMarker(i == ArrayExtensions.getLength(packetArray) - 1);
            rtpHeaders[i] = header;
        }
        return new PacketizedVideoBuffer(width, height, dataBuffers, (VideoFormat)super.getOutputFormat(), rtpHeaders);
    }

    public Packetizer() {
        super(new Format());
        this.initialize();
    }

    public Packetizer(IVideoOutput input) {
        super(input);
        this.initialize();
    }

    public void setPacketizationMode(int value) {
        this._packetizationMode = value;
    }

    private void setSupportedPacketizationModes(int[] value) {
        this._supportedPacketizationModes = value;
    }

    private boolean validatePacketizationMode(int packetizationMode) {
        for (int num : this.getSupportedPacketizationModes()) {
            if (packetizationMode != num) continue;
            return true;
        }
        return false;
    }
}

