/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.dtmf;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPacketizer;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.MathAssistant;
import fm.icelink.PacketizedAudioBuffer;
import fm.icelink.RtpPacketHeader;
import fm.icelink.dtmf.Format;
import fm.icelink.dtmf.Packet;
import fm.icelink.dtmf.Tone;
import java.util.ArrayList;
import java.util.List;

public class Sender
extends AudioPacketizer {
    private volatile boolean __nextStart = true;
    private List<IAction1<Tone>> __onTone = new ArrayList<IAction1<Tone>>();
    private List<IAction1<Tone>> __onToneChange = new ArrayList<IAction1<Tone>>();
    private ArrayList<Tone> __toneQueue = new ArrayList();
    private Object __toneQueueLock = new Object();
    private IAction1<Tone> _onTone = null;
    private IAction1<Tone> _onToneChange = null;
    private Tone _tone;

    public void addOnTone(IAction1<Tone> value) {
        if (value != null) {
            if (this._onTone == null) {
                this._onTone = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(Sender.this.__onTone)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onTone.add(value);
        }
    }

    public void addOnToneChange(IAction1<Tone> value) {
        if (value != null) {
            if (this._onToneChange == null) {
                this._onToneChange = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(Sender.this.__onToneChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onToneChange.add(value);
        }
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        throw new RuntimeException(new Exception("Use InsertTones."));
    }

    @Override
    public String getLabel() {
        return "DTMF Sender";
    }

    public Tone getTone() {
        return this._tone;
    }

    public boolean hasTone() {
        return ArrayListExtensions.getCount(this.__toneQueue) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTones(Tone[] tones) {
        for (Tone tone : tones) {
            tone.setTimestamp(-1L);
        }
        Object object = this.__toneQueueLock;
        synchronized (object) {
            if (ArrayListExtensions.getCount(this.__toneQueue) > 0) {
                this.__toneQueue.add(new Tone(Tone.getEmptyValue(), 100));
            }
            ArrayListExtensions.addRange(this.__toneQueue, tones);
        }
    }

    private void processPacket(Packet packet) {
        Tone tone = this.getTone();
        this.setTone(Tone.fromPacket(packet, super.getConfig().getClockRate()));
        if (!Global.equals(this.getTone().getValue(), tone.getValue())) {
            this.raiseToneChange(this.getTone());
        }
        this.raiseTone(this.getTone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean raiseTone(int duration, long timestamp, long synchronizationSource) {
        boolean flag3;
        boolean flag2;
        Tone tone2;
        Tone tone;
        if (ArrayListExtensions.getCount(this.__toneQueue) == 0) {
            return false;
        }
        if (duration <= 0) {
            duration = 20;
        }
        boolean flag = this.__nextStart;
        Object object = this.__toneQueueLock;
        synchronized (object) {
            tone = ArrayListExtensions.getItem(this.__toneQueue).get(0);
            if (tone.getTimestamp() == -1L) {
                tone.setTimestamp(timestamp);
            }
            tone2 = tone.clone();
            tone.setRemainingDuration(MathAssistant.max(0, tone.getRemainingDuration() - duration));
            tone2.setDuration(tone.getDuration() - tone.getRemainingDuration());
            if (tone.getRemainingDuration() == 0) {
                ArrayListExtensions.removeAt(this.__toneQueue, 0);
                this.__nextStart = true;
                flag2 = true;
            } else {
                this.__nextStart = false;
                flag2 = false;
            }
        }
        if (tone2.getValue() == null || Global.equals(tone2.getValue(), Tone.getEmptyValue())) {
            return false;
        }
        if (Global.equals(tone2.getValue(), Tone.getPauseValue())) {
            return true;
        }
        Packet packet = tone2.toPacket(super.getConfig().getClockRate());
        packet.setVolume(15);
        packet.setEnd(flag2);
        DataBuffer dataBuffer = DataBufferPool.getInstance().take(packet.getLength());
        try {
            packet.writeTo(dataBuffer);
            this.processPacket(packet);
            if (packet.getEnd()) {
                Packet packet2 = new Packet();
                packet2.setEventCode(-1);
                packet2.setEnd(true);
                packet2.setDuration(0);
                packet2.setVolume(0);
                this.processPacket(packet2);
            }
            RtpPacketHeader rtpPacket = new RtpPacketHeader();
            rtpPacket.setMarker(flag);
            PacketizedAudioBuffer buffer = new PacketizedAudioBuffer(dataBuffer, (AudioFormat)super.getOutputFormat(), rtpPacket);
            AudioFrame frame2 = new AudioFrame(duration, buffer);
            frame2.setSynchronizationSource(synchronizationSource);
            frame2.setTimestamp(tone.getTimestamp());
            AudioFrame frame = frame2;
            this.raiseFrame(frame);
            if (packet.getEnd() && ArrayListExtensions.getCount(this.__toneQueue) == 0) {
                this.raiseFrame(frame);
                this.raiseFrame(frame);
                this.raiseFrame(frame);
            }
            flag3 = true;
        }
        finally {
            dataBuffer.free();
        }
        return flag3;
    }

    private void raiseTone(Tone tone) {
        IAction1<Tone> onTone = this._onTone;
        if (onTone != null) {
            onTone.invoke(tone);
        }
    }

    private void raiseToneChange(Tone tone) {
        IAction1<Tone> onToneChange = this._onToneChange;
        if (onToneChange != null) {
            onToneChange.invoke(tone);
        }
    }

    public void removeOnTone(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onTone, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onTone.remove(value);
        if (this.__onTone.size() == 0) {
            this._onTone = null;
        }
    }

    public void removeOnToneChange(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onToneChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onToneChange.remove(value);
        if (this.__onToneChange.size() == 0) {
            this._onToneChange = null;
        }
    }

    public Sender(int clockRate) {
        super(new Format(clockRate));
        this.setTone(Tone.getEmpty());
    }

    public Sender() {
        this(new Format().getClockRate());
    }

    private void setTone(Tone value) {
        this._tone = value;
    }
}

