/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.dtmf;

import fm.icelink.DataBuffer;

public class Packet {
    private int _duration;
    private boolean _end;
    private int _eventCode;
    private int _volume;

    public int getDuration() {
        return this._duration;
    }

    public boolean getEnd() {
        return this._end;
    }

    public int getEventCode() {
        return this._eventCode;
    }

    public int getLength() {
        return 4;
    }

    public int getVolume() {
        return this._volume;
    }

    public Packet() {
        this.setEventCode(0);
        this.setEnd(true);
        this.setVolume(0);
        this.setDuration(800);
    }

    public static Packet readFrom(DataBuffer dataBuffer) {
        if (dataBuffer.getLength() < 4) {
            return null;
        }
        Packet packet = new Packet();
        packet.setEventCode(dataBuffer.read8(0));
        packet.setEnd(dataBuffer.read1(1, 0));
        packet.setVolume(dataBuffer.read6(1, 2));
        packet.setDuration(dataBuffer.read16(2));
        return packet;
    }

    public void setDuration(int value) {
        this._duration = value;
    }

    public void setEnd(boolean value) {
        this._end = value;
    }

    public void setEventCode(int value) {
        this._eventCode = value;
    }

    public void setVolume(int value) {
        this._volume = value;
    }

    public void writeTo(DataBuffer dataBuffer) {
        dataBuffer.write8(this.getEventCode(), 0);
        dataBuffer.write1(this.getEnd(), 1, 0);
        dataBuffer.write6(this.getVolume(), 1, 2);
        dataBuffer.write16(this.getDuration(), 2);
    }
}

