/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.diagnostics;

import fm.icelink.ClassExtensions;
import fm.icelink.IActionDelegate0;
import fm.icelink.ILog;
import fm.icelink.Log;
import fm.icelink.LogLevel;
import fm.icelink.ManagedTimer;
import fm.icelink.diagnostics.DurationTimer;
import fm.icelink.diagnostics.RateTimer;
import fm.icelink.diagnostics.Timer;
import java.util.ArrayList;

public abstract class Timers {
    private static ILog __log = Log.getLogger(Timers.class);
    private static int __outputInterval;
    private static ManagedTimer __outputTimer;
    private static ArrayList<Timer> __timers;
    private static LogLevel _outputLogLevel;

    public static DurationTimer getDurationTimer(Class type) {
        return Timers.getDurationTimer(ClassExtensions.getFullName(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DurationTimer getDurationTimer(String tag) {
        ArrayList<Timer> arrayList = __timers;
        synchronized (arrayList) {
            DurationTimer item = new DurationTimer(tag);
            __timers.add(item);
            return item;
        }
    }

    public static boolean getEnabled() {
        return Timers.getOutputInterval() > 0 && __log.isLogEnabled(Timers.getOutputLogLevel());
    }

    public static int getOutputInterval() {
        return __outputInterval;
    }

    public static LogLevel getOutputLogLevel() {
        return _outputLogLevel;
    }

    public static RateTimer getRateTimer(Class type) {
        return Timers.getRateTimer(ClassExtensions.getFullName(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RateTimer getRateTimer(String tag) {
        ArrayList<Timer> arrayList = __timers;
        synchronized (arrayList) {
            RateTimer item = new RateTimer(tag);
            __timers.add(item);
            return item;
        }
    }

    private static void logTick() {
        if (Timers.getEnabled()) {
            for (Timer timer : __timers) {
                if (!timer.getHasData()) continue;
                LogLevel _var0 = Timers.getOutputLogLevel();
                if (_var0 == LogLevel.Verbose) {
                    __log.verbose(timer.getStats());
                    continue;
                }
                if (_var0 == LogLevel.Debug) {
                    __log.debug(timer.getStats());
                    continue;
                }
                if (_var0 == LogLevel.Info) {
                    __log.info(timer.getStats());
                    continue;
                }
                if (_var0 == LogLevel.Warn) {
                    __log.warn(timer.getStats());
                    continue;
                }
                if (_var0 == LogLevel.Error) {
                    __log.error(timer.getStats());
                    continue;
                }
                if (_var0 != LogLevel.Fatal) continue;
                __log.fatal(timer.getStats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTimer(Timer timer) {
        ArrayList<Timer> arrayList = __timers;
        synchronized (arrayList) {
            __timers.remove(timer);
        }
    }

    public static void setOutputInterval(int value) {
        if (__outputInterval != value) {
            if (value > 0) {
                if (__outputTimer != null) {
                    __outputTimer.stop();
                    __outputTimer = null;
                }
                __outputTimer = new ManagedTimer(value * 1000, new IActionDelegate0(){

                    @Override
                    public String getId() {
                        return "fm.icelink.diagnostics.Timers.logTick";
                    }

                    @Override
                    public void invoke() {
                        Timers.logTick();
                    }
                });
                __outputTimer.start();
            } else if (__outputTimer != null) {
                __outputTimer.stop();
                __outputTimer = null;
            }
            __outputInterval = value;
        }
    }

    public static void setOutputLogLevel(LogLevel value) {
        _outputLogLevel = value;
    }

    static {
        __timers = new ArrayList();
        Timers.setOutputLogLevel(LogLevel.Debug);
        Timers.setOutputInterval(0);
    }
}

