/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.diagnostics;

import fm.icelink.AtomicLong;
import fm.icelink.DoubleExtensions;
import fm.icelink.MathAssistant;
import fm.icelink.StringExtensions;
import fm.icelink.diagnostics.Timer;
import fm.icelink.diagnostics.Timers;

public class RateTimer
extends Timer {
    private int __averageCount = 0;
    private double __avg = 0.0;
    private AtomicLong __counter = new AtomicLong();
    private boolean __hasData;
    private long __lastWatchTick = 0L;
    private double __max = -1.0;
    private double __min = -1.0;

    public void addTick() {
        if (Timers.getEnabled()) {
            this.__hasData = true;
            this.__counter.increment();
        }
    }

    @Override
    public boolean getHasData() {
        return this.__hasData;
    }

    @Override
    public String getStats() {
        long elapsedMilliseconds = super.getWatch().getElapsedMilliseconds();
        long delta = this.__counter.getValue();
        this.__counter.subtract(delta);
        long num3 = elapsedMilliseconds - this.__lastWatchTick;
        this.__lastWatchTick = elapsedMilliseconds;
        long num4 = num3 / 1000L;
        double num5 = (double)delta / (double)num4;
        this.__min = this.__min == -1.0 ? num5 : MathAssistant.min(this.__min, num5);
        this.__max = this.__max == -1.0 ? num5 : MathAssistant.max(this.__max, num5);
        this.__avg += (num5 - this.__avg) / (double)(++this.__averageCount);
        return StringExtensions.format("{0}:\n\tInstant: {1}hz\n\tMin: {2}hz\n\tMax: {3}hz\n\tAvg: {4}hz", new Object[]{super.getTag(), DoubleExtensions.toString(num5), DoubleExtensions.toString(this.__min), DoubleExtensions.toString(this.__max), DoubleExtensions.toString(this.__avg)});
    }

    RateTimer(String tag) {
        super(tag);
    }
}

