/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1Explicit;
import fm.icelink.Asn1Implicit;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Sequence;
import fm.icelink.Asn1Unknown;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.X501Name;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509Extensions;
import fm.icelink.X509SubjectPublicKeyInfo;
import fm.icelink.X509Validity;
import java.util.ArrayList;

class X509TbsCertificate {
    private X509Extensions _extensions;
    private X501Name _issuer;
    private byte[] _issuerUniqueId;
    private boolean _missingVersion;
    private byte[] _serialNumber;
    private X509AlgorithmIdentifier _signatureAlgorithm;
    private Asn1Any _sourceAsn;
    private X501Name _subject;
    private X509SubjectPublicKeyInfo _subjectPublicKeyInfo;
    private byte[] _subjectUniqueId;
    private X509Validity _validity;
    private int _version;

    public static X509TbsCertificate fromAsn1(Asn1Any any) {
        Asn1Any any2;
        int num2;
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 6) {
            return null;
        }
        X509TbsCertificate certificate = new X509TbsCertificate();
        int num = 0;
        if (sequence.getValues()[0] instanceof Asn1Unknown && sequence.getValues()[1] instanceof Asn1Integer) {
            num2 = -1;
            IntegerHolder _var0 = new IntegerHolder(num2);
            Asn1Any _var1 = Asn1Unknown.unwrap(sequence.getValues()[num++], _var0);
            num2 = _var0.getValue();
            any2 = _var1;
            certificate.setVersion((int)((Asn1Integer)any2).getLongValue());
        } else {
            certificate.setMissingVersion(true);
        }
        certificate.setSerialNumber(((Asn1Integer)sequence.getValues()[num++]).getValue());
        certificate.setSignatureAlgorithm(X509AlgorithmIdentifier.fromAsn1(sequence.getValues()[num++]));
        certificate.setIssuer(X501Name.fromAsn1(sequence.getValues()[num++]));
        certificate.setValidity(X509Validity.fromAsn1(sequence.getValues()[num++]));
        certificate.setSubject(X501Name.fromAsn1(sequence.getValues()[num++]));
        certificate.setSubjectPublicKeyInfo(X509SubjectPublicKeyInfo.fromAsn1(sequence.getValues()[num++]));
        while (ArrayExtensions.getLength(sequence.getValues()) > num) {
            num2 = -1;
            IntegerHolder _var2 = new IntegerHolder(num2);
            Asn1Any _var3 = Asn1Unknown.unwrap(sequence.getValues()[num++], _var2);
            num2 = _var2.getValue();
            any2 = _var3;
            int _var4 = num2;
            if (_var4 == 1) {
                certificate.setIssuerUniqueId(((Asn1BitString)any2).getValueBytes());
                continue;
            }
            if (_var4 == 2) {
                certificate.setSubjectUniqueId(((Asn1BitString)any2).getValueBytes());
                continue;
            }
            if (_var4 != 3) continue;
            certificate.setExtensions(X509Extensions.fromAsn1(any2));
        }
        certificate.setSourceAsn(any);
        return certificate;
    }

    public X509Extensions getExtensions() {
        return this._extensions;
    }

    public X501Name getIssuer() {
        return this._issuer;
    }

    public byte[] getIssuerUniqueId() {
        return this._issuerUniqueId;
    }

    public boolean getMissingVersion() {
        return this._missingVersion;
    }

    public byte[] getSerialNumber() {
        return this._serialNumber;
    }

    public X509AlgorithmIdentifier getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public Asn1Any getSourceAsn() {
        return this._sourceAsn;
    }

    public X501Name getSubject() {
        return this._subject;
    }

    public X509SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this._subjectPublicKeyInfo;
    }

    public byte[] getSubjectUniqueId() {
        return this._subjectUniqueId;
    }

    public X509Validity getValidity() {
        return this._validity;
    }

    public int getVersion() {
        return this._version;
    }

    public static int getVersion1() {
        return 0;
    }

    public static int getVersion2() {
        return 1;
    }

    public static int getVersion3() {
        return 2;
    }

    public void setExtensions(X509Extensions value) {
        this._extensions = value;
    }

    public void setIssuer(X501Name value) {
        this._issuer = value;
    }

    public void setIssuerUniqueId(byte[] value) {
        this._issuerUniqueId = value;
    }

    private void setMissingVersion(boolean value) {
        this._missingVersion = value;
    }

    public void setSerialNumber(byte[] value) {
        this._serialNumber = value;
    }

    public void setSignatureAlgorithm(X509AlgorithmIdentifier value) {
        this._signatureAlgorithm = value;
    }

    private void setSourceAsn(Asn1Any value) {
        this._sourceAsn = value;
    }

    public void setSubject(X501Name value) {
        this._subject = value;
    }

    public void setSubjectPublicKeyInfo(X509SubjectPublicKeyInfo value) {
        this._subjectPublicKeyInfo = value;
    }

    public void setSubjectUniqueId(byte[] value) {
        this._subjectUniqueId = value;
    }

    public void setValidity(X509Validity value) {
        this._validity = value;
    }

    public void setVersion(int value) {
        this._version = value;
    }

    public Asn1Sequence toAsn1() {
        if (!this.getMissingVersion()) {
            if ((this.getIssuerUniqueId() != null || this.getSubjectUniqueId() != null) && this.getVersion() < X509TbsCertificate.getVersion2()) {
                Log.error("Version must be at least v2 if IssuerUniqueId or SubjectUniqueId are not null.");
                return null;
            }
            if (this.getExtensions() != null && this.getVersion() < X509TbsCertificate.getVersion3()) {
                Log.error("Version must be at least v3 if Extensions is not null.");
                return null;
            }
        }
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        if (!this.getMissingVersion()) {
            list.add(Asn1Explicit.wrap(0, new Asn1Integer(this.getVersion())));
        }
        list.add(new Asn1Integer(this.getSerialNumber()));
        list.add(this.getSignatureAlgorithm().toAsn1());
        list.add(this.getIssuer().toAsn1());
        list.add(this.getValidity().toAsn1());
        list.add(this.getSubject().toAsn1());
        list.add(this.getSubjectPublicKeyInfo().toAsn1());
        if (this.getIssuerUniqueId() != null) {
            list.add(Asn1Implicit.wrap(1, new Asn1BitString(this.getIssuerUniqueId())));
        } else if (this.getSubjectUniqueId() != null) {
            list.add(Asn1Implicit.wrap(2, new Asn1BitString(this.getSubjectUniqueId())));
        } else if (this.getExtensions() != null) {
            list.add(Asn1Explicit.wrap(3, this.getExtensions().toAsn1()));
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }
}

